/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.enums.Result;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.manager.NpcManager;
import de.eisi05.npc.api.objects.NpcHolder;
import de.eisi05.npc.api.objects.NpcOption;
import de.eisi05.npc.api.utils.ObjectSaver;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import de.eisi05.npc.api.wrapper.objects.WrappedEntityData;
import de.eisi05.npc.api.wrapper.objects.WrappedPlayerTeam;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import de.eisi05.npc.api.wrapper.packets.AnimatePacket;
import de.eisi05.npc.api.wrapper.packets.MoveEntityPacket;
import de.eisi05.npc.api.wrapper.packets.PacketWrapper;
import de.eisi05.npc.api.wrapper.packets.PlayerInfoRemovePacket;
import de.eisi05.npc.api.wrapper.packets.PlayerInfoUpdatePacket;
import de.eisi05.npc.api.wrapper.packets.RemoveEntityPacket;
import de.eisi05.npc.api.wrapper.packets.RotateHeadPacket;
import de.eisi05.npc.api.wrapper.packets.SetEntityDataPacket;
import de.eisi05.npc.api.wrapper.packets.SetPassengerPacket;
import de.eisi05.npc.api.wrapper.packets.SetPlayerTeamPacket;
import de.eisi05.npc.api.wrapper.packets.TeleportEntityPacket;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NPC
extends NpcHolder {
    final List<Integer> toDeleteEntities = new ArrayList<Integer>();
    private final List<UUID> viewers = new ArrayList<UUID>();
    private final Map<NpcOption<?, ?>, Object> options;
    private Path npcPath;
    WrappedServerPlayer serverPlayer;
    private WrappedComponent name;
    private Location location;
    private NpcClickAction clickEvent;
    private Instant createdAt = Instant.now();

    public NPC(@NotNull Location location) {
        this(location, UUID.randomUUID());
    }

    public NPC(@NotNull Location location, @NotNull WrappedComponent name) {
        this(location, UUID.randomUUID(), name);
    }

    public NPC(@NotNull Location location, @NotNull UUID uuid) {
        this(location, uuid, WrappedComponent.create(null));
    }

    public NPC(@NotNull Location location, @NotNull UUID uuid, @NotNull WrappedComponent name) {
        this.name = name;
        this.location = location;
        this.serverPlayer = WrappedServerPlayer.create(location, uuid, name);
        this.npcPath = NpcApi.plugin.getDataFolder().toPath().resolve("NPC").resolve(uuid + ".npc");
        this.options = new HashMap();
        for (NpcOption<?, ?> value : NpcOption.values()) {
            this.setOption(value, Var.unsafeCast(value.getDefaultValue()));
        }
        NpcManager.addNPC(this);
    }

    private NPC(@NotNull Location location, @NotNull WrappedComponent name, @NotNull Map<NpcOption<?, ?>, Object> options, @Nullable NpcClickAction clickEvent) {
        this(location, UUID.randomUUID(), name);
        this.options.putAll(options);
        this.clickEvent = clickEvent;
    }

    @NotNull
    public NPC copy(@NotNull Location newLocation) {
        return new NPC(newLocation, this.name.copy(), new HashMap(this.options), this.clickEvent == null ? null : this.clickEvent.copy());
    }

    public boolean isSaved() {
        return Files.exists(this.npcPath, new LinkOption[0]);
    }

    @Override
    public void save() throws IOException {
        this.npcPath.toFile().getParentFile().mkdirs();
        new ObjectSaver(this.npcPath.toFile()).write(SerializedNPC.serializedNPC(this), false);
        super.save();
    }

    @NotNull
    public WrappedServerPlayer getServerPlayer() {
        return this.serverPlayer;
    }

    @Nullable
    public NpcClickAction getClickEvent() {
        return this.clickEvent;
    }

    @NotNull
    public NPC setClickEvent(@Nullable NpcClickAction event) {
        this.clickEvent = event;
        return this;
    }

    public boolean isEnabled() {
        return this.getOption(NpcOption.ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.setOption(NpcOption.ENABLED, enabled);
        this.reload();
    }

    public boolean isEditable() {
        return this.getOption(NpcOption.EDITABLE);
    }

    public void setEditable(boolean editable) {
        this.setOption(NpcOption.EDITABLE, editable);
    }

    public <T> void setOption(@NotNull NpcOption<T, ?> option, @Nullable T value) {
        if (value == null) {
            this.options.remove(option);
        } else {
            this.options.put(option, value);
        }
        if (NpcApi.config.autoUpdate()) {
            option.getPacket(value, this, null).ifPresent(packetWrapper -> this.viewers.forEach(uuid -> {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) {
                    return;
                }
                WrappedServerPlayer.fromPlayer(player).sendPacket((PacketWrapper)packetWrapper);
            }));
        }
    }

    @NotNull
    public <T> T getOption(@NotNull NpcOption<T, ?> option) {
        return (T)this.options.getOrDefault(option, option.getDefaultValue());
    }

    public void playAnimation(@NotNull Player player, @NotNull AnimatePacket.Animation animation) {
        WrappedServerPlayer.fromPlayer(player).sendPacket(AnimatePacket.create(this.getServerPlayer(), animation));
    }

    public void reload() {
        ArrayList<UUID> viewers = new ArrayList<UUID>(this.viewers);
        this.hideNpcFromAllPlayers();
        WrappedPlayerTeam.clear(this.getServerPlayer().getName());
        viewers.stream().filter(uuid -> Bukkit.getPlayer((UUID)uuid) != null).forEach(uuid -> this.showNPCToPlayer(Bukkit.getPlayer((UUID)uuid)));
    }

    @NotNull
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(@NotNull Location location) {
        this.location = location;
        this.serverPlayer.moveTo(location);
    }

    @NotNull
    public UUID getUUID() {
        return this.serverPlayer.getUUID();
    }

    @NotNull
    public WrappedComponent getName() {
        return this.name;
    }

    public void setName(@NotNull WrappedComponent name) {
        this.name = name;
        this.serverPlayer.setListName(WrappedComponent.parseFromLegacy(name.toLegacy(false).replace("\n", "\\n")));
        this.viewers.stream().filter(uuid -> Bukkit.getPlayer((UUID)uuid) != null).forEach(uuid -> WrappedServerPlayer.fromPlayer(Bukkit.getPlayer((UUID)uuid)).sendPacket(SetEntityDataPacket.create(this.serverPlayer.getNameTag().getId(), this.serverPlayer.getNameTag().applyData(Versions.isCurrentVersionSmallerThan(Versions.V1_19_4) || this.isEnabled() ? name : WrappedComponent.parseFromLegacy(NpcApi.DISABLED_MESSAGE_PROVIDER.apply(Bukkit.getPlayer((UUID)uuid))).append(name)))));
    }

    @NotNull
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void showNpcToAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(this::showNPCToPlayer);
    }

    public void showNPCToPlayer(@NotNull Player player) {
        if (!this.getOption(NpcOption.ENABLED).booleanValue() && !player.isOp()) {
            return;
        }
        if (!player.getWorld().getName().equals(this.serverPlayer.getWorld().getName())) {
            this.hideNpcFromPlayer(player);
            return;
        }
        if (!this.serverPlayer.getWorld().isChunkLoaded(this.location.getBlockX() >> 4, this.location.getBlockZ() >> 4)) {
            return;
        }
        if (!this.viewers.contains(player.getUniqueId())) {
            this.viewers.add(player.getUniqueId());
        }
        ArrayList<PacketWrapper> packets = new ArrayList<PacketWrapper>();
        Arrays.stream(NpcOption.values()).filter(NpcOption::loadBefore).forEach(npcOption -> npcOption.getPacket(this.getOption((NpcOption)npcOption), this, player).ifPresent(packets::add));
        packets.add(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.ADD_PLAYER, this.serverPlayer));
        packets.add(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, this.serverPlayer));
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_19_3)) {
            packets.add(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_LISTED, this.serverPlayer));
        }
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_2)) {
            packets.add(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_LIST_ORDER, this.serverPlayer));
        }
        packets.add(this.serverPlayer.getAddEntityPacket());
        boolean modified = WrappedPlayerTeam.exists(player, this.getServerPlayer().getName());
        WrappedPlayerTeam wrappedPlayerTeam = WrappedPlayerTeam.create(player, this.getServerPlayer().getName());
        wrappedPlayerTeam.setNameTagVisibility(WrappedPlayerTeam.Visibility.NEVER);
        packets.add(SetPlayerTeamPacket.createAddOrModifyPacket(wrappedPlayerTeam, !modified));
        packets.add(SetPlayerTeamPacket.createPlayerPacket(wrappedPlayerTeam, this.getServerPlayer().getName(), SetPlayerTeamPacket.Action.ADD));
        packets.add(new RotateHeadPacket(this.serverPlayer, (byte)(this.location.getYaw() % 360.0f * 256.0f / 360.0f)));
        packets.add(new MoveEntityPacket.Rot(this.serverPlayer.getId(), (byte)this.location.getYaw(), (byte)this.location.getPitch(), this.serverPlayer.isOnGround()));
        WrappedEntityData data = this.serverPlayer.getEntityData();
        data.set(WrappedEntityData.EntityDataSerializers.OPTIONAL_CHAT_COMPONENT.create(2), Optional.of(WrappedComponent.create("NPC").getHandle()));
        data.set(WrappedEntityData.EntityDataSerializers.BOOLEAN.create(3), false);
        packets.add(SetEntityDataPacket.create(this.serverPlayer.getId(), data));
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_19_4) || !this.getOption(NpcOption.HIDE_NAMETAG).booleanValue()) {
            if (Versions.isCurrentVersionSmallerThan(Versions.V1_21)) {
                this.serverPlayer.getNameTag().moveTo(this.getLocation().clone().add(0.0, this.serverPlayer.getBoundingBox().getYSize() * this.getOption(NpcOption.SCALE), 0.0));
            }
            packets.add(this.serverPlayer.getNameTag().getAddEntityPacket());
            packets.add(SetEntityDataPacket.create(this.serverPlayer.getNameTag().getId(), this.serverPlayer.getNameTag().applyData(Versions.isCurrentVersionSmallerThan(Versions.V1_19_4) || this.isEnabled() ? this.name : WrappedComponent.parseFromLegacy(NpcApi.DISABLED_MESSAGE_PROVIDER.apply(player)).append(WrappedComponent.create("\n").append(this.name)))));
            if (!Versions.isCurrentVersionSmallerThan(Versions.V1_19_4)) {
                packets.add(new SetPassengerPacket(this.serverPlayer));
            }
        }
        Arrays.stream(NpcOption.values()).filter(npcOption -> !npcOption.equals(NpcOption.ENABLED) && !npcOption.loadBefore()).forEach(npcOption -> npcOption.getPacket(this.getOption((NpcOption)npcOption), this, player).ifPresent(packets::add));
        NpcOption.ENABLED.getPacket(this.isEnabled(), this, player).ifPresent(packets::add);
        WrappedServerPlayer wrappedServerPlayer = WrappedServerPlayer.fromPlayer(player);
        packets.forEach(wrappedServerPlayer::sendPacket);
    }

    public void hideNpcFromAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(this::hideNpcFromPlayer);
    }

    public void hideNpcFromPlayer(@NotNull Player player) {
        WrappedServerPlayer wrappedServerPlayer = WrappedServerPlayer.fromPlayer(player);
        wrappedServerPlayer.sendPacket(new RemoveEntityPacket(this.serverPlayer.getId()));
        wrappedServerPlayer.sendPacket(new RemoveEntityPacket(this.serverPlayer.getNameTag().getId()));
        if (WrappedPlayerTeam.exists(player, this.getServerPlayer().getName())) {
            WrappedPlayerTeam wrappedPlayerTeam = WrappedPlayerTeam.create(player, this.getServerPlayer().getName());
            wrappedServerPlayer.sendPacket(SetPlayerTeamPacket.createPlayerPacket(wrappedPlayerTeam, this.getServerPlayer().getName(), SetPlayerTeamPacket.Action.REMOVE));
            wrappedServerPlayer.sendPacket(SetPlayerTeamPacket.createRemovePacket(wrappedPlayerTeam));
        }
        this.toDeleteEntities.forEach(integer -> wrappedServerPlayer.sendPacket(new RemoveEntityPacket((int)integer)));
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_19_3)) {
            wrappedServerPlayer.sendPacket(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.REMOVE_PLAYER, this.serverPlayer));
        } else {
            wrappedServerPlayer.sendPacket(new PlayerInfoRemovePacket(List.of(this.getUUID())));
        }
        this.viewers.remove(player.getUniqueId());
    }

    public void delete() throws IOException {
        this.hideNpcFromAllPlayers();
        NpcManager.removeNPC(this);
        ((Player)this.serverPlayer.getBukkitPlayer()).remove();
        this.serverPlayer.remove();
        this.serverPlayer = null;
        this.npcPath.toFile().getParentFile().mkdirs();
        Files.deleteIfExists(this.npcPath);
    }

    public void lookAtPlayer(@NotNull Player viewer) {
        Location npcLoc = ((Player)this.serverPlayer.getBukkitPlayer()).getLocation();
        Location playerLoc = viewer.getLocation();
        if (npcLoc.getWorld() != playerLoc.getWorld()) {
            return;
        }
        double dx = playerLoc.getX() - npcLoc.getX();
        double dy = playerLoc.getY() + viewer.getEyeHeight() - (npcLoc.getY() + ((Player)this.serverPlayer.getBukkitPlayer()).getEyeHeight() * this.getOption(NpcOption.SCALE));
        double dz = playerLoc.getZ() - npcLoc.getZ();
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
        float pitch = (float)Math.toDegrees(-Math.atan2(dy, distanceXZ));
        byte yawByte = (byte)(yaw * 256.0f / 360.0f);
        byte pitchByte = (byte)(pitch * 256.0f / 360.0f);
        WrappedServerPlayer player = WrappedServerPlayer.fromPlayer(viewer);
        player.sendPacket(new RotateHeadPacket(this.serverPlayer, yawByte));
        player.sendPacket(new MoveEntityPacket.Rot(this.serverPlayer.getId(), yawByte, pitchByte, this.serverPlayer.isOnGround()));
    }

    @NotNull
    public BukkitTask walkTo(final @NotNull de.eisi05.npc.api.pathfinding.Path path, final @Nullable Player player, double walkSpeed, final boolean changeRealLocation, final @Nullable Consumer<Result> onEnd) {
        final double speed = Math.max(Math.min(walkSpeed, 1.0), 0.1);
        double gravity = -0.08;
        double jumpVelocity = 0.5;
        double terminal = -0.5;
        double stepHeight = 0.6;
        return new BukkitRunnable(){
            final List<Location> pathPoints;
            int index;
            Vector current;
            double yVel;
            float previousYaw;
            Vector previousMovement;
            {
                this.pathPoints = path.asLocations();
                this.index = 0;
                this.current = NPC.this.location.toVector();
                this.yVel = 0.0;
                this.previousYaw = NPC.this.location.getYaw();
                this.previousMovement = NPC.this.location.getDirection();
            }

            public void run() {
                float yaw;
                float targetYaw;
                Vector lookDir;
                boolean onGround;
                if (this.index >= this.pathPoints.size()) {
                    Location last = this.pathPoints.get(this.pathPoints.size() - 1);
                    Vector lastVector = last.toVector();
                    Vector lastMovement = lastVector.clone().subtract(this.current);
                    RotateHeadPacket rotateHeadPacket = new RotateHeadPacket(NPC.this.serverPlayer, (byte)(last.getYaw() * 256.0f / 360.0f));
                    TeleportEntityPacket teleportEntityPacket = new TeleportEntityPacket(NPC.this.serverPlayer, new TeleportEntityPacket.PositionMoveRotation(lastVector, lastMovement, last.getYaw(), last.getPitch()), Set.of(), true);
                    TeleportEntityPacket teleportNameTagPacket = null;
                    if (Versions.isCurrentVersionSmallerThan(Versions.V1_19_4)) {
                        Vector nameTagVector = lastVector.clone().add(new Vector(0.0, NPC.this.serverPlayer.getBoundingBox().getYSize() * NPC.this.getOption(NpcOption.SCALE), 0.0));
                        teleportNameTagPacket = new TeleportEntityPacket(NPC.this.serverPlayer.getNameTag(), new TeleportEntityPacket.PositionMoveRotation(nameTagVector, lastMovement, 0.0f, 0.0f), Set.of(), false);
                    }
                    NPC.this.sendNpcMovePackets(player, teleportEntityPacket, rotateHeadPacket, teleportNameTagPacket);
                    if (changeRealLocation) {
                        NPC.this.setLocation(last);
                        if (player != null) {
                            for (UUID uuid : NPC.this.viewers) {
                                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                                if (!offlinePlayer.isOnline() || uuid.equals(player.getUniqueId())) continue;
                                NPC.this.hideNpcFromPlayer(offlinePlayer.getPlayer());
                                NPC.this.showNPCToPlayer(offlinePlayer.getPlayer());
                            }
                        }
                    }
                    if (onEnd != null) {
                        onEnd.accept((Object)Result.SUCCESS);
                    }
                    this.cancel();
                    return;
                }
                Vector target = this.pathPoints.get(this.index).toVector();
                Vector toTarget = target.clone().subtract(this.current);
                if (toTarget.lengthSquared() < 0.04 && Math.abs(toTarget.getY()) < 0.2) {
                    ++this.index;
                    return;
                }
                Vector horizontal = new Vector(toTarget.getX(), 0.0, toTarget.getZ());
                Vector horizontalMove = horizontal.lengthSquared() > 1.0E-6 ? horizontal.clone().normalize().multiply(speed) : new Vector(0, 0, 0);
                double nextDist = target.clone().subtract(this.current.clone().add(horizontalMove)).lengthSquared();
                if (nextDist > toTarget.lengthSquared()) {
                    this.current = target;
                    ++this.index;
                    return;
                }
                World world = NPC.this.location.getWorld();
                int bx = (int)Math.floor(this.current.getX());
                int bz = (int)Math.floor(this.current.getZ());
                int searchStart = (int)Math.floor(this.current.getY());
                int groundBlockY = Integer.MIN_VALUE;
                for (int y = searchStart; y >= searchStart - 3; --y) {
                    Block block = world.getBlockAt(bx, y - 1, bz);
                    if (!block.getType().isSolid() || block.getType().isAir() || block.isPassable()) continue;
                    groundBlockY = y - 1;
                    break;
                }
                if (groundBlockY == Integer.MIN_VALUE) {
                    groundBlockY = world.getHighestBlockYAt(bx, bz) - 1;
                }
                double groundY = (double)groundBlockY + 1.0;
                boolean bl = onGround = this.current.getY() <= groundY + 1.0E-5;
                if (onGround) {
                    if (toTarget.getY() > 0.0 && toTarget.getY() <= 0.6 && horizontal.lengthSquared() > 1.0E-6) {
                        this.current = this.current.clone().add(new Vector(0.0, Math.min(toTarget.getY(), 0.6), 0.0));
                        this.yVel = 0.0;
                        onGround = true;
                    } else if (toTarget.getY() > 0.5) {
                        this.yVel = 0.5;
                        onGround = false;
                    } else {
                        this.yVel = 0.0;
                        this.current = new Vector(this.current.getX(), groundY, this.current.getZ());
                    }
                }
                double yDelta = 0.0;
                if (!onGround) {
                    this.yVel += -0.08;
                    if (this.yVel < -0.5) {
                        this.yVel = -0.5;
                    }
                    yDelta = this.yVel;
                    if (this.current.getY() + yDelta <= groundY) {
                        yDelta = groundY - this.current.getY();
                        this.yVel = 0.0;
                        onGround = true;
                    }
                }
                Vector movement = new Vector(horizontalMove.getX(), yDelta, horizontalMove.getZ());
                this.current = this.current.clone().add(movement);
                if (this.index + 1 < this.pathPoints.size()) {
                    Vector currentTarget = this.pathPoints.get(this.index).toVector().clone();
                    Vector nextTarget = this.pathPoints.get(this.index + 1).toVector().clone();
                    lookDir = currentTarget.clone().add(nextTarget).multiply(0.5).subtract(this.current);
                } else {
                    lookDir = this.pathPoints.get(this.index).toVector().clone().subtract(this.current);
                }
                Vector horizontalVec = new Vector(lookDir.getX(), 0.0, lookDir.getZ());
                if (horizontalVec.lengthSquared() < 1.0E-6) {
                    horizontalVec = this.previousMovement.clone();
                }
                for (targetYaw = (float)(Math.atan2(horizontalVec.getZ(), horizontalVec.getX()) * 180.0 / Math.PI - 90.0); targetYaw > 180.0f; targetYaw -= 360.0f) {
                }
                while (targetYaw < -180.0f) {
                    targetYaw += 360.0f;
                }
                float diff = targetYaw - this.previousYaw;
                if (diff > 180.0f) {
                    diff -= 360.0f;
                }
                if (diff < -180.0f) {
                    diff += 360.0f;
                }
                float maxTurn = 15.0f;
                diff = Math.max(-maxTurn, Math.min(maxTurn, diff));
                this.previousYaw = yaw = this.previousYaw + diff;
                this.previousMovement = horizontalVec.clone();
                Vector targetVec = this.pathPoints.get(Math.min(this.index + 1, this.pathPoints.size() - 1)).toVector().clone().subtract(this.current);
                double horizontalLen = Math.sqrt(targetVec.getX() * targetVec.getX() + targetVec.getZ() * targetVec.getZ());
                float pitch = (float)(-Math.atan2(targetVec.getY(), horizontalLen) * 180.0 / Math.PI) / 1.5f;
                RotateHeadPacket rotateHeadPacket = new RotateHeadPacket(NPC.this.serverPlayer, (byte)(yaw * 256.0f / 360.0f));
                TeleportEntityPacket teleportEntityPacket = new TeleportEntityPacket(NPC.this.serverPlayer, new TeleportEntityPacket.PositionMoveRotation(this.current, movement, yaw, pitch), Set.of(), onGround);
                TeleportEntityPacket teleportNameTagPacket = null;
                if (Versions.isCurrentVersionSmallerThan(Versions.V1_19_4)) {
                    Vector nameTagVector = this.current.clone().add(new Vector(0.0, NPC.this.serverPlayer.getBoundingBox().getYSize() * NPC.this.getOption(NpcOption.SCALE), 0.0));
                    teleportNameTagPacket = new TeleportEntityPacket(NPC.this.serverPlayer.getNameTag(), new TeleportEntityPacket.PositionMoveRotation(nameTagVector, movement, 0.0f, 0.0f), Set.of(), false);
                }
                NPC.this.sendNpcMovePackets(player, teleportEntityPacket, rotateHeadPacket, teleportNameTagPacket);
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                if (onEnd != null) {
                    onEnd.accept((Object)Result.CANCELLED);
                }
            }
        }.runTaskTimer(NpcApi.plugin, 1L, 1L);
    }

    private void sendNpcMovePackets(@Nullable Player player, @NotNull TeleportEntityPacket teleportEntityPacket, @NotNull RotateHeadPacket rotateHeadPacket, @Nullable TeleportEntityPacket teleportNameTagPacket) {
        if (player != null) {
            WrappedServerPlayer serverPlayer1 = WrappedServerPlayer.fromPlayer(player);
            serverPlayer1.sendPacket(teleportEntityPacket);
            serverPlayer1.sendPacket(rotateHeadPacket);
            if (teleportNameTagPacket != null) {
                serverPlayer1.sendPacket(teleportNameTagPacket);
            }
        } else {
            for (UUID uuid : this.viewers) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (!offlinePlayer.isOnline()) continue;
                WrappedServerPlayer serverPlayer1 = WrappedServerPlayer.fromPlayer(offlinePlayer.getPlayer());
                serverPlayer1.sendPacket(teleportEntityPacket);
                serverPlayer1.sendPacket(rotateHeadPacket);
                if (teleportNameTagPacket == null) continue;
                serverPlayer1.sendPacket(teleportNameTagPacket);
            }
        }
    }

    void changeUUID(@NotNull UUID newUUID) {
        try {
            Files.deleteIfExists(this.npcPath);
            this.npcPath = NpcApi.plugin.getDataFolder().toPath().resolve("NPC").resolve(newUUID + ".npc");
            this.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public record SerializedNPC(@NotNull UUID world, double x, double y, double z, float yaw, float pitch, @NotNull UUID id, @NotNull WrappedComponent.SerializedComponent name, @NotNull Map<String, ? extends Serializable> options, @Nullable NpcClickAction clickEvent, @NotNull Instant createdAt) implements Serializable
    {
        private static final long serialVersionUID = 1L;

        @NotNull
        public static SerializedNPC serializedNPC(@NotNull NPC npc) {
            return new SerializedNPC(npc.getLocation().getWorld().getUID(), npc.getLocation().getX(), npc.getLocation().getY(), npc.getLocation().getZ(), npc.getLocation().getYaw(), npc.getLocation().getPitch(), npc.getUUID(), npc.getName().serialize(), npc.options.keySet().stream().collect(Collectors.toMap(NpcOption::getPath, npcOption -> npcOption.serialize(npc.getOption(npcOption)))), npc.clickEvent, npc.createdAt);
        }

        @NotNull
        public <T, S extends Serializable> NPC deserializedNPC() {
            NPC npc = new NPC(new Location(Bukkit.getWorld((UUID)this.world), this.x, this.y, this.z, this.yaw, this.pitch), this.id, this.name.deserialize()).setClickEvent(this.clickEvent == null ? this.clickEvent : this.clickEvent.initialize());
            this.options.forEach((string, serializable) -> NpcOption.getOption(string).ifPresent(npcOption -> npc.setOption(npcOption, npcOption.deserialize((Serializable)Var.unsafeCast(serializable)))));
            npc.createdAt = this.createdAt == null ? Instant.now() : this.createdAt;
            return npc;
        }
    }
}

