/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import com.google.common.collect.Multimaps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Pair;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.enums.SkinParts;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.Skin;
import de.eisi05.npc.api.utils.ItemSerializer;
import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.TriFunction;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.enums.ChatFormat;
import de.eisi05.npc.api.wrapper.enums.EquipmentSlot;
import de.eisi05.npc.api.wrapper.enums.Pose;
import de.eisi05.npc.api.wrapper.objects.WrappedArmorStand;
import de.eisi05.npc.api.wrapper.objects.WrappedAttributeInstance;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import de.eisi05.npc.api.wrapper.objects.WrappedEntity;
import de.eisi05.npc.api.wrapper.objects.WrappedEntityData;
import de.eisi05.npc.api.wrapper.objects.WrappedPlayerTeam;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import de.eisi05.npc.api.wrapper.objects.WrappedTextDisplay;
import de.eisi05.npc.api.wrapper.packets.BundlePacket;
import de.eisi05.npc.api.wrapper.packets.PacketWrapper;
import de.eisi05.npc.api.wrapper.packets.PlayerInfoRemovePacket;
import de.eisi05.npc.api.wrapper.packets.PlayerInfoUpdatePacket;
import de.eisi05.npc.api.wrapper.packets.RemoveEntityPacket;
import de.eisi05.npc.api.wrapper.packets.SetEntityDataPacket;
import de.eisi05.npc.api.wrapper.packets.SetEquipmentPacket;
import de.eisi05.npc.api.wrapper.packets.SetPlayerTeamPacket;
import de.eisi05.npc.api.wrapper.packets.UpdateAttributesPacket;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpcOption<T, S extends Serializable> {
    public static final NpcOption<Boolean, Boolean> USE_PLAYER_SKIN = new NpcOption<Boolean, Boolean>("use-player-skin", false, aBoolean -> aBoolean, aBoolean -> aBoolean, (skin, npc, player) -> {
        if (!skin.booleanValue()) {
            return null;
        }
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) {
            Property npcProperty;
            Iterator textureProperties = ((PropertyMap)Reflections.getField(WrappedServerPlayer.fromPlayer(player).getGameProfile(), "properties").get()).get((Object)"textures").iterator();
            Iterator npcTextureProperties = ((PropertyMap)Reflections.getField(npc.getServerPlayer().getGameProfile(), "properties").get()).get((Object)"textures").iterator();
            Property property = textureProperties.hasNext() ? (Property)textureProperties.next() : null;
            Property property2 = npcProperty = npcTextureProperties.hasNext() ? (Property)npcTextureProperties.next() : null;
            if (property == null && npcProperty == null || property != null && npcProperty != null && Reflections.getField(property, "value").get().equals(Reflections.getField(npcProperty, "value").get())) {
                return null;
            }
            UUID newUUID = UUID.randomUUID();
            npc.changeUUID(newUUID);
            GameProfile profile = Reflections.getInstance(GameProfile.class, newUUID, "NPC" + newUUID.toString().substring(0, 13), Reflections.getInstance(PropertyMap.class, Multimaps.forMap(property == null ? Map.of() : Map.of("textures", property))).orElseThrow()).orElseThrow();
            npc.serverPlayer = WrappedServerPlayer.create(npc.getLocation(), newUUID, profile, npc.getName());
            return null;
        }
        Iterator textureProperties = WrappedServerPlayer.fromPlayer(player).getGameProfile().getProperties().get((Object)"textures").iterator();
        npc.getServerPlayer().getGameProfile().getProperties().removeAll((Object)"textures");
        if (!textureProperties.hasNext()) {
            return null;
        }
        Property textureProperty = (Property)textureProperties.next();
        npc.getServerPlayer().getGameProfile().getProperties().put((Object)"textures", (Object)textureProperty);
        return null;
    }).loadBefore(!Versions.isCurrentVersionSmallerThan(Versions.V1_21_9));
    public static final NpcOption<Skin, Skin> SKIN = new NpcOption<Skin, Skin>("skin", null, skin -> skin, skin -> skin, (skin, npc, player) -> {
        if (npc.getOption(USE_PLAYER_SKIN).booleanValue()) {
            return null;
        }
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) {
            Property npcProperty;
            Iterator npcTextureProperties = ((PropertyMap)Reflections.getField(npc.getServerPlayer().getGameProfile(), "properties").get()).get((Object)"textures").iterator();
            Property property = npcProperty = npcTextureProperties.hasNext() ? (Property)npcTextureProperties.next() : null;
            if (skin == null && npcProperty == null || npcProperty != null && skin.value().equals(Reflections.getField(npcProperty, "value").get())) {
                return null;
            }
            UUID newUUID = UUID.randomUUID();
            npc.changeUUID(newUUID);
            PropertyMap propertyMap = Reflections.getInstance(PropertyMap.class, Multimaps.forMap(skin == null ? Map.of() : Map.of("textures", new Property("textures", skin.value(), skin.signature())))).orElseThrow();
            GameProfile profile = Reflections.getInstance(GameProfile.class, newUUID, "NPC" + newUUID.toString().substring(0, 13), propertyMap).orElseThrow();
            npc.serverPlayer = WrappedServerPlayer.create(npc.getLocation(), newUUID, profile, npc.getName());
            return null;
        }
        npc.getServerPlayer().getGameProfile().getProperties().removeAll((Object)"textures");
        if (skin == null) {
            return null;
        }
        npc.getServerPlayer().getGameProfile().getProperties().put((Object)"textures", (Object)new Property("textures", skin.value(), skin.signature()));
        return null;
    }).loadBefore(!Versions.isCurrentVersionSmallerThan(Versions.V1_21_9));
    public static final NpcOption<Boolean, Boolean> SHOW_TAB_LIST = new NpcOption<Boolean, Boolean>("show-tab-list", true, aBoolean -> aBoolean, aBoolean -> aBoolean, (show, npc, player) -> {
        if (show.booleanValue()) {
            return null;
        }
        new BukkitRunnable((Player)player, (NPC)npc){
            final /* synthetic */ Player val$player;
            final /* synthetic */ NPC val$npc;
            {
                this.val$player = player;
                this.val$npc = nPC;
            }

            public void run() {
                if (Versions.isCurrentVersionSmallerThan(Versions.V1_19_3)) {
                    WrappedServerPlayer.fromPlayer(this.val$player).sendPacket(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.REMOVE_PLAYER, this.val$npc.getServerPlayer()));
                } else {
                    WrappedServerPlayer.fromPlayer(this.val$player).sendPacket(new PlayerInfoRemovePacket(List.of(this.val$npc.getUUID())));
                }
            }
        }.runTaskLater(NpcApi.plugin, 50L);
        return null;
    });
    public static final NpcOption<Integer, Integer> LATENCY = new NpcOption<Integer, Integer>("latency", 0, aInteger -> aInteger, aInteger -> aInteger, (latency, npc, player) -> {
        npc.getServerPlayer().setLatency((int)latency);
        return new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_LATENCY, npc.getServerPlayer());
    });
    public static final NpcOption<Boolean, Boolean> HIDE_NAMETAG = new NpcOption<Boolean, Boolean>("hide-nametag", false, aBoolean -> aBoolean, aBoolean -> aBoolean, (hide, npc, player) -> {
        WrappedEntity.WrappedNameTag<?> nameTag = npc.getServerPlayer().getNameTag();
        WrappedEntityData data = npc.getServerPlayer().getNameTag().getEntityData();
        if (nameTag instanceof WrappedArmorStand) {
            data.set(WrappedEntityData.EntityDataSerializers.BOOLEAN.create(3), hide == false);
        } else if (nameTag instanceof WrappedTextDisplay) {
            if (!hide.booleanValue()) {
                return null;
            }
            return new RemoveEntityPacket(npc.getServerPlayer().getNameTag().getId());
        }
        return SetEntityDataPacket.create(npc.getServerPlayer().getNameTag().getId(), data);
    });
    public static final NpcOption<org.bukkit.entity.Pose, org.bukkit.entity.Pose> POSE = new NpcOption<org.bukkit.entity.Pose, org.bukkit.entity.Pose>("pose", org.bukkit.entity.Pose.STANDING, pose -> pose, pose -> pose, (pose, npc, player) -> {
        Pose nmsPose = Pose.fromBukkit(pose);
        if (nmsPose == null) {
            throw new RuntimeException("Pose (" + pose.name() + ") not found");
        }
        npc.getServerPlayer().setPose(nmsPose);
        WrappedEntityData data = npc.getServerPlayer().getEntityData();
        data.set(WrappedEntityData.EntityDataSerializers.ENTITY_POSE.create(6), nmsPose);
        if (pose == org.bukkit.entity.Pose.SPIN_ATTACK) {
            data.set(WrappedEntityData.EntityDataSerializers.BYTE.create(8), (byte)4);
        } else {
            data.set(WrappedEntityData.EntityDataSerializers.BYTE.create(8), (byte)1);
        }
        return SetEntityDataPacket.create(npc.getServerPlayer().getId(), data);
    });
    public static final NpcOption<Map<org.bukkit.inventory.EquipmentSlot, ItemStack>, HashMap<org.bukkit.inventory.EquipmentSlot, String>> EQUIPMENT = new NpcOption<Map, HashMap>("equipment", Map.of(), map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ItemSerializer.itemStackToBase64((ItemStack)entry.getValue()), (a, b) -> b, HashMap::new)), serializedMap -> serializedMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ItemSerializer.itemStackFromBase64((String)entry.getValue()), (a, b) -> b, HashMap::new)), (map, npc, player) -> {
        if (map.isEmpty()) {
            return null;
        }
        ArrayList list = new ArrayList();
        map.forEach((slot, item) -> list.add(new Pair(EquipmentSlot.values()[slot.ordinal()].getHandle(), Var.toNmsItemStack(item))));
        return new SetEquipmentPacket(npc.getServerPlayer().getId(), list);
    });
    public static final NpcOption<SkinParts[], SkinParts[]> SKIN_PARTS = new NpcOption<SkinParts[], SkinParts[]>("skin-parts", SkinParts.values(), skinParts -> skinParts, skinParts -> skinParts, (skinParts, npc, player) -> {
        WrappedEntityData data = npc.getServerPlayer().getEntityData();
        data.set(WrappedEntityData.EntityDataSerializers.BYTE.create(Versions.isCurrentVersionSmallerThan(Versions.V1_21_9) ? 17 : 16), (byte)Arrays.stream(skinParts).mapToInt(SkinParts::getValue).sum());
        return SetEntityDataPacket.create(npc.getServerPlayer().getId(), data);
    });
    public static final NpcOption<Double, Double> LOOK_AT_PLAYER = new NpcOption<Double, Double>("look-at-player", 0.0, distance -> distance, distance -> distance, (distance, npc, player) -> null);
    public static final NpcOption<ChatColor, ChatColor> GLOWING = new NpcOption<ChatColor, ChatColor>("glowing", null, color -> color, color -> color, (color, npc, player) -> {
        if (color == null) {
            WrappedEntityData entityData = npc.getServerPlayer().getEntityData();
            entityData.set(WrappedEntityData.EntityDataSerializers.BYTE.create(0), (byte)0);
            return SetEntityDataPacket.create(npc.getServerPlayer().getId(), entityData);
        }
        String teamName = npc.getServerPlayer().getName();
        boolean modified = WrappedPlayerTeam.exists(player, teamName);
        WrappedPlayerTeam wrappedPlayerTeam = WrappedPlayerTeam.create(player, teamName);
        wrappedPlayerTeam.setColor(ChatFormat.fromChatColor(color));
        SetPlayerTeamPacket teamPacket = SetPlayerTeamPacket.createAddOrModifyPacket(wrappedPlayerTeam, !modified);
        WrappedEntityData entityData = npc.getServerPlayer().getEntityData();
        entityData.set(WrappedEntityData.EntityDataSerializers.BYTE.create(0), (byte)64);
        return new BundlePacket(teamPacket, SetEntityDataPacket.create(npc.getServerPlayer().getId(), entityData));
    });
    public static final NpcOption<Double, Double> SCALE = new NpcOption<Double, Double>("scale", 1.0, scale -> scale, scale -> scale, (scale, npc, player) -> {
        WrappedAttributeInstance instance = npc.getServerPlayer().getAttribute(WrappedAttributeInstance.Attributes.SCALE_HOLDER);
        instance.setBaseValue((double)scale);
        return new UpdateAttributesPacket(npc.getServerPlayer().getId(), instance);
    }).since(Versions.V1_20_6);
    public static final NpcOption<Integer, Integer> LIST_ORDER = new NpcOption<Integer, Integer>("list-order", 0, aInt -> aInt, aInt -> aInt, (order, npc, player) -> {
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_2)) {
            return null;
        }
        npc.getServerPlayer().setListOrder((int)order);
        return new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_LIST_ORDER, npc.getServerPlayer());
    }).since(Versions.V1_21_2);
    static final NpcOption<Boolean, Boolean> ENABLED = new NpcOption<Boolean, Boolean>("enabled", false, aBoolean -> aBoolean, aBoolean -> aBoolean, (enabled, npc, player) -> {
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_19_4)) {
            return null;
        }
        if (enabled.booleanValue()) {
            return null;
        }
        WrappedArmorStand armorStand = WrappedArmorStand.create(npc.getLocation().getWorld());
        armorStand.moveTo(npc.getLocation().clone().add(0.0, npc.getServerPlayer().getBoundingBox().getYSize() * npc.getOption(SCALE), 0.0));
        PacketWrapper addPacket = armorStand.getAddEntityPacket();
        WrappedEntityData data = armorStand.getEntityData();
        data.set(WrappedEntityData.EntityDataSerializers.BYTE.create(0), (byte)32);
        data.set(WrappedEntityData.EntityDataSerializers.OPTIONAL_CHAT_COMPONENT.create(2), Optional.of(WrappedComponent.parseFromLegacy(NpcApi.DISABLED_MESSAGE_PROVIDER.apply((Player)player)).getHandle()));
        data.set(WrappedEntityData.EntityDataSerializers.BOOLEAN.create(3), true);
        data.set(WrappedEntityData.EntityDataSerializers.BOOLEAN.create(4), true);
        data.set(WrappedEntityData.EntityDataSerializers.BYTE.create(15), (byte)16);
        npc.toDeleteEntities.add(armorStand.getId());
        return new BundlePacket(addPacket, SetEntityDataPacket.create(armorStand.getId(), data));
    });
    static final NpcOption<Boolean, Boolean> EDITABLE = new NpcOption<Boolean, Boolean>("editable", false, aBoolean -> aBoolean, aBoolean -> aBoolean, (enabled, npc, player) -> null);
    private final String path;
    private final T defaultValue;
    private final Function<T, S> serializer;
    private final Function<S, T> deserializer;
    private final TriFunction<T, NPC, Player, PacketWrapper> packet;
    private Versions since = Versions.V1_17;
    private boolean loadBefore = false;

    private NpcOption(@NotNull String path, @Nullable T defaultValue, @NotNull Function<T, S> serializer, @NotNull Function<S, T> deserializer, @NotNull TriFunction<T, NPC, Player, PacketWrapper> packet) {
        this.path = path;
        this.defaultValue = defaultValue;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.packet = packet;
    }

    @NotNull
    public static NpcOption<?, ?>[] values() {
        List<Field> fields = Arrays.stream(NpcOption.class.getDeclaredFields()).filter(field -> field.getType().equals(NpcOption.class)).toList();
        NpcOption[] values = new NpcOption[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            try {
                values[i] = (NpcOption)fields.get(i).get(null);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return values;
    }

    @NotNull
    public static Optional<NpcOption<?, ?>> getOption(@NotNull String path) {
        return Arrays.stream(NpcOption.values()).filter(npcOption -> npcOption.getPath().equals(path)).findFirst();
    }

    @NotNull
    public NpcOption<T, S> since(@NotNull Versions since) {
        this.since = since;
        return this;
    }

    @NotNull
    public NpcOption<T, S> loadBefore(boolean loadBefore) {
        this.loadBefore = loadBefore;
        return this;
    }

    public boolean loadBefore() {
        return this.loadBefore;
    }

    public boolean isCompatible() {
        return !Versions.isCurrentVersionSmallerThan(this.since);
    }

    public Versions since() {
        return this.since;
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public S serialize(@Nullable Object var1) {
        try {
            return (S)((Serializable)this.serializer.apply(var1));
        }
        catch (ClassCastException e) {
            throw new RuntimeException(this.path + " -> " + var1);
        }
    }

    @Nullable
    public T deserialize(@Nullable S var1) {
        return this.deserializer.apply(var1);
    }

    @NotNull
    public Optional<PacketWrapper> getPacket(@Nullable Object object, @NotNull NPC npc, @NotNull Player player) {
        if (this.packet == null || !this.isCompatible()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.packet.apply(object, npc, player));
    }
}

