/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.wrapper.objects;

import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.Mapping;
import de.eisi05.npc.api.wrapper.Wrapper;
import de.eisi05.npc.api.wrapper.enums.ChatFormat;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_9), path="net.minecraft.world.scores.ScoreboardTeam")
public class WrappedPlayerTeam
extends Wrapper {
    private static final Map<UUID, Map<String, WrappedPlayerTeam>> teams = new HashMap<UUID, Map<String, WrappedPlayerTeam>>();

    private WrappedPlayerTeam(Object handle) {
        super(handle);
    }

    @NotNull
    public static WrappedPlayerTeam create(@NotNull Player player, @NotNull String name) {
        if (WrappedPlayerTeam.exists(player, name)) {
            return teams.get(player.getUniqueId()).get(name);
        }
        Object scoreboard = Reflections.invokeMethod(player.getScoreboard(), "getHandle", new Object[0]).get();
        WrappedPlayerTeam wrappedPlayerTeam = WrappedPlayerTeam.createWrappedInstance(WrappedPlayerTeam.class, scoreboard, name);
        Map map = teams.getOrDefault(player.getUniqueId(), new HashMap());
        map.put(name, wrappedPlayerTeam);
        teams.put(player.getUniqueId(), map);
        return wrappedPlayerTeam;
    }

    public static void clear() {
        teams.clear();
    }

    public static void clear(String name) {
        for (Map.Entry<UUID, Map<String, WrappedPlayerTeam>> entry : teams.entrySet()) {
            entry.getValue().keySet().removeIf(s -> s.equals(name));
        }
    }

    public static boolean exists(@NotNull Player player, @NotNull String name) {
        return ((Map)teams.getOrDefault(player.getUniqueId(), new HashMap())).containsKey(name);
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_9), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="setNameTagVisibility")})
    public void setNameTagVisibility(@NotNull Visibility visibility) {
        this.invokeWrappedMethod(visibility.getHandle());
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_5, to=Versions.V1_21_9), path="h"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_4), path="g"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="getPlayerNameSet")})
    @NotNull
    public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_5, to=Versions.V1_21_9), path="h"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_4), path="g"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="getPlayerNameSet")}) @NotNull Collection<String> getPlayers() {
        return (Collection)this.invokeWrappedMethod(new Object[0]);
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_5, to=Versions.V1_21_9), path="c"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_4), path="b"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="getName")})
    @NotNull
    public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_5, to=Versions.V1_21_9), path="c"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_4), path="b"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="getName")}) @NotNull String getName() {
        return (String)this.invokeWrappedMethod(new Object[0]);
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_9), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="setColor")})
    public void setColor(@NotNull ChatFormat color) {
        this.invokeWrappedMethod(color);
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_9), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="setPrefix")})
    public void setPrefix(@NotNull WrappedComponent prefix) {
        this.invokeWrappedMethod(prefix);
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_9), path="net.minecraft.world.scores.ScoreboardTeamBase$EnumNameTagVisibility")
    public static enum Visibility implements Wrapper.EnumWrapper
    {
        ALWAYS,
        NEVER,
        HIDE_FOR_OTHER_TEAMS,
        HIDE_FOR_OWN_TEAM;


        @Override
        @NotNull
        public Object getHandle() {
            return this.cast(this);
        }
    }
}

