/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.wrapper.objects;

import com.mojang.authlib.GameProfile;
import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.utils.exceptions.VersionNotFound;
import de.eisi05.npc.api.wrapper.Mapping;
import de.eisi05.npc.api.wrapper.Wrapper;
import de.eisi05.npc.api.wrapper.enums.Pose;
import de.eisi05.npc.api.wrapper.objects.WrappedArmorStand;
import de.eisi05.npc.api.wrapper.objects.WrappedAttributeInstance;
import de.eisi05.npc.api.wrapper.objects.WrappedClientInformation;
import de.eisi05.npc.api.wrapper.objects.WrappedCommandSourceStack;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import de.eisi05.npc.api.wrapper.objects.WrappedConnection;
import de.eisi05.npc.api.wrapper.objects.WrappedEntity;
import de.eisi05.npc.api.wrapper.objects.WrappedMinecraftServer;
import de.eisi05.npc.api.wrapper.objects.WrappedTextDisplay;
import de.eisi05.npc.api.wrapper.packets.BundlePacket;
import de.eisi05.npc.api.wrapper.packets.ChatPacket;
import de.eisi05.npc.api.wrapper.packets.PacketWrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_9), path="net.minecraft.server.level.EntityPlayer")
public class WrappedServerPlayer
extends WrappedEntity<Player> {
    private static final Map<UUID, WrappedServerPlayer> map = new HashMap<UUID, WrappedServerPlayer>();
    private WrappedEntity.WrappedNameTag<?> nameDisplay;

    WrappedServerPlayer(Object serverPlayer) {
        super(serverPlayer);
    }

    @NotNull
    public static WrappedServerPlayer fromPlayer(@NotNull Player player) {
        return WrappedServerPlayer.fromEntity(player, WrappedServerPlayer.class);
    }

    @NotNull
    public static WrappedServerPlayer create(@NotNull Location location, @NotNull UUID uuid, @NotNull GameProfile gameProfile, @NotNull WrappedComponent name) {
        if (map.containsKey(uuid)) {
            return map.get(uuid);
        }
        Object mcServer = WrappedMinecraftServer.INSTANCE.getHandle();
        Object serverLevel = Var.getNmsLevel(location.getWorld());
        Class<?> targetClass = PacketWrapper.getWrappedClass(WrappedServerPlayer.class);
        if (targetClass == null) {
            throw new VersionNotFound(targetClass);
        }
        WrappedServerPlayer wrappedServerPlayer = switch (Versions.getVersion()) {
            default -> throw new IncompatibleClassChangeError();
            case Versions.V1_17, Versions.V1_18, Versions.V1_18_2, Versions.V1_19_3, Versions.V1_19_4, Versions.V1_20 -> WrappedServerPlayer.createWrappedInstance(WrappedServerPlayer.class, mcServer, serverLevel, gameProfile);
            case Versions.V1_19, Versions.V1_19_1 -> WrappedServerPlayer.createWrappedInstance(WrappedServerPlayer.class, mcServer, serverLevel, gameProfile, null);
            case Versions.V1_20_2, Versions.V1_20_4, Versions.V1_20_6, Versions.V1_21, Versions.V1_21_2, Versions.V1_21_4, Versions.V1_21_5, Versions.V1_21_6, Versions.V1_21_9 -> {
                WrappedServerPlayer serverPlayer = WrappedServerPlayer.createWrappedInstance(WrappedServerPlayer.class, mcServer, serverLevel, gameProfile, WrappedClientInformation.createDefault().getHandle());
                serverPlayer.setConnection(new WrappedConnection(WrappedMinecraftServer.INSTANCE, WrappedConnection.WrappedNetworkManager.create(WrappedConnection.WrappedNetworkManager.PacketFlow.SERVERBOUND), serverPlayer, new WrappedConnection.CommonListenerCookie(gameProfile, 0, true)));
                yield serverPlayer;
            }
            case Versions.NONE -> throw new VersionNotFound();
        };
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_19_4)) {
            WrappedArmorStand armorStand = WrappedArmorStand.create(location.getWorld());
            armorStand.moveTo(location.clone().add(0.0, 0.2, 0.0));
            wrappedServerPlayer.setNameTag(armorStand);
        } else {
            WrappedTextDisplay textDisplay = WrappedTextDisplay.create(location.getWorld());
            textDisplay.moveTo(location.clone().add(0.0, 0.2, 0.0));
            wrappedServerPlayer.setNameTag(textDisplay);
        }
        wrappedServerPlayer.moveTo(location);
        wrappedServerPlayer.setListName(name);
        map.put(uuid, wrappedServerPlayer);
        return wrappedServerPlayer;
    }

    @NotNull
    public static WrappedServerPlayer create(@NotNull Location location, @NotNull UUID uuid, @NotNull WrappedComponent name) {
        return WrappedServerPlayer.create(location, uuid, new GameProfile(uuid, "NPC" + uuid.toString().substring(0, 13)), name);
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_6, to=Versions.V1_21_9), path="h"), @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_5), path="g"), @Mapping(range=@Mapping.Range(from=Versions.V1_20_6, to=Versions.V1_21), path="f")})
    @NotNull
    public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_6, to=Versions.V1_21_9), path="h"), @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_5), path="g"), @Mapping(range=@Mapping.Range(from=Versions.V1_20_6, to=Versions.V1_21), path="f")}) @NotNull WrappedAttributeInstance getAttribute(Object attribute) {
        return new WrappedAttributeInstance(this.invokeWrappedMethod(attribute));
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_9, to=Versions.V1_21_9), path="gz"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_21_6), path="gr"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_21_5), path="gi"), @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_4), path="gh"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_21), path="fX"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20_6), path="gb"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20_4), path="fR"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20_2), path="fQ"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20), path="fM"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_4), path="fI"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_3), path="fD"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_1), path="fy"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19), path="fz"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_18_2), path="fq"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_18), path="fp"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="getProfile")})
    @NotNull
    public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_9, to=Versions.V1_21_9), path="gz"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_21_6), path="gr"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_21_5), path="gi"), @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_4), path="gh"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_21), path="fX"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20_6), path="gb"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20_4), path="fR"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20_2), path="fQ"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20), path="fM"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_4), path="fI"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_3), path="fD"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_1), path="fy"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19), path="fz"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_18_2), path="fq"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_18), path="fp"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="getProfile")}) @NotNull GameProfile getGameProfile() {
        return (GameProfile)this.invokeWrappedMethod(new Object[0]);
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_6, to=Versions.V1_21_9), path="g"), @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_5), path="f"), @Mapping(range=@Mapping.Range(from=Versions.V1_20, to=Versions.V1_21), path="c"), @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_19_4), path="b")})
    @NotNull
    public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_6, to=Versions.V1_21_9), path="g"), @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_5), path="f"), @Mapping(range=@Mapping.Range(from=Versions.V1_20, to=Versions.V1_21), path="c"), @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_19_4), path="b")}) @NotNull WrappedConnection playerConnection() {
        return new WrappedConnection(this.getWrappedFieldValue());
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_6, to=Versions.V1_21_9), path="g"), @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_5), path="f"), @Mapping(range=@Mapping.Range(from=Versions.V1_20, to=Versions.V1_21), path="c"), @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_19_4), path="b")})
    public void setConnection(@NotNull WrappedConnection newConnection) {
        this.setWrappedFieldValue(newConnection.getHandle());
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_9), path="listName")
    public void setListName(@Nullable WrappedComponent component) {
        this.setWrappedFieldValue(component.getHandle());
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_9), path="listName")
    public void setListName(@Nullable String name) {
        this.setListName(WrappedComponent.create(name));
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_19_4, to=Versions.V1_21_9), path="listOrder")
    public void setListOrder(int order) {
        this.setWrappedFieldValue(order);
    }

    @Mapping.WrapList(value={@Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20), path="f"), @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_19_4), path="e")})
    public void setLatency(int i) {
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_20_2)) {
            this.setWrappedFieldValue(i);
        } else {
            this.setConnection(new WrappedConnection(WrappedMinecraftServer.INSTANCE, this.playerConnection().networkManager(), this, new WrappedConnection.CommonListenerCookie(this.getGameProfile(), i, true)));
        }
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_9), path="b"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="setPose")})
    public void setPose(@NotNull Pose pose) {
        this.invokeWrappedMethod(pose);
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_9, to=Versions.V1_21_9), path="C"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_21_6), path="A"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_21_5), path="z"), @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_4), path="A"), @Mapping(range=@Mapping.Range(from=Versions.V1_20_6, to=Versions.V1_21), path="dg"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20_4), path="dd"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20_2), path="dc"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20), path="da"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_4), path="cZ"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_3), path="cY"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_1), path="cT"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19), path="cU"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_18_2), path="cQ"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="getCommandListener")})
    public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_21_9, to=Versions.V1_21_9), path="C"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_21_6), path="A"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_21_5), path="z"), @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_4), path="A"), @Mapping(range=@Mapping.Range(from=Versions.V1_20_6, to=Versions.V1_21), path="dg"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20_4), path="dd"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20_2), path="dc"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_20), path="da"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_4), path="cZ"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_3), path="cY"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19_1), path="cT"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_19), path="cU"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_18_2), path="cQ"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="getCommandListener")}) WrappedCommandSourceStack createCommandStack() {
        return new WrappedCommandSourceStack(this.invokeWrappedMethod(new Object[0]));
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_19, to=Versions.V1_21_9), path="a")
    public void sendRawMessage(@NotNull WrappedComponent component) {
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_19)) {
            this.sendPacket(new ChatPacket(component, ChatPacket.ChatType.CHAT));
        } else {
            this.invokeWrappedMethod(component);
        }
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_19, to=Versions.V1_21_9), path="a")
    public void remove() {
        map.remove(this.getUUID());
        Object nmsLevel = Var.getNmsLevel(this.getWorld());
        Reflections.invokeMethod(nmsLevel, this.getPath(), this.getHandle(), RemovalReason.DISCARDED.getHandle());
    }

    @NotNull
    public String getName() {
        return (String)Reflections.getField(this.getGameProfile(), "name").get();
    }

    @NotNull
    public UUID getUUID() {
        return (UUID)Reflections.getField(this.getGameProfile(), "id").get();
    }

    public boolean isOnGround() {
        return this.getBukkitPlayer().isOnGround();
    }

    public void sendPacket(@NotNull PacketWrapper packet) {
        if (packet instanceof BundlePacket) {
            BundlePacket bundlePacket = (BundlePacket)packet;
            Arrays.stream(bundlePacket.getPackets()).forEach(this::sendPacket);
        } else {
            this.playerConnection().sendPacket(packet);
        }
    }

    public WrappedEntity.WrappedNameTag<?> getNameTag() {
        return this.nameDisplay;
    }

    public void setNameTag(WrappedEntity.WrappedNameTag<?> nameDisplay) {
        this.setPassengers(nameDisplay);
        this.nameDisplay = nameDisplay;
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_19, to=Versions.V1_21_9), path="net.minecraft.world.entity.Entity$RemovalReason")
    private static enum RemovalReason implements Wrapper.EnumWrapper
    {
        DISCARDED;


        @Override
        @NotNull
        public Object getHandle() {
            return this.cast(this);
        }
    }
}

