/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.manager;

import de.eisi05.npc.api.enums.Result;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.NpcOption;
import de.eisi05.npc.api.pathfinding.Path;
import de.eisi05.npc.api.pathfinding.PathfindingUtils;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.utils.wrapper.BlockPos;
import de.eisi05.npc.plugin.utils.wrapper.GameAddTestMarkerPacket;
import de.eisi05.npc.plugin.utils.wrapper.GameClearTestMarkerPacket;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    private static final Map<UUID, PathManager> INSTANCES = new HashMap<UUID, PathManager>();
    private static final Map<String, Path> pathCache = new HashMap<String, Path>();
    private final UUID uuid;
    private final List<Location> pathPoints;
    private final Set<Path> pathVisualizedSet = new HashSet<Path>();
    private final Map<Path, BukkitTask> pathTestTaskMap = new HashMap<Path, BukkitTask>();
    private PathRecordingListener pathRecordingListener;
    private String editingPath = null;
    private BukkitTask pathPointVisualizationTask;

    private PathManager(@NotNull UUID uuid) {
        this.uuid = uuid;
        this.pathPoints = new ArrayList<Location>();
    }

    public static PathManager getInstance(@NotNull Player player) {
        return INSTANCES.computeIfAbsent(player.getUniqueId(), PathManager::new);
    }

    public static void savePaths() {
        File file = new File(NpcPlugin.plugin.getDataFolder(), "paths.yml");
        YamlConfiguration config = new YamlConfiguration();
        pathCache.forEach((arg_0, arg_1) -> ((YamlConfiguration)config).set(arg_0, arg_1));
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadPaths() {
        File file = new File(NpcPlugin.plugin.getDataFolder(), "paths.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        pathCache.clear();
        config.getKeys(false).forEach(s -> pathCache.put((String)s, (Path)config.get(s)));
    }

    public void addPathPoint(@NotNull Location location, int index) {
        Location loc = location.clone();
        while (loc.getY() > (double)loc.getWorld().getMinHeight() && loc.getBlock().isPassable()) {
            loc = loc.clone().subtract(0.0, 1.0, 0.0);
        }
        loc = loc.getBlock().getLocation().add(0.5, 1.0, 0.5);
        if (index == -1 || index >= this.pathPoints.size()) {
            this.pathPoints.add(loc);
        } else {
            this.pathPoints.add(index, loc);
        }
    }

    public boolean removePathPoint(@NotNull Location location) {
        return this.pathPoints.removeIf(location1 -> location1.getX() == location.getX() && location1.getY() == location.getY() && location1.getZ() == location.getZ());
    }

    public boolean removePathPoint(int index) {
        if (this.pathPoints.isEmpty()) {
            return false;
        }
        if (index >= this.pathPoints.size()) {
            return false;
        }
        this.pathPoints.remove(index);
        return true;
    }

    public List<Location> getPathPoints() {
        return this.pathPoints;
    }

    public void clearPathPoints() {
        this.pathPoints.clear();
    }

    public boolean visualizePoints() {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (this.pathPoints.isEmpty()) {
            return false;
        }
        if (this.pathPointVisualizationTask != null && !this.pathPointVisualizationTask.isCancelled()) {
            this.pathPointVisualizationTask.cancel();
            this.pathPointVisualizationTask = null;
            return false;
        }
        WrappedServerPlayer serverPlayer = WrappedServerPlayer.fromPlayer(player);
        this.pathPointVisualizationTask = Bukkit.getScheduler().runTaskTimer((Plugin)NpcPlugin.plugin, () -> {
            for (int i = 0; i < this.pathPoints.size(); ++i) {
                Location l = this.pathPoints.get(i).clone().add(0.0, 0.3, 0.0);
                player.spawnParticle(Particle.REDSTONE, l, 1, (Object)new Particle.DustOptions(Color.RED, 1.0f));
                if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) continue;
                serverPlayer.sendPacket(new GameAddTestMarkerPacket(BlockPos.fromLocation(l), 65280, String.valueOf(i), 75));
            }
        }, 0L, 1L);
        return true;
    }

    public CompletableFuture<Path> createPath(@NotNull String name, int maxIterations, boolean allowDiagonalMovement) {
        if (this.pathPoints.isEmpty()) {
            return CompletableFuture.failedFuture(new EmptyPathException());
        }
        if (this.pathPoints.stream().collect(Collectors.groupingBy(Location::getWorld)).size() != 1) {
            return CompletableFuture.failedFuture(new MultipleWorldsException());
        }
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        BossBar bossBar = Bukkit.createBossBar((String)(String.valueOf(ChatColor.GREEN) + name + String.valueOf(ChatColor.GRAY) + " - " + String.valueOf(ChatColor.AQUA) + "0.00%"), (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        bossBar.setProgress(0.0);
        bossBar.addPlayer(player);
        CompletableFuture<Path> future = PathfindingUtils.findPathAsync(this.pathPoints.stream().map(location -> location.clone().subtract(0.0, 1.0, 0.0)).toList(), maxIterations <= 0 ? 10000 : maxIterations, allowDiagonalMovement, (current, max) -> {
            double progress = (double)current.intValue() / (double)max.intValue();
            bossBar.setProgress(progress);
            bossBar.setTitle(String.valueOf(ChatColor.GREEN) + name + String.valueOf(ChatColor.GRAY) + " - " + String.valueOf(ChatColor.AQUA) + String.format("%.2f", progress * 100.0) + "%");
        });
        future.handle((path, throwable) -> {
            bossBar.removePlayer(player);
            return null;
        });
        future.thenAccept(path1 -> {
            path1.setName(name);
            pathCache.put(name, (Path)path1);
            this.pathPoints.clear();
            this.editingPath = null;
            if (this.pathPointVisualizationTask != null && !this.pathPointVisualizationTask.isCancelled()) {
                this.pathPointVisualizationTask.cancel();
                this.pathPointVisualizationTask = null;
                this.visualizePath((Path)path1);
            }
        });
        return future;
    }

    public Optional<Path> getPath(@NotNull String name) {
        return pathCache.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(name)).map(Map.Entry::getValue).findFirst();
    }

    public void deletePath(@NotNull String name) {
        this.hideVisualize(pathCache.remove(name), true);
    }

    public void editPath(@NotNull String name) {
        this.getPath(name).ifPresent(path -> {
            this.editingPath = name;
            this.pathPoints.clear();
            this.pathPoints.addAll(path.getWaypoints().stream().map(location -> location.clone().add(0.0, 1.0, 0.0)).toList());
            if (this.hideVisualize((Path)path, true)) {
                this.visualizePoints();
            }
        });
    }

    @Nullable
    public String getEditingPath() {
        return this.editingPath;
    }

    public boolean visualizePath(@NotNull Path path) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (!this.pathVisualizedSet.add(path)) {
            this.hideVisualize(path, true);
            return false;
        }
        List<Location> locations = path.asLocations();
        for (int i = 0; i < locations.size(); ++i) {
            Location next;
            Location current = locations.get(i);
            Location location = next = i + 1 < locations.size() ? locations.get(i + 1) : null;
            if (next == null) continue;
            Vector dir = next.toVector().subtract(current.toVector()).normalize();
            BlockFace face = this.yawToFace(dir);
            BlockData data = Material.MAGENTA_GLAZED_TERRACOTTA.createBlockData();
            if (data instanceof Directional) {
                Directional directional = (Directional)data;
                directional.setFacing(face);
            }
            player.sendBlockChange(current.clone().subtract(0.0, 1.0, 0.0), data);
        }
        return true;
    }

    private boolean hideVisualize(@Nullable Path path, boolean remove) {
        if (path == null || !this.pathVisualizedSet.contains(path)) {
            return false;
        }
        if (remove) {
            this.pathVisualizedSet.remove(path);
        }
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        for (Location location : path.asLocations()) {
            Location current = location.clone().subtract(0.0, 1.0, 0.0);
            player.sendBlockChange(current, current.getBlock().getBlockData());
        }
        return true;
    }

    public long hideVisualizations() {
        long removeCount = this.pathVisualizedSet.size();
        for (Path path : this.pathVisualizedSet) {
            this.hideVisualize(path, false);
        }
        this.pathVisualizedSet.clear();
        if (this.pathPointVisualizationTask != null && !this.pathPointVisualizationTask.isCancelled()) {
            this.pathPointVisualizationTask.cancel();
            this.pathPointVisualizationTask = null;
            ++removeCount;
        }
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) {
            WrappedServerPlayer.fromPlayer(Bukkit.getPlayer((UUID)this.uuid)).sendPacket(new GameClearTestMarkerPacket());
        }
        return removeCount == 0L ? -1L : removeCount;
    }

    public boolean testPath(@NotNull Path path, double walkSpeed) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        BukkitTask testTask = this.pathTestTaskMap.get(path);
        if (testTask != null && !testTask.isCancelled()) {
            testTask.cancel();
            this.pathTestTaskMap.remove(path);
            return false;
        }
        NPC tempNPC = new NPC(path.asLocations().getFirst());
        tempNPC.setOption(NpcOption.HIDE_NAMETAG, true);
        tempNPC.setOption(NpcOption.SHOW_TAB_LIST, false);
        tempNPC.setOption(NpcOption.USE_PLAYER_SKIN, true);
        tempNPC.setOption(NpcOption.GLOWING, ChatColor.RED);
        tempNPC.setEnabled(true);
        tempNPC.showNPCToPlayer(player);
        this.pathTestTaskMap.put(path, tempNPC.walkTo(path, player, walkSpeed, false, (Consumer<Result>)((Consumer)result -> {
            try {
                tempNPC.delete();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })));
        return true;
    }

    public Map<String, Path> getPaths() {
        return pathCache;
    }

    public Set<String> getPathNames() {
        return pathCache.keySet();
    }

    public boolean startRecording() {
        if (this.pathRecordingListener != null) {
            return false;
        }
        this.pathRecordingListener = new PathRecordingListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.pathRecordingListener, (Plugin)NpcPlugin.plugin);
        return true;
    }

    public long stopRecording() {
        if (this.pathRecordingListener == null) {
            return -1L;
        }
        long additions = this.pathRecordingListener.additions;
        HandlerList.unregisterAll((Listener)this.pathRecordingListener);
        this.pathRecordingListener = null;
        return additions;
    }

    private BlockFace yawToFace(Vector dir) {
        float yaw = (float)Math.toDegrees(Math.atan2(-dir.getX(), dir.getZ()));
        if ((yaw = (yaw + 360.0f) % 360.0f) >= 45.0f && yaw < 135.0f) {
            return BlockFace.EAST;
        }
        if (yaw >= 135.0f && yaw < 225.0f) {
            return BlockFace.SOUTH;
        }
        if (yaw >= 225.0f && yaw < 315.0f) {
            return BlockFace.WEST;
        }
        return BlockFace.NORTH;
    }

    public static class EmptyPathException
    extends RuntimeException {
        public EmptyPathException() {
            super("Path points are in different worlds!");
        }
    }

    public static class MultipleWorldsException
    extends RuntimeException {
        public MultipleWorldsException() {
            super("Path points are in different worlds!");
        }
    }

    private static class PathRecordingListener
    implements Listener {
        private final PathManager pathManager;
        private long additions = 0L;
        private Location lastLocation;

        private PathRecordingListener(@NotNull PathManager pathManager) {
            this.pathManager = pathManager;
        }

        @EventHandler
        public void onPlayerMove(PlayerMoveEvent event) {
            if (!this.pathManager.uuid.equals(event.getPlayer().getUniqueId())) {
                return;
            }
            Location currentLocation = event.getTo();
            if (currentLocation == null) {
                return;
            }
            if (this.lastLocation == null) {
                this.lastLocation = currentLocation;
                this.pathManager.addPathPoint(this.lastLocation, -1);
                ++this.additions;
            } else if (currentLocation.distanceSquared(this.lastLocation) >= 1.0) {
                this.lastLocation = currentLocation;
                this.pathManager.addPathPoint(this.lastLocation, -1);
                ++this.additions;
            }
        }
    }
}

