/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.objects;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.eisi05.dialogMenu.DialogMenu;
import de.eisi05.dialogMenu.TriConsumer;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.enums.ClickActionType;
import de.eisi05.npc.api.events.NpcInteractEvent;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.pathfinding.Path;
import de.eisi05.npc.api.pathfinding.PathfindingUtils;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.enums.ChatFormat;
import de.eisi05.npc.api.wrapper.objects.WrappedCommandSourceStack;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import de.eisi05.npc.api.wrapper.packets.AnimatePacket;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.gui.NpcGUI;
import de.eisi05.npc.plugin.manager.CommandManager;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.manager.PathManager;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import de.eisi05.npc.plugin.utils.Prefix;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.InactivityConversationCanceller;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpcClickActionImpl
implements NpcClickAction {
    private static final long serialVersionUID = 1L;
    private final List<PluginAction<?>> actionListRight = new ArrayList();
    private final List<PluginAction<?>> actionListLeft = new ArrayList();

    public <T extends Serializable> NpcClickActionImpl add(@NotNull ClickActionType clickActionType, @NotNull PluginActionOptions<T> pluginActionOptions, @Nullable T param) {
        PluginAction<T> action = new PluginAction<T>(pluginActionOptions, param);
        if (clickActionType == ClickActionType.BOTH && !this.isBoth()) {
            this.actionListRight.clear();
            this.actionListLeft.clear();
        }
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.add(action);
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.add(action);
        }
        return this;
    }

    @Override
    public NpcClickAction copy() {
        NpcClickActionImpl copy = new NpcClickActionImpl();
        List<PluginAction> copyRight = this.actionListRight.stream().map(pluginAction -> new PluginAction((PluginActionOptions)Var.unsafeCast(pluginAction.option), pluginAction.param)).toList();
        List<PluginAction> copyLeft = this.actionListLeft.stream().map(pluginAction -> new PluginAction((PluginActionOptions)Var.unsafeCast(pluginAction.option), pluginAction.param)).toList();
        copy.actionListRight.addAll(copyRight);
        copy.actionListLeft.addAll(copyLeft);
        return copy;
    }

    public <T extends Serializable> void insert(int index, @NotNull ClickActionType clickActionType, @NotNull PluginActionOptions<T> pluginActionOptions, @Nullable T param) {
        PluginAction<T> action = new PluginAction<T>(pluginActionOptions, param);
        if (clickActionType == ClickActionType.BOTH && !this.isBoth()) {
            this.actionListRight.clear();
            this.actionListLeft.clear();
        }
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.add(index, action);
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.add(index, action);
        }
    }

    public void remove(@NotNull ClickActionType clickActionType, @NotNull PluginAction<? extends Serializable> action) {
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.remove(action);
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.remove(action);
        }
    }

    public void clear(@NotNull ClickActionType clickActionType) {
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.clear();
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.clear();
        }
    }

    @Override
    @NotNull
    public NpcClickActionImpl initialize() {
        new ArrayList(this.actionListRight).forEach((Consumer<PluginAction<?>>)((Consumer<PluginAction>)PluginAction::reload));
        new ArrayList(this.actionListLeft).forEach((Consumer<PluginAction<?>>)((Consumer<PluginAction>)PluginAction::reload));
        return this;
    }

    @NotNull
    public List<PluginAction<?>> getRightActions() {
        return Collections.unmodifiableList(this.actionListRight);
    }

    @NotNull
    public List<PluginAction<?>> getLeftActions() {
        return Collections.unmodifiableList(this.actionListLeft);
    }

    @NotNull
    public List<PluginAction<?>> getActions(@NotNull ClickActionType clickActionType) {
        if (!this.isBoth() && clickActionType == ClickActionType.BOTH) {
            return new ArrayList();
        }
        if (clickActionType == ClickActionType.LEFT) {
            return this.getLeftActions();
        }
        return this.getRightActions();
    }

    public boolean isBoth() {
        return this.actionListRight.equals(this.actionListLeft);
    }

    @Override
    public void call(@NotNull NpcInteractEvent event) {
        if (event.getAction() == ClickActionType.LEFT && this.actionListLeft.isEmpty()) {
            return;
        }
        if (event.getAction() == ClickActionType.RIGHT && this.actionListRight.isEmpty()) {
            return;
        }
        this.call(0, event);
    }

    private void call(int index, @NotNull NpcInteractEvent event) {
        List<PluginAction<?>> listToExecute;
        List<PluginAction<?>> list = listToExecute = event.getAction() == ClickActionType.LEFT ? this.actionListLeft : this.actionListRight;
        if (index >= listToExecute.size()) {
            return;
        }
        PluginAction<?> action = listToExecute.get(index);
        if (action.option.equals(PluginActionOptions.WAIT)) {
            if (action.param instanceof Double) {
                double wait = (Double)action.param;
                Bukkit.getScheduler().runTaskLater((Plugin)NpcPlugin.plugin, () -> this.call(index + 1, event), (long)(wait * 20.0));
            } else {
                NpcPlugin.plugin.getLogger().warning("WAIT action parameter is not a Double for NPC interaction. Skipping WAIT!");
                this.call(index + 1, event);
            }
            return;
        }
        NpcClickAction executable = action.option.function.apply((Serializable)Var.unsafeCast(action.param));
        if (executable != null) {
            executable.call(event);
        }
        this.call(index + 1, event);
    }

    public static class PluginAction<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private PluginActionOptions<T> option;
        private T param;

        public PluginAction(PluginActionOptions<T> option, T param) {
            this.option = option;
            this.param = param;
        }

        private void reload() {
            if (this.option != null) {
                PluginActionOptions reloadedOption = this.option.getOption();
                if (reloadedOption != null) {
                    this.option = reloadedOption;
                } else {
                    NpcPlugin.plugin.getLogger().warning("Failed to reload PluginActionOption for: " + this.option.name + ". It might be missing or renamed.");
                }
            }
        }

        @NotNull
        public String getTypeName(Player player) {
            return this.option != null ? this.option.getName(player) : LocalizationManager.get(player, "actions.invalid.title", new Object[0]);
        }

        @NotNull
        public Supplier<ItemBuilder> getIcon(Player player) {
            if (this.option == null) {
                return () -> new ItemBuilder(Material.BARRIER).setName(LocalizationManager.get(player, "actions.invalid.title", new Object[0])).setLore(LocalizationManager.get(player, "actions.invalid.description", new Object[0]));
            }
            return () -> this.option.icon.apply(this.param, player).setName(this.getTypeName(player)).hideFlags(true).hideAttributes();
        }

        @NotNull
        public Consumer<InventoryClickEvent> getConsumer(@NotNull NPC npc, @NotNull ClickActionType clickActionType, boolean withTeleport) {
            return inventoryClickEvent -> {
                if (this.option != null) {
                    this.param = (Serializable)this.option.clickAction.apply(this.param, new PluginActionOptions.PluginActionData((InventoryClickEvent)inventoryClickEvent, npc, clickActionType, this, withTeleport));
                }
            };
        }
    }

    public static class PluginActionOptions<T extends Serializable>
    implements Serializable {
        public static final Map<String, PluginActionOptions<?>> OPTIONS_REGISTRY = new HashMap();
        public static final PluginActionOptions<AnimatePacket.Animation> ANIMATION = new PluginActionOptions<AnimatePacket.Animation>("animation", AnimatePacket.Animation.SWING_MAIN_HAND, animation -> event -> event.getNpc().playAnimation(event.getPlayer(), (AnimatePacket.Animation)animation), (animation, player) -> new ItemBuilder(Material.ITEM_FRAME).setLore(Arrays.stream(AnimatePacket.Animation.values()).map(animation1 -> {
            String animationName = ChatColor.stripColor((String)LocalizationManager.get(player, "actions.animation." + animation1.name().replace("_", "-").toLowerCase(), new Object[0]));
            if (animation == animation1) {
                return String.valueOf(ChatColor.GOLD) + "> " + animationName;
            }
            return String.valueOf(ChatColor.GRAY) + " " + animationName;
        }).toList()), (animation, data) -> {
            AnimatePacket.Animation[] values = AnimatePacket.Animation.values();
            int currentIndex = animation.ordinal();
            AnimatePacket.Animation newAnimation = animation;
            boolean changed = false;
            float pitch = 1.0f;
            if (data.event().getClick().isLeftClick()) {
                newAnimation = values[(currentIndex + 1) % values.length];
                if (newAnimation != animation) {
                    changed = true;
                    pitch = 1.2f;
                }
            } else if (data.event().getClick().isRightClick() && (newAnimation = values[(currentIndex - 1 + values.length) % values.length]) != animation) {
                changed = true;
                pitch = 0.8f;
            }
            if (changed) {
                ItemMeta meta;
                Player p = (Player)data.event.getWhoClicked();
                p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, pitch);
                ArrayList<CallSite> modifiedLore = new ArrayList<CallSite>();
                for (AnimatePacket.Animation animation1 : AnimatePacket.Animation.values()) {
                    modifiedLore.add((CallSite)((Object)((animation1 == newAnimation ? String.valueOf(ChatColor.GOLD) + "> " : String.valueOf(ChatColor.GRAY) + " ") + ChatColor.stripColor((String)LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.animation." + animation1.name().replace("_", "-").toLowerCase(), new Object[0])))));
                }
                ItemStack current = data.event().getCurrentItem();
                if (current != null && (meta = current.getItemMeta()) != null) {
                    meta.setLore(modifiedLore);
                    current.setItemMeta(meta);
                }
                data.npc().markChange();
            } else if (data.event().getClick().isLeftClick() || data.event().getClick().isRightClick()) {
                Player p = (Player)data.event.getWhoClicked();
                p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 0.7f);
            }
            return newAnimation;
        });
        public static final PluginActionOptions<Double> WAIT = new PluginActionOptions<Double>("wait", 1.0, value -> null, (value, player) -> new ItemBuilder(Material.CLOCK).setLore(LocalizationManager.get(player, "actions.wait.value", value)), (value, data) -> {
            ItemStack currentItem;
            boolean actuallyChanged;
            double originalValue = value;
            double newValue = value;
            double increment = data.event().isShiftClick() ? 1.0 : 0.1;
            Sound soundToPlay = null;
            float pitch = 1.0f;
            float volume = 1.0f;
            if (data.event().getClick().isLeftClick()) {
                if ((newValue += increment) > 600.0) {
                    newValue = 600.0;
                }
            } else if (data.event().getClick().isRightClick()) {
                if ((newValue -= increment) < 0.1) {
                    newValue = 0.1;
                }
            } else if (data.event().getClick() == ClickType.MIDDLE) {
                newValue = 1.0;
            }
            boolean bl = actuallyChanged = Math.abs((newValue = (double)Math.round(newValue * 10.0) / 10.0) - originalValue) > 0.001;
            if (actuallyChanged) {
                soundToPlay = Sound.BLOCK_COMPARATOR_CLICK;
                pitch = newValue > originalValue ? 1.2f : (newValue < originalValue ? 0.8f : 1.0f);
                data.npc().markChange();
            } else if (data.event().getClick().isLeftClick() || data.event().getClick().isRightClick()) {
                soundToPlay = Sound.UI_BUTTON_CLICK;
                pitch = 0.7f;
                volume = 0.8f;
            }
            if (soundToPlay != null) {
                Player p = (Player)data.event.getWhoClicked();
                p.playSound(p.getLocation(), soundToPlay, volume, pitch);
            }
            if ((currentItem = data.event().getCurrentItem()) != null && currentItem.hasItemMeta()) {
                ItemMeta meta = currentItem.getItemMeta();
                ArrayList<String> lore = new ArrayList<String>(Arrays.stream(LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.wait.value", newValue).split("\n")).toList());
                meta.setLore(lore);
                currentItem.setItemMeta(meta);
            }
            return newValue;
        });
        private static final long serialVersionUID = 1L;
        private final String name;
        private final T defaultValue;
        private final transient Function<T, NpcClickAction> function;
        private final transient BiFunction<T, Player, ItemBuilder> icon;
        private final transient BiFunction<T, PluginActionData, T> clickAction;
        public static final PluginActionOptions<String> COMMAND = new PluginActionOptions<String>("command", null, s -> event -> {
            block7: {
                if (s == null || s.isBlank()) {
                    return;
                }
                String commandToExecute = s.startsWith("/") ? s.substring(1) : s;
                try {
                    CommandManager.DISPATCHER.execute(commandToExecute, WrappedServerPlayer.fromPlayer(event.getPlayer()).createCommandStack().withMaximumPermission().withSuppressedOutput().getHandle());
                }
                catch (CommandSyntaxException e) {
                    try {
                        Bukkit.dispatchCommand((CommandSender)event.getPlayer(), (String)commandToExecute);
                    }
                    catch (CommandException ex) {
                        if (event.getPlayer().hasPermission("npc.admin")) {
                            LocalizedMessage.sendMessage(event.getPlayer(), "actions.command.error.known", true, e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    NpcPlugin.plugin.getLogger().warning("Error executing NPC command: " + s + " for player " + event.getPlayer().getName() + " - " + e.getMessage());
                    if (!event.getPlayer().hasPermission("npc.admin")) break block7;
                    LocalizedMessage.sendMessage(event.getPlayer(), "actions.command.error.unknown", true, new Object[0]);
                }
            }
        }, (s, player) -> new ItemBuilder(Material.COMMAND_BLOCK).setLore(s == null || s.isEmpty() ? LocalizationManager.get(player, "actions.command.value.short", LocalizationManager.get(player, "misc.not-set", new Object[0])) : LocalizationManager.get(player, "actions.command.value." + (s.length() > 23 ? "long" : "short"), s.length() > 23 ? s.substring(0, 20) : s)), (currentCommand, data) -> {
            Player p = (Player)data.event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
            data.event().getWhoClicked().closeInventory();
            if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_6)) {
                DialogMenu.command(p, (Plugin)NpcPlugin.plugin, currentCommand, null, player -> player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport())), (player, s) -> {
                    WrappedCommandSourceStack sourceStack;
                    if (s == null || s.trim().isEmpty()) {
                        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(player, "actions.command.input.empty", true, new Object[0]);
                        player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                        return;
                    }
                    String processedInput = s.startsWith("/") ? s.substring(1) : s;
                    ParseResults results = CommandManager.DISPATCHER.parse(processedInput, (sourceStack = WrappedServerPlayer.fromPlayer(player).createCommandStack()).getHandle());
                    if (!results.getExceptions().isEmpty()) {
                        for (CommandSyntaxException e : results.getExceptions().values()) {
                            LocalizedMessage.sendMessage(player, "actions.command.error.syntax", true, e.getMessage());
                        }
                        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                        return;
                    }
                    if (results.getReader().canRead() && !NpcApi.config.avoidCommandCheck()) {
                        LocalizedMessage.sendMessage(player, "actions.command.error.arguments", true, results.getReader().getRemaining());
                        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                        return;
                    }
                    data.actionInstance().param = (Serializable)Var.unsafeCast("/" + processedInput);
                    data.npc().markChange();
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                    LocalizedMessage.sendMessage(player, "actions.command.set", true, "/" + processedInput);
                    player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                }, LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.command.input.prompt", new Object[0]), LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.command.input.edit.text", new Object[0]), LocalizationManager.get((Player)data.event.getWhoClicked(), "misc.ok", new Object[0]), LocalizationManager.get((Player)data.event.getWhoClicked(), "misc.back", new Object[0]));
                return currentCommand;
            }
            new ConversationManager((Plugin)NpcPlugin.plugin).withModality(false).withLocalEcho(false).withEscapeSequence(LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.command.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(abandonedEvent -> {
                Player player = (Player)abandonedEvent.getContext().getForWhom();
                if (!abandonedEvent.gracefulExit()) {
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    ConversationContext context = abandonedEvent.getContext();
                    if (!(abandonedEvent.getCanceller() instanceof InactivityConversationCanceller)) {
                        LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.command.input.cancelled", true, new Object[0]);
                    } else {
                        LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.command.input.timeout", true, new Object[0]);
                    }
                }
                Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport())));
            }).withFirstPrompt(new Prompt(){
                final /* synthetic */ String val$currentCommand;
                final /* synthetic */ PluginActionData val$data;
                {
                    this.val$currentCommand = string;
                    this.val$data = pluginActionData;
                }

                public boolean blocksForInput(@NotNull ConversationContext context) {
                    if (this.val$currentCommand == null || this.val$currentCommand.isEmpty()) {
                        return true;
                    }
                    WrappedServerPlayer.fromPlayer((Player)context.getForWhom()).sendRawMessage(WrappedComponent.parseFromLegacy(LocalizationManager.get((Player)context.getForWhom(), "actions.command.input.edit.text", new Object[0])).setFormats(ChatFormat.ITALIC, ChatFormat.GREEN).withClickEvent(WrappedComponent.ClickEvent.create(WrappedComponent.ClickEvent.ClickAction.SUGGEST_COMMAND, this.val$currentCommand.startsWith("/") ? this.val$currentCommand.substring(1) : this.val$currentCommand)).withHoverEvent(WrappedComponent.HoverEvent.create(WrappedComponent.create(LocalizationManager.get((Player)context.getForWhom(), "actions.command.input.edit.hover", new Object[0])).setFormats(ChatFormat.GRAY, ChatFormat.ITALIC))));
                    return true;
                }

                @NotNull
                public String getPromptText(@NotNull ConversationContext context) {
                    return Prefix.PREFIX + LocalizationManager.get((Player)context.getForWhom(), "actions.command.input.prompt", new Object[0]);
                }

                public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
                    WrappedCommandSourceStack sourceStack;
                    Player conversingPlayer = (Player)context.getForWhom();
                    if (input == null || input.trim().isEmpty()) {
                        conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(conversingPlayer, "actions.command.input.empty", true, new Object[0]);
                        return this;
                    }
                    String processedInput = input.startsWith("/") ? input.substring(1) : input;
                    ParseResults results = CommandManager.DISPATCHER.parse(processedInput, (sourceStack = WrappedServerPlayer.fromPlayer((Player)context.getForWhom()).createCommandStack()).getHandle());
                    if (!results.getExceptions().isEmpty()) {
                        for (CommandSyntaxException e : results.getExceptions().values()) {
                            LocalizedMessage.sendMessage(conversingPlayer, "actions.command.error.syntax", true, e.getMessage());
                        }
                        conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        return this;
                    }
                    if (results.getReader().canRead() && !NpcApi.config.avoidCommandCheck()) {
                        LocalizedMessage.sendMessage(conversingPlayer, "actions.command.error.arguments", true, results.getReader().getRemaining());
                        conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        return this;
                    }
                    this.val$data.actionInstance().param = (Serializable)Var.unsafeCast("/" + processedInput);
                    this.val$data.npc().markChange();
                    conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                    LocalizedMessage.sendMessage(conversingPlayer, "actions.command.set", true, "/" + processedInput);
                    return Prompt.END_OF_CONVERSATION;
                }
            }).buildConversation((Conversable)data.event().getWhoClicked()).begin();
            return currentCommand;
        });
        public static final PluginActionOptions<Pair<Path.SerializablePath, Float>> PATH = new PluginActionOptions<Pair>("path", null, pair -> e -> {
            if (pair == null || pair.getKey() == null) {
                return;
            }
            e.getNpc().walkTo(((Path.SerializablePath)pair.getKey()).toPath(), e.getPlayer(), pair.getRight() == null ? 0.25 : (double)((Float)pair.getRight()).floatValue(), false, null);
        }, (pair, player) -> new ItemBuilder(Material.DIRT_PATH).addLore(pair != null && pair.getKey() != null && ((Path.SerializablePath)pair.getKey()).toPath().getName() != null ? LocalizationManager.get(player, "actions.path.value.name", ((Path.SerializablePath)pair.getKey()).toPath().getName()) : LocalizationManager.get(player, "actions.path.value.name", LocalizationManager.get(player, "misc.not-set", new Object[0]))).addLore(pair != null && pair.getRight() != null ? LocalizationManager.get(player, "actions.path.value.speed", ((Float)pair.getRight()).toString()) : LocalizationManager.get(player, "actions.path.value.speed", LocalizationManager.get(player, "misc.not-set", new Object[0]))), (currentPair, data) -> {
            final Path currentPath = currentPair == null ? null : ((Path.SerializablePath)currentPair.getKey()).toPath();
            Player p = (Player)data.event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
            data.event().getWhoClicked().closeInventory();
            if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_6)) {
                DialogMenu.path(p, (Plugin)NpcPlugin.plugin, currentPath == null ? null : currentPath.getName(), null, 25.0f, player -> player.openInventory(player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()))), new TriConsumer<Player, String, Float>(){

                    @Override
                    public void accept(Player player, String s, Float f) {
                        if (s == null || s.trim().isEmpty()) {
                            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                            LocalizedMessage.sendMessage(player, "actions.path.input.empty.1", true, new Object[0]);
                            player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                            return;
                        }
                        Optional<Path> newPath = PathManager.getInstance(player).getPath(s);
                        if (newPath.isEmpty()) {
                            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                            LocalizedMessage.sendMessage(player, "command.path.not-exists", true, s);
                            player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                            return;
                        }
                        if ((double)f.floatValue() < 0.1 || f.floatValue() > 1.0f) {
                            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                            LocalizedMessage.sendMessage(player, "actions.path.input.speed.invalid", true, new Object[0]);
                            player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                            return;
                        }
                        data.actionInstance().param = (Serializable)Var.unsafeCast(new MutablePair((Object)newPath.get().toSerializablePath(), (Object)f));
                        data.npc().markChange();
                        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                        LocalizedMessage.sendMessage(player, "actions.path.set", true, newPath.get().getName(), f);
                        player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                    }

                    @Override
                    public void accept(Player player, String s) {
                    }
                }, LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.path.input.prompt.1", new Object[0]), LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.path.input.edit.text.1", new Object[0]), LocalizationManager.get((Player)data.event.getWhoClicked(), "misc.ok", new Object[0]), LocalizationManager.get((Player)data.event.getWhoClicked(), "misc.back", new Object[0]));
                return currentPair;
            }
            new ConversationManager((Plugin)NpcPlugin.plugin).withModality(false).withLocalEcho(false).withEscapeSequence(LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.path.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(abandonedEvent -> {
                Player player = (Player)abandonedEvent.getContext().getForWhom();
                if (!abandonedEvent.gracefulExit()) {
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    ConversationContext context = abandonedEvent.getContext();
                    if (!(abandonedEvent.getCanceller() instanceof InactivityConversationCanceller)) {
                        LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.path.input.cancelled", true, new Object[0]);
                    } else {
                        LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.path.input.timeout", true, NpcApi.config.inputTime());
                    }
                }
                Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport())));
            }).withFirstPrompt(new Prompt(){
                final /* synthetic */ PluginActionData val$data;
                final /* synthetic */ Pair val$currentPair;
                {
                    this.val$data = pluginActionData;
                    this.val$currentPair = pair;
                }

                public boolean blocksForInput(@NotNull ConversationContext context) {
                    if (currentPath == null || currentPath.getName() == null || currentPath.asLocations().isEmpty()) {
                        return true;
                    }
                    WrappedServerPlayer.fromPlayer((Player)context.getForWhom()).sendRawMessage(WrappedComponent.parseFromLegacy(LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.edit.text.1", new Object[0])).setFormats(ChatFormat.ITALIC, ChatFormat.GREEN).withClickEvent(WrappedComponent.ClickEvent.create(WrappedComponent.ClickEvent.ClickAction.SUGGEST_COMMAND, currentPath.getName())).withHoverEvent(WrappedComponent.HoverEvent.create(WrappedComponent.create(LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.edit.hover.1", new Object[0])).setFormats(ChatFormat.GRAY, ChatFormat.ITALIC))));
                    return true;
                }

                @NotNull
                public String getPromptText(@NotNull ConversationContext context) {
                    return Prefix.PREFIX + LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.prompt.1", new Object[0]);
                }

                public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
                    Player conversingPlayer = (Player)context.getForWhom();
                    if (input == null || input.trim().isEmpty()) {
                        conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(conversingPlayer, "actions.path.input.empty.1", true, new Object[0]);
                        return this;
                    }
                    Optional<Path> newPath = PathManager.getInstance(conversingPlayer).getPath(input);
                    if (newPath.isEmpty()) {
                        conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(conversingPlayer, "command.path.not-exists", true, input);
                        return this;
                    }
                    if (!newPath.get().asLocations().getFirst().getWorld().equals((Object)this.val$data.npc.getLocation().getWorld())) {
                        conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(conversingPlayer, "actions.path.other-world", true, new Object[0]);
                        return this;
                    }
                    context.setSessionData((Object)"path", (Object)newPath.get());
                    return new Prompt(){

                        @NotNull
                        public String getPromptText(@NotNull ConversationContext context) {
                            return Prefix.PREFIX + LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.prompt.2", new Object[0]);
                        }

                        public boolean blocksForInput(@NotNull ConversationContext context) {
                            if (val$currentPair == null || val$currentPair.getRight() == null || (double)((Float)val$currentPair.getRight()).floatValue() < 0.1) {
                                return true;
                            }
                            WrappedServerPlayer.fromPlayer((Player)context.getForWhom()).sendRawMessage(WrappedComponent.parseFromLegacy(LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.edit.text.2", new Object[0])).setFormats(ChatFormat.ITALIC, ChatFormat.GREEN).withClickEvent(WrappedComponent.ClickEvent.create(WrappedComponent.ClickEvent.ClickAction.SUGGEST_COMMAND, String.valueOf(val$currentPair.getRight()))).withHoverEvent(WrappedComponent.HoverEvent.create(WrappedComponent.create(LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.edit.hover.2", new Object[0])).setFormats(ChatFormat.GRAY, ChatFormat.ITALIC))));
                            return true;
                        }

                        @Nullable
                        public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
                            float speed;
                            Player conversingPlayer = (Player)context.getForWhom();
                            if (input == null || input.trim().isEmpty()) {
                                conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                                LocalizedMessage.sendMessage(conversingPlayer, "actions.path.input.empty.2", true, new Object[0]);
                                return this;
                            }
                            try {
                                speed = Float.parseFloat(input);
                                if ((double)speed < 0.1 || speed > 1.0f) {
                                    conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                                    LocalizedMessage.sendMessage(conversingPlayer, "actions.path.input.speed.invalid", true, new Object[0]);
                                    return this;
                                }
                            }
                            catch (NumberFormatException e) {
                                conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                                LocalizedMessage.sendMessage(conversingPlayer, "actions.path.input.speed.invalid", true, new Object[0]);
                                return this;
                            }
                            Path newPath = (Path)context.getSessionData((Object)"path");
                            LocalizedMessage.sendMessage(conversingPlayer, "actions.path.creating", true, newPath.getName());
                            System.out.println(newPath.asLocations().getFirst());
                            ((CompletableFuture)PathfindingUtils.findPathAsync(List.of(val$data.npc.getLocation().clone().subtract(0.0, 1.0, 0.0), newPath.asLocations().getFirst().clone().subtract(0.0, 1.0, 0.0)), 10000, true, null).thenAccept(path -> {
                                Path finalPath = new Path(Stream.concat(path.asLocations().stream(), newPath.asLocations().stream()).toList(), null);
                                finalPath.setName(newPath.getName());
                                data.actionInstance().param = (Serializable)Var.unsafeCast(new MutablePair((Object)finalPath.toSerializablePath(), (Object)Float.valueOf(speed)));
                                val$data.npc().markChange();
                                conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                                LocalizedMessage.sendMessage(conversingPlayer, "actions.path.set", true, newPath.getName(), input);
                            })).exceptionally(throwable -> {
                                throwable.printStackTrace();
                                LocalizedMessage.sendMessage(conversingPlayer, "actions.path.failed", true, newPath.getName());
                                return null;
                            });
                            return END_OF_CONVERSATION;
                        }
                    };
                }
            }).buildConversation((Conversable)data.event().getWhoClicked()).begin();
            return currentPair;
        });
        public static final PluginActionOptions<String> SERVER = new PluginActionOptions<String>("server", null, s -> e -> {
            if (s == null || s.isBlank()) {
                return;
            }
            try {
                ByteArrayOutputStream bb = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(bb);
                out.writeUTF("Connect");
                out.writeUTF((String)s);
                e.getPlayer().sendPluginMessage((Plugin)NpcPlugin.plugin, "BungeeCord", bb.toByteArray());
                LocalizedMessage.sendMessage(e.getPlayer(), "actions.server.connecting", true, s);
            }
            catch (Exception ex) {
                LocalizedMessage.sendMessage(e.getPlayer(), "actions.server.failed", true, s);
                NpcPlugin.plugin.getLogger().severe("BungeeCord Connect Error: " + ex.getMessage());
            }
        }, (s, player) -> new ItemBuilder(Material.ENDER_PEARL).addLore(s == null || s.isEmpty() ? LocalizationManager.get(player, "actions.server.value", LocalizationManager.get(player, "misc.not-set", new Object[0])) : LocalizationManager.get(player, "actions.server.value", s)), (currentServer, data) -> {
            Player p = (Player)data.event.getWhoClicked();
            p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
            data.event().getWhoClicked().closeInventory();
            if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_6)) {
                DialogMenu.server(p, (Plugin)NpcPlugin.plugin, currentServer, null, player -> player.openInventory(player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()))), (player, s) -> {
                    if (s == null || s.trim().isEmpty()) {
                        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(player, "actions.server.input.empty", true, new Object[0]);
                        player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                        return;
                    }
                    data.actionInstance().param = (Serializable)Var.unsafeCast(s);
                    data.npc().markChange();
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                    LocalizedMessage.sendMessage(player, "actions.server.set", true, s);
                    player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                }, LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.server.input.prompt", new Object[0]), LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.server.input.edit.text", new Object[0]), LocalizationManager.get((Player)data.event.getWhoClicked(), "misc.ok", new Object[0]), LocalizationManager.get((Player)data.event.getWhoClicked(), "misc.back", new Object[0]));
                return currentServer;
            }
            new ConversationManager((Plugin)NpcPlugin.plugin).withModality(false).withLocalEcho(false).withEscapeSequence(LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.server.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(abandonedEvent -> {
                Player player = (Player)abandonedEvent.getContext().getForWhom();
                if (!abandonedEvent.gracefulExit()) {
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    ConversationContext context = abandonedEvent.getContext();
                    if (!(abandonedEvent.getCanceller() instanceof InactivityConversationCanceller)) {
                        LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.server.input.cancelled", true, new Object[0]);
                    } else {
                        LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.server.input.timeout", true, NpcApi.config.inputTime());
                    }
                }
                Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport())));
            }).withFirstPrompt(new Prompt(){
                final /* synthetic */ String val$currentServer;
                final /* synthetic */ PluginActionData val$data;
                {
                    this.val$currentServer = string;
                    this.val$data = pluginActionData;
                }

                public boolean blocksForInput(@NotNull ConversationContext context) {
                    if (this.val$currentServer == null || this.val$currentServer.isEmpty()) {
                        return true;
                    }
                    WrappedServerPlayer.fromPlayer((Player)context.getForWhom()).sendRawMessage(WrappedComponent.parseFromLegacy(LocalizationManager.get((Player)context.getForWhom(), "actions.server.input.edit.text", new Object[0])).setFormats(ChatFormat.ITALIC, ChatFormat.GREEN).withClickEvent(WrappedComponent.ClickEvent.create(WrappedComponent.ClickEvent.ClickAction.SUGGEST_COMMAND, this.val$currentServer)).withHoverEvent(WrappedComponent.HoverEvent.create(WrappedComponent.create(LocalizationManager.get((Player)context.getForWhom(), "actions.server.input.edit.hover", new Object[0])).setFormats(ChatFormat.GRAY, ChatFormat.ITALIC))));
                    return true;
                }

                @NotNull
                public String getPromptText(@NotNull ConversationContext context) {
                    return Prefix.PREFIX + LocalizationManager.get((Player)context.getForWhom(), "actions.server.input.prompt", new Object[0]);
                }

                public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
                    Player conversingPlayer = (Player)context.getForWhom();
                    if (input == null || input.trim().isEmpty()) {
                        conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(conversingPlayer, "actions.server.input.empty", true, new Object[0]);
                        return this;
                    }
                    this.val$data.actionInstance().param = (Serializable)Var.unsafeCast(input);
                    this.val$data.npc().markChange();
                    conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                    LocalizedMessage.sendMessage(conversingPlayer, "actions.server.set", true, input);
                    return Prompt.END_OF_CONVERSATION;
                }
            }).buildConversation((Conversable)data.event().getWhoClicked()).begin();
            return currentServer;
        });

        public PluginActionOptions(@NotNull String name, @Nullable T defaultValue, @NotNull Function<T, NpcClickAction> function, @NotNull BiFunction<T, Player, ItemBuilder> icon, @NotNull BiFunction<T, PluginActionData, T> clickAction) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.function = function;
            this.icon = icon;
            this.clickAction = clickAction;
            OPTIONS_REGISTRY.put(name, this);
        }

        @Nullable
        public static PluginActionOptions<?> getFromMaterial(@NotNull Material material) {
            return OPTIONS_REGISTRY.values().stream().filter(option -> option.icon.apply(null, null).build().getType() == material).findFirst().orElse(null);
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String getName(Player player) {
            return LocalizationManager.get(player, "actions." + this.name + ".title", new Object[0]);
        }

        @NotNull
        public ItemBuilder getDefaultItem(Player player) {
            return this.icon.apply(null, player).setName(this.getName(player)).setClickHandler(null).setLore(new ArrayList<String>());
        }

        private <V extends Serializable> PluginActionOptions<V> getOption() {
            PluginActionOptions<?> registeredOption = OPTIONS_REGISTRY.get(this.name);
            if (registeredOption != null && registeredOption.getClass() == this.getClass()) {
                return registeredOption;
            }
            NpcPlugin.plugin.getLogger().severe("Failed to get canonical option for: " + this.name + ". It may have been removed or renamed.");
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PluginActionOptions)) {
                return false;
            }
            PluginActionOptions that = (PluginActionOptions)obj;
            return this.name.equals(that.name);
        }

        public record PluginActionData(@NotNull InventoryClickEvent event, @NotNull NPC npc, @NotNull ClickActionType clickActionType, @NotNull PluginAction<?> actionInstance, boolean withTeleport) {
        }
    }
}

