/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils;

import de.eisi05.npc.api.enums.ClickActionType;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.NpcOption;
import de.eisi05.npc.api.objects.Skin;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import de.eisi05.npc.plugin.objects.NpcClickActionImpl;
import java.io.File;
import java.nio.file.Path;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;

public class NpcUpdater {
    public static void update() {
        File file = Path.of("plugins", "NPC", "NPC.yml").toFile();
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (!config.contains("data")) {
            return;
        }
        for (String id : config.getConfigurationSection("data").getKeys(false)) {
            try {
                String world = config.getString("data." + id + ".world");
                double x = config.getDouble("data." + id + ".x");
                double y = config.getDouble("data." + id + ".y");
                double z = config.getDouble("data." + id + ".z");
                float yaw = (float)config.getDouble("data." + id + ".yaw");
                float pitch = (float)config.getDouble("data." + id + ".pitch");
                String name = config.getString("data." + id + ".name");
                String texture = config.getString("data." + id + ".texture");
                String signature = config.getString("data." + id + ".signature");
                NPC npc = new NPC(new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch), WrappedComponent.parseFromLegacy(name));
                npc.setOption(NpcOption.SKIN, new Skin("?", texture, signature));
                try {
                    String action = config.getString("data." + id + ".action");
                    String interaction = config.getString("data." + id + ".interaction");
                    String function = config.getString("data." + id + ".function");
                    ClickActionType type = interaction.equalsIgnoreCase("all") ? ClickActionType.BOTH : ClickActionType.valueOf(interaction.toUpperCase());
                    switch (action.toLowerCase()) {
                        case "command": {
                            npc.setClickEvent(new NpcClickActionImpl().add(type, NpcClickActionImpl.PluginActionOptions.COMMAND, function.startsWith("/") ? function : "/" + function));
                            break;
                        }
                        case "world": {
                            Location location = Bukkit.getWorld((String)function).getSpawnLocation();
                            npc.setClickEvent(new NpcClickActionImpl().add(type, NpcClickActionImpl.PluginActionOptions.COMMAND, "tp @s " + location.getX() + " " + location.getY() + " " + location.getZ() + " " + location.getYaw() + " " + location.getPitch()));
                            break;
                        }
                        case "server": {
                            npc.setClickEvent(new NpcClickActionImpl().add(type, NpcClickActionImpl.PluginActionOptions.SERVER, function));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                npc.showNpcToAllPlayers();
            }
            catch (Exception exception) {}
        }
        file.delete();
        file.getParentFile().delete();
    }
}

