/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.properties.Property;
import de.eisi05.npc.api.objects.SkinData;
import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.utils.exceptions.VersionNotFound;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Skin(@Nullable String name, @Nullable String value, @Nullable String signature) implements SkinData
{
    private static final long serialVersionUID = 1L;
    private static final Map<String, Skin> skinCacheName = new HashMap<String, Skin>();
    private static final Map<UUID, Skin> skinCacheUUID = new HashMap<UUID, Skin>();
    private static final Map<File, Skin> skinCacheFile = new HashMap<File, Skin>();

    @Nullable
    public static Skin fromPlayer(@NotNull Player player) {
        Iterator properties = WrappedServerPlayer.fromPlayer(player).getGameProfile().getProperties().get((Object)"textures").iterator();
        if (!properties.hasNext()) {
            return null;
        }
        Property property = (Property)properties.next();
        if (Versions.getVersion() == Versions.NONE) {
            throw new VersionNotFound();
        }
        return Versions.isCurrentVersionSmallerThan(Versions.V1_20_2) ? new Skin(player.getName(), (String)Reflections.invokeMethod(property, "getValue", new Object[0]).get(), (String)Reflections.invokeMethod(property, "getSignature", new Object[0]).get()) : new Skin(player.getName(), (String)Reflections.invokeMethod(property, "value", new Object[0]).get(), (String)Reflections.invokeMethod(property, "signature", new Object[0]).get());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Optional<Skin> fetchSkin(@NotNull UUID uuid) {
        if (skinCacheUUID.containsKey(uuid)) {
            return Optional.ofNullable(skinCacheUUID.get(uuid));
        }
        try {
            URL url = URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false").toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(10000);
            try (InputStream is = connection.getInputStream();){
                Object object;
                Scanner scanner;
                block17: {
                    scanner = new Scanner(is);
                    try {
                        String signature;
                        String response = scanner.useDelimiter("\\A").next();
                        JsonObject json = new JsonParser().parse(response).getAsJsonObject();
                        String name = json.get("name").getAsString();
                        JsonArray properties = json.getAsJsonArray("properties");
                        object = properties.iterator();
                        if (!object.hasNext()) break block17;
                        JsonElement prop = (JsonElement)object.next();
                        JsonObject obj = prop.getAsJsonObject();
                        String value = obj.get("value").getAsString();
                        String string = signature = obj.has("signature") ? obj.get("signature").getAsString() : null;
                        if (Versions.getVersion() == Versions.NONE) {
                            throw new VersionNotFound();
                        }
                        Skin skin = new Skin(name, value, signature);
                        skinCacheUUID.put(uuid, skin);
                        skinCacheName.put(name, skin);
                        Optional<Skin> optional = Optional.of(skin);
                        scanner.close();
                        return optional;
                    }
                    catch (Throwable throwable) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                object = Optional.empty();
                scanner.close();
                return object;
            }
        }
        catch (IOException e) {
            skinCacheUUID.put(uuid, null);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<Skin> fetchSkin(@NotNull String name) {
        if (skinCacheName.containsKey(name)) {
            return Optional.ofNullable(skinCacheName.get(name));
        }
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(10000);
            try (InputStream is = conn.getInputStream();){
                Scanner scanner = new Scanner(is);
                try {
                    String response = scanner.useDelimiter("\\A").next();
                    JsonObject json = new JsonParser().parse(response).getAsJsonObject();
                    String id = json.get("id").getAsString();
                    Optional<Skin> optional = Skin.fetchSkin(UUID.fromString(id.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5")));
                    scanner.close();
                    return optional;
                }
                catch (Throwable throwable) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            skinCacheName.put(name, null);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<Skin> fetchSkin(@NotNull File skinFile) {
        if (!skinFile.exists()) {
            throw new IllegalArgumentException("File does not exist");
        }
        if (skinCacheFile.containsKey(skinFile)) {
            return Optional.ofNullable(skinCacheFile.get(skinFile));
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build();
        String boundary = "----MineSkinBoundary" + System.currentTimeMillis();
        try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();){
            Optional optional;
            try (FileInputStream fis = new FileInputStream(skinFile);){
                int len;
                HttpPost upload = new HttpPost("https://api.mineskin.org/generate/upload");
                upload.setHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8), true);
                writer.append("--").append(boundary).append("\r\n");
                writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(skinFile.getName()).append("\"\r\n");
                writer.append("Content-Type: image/png\r\n\r\n");
                writer.flush();
                byte[] buffer = new byte[4096];
                while ((len = fis.read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
                baos.flush();
                writer.append("\r\n--").append(boundary).append("--\r\n");
                writer.flush();
                upload.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray()));
                optional = (Optional)httpClient.execute((HttpUriRequest)upload, response -> {
                    HttpEntity responseEntity = response.getEntity();
                    String json = EntityUtils.toString((HttpEntity)responseEntity);
                    JsonObject obj = new JsonParser().parse(json).getAsJsonObject();
                    JsonObject texture = obj.getAsJsonObject("data").getAsJsonObject("texture");
                    String value = texture.get("value").getAsString();
                    String signature = texture.get("signature").getAsString();
                    Skin skin = new Skin(null, value, signature);
                    skinCacheFile.put(skinFile, skin);
                    return Optional.of(skin);
                });
            }
            return optional;
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static CompletableFuture<Optional<Skin>> fetchSkinAsync(@NotNull UUID uuid) {
        return CompletableFuture.supplyAsync(() -> Skin.fetchSkin(uuid));
    }

    public static CompletableFuture<Optional<Skin>> fetchSkinAsync(@NotNull String name) {
        return CompletableFuture.supplyAsync(() -> Skin.fetchSkin(name));
    }

    public static CompletableFuture<Optional<Skin>> fetchSkinAsync(@NotNull File skinFile) {
        return CompletableFuture.supplyAsync(() -> Skin.fetchSkin(skinFile));
    }

    public static boolean isPreLoaded(@NotNull String name) {
        return skinCacheName.containsKey(name);
    }

    public static boolean isPreLoaded(@NotNull UUID uuid) {
        return skinCacheUUID.containsKey(uuid);
    }
}

