/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.utils;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallerUtils {
    private static final Map<Class<?>, MethodHandles.Lookup> lookupCache = new ConcurrentHashMap();
    private static final StackWalker WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    @Nullable
    public static Class<?> getCallerClass() {
        return WALKER.walk(frames -> frames.skip(2L).findFirst().map(StackWalker.StackFrame::getDeclaringClass).orElse(null));
    }

    @Nullable
    public static String getCallerMethodName() {
        return WALKER.walk(frames -> frames.skip(2L).findFirst().map(StackWalker.StackFrame::getMethodName).orElse(null));
    }

    @NotNull
    public static MethodHandles.Lookup getLookup(@NotNull Class<?> clazz) {
        return lookupCache.computeIfAbsent(clazz, c -> MethodHandles.lookup());
    }
}

