/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.commands;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.eisi05.npc.api.pathfinding.Path;
import de.eisi05.npc.api.wrapper.objects.WrappedCommandSourceStack;
import de.eisi05.npc.api.wrapper.objects.WrappedVec2F;
import de.eisi05.npc.api.wrapper.objects.WrappedVec3D;
import de.eisi05.npc.plugin.commands.arguments.RotationArgument;
import de.eisi05.npc.plugin.commands.arguments.Vec3Argument;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.manager.PathManager;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import de.eisi05.npc.plugin.utils.Prefix;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PathCommand {
    public static ArgumentBuilder<Object, ?> pathCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"path").requires(o -> new WrappedCommandSourceStack(o).getBukkitSender() instanceof Player)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"point").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"add").then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(PathCommand::pathPointIndexSuggestions).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            int index = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index");
            PathCommand.addPoint(player, index, player.getLocation());
            return 1;
        }))).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathCommand.addPoint(player, -1, player.getLocation());
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"location", Vec3Argument.vec3()).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"rotation", RotationArgument.rotation()).then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(PathCommand::pathPointIndexSuggestions).executes(ctx -> {
            WrappedCommandSourceStack sourceStack = new WrappedCommandSourceStack(ctx.getSource());
            Player player = (Player)sourceStack.getBukkitSender();
            WrappedVec3D wrappedVec3D = Vec3Argument.getVec3(ctx, "location");
            WrappedVec2F wrappedVec2F = RotationArgument.getRotation(ctx, "rotation").getRotation(sourceStack);
            int index = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index");
            Location location = new Location(player.getWorld(), wrappedVec3D.getX(), wrappedVec3D.getY(), wrappedVec3D.getZ(), wrappedVec2F.getYaw(), wrappedVec2F.getPitch());
            PathCommand.addPoint(player, index, location);
            return 1;
        }))).executes(ctx -> {
            WrappedCommandSourceStack sourceStack = new WrappedCommandSourceStack(ctx.getSource());
            Player player = (Player)sourceStack.getBukkitSender();
            WrappedVec3D wrappedVec3D = Vec3Argument.getVec3(ctx, "location");
            WrappedVec2F wrappedVec2F = RotationArgument.getRotation(ctx, "rotation").getRotation(sourceStack);
            Location location = new Location(player.getWorld(), wrappedVec3D.getX(), wrappedVec3D.getY(), wrappedVec3D.getZ(), wrappedVec2F.getYaw(), wrappedVec2F.getPitch());
            PathCommand.addPoint(player, -1, location);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"remove").then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(PathCommand::pathPointIndexSuggestions).executes(ctx -> {
            int index;
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            if (pathManager.removePathPoint(index = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index"))) {
                LocalizedMessage.sendMessage(player, "command.path.point.remove.success.index", true, index);
            } else {
                LocalizedMessage.sendMessage(player, "command.path.point.remove.fail.index", true, index);
            }
            return 1;
        }))).then(RequiredArgumentBuilder.argument((String)"location", Vec3Argument.vec3()).suggests((context, builder) -> {
            Player player = (Player)new WrappedCommandSourceStack(context.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            if (pathManager == null || pathManager.getPathPoints().isEmpty()) {
                return builder.buildFuture();
            }
            for (Location loc : pathManager.getPathPoints()) {
                String suggestion = String.format("%.2f %.2f %.2f", loc.getX(), loc.getY(), loc.getZ());
                if (!suggestion.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(suggestion, (Message)new LiteralMessage("World: " + loc.getWorld().getName()));
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            WrappedVec3D location = Vec3Argument.getVec3(ctx, "location");
            if (pathManager.removePathPoint(new Location(player.getWorld(), location.getX(), location.getY(), location.getZ()))) {
                LocalizedMessage.sendMessage(player, "command.path.point.remove.success.loc", true, new Object[0]);
            } else {
                LocalizedMessage.sendMessage(player, "command.path.point.remove.fail.loc", true, new Object[0]);
            }
            return 1;
        }))).executes(ctx -> {
            int index;
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            if (pathManager.removePathPoint(index = pathManager.getPathPoints().size() - 1)) {
                LocalizedMessage.sendMessage(player, "command.path.point.remove.success.index", true, index);
            } else {
                LocalizedMessage.sendMessage(player, "command.path.point.remove.fail.index", true, index);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"list").then(RequiredArgumentBuilder.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            PathCommand.showPointsList(player, pathManager.getPathPoints(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"));
            return 1;
        }))).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            PathCommand.showPointsList(player, pathManager.getPathPoints(), 1);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"clear").executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            pathManager.clearPathPoints();
            LocalizedMessage.sendMessage(player, "command.path.point.clear", true, new Object[0]);
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"create").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"maxIterations", (ArgumentType)IntegerArgumentType.integer((int)1)).then(RequiredArgumentBuilder.argument((String)"allowDiagonalMovement", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            int maxIterations = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxIterations");
            boolean allowDiagonalMovement = BoolArgumentType.getBool((CommandContext)ctx, (String)"allowDiagonalMovement");
            PathCommand.createPath(player, name, maxIterations, allowDiagonalMovement);
            return 1;
        }))).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            int maxIterations = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxIterations");
            PathCommand.createPath(player, name, maxIterations, true);
            return 1;
        }))).then(RequiredArgumentBuilder.argument((String)"allowDiagonalMovement", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            boolean allowDiagonalMovement = BoolArgumentType.getBool((CommandContext)ctx, (String)"allowDiagonalMovement");
            PathCommand.createPath(player, name, 10000, allowDiagonalMovement);
            return 1;
        }))).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            PathCommand.createPath(player, name, 10000, true);
            return 1;
        }))).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            String name = pathManager.getEditingPath();
            if (name == null) {
                LocalizedMessage.sendMessage(player, "command.path.edit.null", true, new Object[0]);
                return 1;
            }
            PathCommand.createPath(player, name, 10000, true);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"delete").then(RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PathCommand::pathNameSuggestions).executes(ctx -> {
            String name;
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            if (pathManager.getPath(name = StringArgumentType.getString((CommandContext)ctx, (String)"name")).isEmpty()) {
                LocalizedMessage.sendMessage(player, "command.path.not-exists", true, name);
                return 1;
            }
            pathManager.deletePath(name);
            LocalizedMessage.sendMessage(player, "command.path.delete", true, name);
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"list").then(RequiredArgumentBuilder.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            PathCommand.showPathList(player, pathManager.getPaths(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"));
            return 1;
        }))).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            PathCommand.showPathList(player, pathManager.getPaths(), 1);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"visualize").then(RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PathCommand::pathNameSuggestions).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            pathManager.getPath(name).ifPresentOrElse(path -> {
                if (pathManager.visualizePath((Path)path)) {
                    LocalizedMessage.sendMessage(player, "command.path.visualize", true, name);
                } else {
                    LocalizedMessage.sendMessage(player, "command.path.hide", true, name);
                }
            }, () -> LocalizedMessage.sendMessage(player, "command.path.not-exists", true, name));
            return 1;
        }))).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            long l = pathManager.hideVisualizations();
            if (l != -1L) {
                LocalizedMessage.sendMessage(player, "command.path.hide-all.success", true, l);
            } else {
                LocalizedMessage.sendMessage(player, "command.path.hide-all.fail", true, new Object[0]);
            }
            return 1;
        })).then(LiteralArgumentBuilder.literal((String)"points").executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            if (pathManager.getPathPoints().isEmpty()) {
                LocalizedMessage.sendMessage(player, "command.path.point.empty", true, new Object[0]);
                return 1;
            }
            if (pathManager.visualizePoints()) {
                LocalizedMessage.sendMessage(player, "command.path.point.visualize", true, new Object[0]);
            } else {
                LocalizedMessage.sendMessage(player, "command.path.point.hide", true, new Object[0]);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"record").then(LiteralArgumentBuilder.literal((String)"start").executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            if (pathManager.startRecording()) {
                LocalizedMessage.sendMessage(player, "command.path.record.start", true, new Object[0]);
            } else {
                LocalizedMessage.sendMessage(player, "command.path.record.already", true, new Object[0]);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"stop").executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            long l = pathManager.stopRecording();
            if (l == -1L) {
                LocalizedMessage.sendMessage(player, "command.path.record.not-started", true, new Object[0]);
            } else {
                LocalizedMessage.sendMessage(player, "command.path.record.stop", true, l);
            }
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"test").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PathCommand::pathNameSuggestions).then(RequiredArgumentBuilder.argument((String)"speed", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            double walkSpeed = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speed");
            pathManager.getPath(name).ifPresentOrElse(path -> {
                if (pathManager.testPath((Path)path, walkSpeed)) {
                    LocalizedMessage.sendMessage(player, "command.path.test.start", true, name);
                } else {
                    LocalizedMessage.sendMessage(player, "command.path.test.stop", true, name);
                }
            }, () -> LocalizedMessage.sendMessage(player, "command.path.not-exists", true, name));
            return 1;
        }))).executes(ctx -> {
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            pathManager.getPath(name).ifPresentOrElse(path -> {
                if (pathManager.testPath((Path)path, 0.25)) {
                    LocalizedMessage.sendMessage(player, "command.path.test.start", true, name);
                } else {
                    LocalizedMessage.sendMessage(player, "command.path.test.stop", true, name);
                }
            }, () -> LocalizedMessage.sendMessage(player, "command.path.not-exists", true, name));
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"edit").then(RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PathCommand::pathNameSuggestions).executes(ctx -> {
            String name;
            Player player = (Player)new WrappedCommandSourceStack(ctx.getSource()).getBukkitSender();
            PathManager pathManager = PathManager.getInstance(player);
            if (pathManager.getPath(name = StringArgumentType.getString((CommandContext)ctx, (String)"name")).isEmpty()) {
                LocalizedMessage.sendMessage(player, "command.path.not-found", true, name);
                return 1;
            }
            pathManager.editPath(name);
            LocalizedMessage.sendMessage(player, "command.path.edit.start", true, name);
            return 1;
        })));
    }

    private static void createPath(@NotNull Player player, @NotNull String path, int maxIterations, boolean allowDiagonalMovement) {
        PathManager pathManager = PathManager.getInstance(player);
        if (pathManager.getPath(path).isPresent() && !path.equals(pathManager.getEditingPath())) {
            LocalizedMessage.sendMessage(player, "command.path.exists", true, path);
            return;
        }
        LocalizedMessage.sendMessage(player, "command.path.creating", true, path);
        ((CompletableFuture)pathManager.createPath(path, maxIterations, allowDiagonalMovement).thenRun(() -> {
            BaseComponent prefix = TextComponent.fromLegacyText((String)Prefix.PREFIX)[0];
            BaseComponent[] textComponent = TextComponent.fromLegacyText((String)LocalizationManager.get(player, "command.path.created", path));
            BaseComponent visualizeButton = TextComponent.fromLegacyText((String)LocalizationManager.get(player, "command.path.button.visualize", new Object[0]))[0];
            visualizeButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npc path visualize " + path));
            TextComponent message = new TextComponent(new BaseComponent[]{prefix});
            for (BaseComponent comp : textComponent) {
                message.addExtra(comp);
            }
            message.addExtra(" ");
            message.addExtra(visualizeButton);
            player.spigot().sendMessage((BaseComponent)message);
        })).exceptionally(throwable -> {
            RuntimeException runtimeException;
            if (throwable instanceof RuntimeException && (runtimeException = (RuntimeException)throwable).getCause() != null) {
                LocalizedMessage.sendMessage(player, "command.path.invalid", true, path, runtimeException.getCause().getMessage());
            }
            return null;
        });
    }

    @NotNull
    private static CompletableFuture<Suggestions> pathPointIndexSuggestions(@NotNull CommandContext<?> context, @NotNull SuggestionsBuilder builder) {
        Player player = (Player)new WrappedCommandSourceStack(context.getSource()).getBukkitSender();
        PathManager pathManager = PathManager.getInstance(player);
        if (pathManager == null || pathManager.getPathPoints().isEmpty()) {
            return builder.buildFuture();
        }
        for (int i = 0; i < pathManager.getPathPoints().size(); ++i) {
            if (!String.valueOf(i).startsWith(builder.getRemainingLowerCase())) continue;
            builder.suggest(i);
        }
        return builder.buildFuture();
    }

    @NotNull
    private static CompletableFuture<Suggestions> pathNameSuggestions(@NotNull CommandContext<?> context, @NotNull SuggestionsBuilder builder) {
        Player player = (Player)new WrappedCommandSourceStack(context.getSource()).getBukkitSender();
        PathManager pathManager = PathManager.getInstance(player);
        if (pathManager == null || pathManager.getPathNames().isEmpty()) {
            return builder.buildFuture();
        }
        for (String name : pathManager.getPathNames()) {
            if (!name.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
            builder.suggest(name);
        }
        return builder.buildFuture();
    }

    private static void addPoint(@NotNull Player player, int index, @NotNull Location location) {
        PathManager pathManager = PathManager.getInstance(player);
        pathManager.addPathPoint(location, index);
        String formateLocation = PathCommand.formatLocation(location);
        if (index != -1) {
            LocalizedMessage.sendMessage(player, "command.path.point.add.index", true, index, formateLocation);
        } else {
            LocalizedMessage.sendMessage(player, "command.path.point.add.loc", true, formateLocation);
        }
    }

    @NotNull
    private static String formatLocation(@NotNull Location location) {
        return String.format("%s: %.1f, %.1f, %.1f (%.1f, %.1f)", location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
    }

    private static void showPointsList(@NotNull Player player, @NotNull List<Location> pathPoints, int page) {
        if (pathPoints.isEmpty()) {
            LocalizedMessage.sendMessage(player, "command.path.point.empty", true, new Object[0]);
            return;
        }
        int perPage = 10;
        int maxPage = (int)Math.ceil((double)pathPoints.size() / 10.0);
        if (page > maxPage) {
            page = maxPage;
        }
        int start = (page - 1) * 10;
        int end = Math.min(start + 10, pathPoints.size());
        LocalizedMessage.sendMessage(player, "command.path.point.list", false, page, maxPage);
        for (int i = start; i < end; ++i) {
            Location loc = pathPoints.get(i);
            String formatted = String.format("\u00a77[%d] \u00a7f%s: %d, %d, %d", i, loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            TextComponent line = new TextComponent(formatted);
            BaseComponent deleteBtn = TextComponent.fromLegacyText((String)LocalizationManager.get(player, "command.path.button.remove", new Object[0]))[0];
            deleteBtn.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npc path point remove " + loc.getX() + " " + loc.getY() + " " + loc.getZ()));
            line.addExtra(" ");
            line.addExtra(deleteBtn);
            player.spigot().sendMessage((BaseComponent)line);
        }
        TextComponent nav = new TextComponent("");
        if (page > 1) {
            TextComponent prev = new TextComponent("\u00a7a\u00ab Prev ");
            prev.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npc path point list " + (page - 1)));
            nav.addExtra((BaseComponent)prev);
        }
        if (page < maxPage) {
            TextComponent next = new TextComponent("\u00a7a Next \u00bb");
            next.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npc path point list " + (page + 1)));
            nav.addExtra((BaseComponent)next);
        }
        if (nav.getExtra() != null && !nav.getExtra().isEmpty()) {
            player.spigot().sendMessage((BaseComponent)nav);
        }
    }

    private static void showPathList(@NotNull Player player, @NotNull Map<String, Path> paths, int page) {
        if (paths.isEmpty()) {
            LocalizedMessage.sendMessage(player, "command.path.empty", true, new Object[0]);
            return;
        }
        int perPage = 10;
        int maxPage = (int)Math.ceil((double)paths.size() / (double)perPage);
        if (page > maxPage) {
            page = maxPage;
        }
        int start = (page - 1) * perPage;
        int end = Math.min(start + perPage, paths.size());
        LocalizedMessage.sendMessage(player, "command.path.list", false, page, maxPage);
        ArrayList<Map.Entry<String, Path>> entries = new ArrayList<Map.Entry<String, Path>>(paths.entrySet());
        for (int i = start; i < end; ++i) {
            Map.Entry entry = (Map.Entry)entries.get(i);
            String pathName = (String)entry.getKey();
            TextComponent line = new TextComponent("\u00a7f" + pathName);
            BaseComponent visBtn = TextComponent.fromLegacyText((String)LocalizationManager.get(player, "command.path.button.visualize", new Object[0]))[0];
            visBtn.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npc path visualize " + pathName));
            BaseComponent delBtn = TextComponent.fromLegacyText((String)LocalizationManager.get(player, "command.path.button.delete", new Object[0]))[0];
            delBtn.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npc path delete " + pathName));
            line.addExtra(" ");
            line.addExtra(visBtn);
            line.addExtra(" ");
            line.addExtra(delBtn);
            player.spigot().sendMessage((BaseComponent)line);
        }
        TextComponent nav = new TextComponent("");
        if (page > 1) {
            TextComponent prev = new TextComponent("\u00a7a\u00ab Prev ");
            prev.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npc path list " + (page - 1)));
            nav.addExtra((BaseComponent)prev);
        }
        if (page < maxPage) {
            TextComponent next = new TextComponent("\u00a7a Next \u00bb");
            next.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npc path list " + (page + 1)));
            nav.addExtra((BaseComponent)next);
        }
        if (nav.getExtra() != null && !nav.getExtra().isEmpty()) {
            player.spigot().sendMessage((BaseComponent)nav);
        }
    }
}

