/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.manager;

import de.eisi05.npc.plugin.utils.Prefix;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.ExactMatchConversationCanceller;
import org.bukkit.conversations.InactivityConversationCanceller;
import org.bukkit.conversations.MessagePrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversationManager
extends ConversationFactory {
    public static final Map<UUID, Conversation> activeConversations = new HashMap<UUID, Conversation>();

    public ConversationManager(@NotNull Plugin plugin) {
        super(plugin);
    }

    @NotNull
    public ConversationManager withModality(boolean modal) {
        this.isModal = modal;
        return this;
    }

    @NotNull
    public ConversationManager withLocalEcho(boolean localEchoEnabled) {
        this.localEchoEnabled = localEchoEnabled;
        return this;
    }

    @NotNull
    public ConversationManager withPrefix(@NotNull ConversationPrefix prefix) {
        this.prefix = prefix;
        return this;
    }

    @NotNull
    public ConversationManager withTimeout(int timeoutSeconds) {
        if (timeoutSeconds <= 0) {
            return this;
        }
        return this.withConversationCanceller((ConversationCanceller)new InactivityConversationCanceller(this.plugin, timeoutSeconds));
    }

    @NotNull
    public ConversationManager withFirstPrompt(@Nullable Prompt firstPrompt) {
        this.firstPrompt = firstPrompt;
        return this;
    }

    @NotNull
    public ConversationManager withInitialSessionData(@NotNull Map<Object, Object> initialSessionData) {
        this.initialSessionData = initialSessionData;
        return this;
    }

    @NotNull
    public ConversationManager withEscapeSequence(@NotNull String escapeSequence) {
        return this.withConversationCanceller((ConversationCanceller)new ExactMatchConversationCanceller(escapeSequence));
    }

    @NotNull
    public ConversationManager withConversationCanceller(@NotNull ConversationCanceller canceller) {
        this.cancellers.add(canceller);
        return this;
    }

    @NotNull
    public ConversationManager thatExcludesNonPlayersWithMessage(@Nullable String playerOnlyMessage) {
        this.playerOnlyMessage = playerOnlyMessage;
        return this;
    }

    @NotNull
    public ConversationManager addConversationAbandonedListener(@NotNull ConversationAbandonedListener listener) {
        this.abandonedListeners.add(listener);
        return this;
    }

    @NotNull
    public MyConversation buildConversation(@NotNull Conversable forWhom) {
        if (this.playerOnlyMessage != null && !(forWhom instanceof Player)) {
            return new MyConversation(this.plugin, forWhom, (Prompt)new NotPlayerMessagePrompt());
        }
        HashMap<Object, Object> copiedInitialSessionData = new HashMap<Object, Object>(this.initialSessionData);
        MyConversation conversation = new MyConversation(this.plugin, forWhom, this.firstPrompt, copiedInitialSessionData);
        conversation.setModal(this.isModal);
        conversation.setLocalEchoEnabled(this.localEchoEnabled);
        conversation.setPrefix(this.prefix);
        for (ConversationCanceller canceller : this.cancellers) {
            conversation.addConversationCanceller(canceller.clone());
        }
        for (ConversationAbandonedListener listener : this.abandonedListeners) {
            conversation.addConversationAbandonedListener(listener);
        }
        return conversation;
    }

    public static class MyConversation
    extends Conversation {
        public MyConversation(@Nullable Plugin plugin, @NotNull Conversable forWhom, @Nullable Prompt firstPrompt) {
            super(plugin, forWhom, firstPrompt);
        }

        public MyConversation(@Nullable Plugin plugin, @NotNull Conversable forWhom, @Nullable Prompt firstPrompt, @NotNull Map<Object, Object> initialSessionData) {
            super(plugin, forWhom, firstPrompt, initialSessionData);
        }

        void setModal(boolean modal) {
            this.modal = modal;
        }

        void setPrefix(@NotNull ConversationPrefix prefix) {
            this.prefix = prefix;
        }

        void addConversationCanceller(@NotNull ConversationCanceller canceller) {
            canceller.setConversation((Conversation)this);
            this.cancellers.add(canceller);
        }

        public synchronized void abandon(@NotNull ConversationAbandonedEvent details) {
            Conversable conversable = details.getContext().getForWhom();
            if (conversable instanceof Player) {
                Player player = (Player)conversable;
                activeConversations.remove(player.getUniqueId());
            }
            if (details.getCanceller() instanceof PluginReloadCanceller) {
                this.abandonedListeners.clear();
                this.context.getForWhom().sendRawMessage(Prefix.PREFIX + String.valueOf(ChatColor.RED) + "Input cancelled due to a plugin reload!");
            }
            super.abandon(details);
        }

        public void begin() {
            Conversable conversable = this.context.getForWhom();
            if (conversable instanceof Player) {
                Player player = (Player)conversable;
                activeConversations.put(player.getUniqueId(), this);
            }
            super.begin();
        }
    }

    private class NotPlayerMessagePrompt
    extends MessagePrompt {
        private NotPlayerMessagePrompt() {
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            return ConversationManager.this.playerOnlyMessage;
        }

        @Nullable
        protected Prompt getNextPrompt(@NotNull ConversationContext context) {
            return Prompt.END_OF_CONVERSATION;
        }
    }

    public static class PluginReloadCanceller
    implements ConversationCanceller {
        public void setConversation(@NotNull Conversation conversation) {
        }

        public boolean cancelBasedOnInput(@NotNull ConversationContext context, @NotNull String input) {
            return false;
        }

        @NotNull
        public ConversationCanceller clone() {
            return null;
        }
    }
}

