/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.objects;

import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.wrapper.packets.AnimatePacket;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.objects.AbstractPluginActionOption;
import de.eisi05.npc.plugin.objects.NpcClickActionImpl;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public final class AnimationActionOption
extends AbstractPluginActionOption<AnimatePacket.Animation> {
    private static final long serialVersionUID = 1L;

    private AnimationActionOption() {
    }

    @NotNull
    static NpcClickActionImpl.PluginActionOptions<AnimatePacket.Animation> getAnimationAction() {
        return AnimationActionOption.getOption(AnimationActionOption.class, AnimationActionOption::new);
    }

    @Override
    String getName() {
        return "animation";
    }

    @Override
    AnimatePacket.Animation getDefaultValue() {
        return AnimatePacket.Animation.SWING_MAIN_HAND;
    }

    @Override
    NpcClickAction getAction(AnimatePacket.Animation animation) {
        return event -> event.getNpc().playAnimation(event.getPlayer(), animation);
    }

    @Override
    ItemBuilder getIcon(AnimatePacket.Animation animation, Player player) {
        return new ItemBuilder(Material.ITEM_FRAME).setLore(Arrays.stream(AnimatePacket.Animation.values()).map(animation1 -> {
            String animationName = ChatColor.stripColor((String)LocalizationManager.get(player, "actions.animation." + animation1.name().replace("_", "-").toLowerCase(), new Object[0]));
            if (animation == animation1) {
                return String.valueOf(ChatColor.GOLD) + "> " + animationName;
            }
            return String.valueOf(ChatColor.GRAY) + " " + animationName;
        }).toList());
    }

    @Override
    AnimatePacket.Animation getClickAction(AnimatePacket.Animation animation, NpcClickActionImpl.PluginActionOptions.PluginActionData data) {
        AnimatePacket.Animation[] values = AnimatePacket.Animation.values();
        int currentIndex = animation.ordinal();
        AnimatePacket.Animation newAnimation = animation;
        boolean changed = false;
        float pitch = 1.0f;
        if (data.event().getClick().isLeftClick()) {
            newAnimation = values[(currentIndex + 1) % values.length];
            if (newAnimation != animation) {
                changed = true;
                pitch = 1.2f;
            }
        } else if (data.event().getClick().isRightClick() && (newAnimation = values[(currentIndex - 1 + values.length) % values.length]) != animation) {
            changed = true;
            pitch = 0.8f;
        }
        if (changed) {
            ItemMeta meta;
            Player p = (Player)data.event().getWhoClicked();
            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, pitch);
            ArrayList<CallSite> modifiedLore = new ArrayList<CallSite>();
            for (AnimatePacket.Animation animation1 : AnimatePacket.Animation.values()) {
                modifiedLore.add((CallSite)((Object)((animation1 == newAnimation ? String.valueOf(ChatColor.GOLD) + "> " : String.valueOf(ChatColor.GRAY) + " ") + ChatColor.stripColor((String)LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.animation." + animation1.name().replace("_", "-").toLowerCase(), new Object[0])))));
            }
            ItemStack current = data.event().getCurrentItem();
            if (current != null && (meta = current.getItemMeta()) != null) {
                meta.setLore(modifiedLore);
                current.setItemMeta(meta);
            }
            data.npc().markChange();
        } else if (data.event().getClick().isLeftClick() || data.event().getClick().isRightClick()) {
            Player p = (Player)data.event().getWhoClicked();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 0.7f);
        }
        return newAnimation;
    }
}

