/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.objects;

import de.eisi05.dialogMenu.DialogMenu;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.enums.ChatFormat;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.gui.NpcGUI;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.objects.AbstractPluginActionOption;
import de.eisi05.npc.plugin.objects.NpcClickActionImpl;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import de.eisi05.npc.plugin.utils.Prefix;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.InactivityConversationCanceller;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerActionOption
extends AbstractPluginActionOption<String> {
    private static final long serialVersionUID = 1L;

    private ServerActionOption() {
    }

    @NotNull
    static NpcClickActionImpl.PluginActionOptions<String> getServerAction() {
        return ServerActionOption.getOption(ServerActionOption.class, ServerActionOption::new);
    }

    @Override
    String getName() {
        return "server";
    }

    @Override
    String getDefaultValue() {
        return null;
    }

    @Override
    NpcClickAction getAction(String s) {
        return e -> {
            if (s == null || s.isBlank()) {
                return;
            }
            try {
                ByteArrayOutputStream bb = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(bb);
                out.writeUTF("Connect");
                out.writeUTF(s);
                e.getPlayer().sendPluginMessage((Plugin)NpcPlugin.plugin, "BungeeCord", bb.toByteArray());
                LocalizedMessage.sendMessage(e.getPlayer(), "actions.server.connecting", true, s);
            }
            catch (Exception ex) {
                LocalizedMessage.sendMessage(e.getPlayer(), "actions.server.failed", true, s);
                NpcPlugin.plugin.getLogger().severe("BungeeCord Connect Error: " + ex.getMessage());
            }
        };
    }

    @Override
    ItemBuilder getIcon(String s, Player player) {
        return new ItemBuilder(Material.ENDER_PEARL).addLore(s == null || s.isEmpty() ? LocalizationManager.get(player, "actions.server.value", LocalizationManager.get(player, "misc.not-set", new Object[0])) : LocalizationManager.get(player, "actions.server.value", s));
    }

    @Override
    String getClickAction(final String currentServer, final NpcClickActionImpl.PluginActionOptions.PluginActionData data) {
        Player p = (Player)data.event().getWhoClicked();
        p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
        data.event().getWhoClicked().closeInventory();
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_6)) {
            DialogMenu.server(p, (Plugin)NpcPlugin.plugin, currentServer, null, player -> player.openInventory(player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()))), (player, s) -> {
                if (s == null || s.trim().isEmpty()) {
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(player, "actions.server.input.empty", true, new Object[0]);
                    player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                    return;
                }
                data.actionInstance().param = (Serializable)Var.unsafeCast(s);
                data.npc().markChange();
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                LocalizedMessage.sendMessage(player, "actions.server.set", true, s);
                player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
            }, LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.server.input.prompt", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.server.input.edit.text", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "misc.ok", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "misc.back", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.server.title", new Object[0]));
            return currentServer;
        }
        new ConversationManager((Plugin)NpcPlugin.plugin).withModality(false).withLocalEcho(false).withEscapeSequence(LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.server.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(abandonedEvent -> {
            Player player = (Player)abandonedEvent.getContext().getForWhom();
            if (!abandonedEvent.gracefulExit()) {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                ConversationContext context = abandonedEvent.getContext();
                if (!(abandonedEvent.getCanceller() instanceof InactivityConversationCanceller)) {
                    LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.server.input.cancelled", true, new Object[0]);
                } else {
                    LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.server.input.timeout", true, NpcApi.config.inputTime());
                }
            }
            Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport())));
        }).withFirstPrompt(new Prompt(){

            public boolean blocksForInput(@NotNull ConversationContext context) {
                if (currentServer == null || currentServer.isEmpty()) {
                    return true;
                }
                WrappedServerPlayer.fromPlayer((Player)context.getForWhom()).sendRawMessage(WrappedComponent.parseFromLegacy(LocalizationManager.get((Player)context.getForWhom(), "actions.server.input.edit.text", new Object[0])).setFormats(ChatFormat.ITALIC, ChatFormat.GREEN).withClickEvent(WrappedComponent.ClickEvent.create(WrappedComponent.ClickEvent.ClickAction.SUGGEST_COMMAND, currentServer)).withHoverEvent(WrappedComponent.HoverEvent.create(WrappedComponent.create(LocalizationManager.get((Player)context.getForWhom(), "actions.server.input.edit.hover", new Object[0])).setFormats(ChatFormat.GRAY, ChatFormat.ITALIC))));
                return true;
            }

            @NotNull
            public String getPromptText(@NotNull ConversationContext context) {
                return Prefix.PREFIX + LocalizationManager.get((Player)context.getForWhom(), "actions.server.input.prompt", new Object[0]);
            }

            public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
                Player conversingPlayer = (Player)context.getForWhom();
                if (input == null || input.trim().isEmpty()) {
                    conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(conversingPlayer, "actions.server.input.empty", true, new Object[0]);
                    return this;
                }
                data.actionInstance().param = (Serializable)Var.unsafeCast(input);
                data.npc().markChange();
                conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                LocalizedMessage.sendMessage(conversingPlayer, "actions.server.set", true, input);
                return Prompt.END_OF_CONVERSATION;
            }
        }).buildConversation((Conversable)data.event().getWhoClicked()).begin();
        return currentServer;
    }
}

