/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import com.google.common.collect.Multimaps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Pair;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.enums.SkinParts;
import de.eisi05.npc.api.manager.TeamManager;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.Skin;
import de.eisi05.npc.api.utils.ItemSerializer;
import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.TriFunction;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.enums.ChatFormat;
import de.eisi05.npc.api.wrapper.packets.SetEntityDataPacket;
import de.eisi05.npc.api.wrapper.packets.SetPlayerTeamPacket;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.scores.PlayerTeam;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpcOption<T, S extends Serializable> {
    public static final NpcOption<Boolean, Boolean> USE_PLAYER_SKIN = new NpcOption<Boolean, Boolean>("use-player-skin", false, aBoolean -> aBoolean, aBoolean -> aBoolean, (skin, npc, player) -> {
        if (!skin.booleanValue()) {
            return null;
        }
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        ServerPlayer npcServerPlayer = (ServerPlayer)npc.getServerPlayer();
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) {
            Property npcProperty;
            Iterator textureProperties = ((PropertyMap)Reflections.getField(serverPlayer.getGameProfile(), "properties").get()).get((Object)"textures").iterator();
            Iterator npcTextureProperties = ((PropertyMap)Reflections.getField(serverPlayer.getGameProfile(), "properties").get()).get((Object)"textures").iterator();
            Property property = textureProperties.hasNext() ? (Property)textureProperties.next() : null;
            Property property2 = npcProperty = npcTextureProperties.hasNext() ? (Property)npcTextureProperties.next() : null;
            if (property == null && npcProperty == null || property != null && npcProperty != null && Reflections.getField(property, "value").get().equals(Reflections.getField(npcProperty, "value").get())) {
                return null;
            }
            UUID newUUID = UUID.randomUUID();
            npc.changeUUID(newUUID);
            GameProfile profile = Reflections.getInstance(GameProfile.class, newUUID, "NPC" + newUUID.toString().substring(0, 13), Reflections.getInstance(PropertyMap.class, Multimaps.forMap(property == null ? Map.of() : Map.of("textures", property))).orElseThrow()).orElseThrow();
            Location location = npc.getLocation();
            DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
            ServerLevel level = ((CraftWorld)location.getWorld()).getHandle();
            npc.serverPlayer = new ServerPlayer((MinecraftServer)server, level, profile, ClientInformation.createDefault());
            Var.moveEntity((Entity)npc.serverPlayer, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            npc.serverPlayer.connection = new ServerGamePacketListenerImpl((MinecraftServer)server, new Connection(PacketFlow.SERVERBOUND), npc.serverPlayer, CommonListenerCookie.createInitial((GameProfile)profile, (boolean)true));
            return null;
        }
        PropertyMap playerProperty = (PropertyMap)Reflections.invokeMethod(serverPlayer.getGameProfile(), "getProperties", new Object[0]).get();
        PropertyMap npcProperty = (PropertyMap)Reflections.invokeMethod(serverPlayer.getGameProfile(), "getProperties", new Object[0]).get();
        Iterator textureProperties = playerProperty.get((Object)"textures").iterator();
        npcProperty.removeAll((Object)"textures");
        if (!textureProperties.hasNext()) {
            return null;
        }
        Property textureProperty = (Property)textureProperties.next();
        npcProperty.put((Object)"textures", (Object)textureProperty);
        return null;
    }).loadBefore(!Versions.isCurrentVersionSmallerThan(Versions.V1_21_9));
    public static final NpcOption<Skin, Skin> SKIN = new NpcOption<Skin, Skin>("skin", null, skin -> skin, skin -> skin, (skin, npc, player) -> {
        if (npc.getOption(USE_PLAYER_SKIN).booleanValue()) {
            return null;
        }
        ServerPlayer npcServerPlayer = (ServerPlayer)npc.getServerPlayer();
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) {
            Property npcProperty;
            Iterator npcTextureProperties = ((PropertyMap)Reflections.getField(npcServerPlayer.getGameProfile(), "properties").get()).get((Object)"textures").iterator();
            Property property = npcProperty = npcTextureProperties.hasNext() ? (Property)npcTextureProperties.next() : null;
            if (skin == null && npcProperty == null || npcProperty != null && skin.value().equals(Reflections.getField(npcProperty, "value").get())) {
                return null;
            }
            UUID newUUID = UUID.randomUUID();
            npc.changeUUID(newUUID);
            Property textures = new Property("textures", skin.value(), skin.signature());
            PropertyMap propertyMap = Reflections.getInstance(PropertyMap.class, Multimaps.forMap(skin == null ? Map.of() : Map.of("textures", textures))).orElseThrow();
            GameProfile profile = Reflections.getInstance(GameProfile.class, newUUID, "NPC" + newUUID.toString().substring(0, 13), propertyMap).orElseThrow();
            Location location = npc.getLocation();
            DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
            ServerLevel level = ((CraftWorld)location.getWorld()).getHandle();
            npc.serverPlayer = new ServerPlayer((MinecraftServer)server, level, profile, ClientInformation.createDefault());
            Var.moveEntity((Entity)npc.serverPlayer, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            npc.serverPlayer.connection = new ServerGamePacketListenerImpl((MinecraftServer)server, new Connection(PacketFlow.SERVERBOUND), npc.serverPlayer, CommonListenerCookie.createInitial((GameProfile)profile, (boolean)true));
            return null;
        }
        PropertyMap properties = (PropertyMap)Reflections.invokeMethod(npcServerPlayer.getGameProfile(), "getProperties", new Object[0]).get();
        properties.removeAll((Object)"textures");
        if (skin == null) {
            return null;
        }
        Property textures = new Property("textures", skin.value(), skin.signature());
        properties.put((Object)"textures", (Object)textures);
        return null;
    }).loadBefore(!Versions.isCurrentVersionSmallerThan(Versions.V1_21_9));
    public static final NpcOption<Boolean, Boolean> SHOW_TAB_LIST = new NpcOption<Boolean, Boolean>("show-tab-list", true, aBoolean -> aBoolean, aBoolean -> aBoolean, (show, npc, player) -> {
        if (show.booleanValue()) {
            return null;
        }
        new BukkitRunnable((Player)player, (NPC)npc){
            final /* synthetic */ Player val$player;
            final /* synthetic */ NPC val$npc;
            {
                this.val$player = player;
                this.val$npc = nPC;
            }

            public void run() {
                ((CraftPlayer)this.val$player).getHandle().connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(this.val$npc.getUUID())));
            }
        }.runTaskLater(NpcApi.plugin, 50L);
        return null;
    });
    public static final NpcOption<Integer, Integer> LATENCY = new NpcOption<Integer, Integer>("latency", 0, aInteger -> aInteger, aInteger -> aInteger, (latency, npc, player) -> {
        ServerPlayer npcServerPlayer = (ServerPlayer)npc.getServerPlayer();
        CommonListenerCookie commonListenerCookie = Versions.isCurrentVersionSmallerThan(Versions.V1_21_7) ? Reflections.getInstanceFirstConstructor(CommonListenerCookie.class, npcServerPlayer.getGameProfile(), latency, ClientInformation.createDefault(), true).orElseThrow() : Reflections.getInstanceFirstConstructor(CommonListenerCookie.class, npcServerPlayer.getGameProfile(), latency, ClientInformation.createDefault(), true, null, new HashSet(), Reflections.getInstance("io.papermc.paper.util.KeepAlive", new Object[0]).orElseThrow()).orElseThrow();
        npcServerPlayer.connection = Versions.isCurrentVersionSmallerThan(Versions.V1_21_9) ? new ServerGamePacketListenerImpl((MinecraftServer)Reflections.invokeMethod(npcServerPlayer, "getServer", new Object[0]).get(), new Connection(PacketFlow.SERVERBOUND), npcServerPlayer, commonListenerCookie) : new ServerGamePacketListenerImpl(npcServerPlayer.level().getServer(), new Connection(PacketFlow.SERVERBOUND), npcServerPlayer, commonListenerCookie);
        return new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY, npcServerPlayer);
    });
    public static final NpcOption<Boolean, Boolean> HIDE_NAMETAG = new NpcOption<Boolean, Boolean>("hide-nametag", false, aBoolean -> aBoolean, aBoolean -> aBoolean, (hide, npc, player) -> {
        if (!hide.booleanValue()) {
            return null;
        }
        return new ClientboundRemoveEntitiesPacket(new int[]{((Entity)npc.getNameTag().getDisplay()).getId()});
    });
    public static final NpcOption<Pose, Pose> POSE = new NpcOption<Pose, Pose>("pose", Pose.STANDING, pose -> pose, pose -> pose, (pose, npc, player) -> {
        net.minecraft.world.entity.Pose nmsPose = net.minecraft.world.entity.Pose.values()[pose.ordinal()];
        if (nmsPose == null) {
            throw new RuntimeException("Pose (" + pose.name() + ") not found");
        }
        ServerPlayer npcServerPlayer = (ServerPlayer)npc.getServerPlayer();
        npcServerPlayer.setPose(nmsPose);
        SynchedEntityData data = npcServerPlayer.getEntityData();
        data.set(EntityDataSerializers.POSE.createAccessor(6), (Object)nmsPose);
        if (pose == Pose.SPIN_ATTACK) {
            data.set(EntityDataSerializers.BYTE.createAccessor(8), (Object)4);
        } else {
            data.set(EntityDataSerializers.BYTE.createAccessor(8), (Object)1);
        }
        return (Packet)SetEntityDataPacket.create(npcServerPlayer.getId(), data);
    });
    public static final NpcOption<Map<org.bukkit.inventory.EquipmentSlot, ItemStack>, HashMap<org.bukkit.inventory.EquipmentSlot, String>> EQUIPMENT = new NpcOption<Map, HashMap>("equipment", Map.of(), map -> {
        HashMap serializedMap = new HashMap();
        map.forEach((slot, item) -> serializedMap.put(slot, ItemSerializer.itemStackToBase64(item)));
        return serializedMap;
    }, serializedMap -> {
        HashMap map = new HashMap();
        serializedMap.forEach((slot, string) -> map.put(slot, ItemSerializer.itemStackFromBase64(string)));
        return map;
    }, (map, npc, player) -> {
        if (map.isEmpty()) {
            return null;
        }
        ArrayList list = new ArrayList();
        map.forEach((slot, item) -> list.add(new Pair((Object)EquipmentSlot.values()[slot.ordinal()], (Object)CraftItemStack.asNMSCopy((ItemStack)item))));
        return new ClientboundSetEquipmentPacket(((ServerPlayer)npc.getServerPlayer()).getId(), list);
    });
    public static final NpcOption<SkinParts[], SkinParts[]> SKIN_PARTS = new NpcOption<SkinParts[], SkinParts[]>("skin-parts", SkinParts.values(), skinParts -> skinParts, skinParts -> skinParts, (skinParts, npc, player) -> {
        ServerPlayer npcServerPlayer = (ServerPlayer)npc.getServerPlayer();
        SynchedEntityData data = npcServerPlayer.getEntityData();
        data.set(EntityDataSerializers.BYTE.createAccessor(Versions.isCurrentVersionSmallerThan(Versions.V1_21_9) ? 17 : 16), (Object)((byte)Arrays.stream(skinParts).mapToInt(SkinParts::getValue).sum()));
        return (Packet)SetEntityDataPacket.create(npcServerPlayer.getId(), data);
    });
    public static final NpcOption<Double, Double> LOOK_AT_PLAYER = new NpcOption<Double, Double>("look-at-player", 0.0, distance -> distance, distance -> distance, (distance, npc, player) -> null);
    public static final NpcOption<ChatFormat, ChatFormat> GLOWING = new NpcOption<ChatFormat, ChatFormat>("glowing", null, color -> color, color -> color, (color, npc, player) -> {
        ServerPlayer npcServerPlayer = (ServerPlayer)npc.getServerPlayer();
        if (color == null) {
            SynchedEntityData entityData = npcServerPlayer.getEntityData();
            entityData.set(EntityDataSerializers.BYTE.createAccessor(0), (Object)0);
            return (Packet)SetEntityDataPacket.create(npcServerPlayer.getId(), entityData);
        }
        String teamName = npc.getGameProfileName();
        boolean modified = TeamManager.exists(player, teamName);
        PlayerTeam team = (PlayerTeam)TeamManager.create(player, teamName);
        team.setColor(ChatFormatting.getByCode((char)color.getColorCode()));
        Object teamPacket = SetPlayerTeamPacket.createAddOrModifyPacket(team, !modified);
        SynchedEntityData entityData = npcServerPlayer.getEntityData();
        entityData.set(EntityDataSerializers.BYTE.createAccessor(0), (Object)64);
        return new ClientboundBundlePacket(List.of((Packet)teamPacket, (Packet)SetEntityDataPacket.create(npcServerPlayer.getId(), entityData)));
    });
    public static final NpcOption<Double, Double> SCALE = new NpcOption<Double, Double>("scale", 1.0, scale -> scale, scale -> scale, (scale, npc, player) -> {
        ServerPlayer npcServerPlayer = (ServerPlayer)npc.getServerPlayer();
        AttributeInstance instance = npcServerPlayer.getAttribute(Attributes.SCALE);
        instance.setBaseValue(scale.doubleValue());
        return new ClientboundUpdateAttributesPacket(npcServerPlayer.getId(), List.of(instance));
    });
    public static final NpcOption<Integer, Integer> LIST_ORDER = new NpcOption<Integer, Integer>("list-order", 0, aInt -> aInt, aInt -> aInt, (order, npc, player) -> {
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_2)) {
            return null;
        }
        ((ServerPlayer)npc.getServerPlayer()).listOrder = order;
        return new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LIST_ORDER, (ServerPlayer)npc.getServerPlayer());
    }).since(Versions.V1_21_2);
    static final NpcOption<Boolean, Boolean> ENABLED = new NpcOption<Boolean, Boolean>("enabled", false, aBoolean -> aBoolean, aBoolean -> aBoolean, (enabled, npc, player) -> null);
    static final NpcOption<Boolean, Boolean> EDITABLE = new NpcOption<Boolean, Boolean>("editable", false, aBoolean -> aBoolean, aBoolean -> aBoolean, (enabled, npc, player) -> null);
    private final String path;
    private final T defaultValue;
    private final Function<T, S> serializer;
    private final Function<S, T> deserializer;
    private final TriFunction<T, NPC, Player, Packet<?>> packet;
    private Versions since = Versions.V1_17;
    private boolean loadBefore = false;

    private NpcOption(@NotNull String path, @Nullable T defaultValue, @NotNull Function<T, S> serializer, @NotNull Function<S, T> deserializer, @NotNull TriFunction<T, NPC, Player, Packet<?>> packet) {
        this.path = path;
        this.defaultValue = defaultValue;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.packet = packet;
    }

    @NotNull
    public static NpcOption<?, ?>[] values() {
        List<Field> fields = Arrays.stream(NpcOption.class.getDeclaredFields()).filter(field -> field.getType().equals(NpcOption.class)).toList();
        NpcOption[] values = new NpcOption[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            try {
                values[i] = (NpcOption)fields.get(i).get(null);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return values;
    }

    @NotNull
    public static Optional<NpcOption<?, ?>> getOption(@NotNull String path) {
        return Arrays.stream(NpcOption.values()).filter(npcOption -> npcOption.getPath().equals(path)).findFirst();
    }

    @NotNull
    public NpcOption<T, S> since(@NotNull Versions since) {
        this.since = since;
        return this;
    }

    @NotNull
    public NpcOption<T, S> loadBefore(boolean loadBefore) {
        this.loadBefore = loadBefore;
        return this;
    }

    public boolean loadBefore() {
        return this.loadBefore;
    }

    public boolean isCompatible() {
        return !Versions.isCurrentVersionSmallerThan(this.since);
    }

    public Versions since() {
        return this.since;
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public S serialize(@Nullable Object var1) {
        try {
            return (S)((Serializable)this.serializer.apply(var1));
        }
        catch (ClassCastException e) {
            throw new RuntimeException(this.path + " -> " + String.valueOf(var1));
        }
    }

    @Nullable
    public T deserialize(@Nullable S var1) {
        return this.deserializer.apply(var1);
    }

    @NotNull
    public Optional<Object> getPacket(@Nullable Object object, @NotNull NPC npc, Player player) {
        if (this.packet == null || !this.isCompatible()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.packet.apply(object, npc, player));
    }
}

