/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.pathfinding;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Path
implements ConfigurationSerializable {
    private final List<Vector> vectors;
    private final List<Location> locations;
    private final List<Location> waypoints;
    private String name;

    public Path(@NotNull List<Location> nodes, @Nullable List<Location> waypoints) {
        this.locations = Collections.unmodifiableList(nodes);
        this.vectors = nodes.stream().map(Location::toVector).toList();
        this.waypoints = waypoints == null ? null : Collections.unmodifiableList(waypoints);
    }

    public Path(@NotNull List<Vector> nodes, @NotNull World world, @Nullable List<Location> waypoints) {
        this.vectors = Collections.unmodifiableList(nodes);
        this.locations = nodes.stream().map(vector -> new Location(world, vector.getX(), vector.getY(), vector.getZ())).toList();
        this.waypoints = waypoints == null ? null : Collections.unmodifiableList(waypoints);
    }

    @NotNull
    public Path setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public static Path deserialize(Map<String, Object> map) {
        return new Path((List)map.get("locations"), (List)map.get("waypoints"));
    }

    public List<Location> asLocations() {
        return this.locations;
    }

    public List<Vector> asVectors() {
        return this.vectors;
    }

    public String toString() {
        if (this.locations.isEmpty()) {
            return "Empty path";
        }
        Vector start = this.vectors.getFirst();
        Vector end = this.vectors.getLast();
        return String.format("Start: [%.2f, %.2f, %.2f] -> End: [%.2f, %.2f, %.2f]", start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ());
    }

    @NotNull
    public List<Location> getWaypoints() {
        return this.waypoints == null ? new ArrayList() : this.waypoints;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path other = (Path)obj;
        return this.locations.equals(other.locations);
    }

    public int hashCode() {
        return this.locations.hashCode();
    }

    @NotNull
    public Map<String, Object> serialize() {
        return Map.of("locations", new ArrayList<Location>(this.locations), "waypoints", new ArrayList<Location>(this.waypoints));
    }

    public SerializablePath toSerializablePath() {
        return new SerializablePath(this);
    }

    public static class SerializablePath
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<SerializableLocation> locations;
        private final List<SerializableLocation> waypoints;
        private final String name;

        private SerializablePath(@NotNull Path path) {
            this.locations = new ArrayList<SerializableLocation>(path.locations.stream().map(SerializableLocation::new).toList());
            this.waypoints = path.waypoints == null ? null : new ArrayList<SerializableLocation>(path.waypoints.stream().map(SerializableLocation::new).toList());
            this.name = path.getName();
        }

        @NotNull
        public Path toPath() {
            return new Path(this.locations.stream().map(SerializableLocation::toLocation).toList(), this.waypoints == null ? null : this.waypoints.stream().map(SerializableLocation::toLocation).toList()).setName(this.name);
        }

        private static class SerializableLocation
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final double x;
            private final double y;
            private final double z;
            private final float pitch;
            private final float yaw;
            private final UUID world;

            public SerializableLocation(@NotNull Location location) {
                this.x = location.getX();
                this.y = location.getY();
                this.z = location.getZ();
                this.pitch = location.getPitch();
                this.yaw = location.getYaw();
                this.world = location.getWorld().getUID();
            }

            @NotNull
            public Location toLocation() {
                return new Location(Bukkit.getWorld((UUID)this.world), this.x, this.y, this.z, this.yaw, this.pitch);
            }
        }
    }
}

