/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectSaver {
    private final File file;

    public ObjectSaver(@NotNull String file) {
        this(new File(file));
    }

    public ObjectSaver(@NotNull File file) {
        file.getParentFile().mkdirs();
        this.file = file;
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <T extends Serializable> void write(T object) throws IOException {
        this.write(object, true);
    }

    public <T extends Serializable> void write(T object, boolean append) throws IOException {
        FileOutputStream fileOut = new FileOutputStream(this.file, append);
        ObjectOutputStream objectOut = new ObjectOutputStream(fileOut);
        objectOut.writeObject(object);
        objectOut.close();
    }

    public <T extends Serializable> void writeList(@NotNull List<T> object) throws IOException {
        this.writeList(object, true);
    }

    public <T extends Serializable> void writeList(@NotNull List<T> object, boolean append) throws IOException {
        FileOutputStream fileOut = new FileOutputStream(this.file, append);
        ObjectOutputStream objectOut = new ObjectOutputStream(fileOut);
        objectOut.writeObject(object);
        objectOut.close();
    }

    @Nullable
    public <T extends Serializable> T read() {
        try {
            FileInputStream fileIn = new FileInputStream(this.file);
            ObjectInputStream objectOut = new ObjectInputStream(fileIn);
            Object object = objectOut.readObject();
            objectOut.close();
            return (T)((Serializable)object);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public <T extends Serializable> List<T> readList() {
        try {
            FileInputStream fileIn = new FileInputStream(this.file);
            ObjectInputStream objectOut = new ObjectInputStream(fileIn);
            Object object = objectOut.readObject();
            objectOut.close();
            return (List)object;
        }
        catch (Exception var4) {
            return new ArrayList();
        }
    }
}

