/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.objects;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.enums.ClickActionType;
import de.eisi05.npc.api.events.NpcInteractEvent;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.pathfinding.Path;
import de.eisi05.npc.api.pathfinding.PathfindingUtils;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.wrapper.packets.AnimatePacket;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.gui.NpcGUI;
import de.eisi05.npc.plugin.manager.CommandManager;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.manager.PathManager;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import de.eisi05.npc.plugin.utils.Prefix;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.commands.CommandSourceStack;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpcClickActionImpl
implements NpcClickAction {
    private static final long serialVersionUID = 1L;
    private final List<PluginAction<?>> actionListRight = new ArrayList();
    private final List<PluginAction<?>> actionListLeft = new ArrayList();

    public <T extends Serializable> NpcClickActionImpl add(@NotNull ClickActionType clickActionType, @NotNull PluginActionOptions<T> pluginActionOptions, @Nullable T param) {
        PluginAction<T> action = new PluginAction<T>(pluginActionOptions, param);
        if (clickActionType == ClickActionType.BOTH && !this.isBoth()) {
            this.actionListRight.clear();
            this.actionListLeft.clear();
        }
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.add(action);
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.add(action);
        }
        return this;
    }

    @Override
    public NpcClickAction copy() {
        NpcClickActionImpl copy = new NpcClickActionImpl();
        List<PluginAction> copyRight = this.actionListRight.stream().map(pluginAction -> new PluginAction((PluginActionOptions)Var.unsafeCast(pluginAction.option), pluginAction.param)).toList();
        List<PluginAction> copyLeft = this.actionListLeft.stream().map(pluginAction -> new PluginAction((PluginActionOptions)Var.unsafeCast(pluginAction.option), pluginAction.param)).toList();
        copy.actionListRight.addAll(copyRight);
        copy.actionListLeft.addAll(copyLeft);
        return copy;
    }

    public <T extends Serializable> void insert(int index, @NotNull ClickActionType clickActionType, @NotNull PluginActionOptions<T> pluginActionOptions, @Nullable T param) {
        PluginAction<T> action = new PluginAction<T>(pluginActionOptions, param);
        if (clickActionType == ClickActionType.BOTH && !this.isBoth()) {
            this.actionListRight.clear();
            this.actionListLeft.clear();
        }
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.add(index, action);
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.add(index, action);
        }
    }

    public void remove(@NotNull ClickActionType clickActionType, @NotNull PluginAction<? extends Serializable> action) {
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.remove(action);
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.remove(action);
        }
    }

    public void clear(@NotNull ClickActionType clickActionType) {
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.clear();
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.clear();
        }
    }

    @Override
    @NotNull
    public NpcClickActionImpl initialize() {
        new ArrayList(this.actionListRight).forEach((Consumer<PluginAction<?>>)((Consumer<PluginAction>)PluginAction::reload));
        new ArrayList(this.actionListLeft).forEach((Consumer<PluginAction<?>>)((Consumer<PluginAction>)PluginAction::reload));
        return this;
    }

    @NotNull
    public List<PluginAction<?>> getRightActions() {
        return Collections.unmodifiableList(this.actionListRight);
    }

    @NotNull
    public List<PluginAction<?>> getLeftActions() {
        return Collections.unmodifiableList(this.actionListLeft);
    }

    @NotNull
    public List<PluginAction<?>> getActions(@NotNull ClickActionType clickActionType) {
        if (!this.isBoth() && clickActionType == ClickActionType.BOTH) {
            return new ArrayList();
        }
        if (clickActionType == ClickActionType.LEFT) {
            return this.getLeftActions();
        }
        return this.getRightActions();
    }

    public boolean isBoth() {
        return this.actionListRight.equals(this.actionListLeft);
    }

    @Override
    public void call(@NotNull NpcInteractEvent event) {
        if (event.getAction() == ClickActionType.LEFT && this.actionListLeft.isEmpty()) {
            return;
        }
        if (event.getAction() == ClickActionType.RIGHT && this.actionListRight.isEmpty()) {
            return;
        }
        this.call(0, event);
    }

    private void call(int index, @NotNull NpcInteractEvent event) {
        List<PluginAction<?>> listToExecute;
        List<PluginAction<?>> list = listToExecute = event.getAction() == ClickActionType.LEFT ? this.actionListLeft : this.actionListRight;
        if (index >= listToExecute.size()) {
            return;
        }
        PluginAction<?> action = listToExecute.get(index);
        if (action.option.equals(PluginActionOptions.WAIT)) {
            if (action.param instanceof Double) {
                double wait = (Double)action.param;
                Bukkit.getScheduler().runTaskLater((Plugin)NpcPlugin.plugin, () -> this.call(index + 1, event), (long)(wait * 20.0));
            } else {
                NpcPlugin.plugin.getLogger().warning("WAIT action parameter is not a Double for NPC interaction. Skipping WAIT!");
                this.call(index + 1, event);
            }
            return;
        }
        NpcClickAction executable = action.option.function.apply((Serializable)Var.unsafeCast(action.param));
        if (executable != null) {
            executable.call(event);
        }
        this.call(index + 1, event);
    }

    public static class PluginAction<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private PluginActionOptions<T> option;
        private T param;

        public PluginAction(PluginActionOptions<T> option, T param) {
            this.option = option;
            this.param = param;
        }

        private void reload() {
            if (this.option != null) {
                PluginActionOptions reloadedOption = this.option.getOption();
                if (reloadedOption != null) {
                    this.option = reloadedOption;
                } else {
                    NpcPlugin.plugin.getLogger().warning("Failed to reload PluginActionOption for: " + this.option.name + ". It might be missing or renamed.");
                }
            }
        }

        @NotNull
        public Component getTypeName(Player player) {
            return this.option != null ? this.option.getName(player) : LocalizationManager.get(player, "actions.invalid.title", new Object[0]);
        }

        @NotNull
        public Supplier<ItemBuilder> getIcon(Player player) {
            if (this.option == null) {
                return () -> new ItemBuilder(Material.BARRIER).setName(LocalizationManager.get(player, "actions.invalid.title", new Object[0])).setLore(LocalizationManager.getAsList(player, "actions.invalid.description", new Object[0]));
            }
            return () -> this.option.icon.apply(this.param, player).setName(this.getTypeName(player).color((TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false)).hideFlags(true).hideAttributes();
        }

        @NotNull
        public Consumer<InventoryClickEvent> getConsumer(@NotNull NPC npc, @NotNull ClickActionType clickActionType, boolean withTeleport) {
            return inventoryClickEvent -> {
                if (this.option != null) {
                    this.param = (Serializable)this.option.clickAction.apply(this.param, new PluginActionOptions.PluginActionData((InventoryClickEvent)inventoryClickEvent, npc, clickActionType, this, withTeleport));
                }
            };
        }
    }

    public static class PluginActionOptions<T extends Serializable>
    implements Serializable {
        public static final Map<String, PluginActionOptions<?>> OPTIONS_REGISTRY = new HashMap();
        public static final PluginActionOptions<AnimatePacket.Animation> ANIMATION = new PluginActionOptions<AnimatePacket.Animation>("animation", AnimatePacket.Animation.SWING_MAIN_HAND, animation -> event -> event.getNpc().playAnimation(event.getPlayer(), (AnimatePacket.Animation)animation), (animation, player) -> new ItemBuilder(Material.ITEM_FRAME).setLore(Arrays.stream(AnimatePacket.Animation.values()).map(animation1 -> {
            Component animationName = LocalizationManager.get(player, "actions.animation." + animation1.name().replace("_", "-").toLowerCase(), new Object[0]);
            if (animation == animation1) {
                return ((TextComponent)((TextComponent)Component.text((String)"> ").append(animationName)).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false);
            }
            return ((TextComponent)Component.text((String)" ").append(animationName)).color((TextColor)NamedTextColor.GRAY);
        }).toList()), (animation, data) -> {
            AnimatePacket.Animation[] values = AnimatePacket.Animation.values();
            int currentIndex = animation.ordinal();
            AnimatePacket.Animation newAnimation = animation;
            boolean changed = false;
            float pitch = 1.0f;
            if (data.event().getClick().isLeftClick()) {
                newAnimation = values[(currentIndex + 1) % values.length];
                if (newAnimation != animation) {
                    changed = true;
                    pitch = 1.2f;
                }
            } else if (data.event().getClick().isRightClick() && (newAnimation = values[(currentIndex - 1 + values.length) % values.length]) != animation) {
                changed = true;
                pitch = 0.8f;
            }
            if (changed) {
                ItemMeta meta;
                Player p = (Player)data.event.getWhoClicked();
                p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, pitch);
                ArrayList<Component> modifiedLore = new ArrayList<Component>();
                for (AnimatePacket.Animation animation1 : AnimatePacket.Animation.values()) {
                    modifiedLore.add((animation1 == newAnimation ? (TextComponent)Component.text((String)"> ").color((TextColor)NamedTextColor.GOLD) : (TextComponent)Component.text((String)" ").color((TextColor)NamedTextColor.GRAY)).append(LocalizationManager.get((Player)data.event.getWhoClicked(), "actions.animation." + animation1.name().replace("_", "-").toLowerCase(), new Object[0]).color((TextColor)(animation1 == newAnimation ? NamedTextColor.GOLD : NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, animation1 != newAnimation)));
                }
                ItemStack current = data.event().getCurrentItem();
                if (current != null && (meta = current.getItemMeta()) != null) {
                    meta.lore(modifiedLore);
                    current.setItemMeta(meta);
                }
                data.npc().markChange();
            } else if (data.event().getClick().isLeftClick() || data.event().getClick().isRightClick()) {
                Player p = (Player)data.event.getWhoClicked();
                p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 0.7f);
            }
            return newAnimation;
        });
        public static final PluginActionOptions<Double> WAIT = new PluginActionOptions<Double>("wait", 1.0, value -> null, (value, player) -> new ItemBuilder(Material.CLOCK).setLore(LocalizationManager.getAsList(player, "actions.wait.value", value)), (value, data) -> {
            ItemStack currentItem;
            boolean actuallyChanged;
            double originalValue = value;
            double newValue = value;
            double increment = data.event().isShiftClick() ? 1.0 : 0.1;
            Sound soundToPlay = null;
            float pitch = 1.0f;
            float volume = 1.0f;
            if (data.event().getClick().isLeftClick()) {
                if ((newValue += increment) > 600.0) {
                    newValue = 600.0;
                }
            } else if (data.event().getClick().isRightClick()) {
                if ((newValue -= increment) < 0.1) {
                    newValue = 0.1;
                }
            } else if (data.event().getClick() == ClickType.MIDDLE) {
                newValue = 1.0;
            }
            boolean bl = actuallyChanged = Math.abs((newValue = (double)Math.round(newValue * 10.0) / 10.0) - originalValue) > 0.001;
            if (actuallyChanged) {
                soundToPlay = Sound.BLOCK_COMPARATOR_CLICK;
                pitch = newValue > originalValue ? 1.2f : (newValue < originalValue ? 0.8f : 1.0f);
                data.npc().markChange();
            } else if (data.event().getClick().isLeftClick() || data.event().getClick().isRightClick()) {
                soundToPlay = Sound.UI_BUTTON_CLICK;
                pitch = 0.7f;
                volume = 0.8f;
            }
            if (soundToPlay != null) {
                Player p = (Player)data.event.getWhoClicked();
                p.playSound(p.getLocation(), soundToPlay, volume, pitch);
            }
            if ((currentItem = data.event().getCurrentItem()) != null && currentItem.hasItemMeta()) {
                ItemMeta meta = currentItem.getItemMeta();
                ArrayList<Component> lore = new ArrayList<Component>(LocalizationManager.getAsList((Player)data.event.getWhoClicked(), "actions.wait.value", newValue));
                meta.lore(lore);
                currentItem.setItemMeta(meta);
            }
            return newValue;
        });
        private static final long serialVersionUID = 1L;
        @NotNull
        public final String name;
        @Nullable
        public final T defaultValue;
        @NotNull
        private final transient BiFunction<T, PluginActionData, T> clickAction;
        @NotNull
        private final transient Function<T, NpcClickAction> function;
        @NotNull
        private final transient BiFunction<T, Player, ItemBuilder> icon;
        public static final PluginActionOptions<String> COMMAND = new PluginActionOptions<String>("command", null, s -> event -> {
            block7: {
                if (s == null || s.isBlank()) {
                    return;
                }
                String commandToExecute = s.startsWith("/") ? s.substring(1) : s;
                try {
                    CommandSourceStack commandSourceStack = ((CraftPlayer)event.getPlayer()).getHandle().createCommandSourceStack().withMaximumPermission(4).withSuppressedOutput();
                    CommandManager.DISPATCHER.execute(commandToExecute, (Object)commandSourceStack);
                }
                catch (CommandSyntaxException e) {
                    try {
                        Bukkit.dispatchCommand((CommandSender)event.getPlayer(), (String)commandToExecute);
                    }
                    catch (CommandException ex) {
                        if (event.getPlayer().hasPermission("npc.admin")) {
                            LocalizedMessage.sendMessage(event.getPlayer(), "actions.command.error.known", true, e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    NpcPlugin.plugin.getLogger().warning("Error executing NPC command: " + s + " for player " + event.getPlayer().getName() + " - " + e.getMessage());
                    if (!event.getPlayer().hasPermission("npc.admin")) break block7;
                    LocalizedMessage.sendMessage(event.getPlayer(), "actions.command.error.unknown", true, new Object[0]);
                }
            }
        }, (s, player) -> new ItemBuilder(Material.COMMAND_BLOCK).setLore(s == null || s.isEmpty() ? LocalizationManager.get(player, "actions.command.value.short", LocalizationManager.get(player, "misc.not-set", new Object[0])) : LocalizationManager.get(player, "actions.command.value." + (s.length() > 23 ? "long" : "short"), s.length() > 23 ? s.substring(0, 20) : s)), (currentCommand, data) -> {
            Player player = (Player)data.event.getWhoClicked();
            player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
            data.event().getWhoClicked().closeInventory();
            ConversationManager conversation = new ConversationManager((Plugin)NpcPlugin.plugin).withEscapeSequence(LocalizationManager.getAsString(player, "actions.command.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(event -> {
                Player p = event.player();
                if (!event.gracefulExit()) {
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    if ("timeout".equals(event.reason())) {
                        LocalizedMessage.sendMessage(p, "actions.command.input.timeout", true, NpcApi.config.inputTime());
                    } else {
                        LocalizedMessage.sendMessage(p, "actions.command.input.cancelled", true, new Object[0]);
                    }
                }
                Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> p.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), p, data.withTeleport())));
            });
            ConversationManager.Prompt commandPrompt = new ConversationManager.Prompt((PluginActionData)data){
                final /* synthetic */ PluginActionData val$data;
                {
                    this.val$data = pluginActionData;
                }

                @Override
                public Component getPromptText(Player p) {
                    return Prefix.PREFIX.append(LocalizationManager.get(p, "actions.command.input.prompt", new Object[0]));
                }

                @Override
                public ConversationManager.Prompt onInput(Player p, String input) {
                    CommandSourceStack commandSourceStack;
                    if (input == null || input.trim().isEmpty()) {
                        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(p, "actions.command.input.empty", true, new Object[0]);
                        return this;
                    }
                    String processedInput = input.startsWith("/") ? input.substring(1) : input;
                    ParseResults results = CommandManager.DISPATCHER.parse(processedInput, (Object)(commandSourceStack = ((CraftPlayer)p).getHandle().createCommandSourceStack()));
                    if (!results.getExceptions().isEmpty()) {
                        for (CommandSyntaxException e : results.getExceptions().values()) {
                            LocalizedMessage.sendMessage(p, "actions.command.error.syntax", true, e.getMessage());
                        }
                        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        return this;
                    }
                    if (results.getReader().canRead() && !NpcApi.config.avoidCommandCheck()) {
                        LocalizedMessage.sendMessage(p, "actions.command.error.arguments", true, results.getReader().getRemaining());
                        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        return this;
                    }
                    this.val$data.actionInstance().param = (Serializable)Var.unsafeCast("/" + processedInput);
                    this.val$data.npc().markChange();
                    p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                    LocalizedMessage.sendMessage(p, "actions.command.set", true, "/" + processedInput);
                    return null;
                }
            };
            conversation.startConversation(player, commandPrompt);
            return currentCommand;
        });
        public static final PluginActionOptions<String> SERVER = new PluginActionOptions<String>("server", null, s -> e -> {
            if (s == null || s.isBlank()) {
                return;
            }
            try {
                ByteArrayOutputStream bb = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(bb);
                out.writeUTF("Connect");
                out.writeUTF((String)s);
                e.getPlayer().sendPluginMessage((Plugin)NpcPlugin.plugin, "BungeeCord", bb.toByteArray());
                LocalizedMessage.sendMessage(e.getPlayer(), "actions.server.connecting", true, s);
            }
            catch (Exception ex) {
                LocalizedMessage.sendMessage(e.getPlayer(), "actions.server.failed", true, s);
                NpcPlugin.plugin.getLogger().severe("BungeeCord Connect Error: " + ex.getMessage());
            }
        }, (s, player) -> new ItemBuilder(Material.ENDER_PEARL).addLore(s == null || s.isEmpty() ? LocalizationManager.get(player, "actions.server.value", LocalizationManager.get(player, "misc.not-set", new Object[0])) : LocalizationManager.get(player, "actions.server.value", s)), (currentServer, data) -> {
            Player player = (Player)data.event.getWhoClicked();
            player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
            data.event().getWhoClicked().closeInventory();
            ConversationManager conversation = new ConversationManager((Plugin)NpcPlugin.plugin).withEscapeSequence(LocalizationManager.getAsString(player, "actions.server.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(event -> {
                Player p = event.player();
                if (!event.gracefulExit()) {
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    if ("timeout".equals(event.reason())) {
                        LocalizedMessage.sendMessage(p, "actions.server.input.timeout", true, NpcApi.config.inputTime());
                    } else {
                        LocalizedMessage.sendMessage(p, "actions.server.input.cancelled", true, new Object[0]);
                    }
                }
                Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> p.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), p, data.withTeleport())));
            });
            ConversationManager.Prompt serverPrompt = new ConversationManager.Prompt((PluginActionData)data){
                final /* synthetic */ PluginActionData val$data;
                {
                    this.val$data = pluginActionData;
                }

                @Override
                public Component getPromptText(Player p) {
                    return Prefix.PREFIX.append(LocalizationManager.get(p, "actions.server.input.prompt", new Object[0]));
                }

                @Override
                public ConversationManager.Prompt onInput(Player p, String input) {
                    if (input == null || input.trim().isEmpty()) {
                        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(p, "actions.server.input.empty", true, new Object[0]);
                        return this;
                    }
                    this.val$data.actionInstance().param = (Serializable)Var.unsafeCast(input);
                    this.val$data.npc().markChange();
                    p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                    LocalizedMessage.sendMessage(p, "actions.server.set", true, input);
                    return null;
                }
            };
            conversation.startConversation(player, serverPrompt);
            return currentServer;
        });
        public static final PluginActionOptions<Pair<Path.SerializablePath, Float>> PATH = new PluginActionOptions<Pair>("path", null, pair -> e -> {
            if (pair == null || pair.getKey() == null) {
                return;
            }
            e.getNpc().walkTo(((Path.SerializablePath)pair.getKey()).toPath(), e.getPlayer(), pair.getRight() == null ? 0.25 : (double)((Float)pair.getRight()).floatValue(), false, null);
        }, (pair, player) -> new ItemBuilder(Material.DIRT_PATH).addLore(pair != null && pair.getKey() != null && ((Path.SerializablePath)pair.getKey()).toPath().getName() != null ? LocalizationManager.get(player, "actions.path.value.name", ((Path.SerializablePath)pair.getKey()).toPath().getName()) : LocalizationManager.get(player, "actions.path.value.name", LocalizationManager.get(player, "misc.not-set", new Object[0]))).addLore(pair != null && pair.getRight() != null ? LocalizationManager.get(player, "actions.path.value.speed", ((Float)pair.getRight()).toString()) : LocalizationManager.get(player, "actions.path.value.speed", LocalizationManager.get(player, "misc.not-set", new Object[0]))), (currentPair, data) -> {
            final Path currentPath = currentPair == null ? null : ((Path.SerializablePath)currentPair.getKey()).toPath();
            Player player = (Player)data.event.getWhoClicked();
            player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
            data.event().getWhoClicked().closeInventory();
            ConversationManager conversation = new ConversationManager((Plugin)NpcPlugin.plugin).withEscapeSequence(LocalizationManager.getAsString(player, "actions.path.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(event -> {
                Player p = event.player();
                if (!event.gracefulExit()) {
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    if ("timeout".equals(event.reason())) {
                        LocalizedMessage.sendMessage(p, "actions.path.input.timeout", true, NpcApi.config.inputTime());
                    } else {
                        LocalizedMessage.sendMessage(p, "actions.path.input.cancelled", true, new Object[0]);
                    }
                }
                Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> p.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), p, data.withTeleport())));
            });
            ConversationManager.Prompt firstPrompt = new ConversationManager.Prompt(){
                final /* synthetic */ PluginActionData val$data;
                final /* synthetic */ Pair val$currentPair;
                {
                    this.val$data = pluginActionData;
                    this.val$currentPair = pair;
                }

                @Override
                public Component getPromptText(Player p) {
                    TextComponent finalComponent = Component.empty();
                    if (currentPath != null && currentPath.getName() != null && !currentPath.asLocations().isEmpty()) {
                        finalComponent = LocalizationManager.get(p, "actions.path.input.edit.text.1", new Object[0]).color((TextColor)NamedTextColor.GREEN).decorate(TextDecoration.ITALIC).clickEvent(ClickEvent.suggestCommand((String)currentPath.getName())).hoverEvent((HoverEventSource)HoverEvent.showText((Component)LocalizationManager.get(p, "actions.path.input.edit.hover.1", new Object[0]).color((TextColor)NamedTextColor.GRAY).decorate(TextDecoration.ITALIC)));
                    }
                    return Prefix.PREFIX.append(LocalizationManager.get(p, "actions.path.input.prompt.1", new Object[0])).appendNewline().append((Component)finalComponent);
                }

                @Override
                public ConversationManager.Prompt onInput(final Player p, final String input) {
                    if (input == null || input.trim().isEmpty()) {
                        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(p, "actions.path.input.empty.1", true, new Object[0]);
                        return this;
                    }
                    Optional<Path> newPathOpt = PathManager.getInstance(p).getPath(input);
                    if (newPathOpt.isEmpty()) {
                        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(p, "command.path.not-exists", true, input);
                        return this;
                    }
                    final Path newPath = newPathOpt.get();
                    if (!newPath.asLocations().getFirst().getWorld().equals((Object)this.val$data.npc.getLocation().getWorld())) {
                        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(p, "actions.path.other-world", true, new Object[0]);
                        return this;
                    }
                    return new ConversationManager.Prompt(){

                        @Override
                        public Component getPromptText(Player p2) {
                            TextComponent finalComponent = Component.empty();
                            if (val$currentPair != null && val$currentPair.getRight() != null && ((Float)val$currentPair.getRight()).floatValue() >= 0.1f) {
                                finalComponent = LocalizationManager.get(p2, "actions.path.input.edit.text.2", new Object[0]).color((TextColor)NamedTextColor.GREEN).decorate(TextDecoration.ITALIC).clickEvent(ClickEvent.suggestCommand((String)String.valueOf(val$currentPair.getRight()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)LocalizationManager.get(p2, "actions.path.input.edit.hover.2", new Object[0]).color((TextColor)NamedTextColor.GRAY).decorate(TextDecoration.ITALIC)));
                            }
                            return Prefix.PREFIX.append(LocalizationManager.get(p, "actions.path.input.prompt.2", new Object[0])).appendNewline().append((Component)finalComponent);
                        }

                        @Override
                        public ConversationManager.Prompt onInput(Player p2, String input2) {
                            float speed;
                            if (input2 == null || input2.trim().isEmpty()) {
                                p2.playSound(p2.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                                LocalizedMessage.sendMessage(p2, "actions.path.input.empty.2", true, new Object[0]);
                                return this;
                            }
                            try {
                                speed = Float.parseFloat(input2);
                                if (speed < 0.1f || speed > 1.0f) {
                                    p2.playSound(p2.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                                    LocalizedMessage.sendMessage(p2, "actions.path.input.speed.invalid", true, new Object[0]);
                                    return this;
                                }
                            }
                            catch (NumberFormatException e) {
                                p2.playSound(p2.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                                LocalizedMessage.sendMessage(p2, "actions.path.input.speed.invalid", true, new Object[0]);
                                return this;
                            }
                            LocalizedMessage.sendMessage(p2, "actions.path.creating", true, input);
                            ((CompletableFuture)PathfindingUtils.findPathAsync(List.of(val$data.npc.getLocation().clone().subtract(0.0, 1.0, 0.0), newPath.asLocations().getFirst().clone().subtract(0.0, 1.0, 0.0)), 10000, true, null).thenAccept(path -> {
                                Path finalPath = new Path(Stream.concat(path.asLocations().stream(), newPath.asLocations().stream()).toList(), null);
                                finalPath.setName(input);
                                data.actionInstance().param = (Serializable)Var.unsafeCast(new MutablePair((Object)finalPath.toSerializablePath(), (Object)Float.valueOf(speed)));
                                val$data.npc().markChange();
                                p2.playSound(p2.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                                LocalizedMessage.sendMessage(p2, "actions.path.set", true, input, input2);
                            })).exceptionally(t -> {
                                t.printStackTrace();
                                LocalizedMessage.sendMessage(p2, "actions.path.failed", true, input);
                                return null;
                            });
                            return null;
                        }
                    };
                }
            };
            conversation.startConversation(player, firstPrompt);
            return currentPair;
        });

        private PluginActionOptions(@NotNull String name, @Nullable T defaultValue, @NotNull Function<T, NpcClickAction> function, @NotNull BiFunction<T, Player, ItemBuilder> icon, @NotNull BiFunction<T, PluginActionData, T> clickAction) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.function = function;
            this.icon = icon;
            this.clickAction = clickAction;
            OPTIONS_REGISTRY.put(name, this);
        }

        @Nullable
        public static PluginActionOptions<?> getFromMaterial(@NotNull Material material) {
            return OPTIONS_REGISTRY.values().stream().filter(option -> option.icon.apply(null, null).build().getType() == material).findFirst().orElse(null);
        }

        @NotNull
        public ItemBuilder getDefaultItem(Player player) {
            return this.icon.apply(this.defaultValue, player).setName(this.getName(player).decoration(TextDecoration.ITALIC, false)).setClickHandler(null).setLore(new ArrayList<Component>());
        }

        public Component getName(Player player) {
            return LocalizationManager.get(player, "actions." + this.name + ".title", new Object[0]);
        }

        private <V extends Serializable> PluginActionOptions<V> getOption() {
            PluginActionOptions<?> registeredOption = OPTIONS_REGISTRY.get(this.name);
            if (registeredOption != null && registeredOption.getClass() == this.getClass()) {
                return registeredOption;
            }
            NpcPlugin.plugin.getLogger().severe("Failed to get canonical option for: " + this.name + ". It may have been removed or renamed.");
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PluginActionOptions)) {
                return false;
            }
            PluginActionOptions that = (PluginActionOptions)obj;
            return this.name.equals(that.name);
        }

        @Nullable
        public T getDefaultValue() {
            return this.defaultValue;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        private record PluginActionData(@NotNull InventoryClickEvent event, @NotNull NPC npc, @NotNull ClickActionType clickActionType, @NotNull PluginAction<?> actionInstance, boolean withTeleport) {
        }
    }
}

