/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.dialogMenu;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.eisi05.dialogMenu.TriConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.api.dialog.DialogBase;
import net.md_5.bungee.api.dialog.MultiActionDialog;
import net.md_5.bungee.api.dialog.action.Action;
import net.md_5.bungee.api.dialog.action.ActionButton;
import net.md_5.bungee.api.dialog.action.CustomClickAction;
import net.md_5.bungee.api.dialog.body.PlainMessageBody;
import net.md_5.bungee.api.dialog.input.NumberRangeInput;
import net.md_5.bungee.api.dialog.input.TextInput;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCustomClickEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogMenu
implements Listener {
    private static final Map<UUID, Consumer<Player>> exitActions = new HashMap<UUID, Consumer<Player>>();
    private static final Map<UUID, BiConsumer<Player, String>> doneActions = new HashMap<UUID, BiConsumer<Player, String>>();
    private static boolean registered = false;

    public static void skin(@NotNull Player player, Plugin plugin, @NotNull Consumer<Player> exitAction, @NotNull BiConsumer<Player, String> doneAction, @NotNull String prompt, @NotNull String ok, @NotNull String back, @NotNull String title) {
        if (!registered && plugin != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new DialogMenu(), plugin);
            registered = true;
        }
        DialogBase dialogBase = new DialogBase(TextComponent.fromLegacy((String)title));
        PlainMessageBody body = new PlainMessageBody(TextComponent.fromLegacy((String)prompt));
        TextInput textInput = new TextInput("input", Integer.valueOf(300), (BaseComponent)new TextComponent(), Boolean.valueOf(true), null, Integer.valueOf(10000), new TextInput.Multiline(Integer.valueOf(10000), Integer.valueOf(100)));
        JsonObject localization = new JsonObject();
        localization.addProperty("prompt", prompt);
        localization.addProperty("ok", ok);
        localization.addProperty("back", back);
        localization.addProperty("title", title);
        MultiActionDialog dialog = new MultiActionDialog(dialogBase.body(List.of(body)).inputs(List.of(textInput)), new ActionButton[]{new ActionButton(TextComponent.fromLegacy((String)ok), (Action)new CustomClickAction("skin-ok").additions((JsonElement)localization))}).columns(Integer.valueOf(2)).exitAction(new ActionButton(TextComponent.fromLegacy((String)back), (Action)new CustomClickAction("skin-exit").additions((JsonElement)localization)));
        exitActions.put(player.getUniqueId(), exitAction);
        doneActions.put(player.getUniqueId(), doneAction);
        player.showDialog((Dialog)dialog);
    }

    public static void name(@NotNull Player player, Plugin plugin, final @Nullable String originalName, @Nullable String name, @NotNull Consumer<Player> exitAction, @NotNull BiConsumer<Player, String> doneAction, @NotNull String prompt, final @NotNull String insertPrev, final @NotNull String ok, @NotNull String back, @NotNull String title) {
        if (!registered && plugin != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new DialogMenu(), plugin);
            registered = true;
        }
        DialogBase dialogBase = new DialogBase(TextComponent.fromLegacy((String)title));
        PlainMessageBody body = new PlainMessageBody(TextComponent.fromLegacy((String)prompt));
        TextInput textInput = new TextInput("input", Integer.valueOf(300), (BaseComponent)new TextComponent(), Boolean.valueOf(true), name, Integer.valueOf(10000), new TextInput.Multiline(Integer.valueOf(10000), Integer.valueOf(100)));
        final JsonObject localization = new JsonObject();
        localization.addProperty("prompt", prompt);
        localization.addProperty("insert-prev", insertPrev);
        localization.addProperty("ok", ok);
        localization.addProperty("back", back);
        localization.addProperty("title", title);
        ArrayList<ActionButton> list = new ArrayList<ActionButton>(){
            {
                if (originalName != null && !originalName.trim().isEmpty()) {
                    JsonObject object = new JsonObject();
                    object.addProperty("original", originalName.replace("\u00a7", "&"));
                    this.add(new ActionButton(TextComponent.fromLegacy((String)insertPrev), (Action)new CustomClickAction("name-insert").additions((JsonElement)object).additions((JsonElement)localization)));
                }
                this.add(new ActionButton(TextComponent.fromLegacy((String)ok), (Action)new CustomClickAction("name-ok").additions((JsonElement)localization)));
            }
        };
        MultiActionDialog dialog = new MultiActionDialog(dialogBase.body(List.of(body)).inputs(List.of(textInput)), (List)list, Integer.valueOf(2), new ActionButton(TextComponent.fromLegacy((String)back), (Action)new CustomClickAction("name-exit").additions((JsonElement)localization)));
        exitActions.put(player.getUniqueId(), exitAction);
        doneActions.put(player.getUniqueId(), doneAction);
        player.showDialog((Dialog)dialog);
    }

    public static void command(@NotNull Player player, Plugin plugin, final @NotNull String originalCommand, @Nullable String command, @NotNull Consumer<Player> exitAction, @NotNull BiConsumer<Player, String> doneAction, @NotNull String prompt, final @NotNull String insertPrev, final @NotNull String ok, @NotNull String back, @NotNull String title) {
        if (!registered && plugin != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new DialogMenu(), plugin);
            registered = true;
        }
        DialogBase dialogBase = new DialogBase(TextComponent.fromLegacy((String)title));
        PlainMessageBody body = new PlainMessageBody(TextComponent.fromLegacy((String)prompt));
        TextInput textInput = new TextInput("input", Integer.valueOf(300), (BaseComponent)new TextComponent(), Boolean.valueOf(true), command, Integer.valueOf(10000), new TextInput.Multiline(Integer.valueOf(10000), Integer.valueOf(100)));
        final JsonObject localization = new JsonObject();
        localization.addProperty("prompt", prompt);
        localization.addProperty("insert-prev", insertPrev);
        localization.addProperty("ok", ok);
        localization.addProperty("back", back);
        localization.addProperty("title", title);
        ArrayList<ActionButton> list = new ArrayList<ActionButton>(){
            {
                if (originalCommand != null && !originalCommand.trim().isEmpty()) {
                    JsonObject object = new JsonObject();
                    object.addProperty("original", originalCommand.replace("\u00a7", "&"));
                    this.add(new ActionButton(TextComponent.fromLegacy((String)insertPrev), (Action)new CustomClickAction("command-insert").additions((JsonElement)object).additions((JsonElement)localization)));
                }
                this.add(new ActionButton(TextComponent.fromLegacy((String)ok), (Action)new CustomClickAction("command-ok").additions((JsonElement)localization)));
            }
        };
        MultiActionDialog dialog = new MultiActionDialog(dialogBase.body(List.of(body)).inputs(List.of(textInput)), (List)list, Integer.valueOf(2), new ActionButton(TextComponent.fromLegacy((String)back), (Action)new CustomClickAction("command-exit").additions((JsonElement)localization)));
        exitActions.put(player.getUniqueId(), exitAction);
        doneActions.put(player.getUniqueId(), doneAction);
        player.showDialog((Dialog)dialog);
    }

    public static void server(@NotNull Player player, Plugin plugin, final @NotNull String originalServer, @Nullable String server, @NotNull Consumer<Player> exitAction, @NotNull BiConsumer<Player, String> doneAction, @NotNull String prompt, final @NotNull String insertPrev, final @NotNull String ok, @NotNull String back, @NotNull String title) {
        if (!registered && plugin != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new DialogMenu(), plugin);
            registered = true;
        }
        DialogBase dialogBase = new DialogBase(TextComponent.fromLegacy((String)title));
        PlainMessageBody body = new PlainMessageBody(TextComponent.fromLegacy((String)prompt));
        TextInput textInput = new TextInput("input", Integer.valueOf(300), (BaseComponent)new TextComponent(), Boolean.valueOf(true), server, Integer.valueOf(10000), new TextInput.Multiline(Integer.valueOf(10000), Integer.valueOf(100)));
        final JsonObject localization = new JsonObject();
        localization.addProperty("prompt", prompt);
        localization.addProperty("insert-prev", insertPrev);
        localization.addProperty("ok", ok);
        localization.addProperty("back", back);
        localization.addProperty("title", title);
        ArrayList<ActionButton> list = new ArrayList<ActionButton>(){
            {
                if (originalServer != null && !originalServer.trim().isEmpty()) {
                    JsonObject object = new JsonObject();
                    object.addProperty("original", originalServer.replace("\u00a7", "&"));
                    this.add(new ActionButton(TextComponent.fromLegacy((String)insertPrev), (Action)new CustomClickAction("server-insert").additions((JsonElement)object).additions((JsonElement)localization)));
                }
                this.add(new ActionButton(TextComponent.fromLegacy((String)ok), (Action)new CustomClickAction("server-ok").additions((JsonElement)localization)));
            }
        };
        MultiActionDialog dialog = new MultiActionDialog(dialogBase.body(List.of(body)).inputs(List.of(textInput)), (List)list, Integer.valueOf(2), new ActionButton(TextComponent.fromLegacy((String)back), (Action)new CustomClickAction("server-exit").additions((JsonElement)localization)));
        exitActions.put(player.getUniqueId(), exitAction);
        doneActions.put(player.getUniqueId(), doneAction);
        player.showDialog((Dialog)dialog);
    }

    public static void path(@NotNull Player player, Plugin plugin, final @NotNull String originalPath, @Nullable String path, float walkSpeed, @NotNull Consumer<Player> exitAction, @NotNull TriConsumer<Player, String, Float> doneAction, @NotNull String prompt, final @NotNull String insertPrev, final @NotNull String ok, @NotNull String back, @NotNull String title) {
        if (!registered && plugin != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new DialogMenu(), plugin);
            registered = true;
        }
        DialogBase dialogBase = new DialogBase(TextComponent.fromLegacy((String)title));
        PlainMessageBody body = new PlainMessageBody(TextComponent.fromLegacy((String)prompt));
        TextInput textInput = new TextInput("input", Integer.valueOf(300), (BaseComponent)new TextComponent(), Boolean.valueOf(true), path, Integer.valueOf(100), new TextInput.Multiline().maxLines(Integer.valueOf(1)));
        final JsonObject localization = new JsonObject();
        localization.addProperty("prompt", prompt);
        localization.addProperty("insert-prev", insertPrev);
        localization.addProperty("ok", ok);
        localization.addProperty("back", back);
        localization.addProperty("title", title);
        NumberRangeInput numberRangeInput = new NumberRangeInput("number", TextComponent.fromLegacy((String)"Walk speed"), 1.0f, 100.0f, Float.valueOf(1.0f), Float.valueOf(walkSpeed)).width(Integer.valueOf(300));
        ArrayList<ActionButton> list = new ArrayList<ActionButton>(){
            {
                if (originalPath != null && !originalPath.trim().isEmpty()) {
                    JsonObject object = new JsonObject();
                    object.addProperty("original", originalPath);
                    this.add(new ActionButton(TextComponent.fromLegacy((String)insertPrev), (Action)new CustomClickAction("path-insert").additions((JsonElement)object).additions((JsonElement)localization)));
                }
                this.add(new ActionButton(TextComponent.fromLegacy((String)ok), (Action)new CustomClickAction("path-ok").additions((JsonElement)localization)));
            }
        };
        MultiActionDialog dialog = new MultiActionDialog(dialogBase.body(List.of(body)).inputs(List.of(textInput, numberRangeInput)), (List)list, Integer.valueOf(2), new ActionButton(TextComponent.fromLegacy((String)back), (Action)new CustomClickAction("path-exit").additions((JsonElement)localization)));
        exitActions.put(player.getUniqueId(), exitAction);
        doneActions.put(player.getUniqueId(), doneAction);
        player.showDialog((Dialog)dialog);
    }

    @EventHandler
    public void onCustomClick(PlayerCustomClickEvent event) {
        Consumer<Player> exitAction = exitActions.get(event.getPlayer().getUniqueId());
        BiConsumer<Player, String> doneAction = doneActions.get(event.getPlayer().getUniqueId());
        JsonObject element = event.getData().getAsJsonObject();
        switch (event.getId().getKey().toLowerCase()) {
            case "name-insert": {
                String original = element.get("original").getAsString();
                String prompt = element.get("prompt").getAsString();
                String insertPrev = element.get("insert-prev").getAsString();
                String ok = element.get("ok").getAsString();
                String back = element.get("back").getAsString();
                String title = element.get("title").getAsString();
                DialogMenu.name(event.getPlayer(), null, original, original, exitAction, doneAction, prompt, insertPrev, ok, back, title);
                break;
            }
            case "command-insert": {
                String original = element.get("original").getAsString();
                String prompt = element.get("prompt").getAsString();
                String insertPrev = element.get("insert-prev").getAsString();
                String ok = element.get("ok").getAsString();
                String back = element.get("back").getAsString();
                String title = element.get("title").getAsString();
                DialogMenu.command(event.getPlayer(), null, original, original, exitAction, doneAction, prompt, insertPrev, ok, back, title);
                break;
            }
            case "server-insert": {
                String original = element.get("original").getAsString();
                String prompt = element.get("prompt").getAsString();
                String insertPrev = element.get("insert-prev").getAsString();
                String ok = element.get("ok").getAsString();
                String back = element.get("back").getAsString();
                String title = element.get("title").getAsString();
                DialogMenu.server(event.getPlayer(), null, original, original, exitAction, doneAction, prompt, insertPrev, ok, back, title);
                break;
            }
            case "name-ok": 
            case "skin-ok": 
            case "command-ok": 
            case "server-ok": {
                doneAction.accept(event.getPlayer(), event.getData().getAsJsonObject().get("input").getAsString());
                break;
            }
            case "path-ok": {
                if (!(doneAction instanceof TriConsumer)) {
                    return;
                }
                TriConsumer triConsumer = (TriConsumer)doneAction;
                triConsumer.accept(event.getPlayer(), event.getData().getAsJsonObject().get("input").getAsString(), Float.valueOf(event.getData().getAsJsonObject().get("number").getAsFloat() / 100.0f));
                break;
            }
            case "name-exit": 
            case "skin-exit": 
            case "command-exit": 
            case "server-exit": 
            case "path-exit": {
                exitAction.accept(event.getPlayer());
            }
        }
    }
}

