/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import de.eisi05.npc.api.utils.SerializableFunction;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpcName
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final WrappedComponent.SerializedComponent nameComponentSerialized;
    private final SerializableFunction<Player, WrappedComponent.SerializedComponent> nameFunctionSerialized;
    private final transient WrappedComponent nameComponent;
    private final transient SerializableFunction<Player, WrappedComponent> nameFunction;

    private NpcName(@NotNull WrappedComponent nameComponent) {
        this.nameComponent = nameComponent;
        this.nameFunction = null;
        this.nameComponentSerialized = nameComponent.serialize();
        this.nameFunctionSerialized = null;
    }

    private NpcName(@NotNull SerializableFunction<Player, WrappedComponent> nameFunction, @NotNull WrappedComponent fallback) {
        this.nameComponent = fallback;
        this.nameFunction = nameFunction;
        this.nameComponentSerialized = fallback.serialize();
        this.nameFunctionSerialized = player -> ((WrappedComponent)nameFunction.apply((Player)player)).serialize();
    }

    @NotNull
    public static NpcName of(@NotNull WrappedComponent name) {
        return new NpcName(name);
    }

    @NotNull
    public static NpcName ofLegacy(@NotNull String name) {
        return new NpcName(WrappedComponent.parseFromLegacy(name));
    }

    @NotNull
    public static NpcName of(@NotNull SerializableFunction<Player, WrappedComponent> nameFunction, @NotNull WrappedComponent fallback) {
        return new NpcName(nameFunction, fallback);
    }

    @NotNull
    public static NpcName empty() {
        return NpcName.of(WrappedComponent.create(null));
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.nameFunctionSerialized == null) {
            return new NpcName(this.nameComponentSerialized.deserialize());
        }
        return new NpcName(player -> ((WrappedComponent.SerializedComponent)this.nameFunctionSerialized.apply((Player)player)).deserialize(), this.nameComponentSerialized.deserialize());
    }

    public boolean isStatic() {
        return this.nameFunction == null;
    }

    @Nullable
    public WrappedComponent getName() {
        return this.nameComponent;
    }

    @Nullable
    public WrappedComponent getName(@Nullable Player player) {
        if (this.nameFunction == null || player == null) {
            return this.nameComponent;
        }
        return (WrappedComponent)this.nameFunction.apply(player);
    }

    @NotNull
    public NpcName copy() {
        return this.isStatic() ? new NpcName(this.nameComponent) : new NpcName(this.nameFunction, this.nameComponent);
    }

    public String toString() {
        return "{" + (this.isStatic() ? "static" : "dynamic") + " -> " + this.getName().toLegacy(false) + "}";
    }
}

