/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.manager;

import com.mojang.datafixers.util.Either;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.utils.ObjectSaver;
import java.io.File;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class NpcManager {
    private static final Map<UUID, List<NPC.SerializedNPC>> toLoadNPCs = new HashMap<UUID, List<NPC.SerializedNPC>>();
    public static Map<String, Exception> loadExceptions = new HashMap<String, Exception>();
    private static final List<NPC> listNPC = new ArrayList<NPC>();

    public static void addNPC(@NotNull NPC npc) {
        listNPC.add(npc);
    }

    @NotNull
    public static List<NPC> getList() {
        return listNPC;
    }

    public static void removeNPC(@NotNull NPC npc) {
        listNPC.remove(npc);
    }

    public static void clear() {
        listNPC.clear();
    }

    @NotNull
    public static Optional<NPC> fromUUID(@NotNull UUID uuid) {
        return listNPC.stream().filter(npc -> npc.getUUID().equals(uuid)).findFirst();
    }

    public static void loadNPCs() {
        File file = new File(NpcApi.plugin.getDataFolder(), "NPC");
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        long failCounter = 0L;
        long successCounter = 0L;
        Exception exception = null;
        for (File file1 : files) {
            if (!file1.getName().endsWith(".npc")) continue;
            try {
                NPC.SerializedNPC serializedNPC = (NPC.SerializedNPC)new ObjectSaver(file1).read();
                Either<NPC, UUID> npcEither = serializedNPC.deserializedNPC();
                if (npcEither.right().isPresent()) {
                    toLoadNPCs.computeIfAbsent((UUID)npcEither.right().get(), k -> new ArrayList()).add(serializedNPC);
                    return;
                }
                if (npcEither.left().isEmpty()) {
                    return;
                }
                NpcManager.loadNpc((NPC)npcEither.left().get());
                ++successCounter;
            }
            catch (Exception e) {
                ++failCounter;
                exception = e;
                loadExceptions.put(file1.getName(), e);
            }
        }
        if (successCounter == 1L) {
            NpcApi.plugin.getLogger().info("Successfully loaded " + successCounter + " NPC");
        } else if (successCounter > 1L) {
            NpcApi.plugin.getLogger().info("Successfully loaded " + successCounter + " NPC's");
        }
        if (failCounter == 1L) {
            NpcApi.plugin.getLogger().warning("Failed to load " + failCounter + " NPC");
        } else if (failCounter > 1L) {
            NpcApi.plugin.getLogger().warning("Failed to load " + failCounter + " NPC's");
        }
        if (exception != null && NpcApi.config.debug()) {
            exception.printStackTrace();
        }
    }

    public static void loadWorld(@NotNull World world) {
        List<NPC.SerializedNPC> serializedNPCS = toLoadNPCs.remove(world.getUID());
        if (serializedNPCS == null || serializedNPCS.isEmpty()) {
            return;
        }
        Throwable exception = null;
        for (NPC.SerializedNPC serializedNPC : serializedNPCS) {
            try {
                Either<NPC, UUID> either = serializedNPC.deserializedNPC();
                if (either.left().isEmpty()) {
                    return;
                }
                NpcManager.loadNpc((NPC)either.left().get());
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception != null && NpcApi.config.debug()) {
            exception.printStackTrace();
        }
    }

    private static void loadNpc(@NotNull NPC npc) {
        LocalDate date = LocalDate.of(2025, 10, 22);
        LocalTime time = LocalTime.of(22, 0);
        Instant instant = LocalDateTime.of(date, time).atZone(ZoneId.of("UTC")).toInstant();
        if (npc.getCreatedAt().isBefore(instant)) {
            npc.setEditable(true);
        }
        npc.showNpcToAllPlayers();
    }
}

