/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.wrapper;

import com.google.common.primitives.Primitives;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.utils.CallerUtils;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.utils.exceptions.VersionNotFound;
import de.eisi05.npc.api.wrapper.HandleHolder;
import de.eisi05.npc.api.wrapper.Mapping;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Wrapper
implements HandleHolder {
    private static final Map<String, Class<?>> classCache = new ConcurrentHashMap();
    private static final Map<Class<?>, Constructor<?>> wrapperConstructorCache = new ConcurrentHashMap();
    private static final Map<String, Constructor<?>> instanceConstructorCache = new ConcurrentHashMap();
    private static final Map<String, MethodHandle> methodCache = new ConcurrentHashMap<String, MethodHandle>();
    private static final Map<String, Field> fieldCache = new ConcurrentHashMap<String, Field>();
    private static final Map<String, MethodHandle> fieldGetterCache = new ConcurrentHashMap<String, MethodHandle>();
    private static final Map<String, MethodHandle> fieldSetterCache = new ConcurrentHashMap<String, MethodHandle>();
    private static final Map<Class<?>, Map<String, Field>> enumFieldCache = new ConcurrentHashMap();
    protected final Object handle;

    public Wrapper(Object handle) {
        this.handle = handle;
    }

    public static Object[] checkArgs(Object ... args) {
        return Arrays.stream(args).map(arg -> {
            Object object;
            if (arg instanceof HandleHolder) {
                HandleHolder h = (HandleHolder)arg;
                object = h.getHandle();
            } else {
                object = arg;
            }
            return object;
        }).toArray();
    }

    @Nullable
    public static Class<?> getWrappedClass(@NotNull Class<?> wrapperClass) {
        Mapping[] annotations;
        for (Mapping mapping : annotations = (Mapping[])wrapperClass.getAnnotationsByType(Mapping.class)) {
            if (!Versions.containsCurrentVersion(mapping)) continue;
            return Wrapper.getTargetClass(mapping);
        }
        throw new VersionNotFound(wrapperClass);
    }

    protected static Class<?> getTargetClass(Mapping mapping) {
        return classCache.computeIfAbsent(mapping.path(), name -> {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        });
    }

    protected static Constructor<?> findConstructor(Class<?> targetClass, Object[] args) {
        return Arrays.stream(targetClass.getDeclaredConstructors()).filter(ctor -> {
            Class<?>[] params = ctor.getParameterTypes();
            boolean varArgs = ctor.isVarArgs();
            if (!varArgs && params.length != args.length || varArgs && args.length < params.length - 1) {
                return false;
            }
            for (int i = 0; i < params.length; ++i) {
                Class<?> comp;
                if (i >= args.length) {
                    return false;
                }
                Object arg = args[i];
                if (arg == null) continue;
                Class<?> actual = arg.getClass();
                if (actual.isAnonymousClass() || actual.isSynthetic()) {
                    Class<?>[] interfaces = actual.getInterfaces();
                    Class<?> clazz = actual = interfaces.length > 0 ? interfaces[0] : actual.getSuperclass();
                }
                if (!(varArgs && i == params.length - 1 ? !Primitives.wrap(comp = params[i].getComponentType()).isAssignableFrom(Primitives.wrap(actual)) && !actual.isArray() : !Primitives.wrap(params[i]).isAssignableFrom(Primitives.wrap(actual)))) continue;
                return false;
            }
            return true;
        }).findFirst().orElse(null);
    }

    protected static Object createInstance(Class<? extends Wrapper> wrapperClass, Object ... args) {
        Object[] checkedArgs = Wrapper.checkArgs(args);
        try {
            Mapping[] annotations;
            for (Mapping mapping : annotations = (Mapping[])wrapperClass.getAnnotationsByType(Mapping.class)) {
                Object[] realArgs;
                if (!Versions.containsCurrentVersion(mapping)) continue;
                Class<?> targetClass = Wrapper.getTargetClass(mapping);
                String cacheKey = targetClass.getName() + Arrays.toString(Arrays.stream(checkedArgs).map(a -> a == null ? "null" : a.getClass().getName()).toArray());
                Constructor constructor = instanceConstructorCache.computeIfAbsent(cacheKey, k -> Wrapper.findConstructor(targetClass, checkedArgs));
                if (constructor == null) {
                    throw new NoSuchMethodException("No matching constructor found for: " + targetClass.getName() + "(" + Arrays.toString(checkedArgs) + ")");
                }
                if (constructor.isVarArgs()) {
                    int fixedCount = constructor.getParameterCount() - 1;
                    Class<?> varArgType = constructor.getParameterTypes()[fixedCount].getComponentType();
                    Object varArgsArray = Array.newInstance(varArgType, args.length - fixedCount);
                    for (int i = 0; i < Array.getLength(varArgsArray); ++i) {
                        Array.set(varArgsArray, i, checkedArgs[fixedCount + i]);
                    }
                    realArgs = new Object[constructor.getParameterCount()];
                    System.arraycopy(checkedArgs, 0, realArgs, 0, fixedCount);
                    realArgs[fixedCount] = varArgsArray;
                } else {
                    realArgs = checkedArgs;
                }
                constructor.setAccessible(true);
                return constructor.newInstance(realArgs);
            }
            throw new VersionNotFound(wrapperClass);
        }
        catch (Exception e) {
            if (NpcApi.config.debug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected static <T extends Wrapper> T createWrappedInstance(Class<T> wrapperClass, Object ... args) {
        try {
            Constructor cached = wrapperConstructorCache.computeIfAbsent(wrapperClass, clazz -> {
                try {
                    Constructor cons = clazz.getDeclaredConstructor(Object.class);
                    cons.setAccessible(true);
                    return cons;
                }
                catch (Exception e) {
                    if (NpcApi.config.debug()) {
                        e.printStackTrace();
                    }
                    throw new RuntimeException(e);
                }
            });
            return (T)((Wrapper)wrapperClass.cast(cached.newInstance(Wrapper.createInstance(wrapperClass, args))));
        }
        catch (Exception e) {
            if (NpcApi.config.debug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static <T> Optional<T> getStaticWrappedFieldValue(String fieldName) {
        try {
            Class<?> callerClass = CallerUtils.getCallerClass();
            Field callerField = callerClass.getDeclaredField(fieldName);
            Mapping[] fieldAnnotations = (Mapping[])callerField.getAnnotationsByType(Mapping.class);
            Mapping[] classAnnotations = (Mapping[])callerClass.getAnnotationsByType(Mapping.class);
            if (classAnnotations.length == 0) {
                throw new IllegalStateException("Missing @WrapData on class: " + callerClass.getName());
            }
            Mapping fieldAnnotation = Arrays.stream(fieldAnnotations).filter(Versions::containsCurrentVersion).findFirst().orElseThrow(() -> new VersionNotFound(callerClass.getName() + " -> " + callerField.getName()));
            for (Mapping classData : classAnnotations) {
                if (!Versions.containsCurrentVersion(classData)) continue;
                String key = classData.path() + "#" + fieldAnnotation.path();
                Field targetField = fieldCache.computeIfAbsent(key, k -> {
                    try {
                        Class<?> targetClass = Wrapper.getTargetClass(classData);
                        Field f = targetClass.getDeclaredField(fieldAnnotation.path());
                        f.setAccessible(true);
                        return f;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                return Optional.ofNullable(targetField.get(null));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> T invokeStaticWrappedMethod(Object ... args) {
        Object[] newArgs = Wrapper.checkArgs(args);
        try {
            String callingMethodName = CallerUtils.getCallerMethodName();
            Class<?> callerClass = CallerUtils.getCallerClass();
            Class<?> targetClass = Wrapper.getTargetClass(callerClass.getAnnotation(Mapping.class));
            Method callingMethod = null;
            for (Class<?> clazz = callerClass; callingMethod == null && clazz != null; clazz = clazz.getSuperclass()) {
                callingMethod = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(callingMethodName)).findFirst().orElse(null);
            }
            if (callingMethod == null) {
                throw new NoSuchElementException("No value present -> " + callingMethodName);
            }
            Mapping[] annotations = (Mapping[])callingMethod.getAnnotationsByType(Mapping.class);
            MethodHandles.Lookup lookup = CallerUtils.getLookup(targetClass);
            for (Mapping mapping : annotations) {
                if (!Versions.containsCurrentVersion(mapping)) continue;
                String methodPath = mapping.path();
                String key = targetClass.getName() + "#" + methodPath + Arrays.toString(Arrays.stream(newArgs).map(a -> a == null ? "null" : a.getClass().getName()).toArray());
                MethodHandle handle = methodCache.computeIfAbsent(key, k -> {
                    try {
                        Method method = Arrays.stream(targetClass.getMethods()).filter(m -> m.getName().equals(methodPath)).filter(m -> {
                            Class<?>[] params = m.getParameterTypes();
                            if (params.length != newArgs.length) {
                                return false;
                            }
                            for (int i = 0; i < params.length; ++i) {
                                if (newArgs[i] == null || Primitives.wrap(params[i]).isAssignableFrom(Primitives.wrap(newArgs[i].getClass()))) continue;
                                return false;
                            }
                            return true;
                        }).findFirst().orElseThrow(() -> new NoSuchMethodException(methodPath));
                        method.setAccessible(true);
                        return lookup.unreflect(method);
                    }
                    catch (Exception e) {
                        if (NpcApi.config.debug()) {
                            e.printStackTrace();
                        }
                        throw new RuntimeException(e);
                    }
                });
                return (T)handle.invokeWithArguments(newArgs);
            }
            throw new VersionNotFound(callingMethod);
        }
        catch (Throwable e) {
            if (NpcApi.config.debug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected String getPath() {
        String callingMethodName = CallerUtils.getCallerMethodName();
        Method callingMethod = Arrays.stream(this.getClass().getMethods()).filter(m -> m.getName().equals(callingMethodName)).findFirst().orElseThrow(() -> new RuntimeException(callingMethodName + " -> " + this.getClass()));
        Mapping[] annotations = (Mapping[])callingMethod.getAnnotationsByType(Mapping.class);
        return Arrays.stream(annotations).filter(Versions::containsCurrentVersion).findFirst().orElseThrow(() -> new VersionNotFound(callingMethod)).path();
    }

    protected <T> T invokeWrappedMethod(Object ... args) {
        Object[] newArgs = Wrapper.checkArgs(args);
        try {
            String callingMethodName = CallerUtils.getCallerMethodName();
            Method callingMethod = null;
            for (Class<?> clazz = this.getClass(); callingMethod == null && clazz != null; clazz = clazz.getSuperclass()) {
                callingMethod = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(callingMethodName)).findFirst().orElse(null);
            }
            if (callingMethod == null) {
                throw new NoSuchElementException("No value present -> " + callingMethodName);
            }
            Mapping[] annotations = (Mapping[])callingMethod.getAnnotationsByType(Mapping.class);
            MethodHandles.Lookup lookup = CallerUtils.getLookup(this.getHandle().getClass());
            for (Mapping mapping : annotations) {
                if (!Versions.containsCurrentVersion(mapping)) continue;
                String methodPath = mapping.path();
                String key = this.getHandle().getClass().getName() + "#" + methodPath + Arrays.toString(Arrays.stream(newArgs).map(a -> a == null ? "null" : a.getClass().getName()).toArray());
                MethodHandle unboundHandle = methodCache.computeIfAbsent(key, k -> {
                    try {
                        Method method = Arrays.stream(this.getHandle().getClass().getMethods()).filter(m -> m.getName().equals(methodPath)).filter(m -> {
                            Class<?>[] params = m.getParameterTypes();
                            if (params.length != newArgs.length) {
                                return false;
                            }
                            for (int i = 0; i < params.length; ++i) {
                                if (newArgs[i] == null || Primitives.wrap(params[i]).isAssignableFrom(Primitives.wrap(newArgs[i].getClass()))) continue;
                                return false;
                            }
                            return true;
                        }).findFirst().orElseThrow(() -> new RuntimeException(new NoSuchMethodException(methodPath + "(" + Arrays.stream(newArgs).map(o -> o.getClass().toString()).toList() + ")")));
                        method.setAccessible(true);
                        return lookup.unreflect(method);
                    }
                    catch (Exception e) {
                        if (NpcApi.config.debug()) {
                            e.printStackTrace();
                        }
                        throw new RuntimeException(e);
                    }
                });
                MethodHandle boundHandle = unboundHandle.bindTo(this.getHandle());
                return (T)boundHandle.invokeWithArguments(newArgs);
            }
            throw new VersionNotFound(callingMethod);
        }
        catch (Throwable e) {
            if (NpcApi.config.debug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected <T> T getWrappedFieldValue() {
        try {
            Mapping[] annotations;
            String callingMethodName = CallerUtils.getCallerMethodName();
            Method callingMethod = null;
            for (Class<?> clazz = this.getClass(); callingMethod == null && clazz != null; clazz = clazz.getSuperclass()) {
                callingMethod = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(callingMethodName)).findFirst().orElse(null);
            }
            if (callingMethod == null) {
                throw new NoSuchElementException("No value present -> " + callingMethodName);
            }
            for (Mapping mapping : annotations = (Mapping[])callingMethod.getAnnotationsByType(Mapping.class)) {
                if (!Versions.containsCurrentVersion(mapping)) continue;
                String fieldName = mapping.path();
                String key = this.getHandle().getClass().getName() + "#" + fieldName;
                MethodHandle getter = fieldGetterCache.computeIfAbsent(key, k -> {
                    try {
                        Field f = null;
                        for (Class<?> c = this.getHandle().getClass(); c != null; c = c.getSuperclass()) {
                            try {
                                f = c.getDeclaredField(fieldName);
                                if (!Modifier.isStatic(f.getModifiers())) break;
                                f = null;
                                continue;
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                // empty catch block
                            }
                        }
                        if (f == null) {
                            throw new NoSuchFieldException(fieldName);
                        }
                        f.setAccessible(true);
                        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(f.getDeclaringClass(), MethodHandles.lookup());
                        return lookup.findGetter(f.getDeclaringClass(), fieldName, f.getType());
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        if (NpcApi.config.debug()) {
                            e.printStackTrace();
                        }
                        throw new RuntimeException(e);
                    }
                });
                return (T)getter.invoke(this.getHandle());
            }
            throw new VersionNotFound(callingMethod);
        }
        catch (Throwable e) {
            if (NpcApi.config.debug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected <T> void setWrappedFieldValue(T value) {
        try {
            Mapping[] annotations;
            String callingMethodName = CallerUtils.getCallerMethodName();
            Method callingMethod = null;
            for (Class<?> clazz = this.getClass(); callingMethod == null && clazz != null; clazz = clazz.getSuperclass()) {
                callingMethod = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(callingMethodName)).findFirst().orElse(null);
            }
            if (callingMethod == null) {
                throw new NoSuchElementException("No value present -> " + callingMethodName);
            }
            for (Mapping mapping : annotations = (Mapping[])callingMethod.getAnnotationsByType(Mapping.class)) {
                if (!Versions.containsCurrentVersion(mapping)) continue;
                String fieldName = mapping.path();
                String key = this.getHandle().getClass().getName() + "#" + fieldName;
                MethodHandle setter = fieldSetterCache.computeIfAbsent(key, k -> {
                    try {
                        Field f = null;
                        for (Class<?> c = this.getHandle().getClass(); c != null; c = c.getSuperclass()) {
                            try {
                                f = c.getDeclaredField(fieldName);
                                if (!Modifier.isStatic(f.getModifiers())) break;
                                f = null;
                                continue;
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                // empty catch block
                            }
                        }
                        if (f == null) {
                            throw new NoSuchFieldException(fieldName);
                        }
                        f.setAccessible(true);
                        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(f.getDeclaringClass(), MethodHandles.lookup());
                        return lookup.findSetter(this.getHandle().getClass(), fieldName, f.getType());
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        if (NpcApi.config.debug()) {
                            e.printStackTrace();
                        }
                        throw new RuntimeException(e);
                    }
                });
                setter.invoke(this.getHandle(), value);
                return;
            }
            throw new VersionNotFound(callingMethod);
        }
        catch (Throwable e) {
            if (NpcApi.config.debug()) {
                e.printStackTrace();
            }
            return;
        }
    }

    @Override
    @NotNull
    public Object getHandle() {
        return this.handle;
    }

    public static interface EnumWrapper
    extends HandleHolder {
        default public <T extends Enum<T>, V extends Enum<?>> V cast(T object) {
            Class<?> targetEnum;
            Class<?> enumClass = object.getClass();
            Mapping[] classData = (Mapping[])enumClass.getAnnotationsByType(Mapping.class);
            String classPath = Arrays.stream(classData).filter(Versions::containsCurrentVersion).map(Mapping::path).findFirst().orElseThrow(() -> new VersionNotFound(enumClass));
            try {
                targetEnum = Class.forName(classPath);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            Map fields = enumFieldCache.computeIfAbsent(enumClass, cls -> {
                ConcurrentHashMap<String, Field> map = new ConcurrentHashMap<String, Field>();
                for (Field f : cls.getDeclaredFields()) {
                    for (Mapping ann : (Mapping[])f.getAnnotationsByType(Mapping.class)) {
                        if (!Versions.containsCurrentVersion(ann)) continue;
                        f.setAccessible(true);
                        map.put(f.getName(), f);
                    }
                }
                return map;
            });
            try {
                Field sourceField = (Field)fields.get(object.name());
                if (sourceField == null) {
                    throw new VersionNotFound(enumClass);
                }
                Mapping[] fieldData = (Mapping[])sourceField.getAnnotationsByType(Mapping.class);
                String fieldName = Arrays.stream(fieldData).filter(Versions::containsCurrentVersion).map(Mapping::path).findFirst().orElseThrow(() -> new VersionNotFound(enumClass));
                Field targetField = targetEnum.getDeclaredField(fieldName);
                targetField.setAccessible(true);
                return (V)((Enum)targetField.get(null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        default public String getPath() {
            String callingMethodName = CallerUtils.getCallerMethodName();
            Method callingMethod = Arrays.stream(this.getClass().getMethods()).filter(m -> m.getName().equals(callingMethodName)).findFirst().orElseThrow(() -> new RuntimeException(callingMethodName + " -> " + this.getClass()));
            Mapping[] annotations = (Mapping[])callingMethod.getAnnotationsByType(Mapping.class);
            return Arrays.stream(annotations).filter(Versions::containsCurrentVersion).findFirst().orElseThrow(() -> new VersionNotFound(callingMethod)).path();
        }
    }
}

