/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.objects;

import de.eisi05.dialogMenu.DialogMenu;
import de.eisi05.dialogMenu.TriConsumer;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.pathfinding.Path;
import de.eisi05.npc.api.pathfinding.PathfindingUtils;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.enums.ChatFormat;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.gui.NpcGUI;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.manager.PathManager;
import de.eisi05.npc.plugin.objects.AbstractPluginActionOption;
import de.eisi05.npc.plugin.objects.NpcClickActionImpl;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import de.eisi05.npc.plugin.utils.Prefix;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.InactivityConversationCanceller;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathActionOption
extends AbstractPluginActionOption<Pair<Path.SerializablePath, Float>> {
    private static final long serialVersionUID = 1L;

    private PathActionOption() {
    }

    @NotNull
    static NpcClickActionImpl.PluginActionOptions<Pair<Path.SerializablePath, Float>> getPathAction() {
        return PathActionOption.getOption(PathActionOption.class, PathActionOption::new);
    }

    @Override
    String getName() {
        return "path";
    }

    @Override
    Pair<Path.SerializablePath, Float> getDefaultValue() {
        return null;
    }

    @Override
    NpcClickAction getAction(Pair<Path.SerializablePath, Float> pair) {
        return e -> {
            if (pair == null || pair.getKey() == null) {
                return;
            }
            e.getNpc().walkTo(((Path.SerializablePath)pair.getKey()).toPath(), pair.getRight() == null ? 0.25 : (double)((Float)pair.getRight()).floatValue(), false, null, e.getPlayer());
        };
    }

    @Override
    ItemBuilder getIcon(Pair<Path.SerializablePath, Float> pair, Player player) {
        return new ItemBuilder(Material.DIRT_PATH).addLore(pair != null && pair.getKey() != null && ((Path.SerializablePath)pair.getKey()).toPath().getName() != null ? LocalizationManager.get(player, "actions.path.value.name", ((Path.SerializablePath)pair.getKey()).toPath().getName()) : LocalizationManager.get(player, "actions.path.value.name", LocalizationManager.get(player, "misc.not-set", new Object[0]))).addLore(pair != null && pair.getRight() != null ? LocalizationManager.get(player, "actions.path.value.speed", ((Float)pair.getRight()).toString()) : LocalizationManager.get(player, "actions.path.value.speed", LocalizationManager.get(player, "misc.not-set", new Object[0])));
    }

    @Override
    Pair<Path.SerializablePath, Float> getClickAction(final Pair<Path.SerializablePath, Float> currentPair, final NpcClickActionImpl.PluginActionOptions.PluginActionData data) {
        final Path currentPath = currentPair == null ? null : ((Path.SerializablePath)currentPair.getKey()).toPath();
        Player p = (Player)data.event().getWhoClicked();
        p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
        data.event().getWhoClicked().closeInventory();
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_6)) {
            DialogMenu.path(p, (Plugin)NpcPlugin.plugin, currentPath == null ? null : currentPath.getName(), null, 25.0f, player -> player.openInventory(player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()))), new TriConsumer<Player, String, Float>(){

                @Override
                public void accept(Player player, String s, Float f) {
                    if (s == null || s.trim().isEmpty()) {
                        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(player, "actions.path.input.empty.1", true, new Object[0]);
                        player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                        return;
                    }
                    Optional<Path> newPath = PathManager.getInstance(player).getPath(s);
                    if (newPath.isEmpty()) {
                        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(player, "command.path.not-exists", true, s);
                        player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                        return;
                    }
                    if ((double)f.floatValue() < 0.1 || f.floatValue() > 1.0f) {
                        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(player, "actions.path.input.speed.invalid", true, new Object[0]);
                        player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                        return;
                    }
                    data.actionInstance().param = (Serializable)Var.unsafeCast(new MutablePair((Object)newPath.get().toSerializablePath(), (Object)f));
                    data.npc().markChange();
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                    LocalizedMessage.sendMessage(player, "actions.path.set", true, newPath.get().getName(), f);
                    player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                }

                @Override
                public void accept(Player player, String s) {
                }
            }, LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.path.input.prompt.1", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.path.input.edit.text.1", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "misc.ok", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "misc.back", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.path.title", new Object[0]));
            return currentPair;
        }
        new ConversationManager((Plugin)NpcPlugin.plugin).withModality(false).withLocalEcho(false).withEscapeSequence(LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.path.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(abandonedEvent -> {
            Player player = (Player)abandonedEvent.getContext().getForWhom();
            if (!abandonedEvent.gracefulExit()) {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                ConversationContext context = abandonedEvent.getContext();
                if (!(abandonedEvent.getCanceller() instanceof InactivityConversationCanceller)) {
                    LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.path.input.cancelled", true, new Object[0]);
                } else {
                    LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.path.input.timeout", true, NpcApi.config.inputTime());
                }
            }
            Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport())));
        }).withFirstPrompt(new Prompt(){

            public boolean blocksForInput(@NotNull ConversationContext context) {
                if (currentPath == null || currentPath.getName() == null || currentPath.asLocations().isEmpty()) {
                    return true;
                }
                WrappedServerPlayer.fromPlayer((Player)context.getForWhom()).sendRawMessage(WrappedComponent.parseFromLegacy(LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.edit.text.1", new Object[0])).setFormats(ChatFormat.ITALIC, ChatFormat.GREEN).withClickEvent(WrappedComponent.ClickEvent.create(WrappedComponent.ClickEvent.ClickAction.SUGGEST_COMMAND, currentPath.getName())).withHoverEvent(WrappedComponent.HoverEvent.create(WrappedComponent.create(LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.edit.hover.1", new Object[0])).setFormats(ChatFormat.GRAY, ChatFormat.ITALIC))));
                return true;
            }

            @NotNull
            public String getPromptText(@NotNull ConversationContext context) {
                return Prefix.PREFIX + LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.prompt.1", new Object[0]);
            }

            public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
                Player conversingPlayer = (Player)context.getForWhom();
                if (input == null || input.trim().isEmpty()) {
                    conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(conversingPlayer, "actions.path.input.empty.1", true, new Object[0]);
                    return this;
                }
                Optional<Path> newPath = PathManager.getInstance(conversingPlayer).getPath(input);
                if (newPath.isEmpty()) {
                    conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(conversingPlayer, "command.path.not-exists", true, input);
                    return this;
                }
                if (!newPath.get().asLocations().getFirst().getWorld().equals((Object)data.npc().getLocation().getWorld())) {
                    conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(conversingPlayer, "actions.path.other-world", true, new Object[0]);
                    return this;
                }
                context.setSessionData((Object)"path", (Object)newPath.get());
                return new Prompt(){

                    @NotNull
                    public String getPromptText(@NotNull ConversationContext context) {
                        return Prefix.PREFIX + LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.prompt.2", new Object[0]);
                    }

                    public boolean blocksForInput(@NotNull ConversationContext context) {
                        if (currentPair == null || currentPair.getRight() == null || (double)((Float)currentPair.getRight()).floatValue() < 0.1) {
                            return true;
                        }
                        WrappedServerPlayer.fromPlayer((Player)context.getForWhom()).sendRawMessage(WrappedComponent.parseFromLegacy(LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.edit.text.2", new Object[0])).setFormats(ChatFormat.ITALIC, ChatFormat.GREEN).withClickEvent(WrappedComponent.ClickEvent.create(WrappedComponent.ClickEvent.ClickAction.SUGGEST_COMMAND, String.valueOf(currentPair.getRight()))).withHoverEvent(WrappedComponent.HoverEvent.create(WrappedComponent.create(LocalizationManager.get((Player)context.getForWhom(), "actions.path.input.edit.hover.2", new Object[0])).setFormats(ChatFormat.GRAY, ChatFormat.ITALIC))));
                        return true;
                    }

                    @Nullable
                    public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
                        float speed;
                        Player conversingPlayer = (Player)context.getForWhom();
                        if (input == null || input.trim().isEmpty()) {
                            conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                            LocalizedMessage.sendMessage(conversingPlayer, "actions.path.input.empty.2", true, new Object[0]);
                            return this;
                        }
                        try {
                            speed = Float.parseFloat(input);
                            if ((double)speed < 0.1 || speed > 1.0f) {
                                conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                                LocalizedMessage.sendMessage(conversingPlayer, "actions.path.input.speed.invalid", true, new Object[0]);
                                return this;
                            }
                        }
                        catch (NumberFormatException e) {
                            conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                            LocalizedMessage.sendMessage(conversingPlayer, "actions.path.input.speed.invalid", true, new Object[0]);
                            return this;
                        }
                        Path newPath = (Path)context.getSessionData((Object)"path");
                        LocalizedMessage.sendMessage(conversingPlayer, "actions.path.creating", true, newPath.getName());
                        ((CompletableFuture)PathfindingUtils.findPathAsync(List.of(data.npc().getLocation().clone().subtract(0.0, 1.0, 0.0), newPath.asLocations().getFirst().clone().subtract(0.0, 1.0, 0.0)), 10000, true, null).thenAccept(path -> {
                            Path finalPath = new Path(Stream.concat(path.asLocations().stream(), newPath.asLocations().stream()).toList(), null);
                            finalPath.setName(newPath.getName());
                            data.actionInstance().param = (Serializable)Var.unsafeCast(new MutablePair((Object)finalPath.toSerializablePath(), (Object)Float.valueOf(speed)));
                            data.npc().markChange();
                            conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                            LocalizedMessage.sendMessage(conversingPlayer, "actions.path.set", true, newPath.getName(), input);
                        })).exceptionally(throwable -> {
                            throwable.printStackTrace();
                            LocalizedMessage.sendMessage(conversingPlayer, "actions.path.failed", true, newPath.getName());
                            return null;
                        });
                        return END_OF_CONVERSATION;
                    }
                };
            }
        }).buildConversation((Conversable)data.event().getWhoClicked()).begin();
        return currentPair;
    }
}

