/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api;

import de.eisi05.npc.api.listeners.ChangeWorldListener;
import de.eisi05.npc.api.listeners.ConnectionListener;
import de.eisi05.npc.api.listeners.NpcInteractListener;
import de.eisi05.npc.api.manager.NpcManager;
import de.eisi05.npc.api.manager.TeamManager;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.NpcConfig;
import de.eisi05.npc.api.pathfinding.Path;
import de.eisi05.npc.api.scheduler.Tasks;
import de.eisi05.npc.api.utils.PacketReader;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class NpcApi {
    public static Plugin plugin;
    public static Function<Player, Component> DISABLED_MESSAGE_PROVIDER;
    public static NpcConfig config;
    private static NpcApi npcApi;

    private NpcApi(@NotNull JavaPlugin plugin, @NotNull NpcConfig config) {
        NpcApi.plugin = plugin;
        NpcApi.config = config;
        Bukkit.getPluginManager().registerEvents((Listener)new ChangeWorldListener(), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new ConnectionListener(), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new NpcInteractListener(), (Plugin)plugin);
        ConfigurationSerialization.registerClass(Path.class);
        NpcManager.loadNPCs();
        PacketReader.injectAll();
        Tasks.start();
    }

    @NotNull
    public static NpcApi createInstance(@NotNull JavaPlugin plugin) {
        return NpcApi.createInstance(plugin, new NpcConfig());
    }

    @NotNull
    public static NpcApi createInstance(@NotNull JavaPlugin plugin, @NotNull NpcConfig config) {
        if (npcApi == null || plugin == null) {
            npcApi = new NpcApi(plugin, config);
        }
        return npcApi;
    }

    @NotNull
    public NpcApi setDisabledMessageProvider(Function<Player, Component> function) {
        DISABLED_MESSAGE_PROVIDER = function;
        return this;
    }

    public static void disable() {
        NpcManager.getList().forEach(NPC::hideNpcFromAllPlayers);
        NpcManager.clear();
        PacketReader.uninjectAll();
        Tasks.stop();
        TeamManager.clear();
        ConfigurationSerialization.unregisterClass(Path.class);
        NpcManager.loadExceptions.clear();
        npcApi = null;
        plugin = null;
    }

    static {
        DISABLED_MESSAGE_PROVIDER = player -> Component.text((String)"DISABLED").color((TextColor)NamedTextColor.RED);
    }
}

