/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import de.eisi05.npc.api.utils.Var;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Display;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.util.Vector;
import org.joml.Vector3f;

public class CustomNameTag {
    private final Display.TextDisplay display;
    private final Map<EntityDataAccessor<?>, Object> dataMap = new LinkedHashMap();

    public CustomNameTag(Object display) {
        this.display = (Display.TextDisplay)display;
    }

    public Object getDisplay() {
        return this.display;
    }

    private <T> CustomNameTag set(EntityDataAccessor<T> accessor, T value) {
        this.dataMap.put(accessor, value);
        return this;
    }

    public CustomNameTag translation(Vector vector) {
        return this.set(EntityDataSerializers.VECTOR3.createAccessor(11), vector.toVector3f());
    }

    public CustomNameTag scale(Vector vector) {
        return this.set(EntityDataSerializers.VECTOR3.createAccessor(12), vector.toVector3f());
    }

    public CustomNameTag billboardConstraints(BillboardConstraints constraints) {
        return this.set(EntityDataSerializers.BYTE.createAccessor(15), (byte)constraints.ordinal());
    }

    public CustomNameTag brightnessOverride(int brightness) {
        return this.set(EntityDataSerializers.INT.createAccessor(16), brightness);
    }

    public CustomNameTag viewRange(float range) {
        return this.set(EntityDataSerializers.FLOAT.createAccessor(17), Float.valueOf(range));
    }

    public CustomNameTag shadowRadius(float radius) {
        return this.set(EntityDataSerializers.FLOAT.createAccessor(18), Float.valueOf(radius));
    }

    public CustomNameTag shadowStrength(float strength) {
        return this.set(EntityDataSerializers.FLOAT.createAccessor(19), Float.valueOf(strength));
    }

    public CustomNameTag width(float width) {
        return this.set(EntityDataSerializers.FLOAT.createAccessor(20), Float.valueOf(width));
    }

    public CustomNameTag height(float height) {
        return this.set(EntityDataSerializers.FLOAT.createAccessor(21), Float.valueOf(height));
    }

    public CustomNameTag glowColorOverride(int color) {
        return this.set(EntityDataSerializers.INT.createAccessor(22), color);
    }

    public CustomNameTag lineWidth(int width) {
        return this.set(EntityDataSerializers.INT.createAccessor(24), width);
    }

    public CustomNameTag backgroundColor(int color) {
        return this.set(EntityDataSerializers.INT.createAccessor(25), color);
    }

    public CustomNameTag textOpacity(byte opacity) {
        return this.set(EntityDataSerializers.BYTE.createAccessor(26), opacity);
    }

    public CustomNameTag flags(TextDisplayFlags ... flags) {
        return this.set(EntityDataSerializers.BYTE.createAccessor(27), TextDisplayFlags.combineFlags(flags));
    }

    Object applyData(@Nullable net.kyori.adventure.text.Component component) {
        String legacy;
        Component nmsComponent;
        SynchedEntityData data = this.display.getEntityData();
        if (component == null) {
            component = net.kyori.adventure.text.Component.empty();
        }
        if ((nmsComponent = CraftChatMessage.fromStringOrNull((String)(legacy = LegacyComponentSerializer.legacySection().serialize(component).replace("\\n", "\n")), (boolean)true)) == null) {
            nmsComponent = Component.empty();
        }
        data.set(EntityDataSerializers.OPTIONAL_COMPONENT.createAccessor(2), Optional.of(nmsComponent));
        data.set(EntityDataSerializers.BOOLEAN.createAccessor(4), (Object)true);
        data.set(EntityDataSerializers.VECTOR3.createAccessor(11), (Object)new Vector3f(0.0f, 0.25f, 0.0f));
        data.set(EntityDataSerializers.BYTE.createAccessor(15), (Object)3);
        data.set(EntityDataSerializers.COMPONENT.createAccessor(23), (Object)nmsComponent);
        this.dataMap.forEach((accessor, value) -> data.set(accessor, Var.unsafeCast(value)));
        return data;
    }

    public static enum BillboardConstraints {
        FIXED,
        VERTICAL,
        HORIZONTAL,
        CENTER;

    }

    public static enum TextDisplayFlags {
        NONE(0),
        HAS_SHADOW(1),
        IS_SEE_THROUGH(2),
        USE_DEFAULT_BACKGROUND_COLOR(4),
        CENTER_ALIGNMENT(0),
        LEFT_ALIGNMENT(1),
        RIGHT_ALIGNMENT(2);

        private final byte flag;

        private TextDisplayFlags(byte flag) {
            this.flag = flag;
        }

        public static byte combineFlags(TextDisplayFlags ... flags) {
            byte result = 0;
            for (TextDisplayFlags flag : flags) {
                result = (byte)(result | flag.flag);
            }
            return result;
        }
    }
}

