/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import de.eisi05.npc.api.utils.SerializableFunction;
import java.io.ObjectStreamException;
import java.io.Serializable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpcName
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String nameComponentSerialized;
    private final SerializableFunction<Player, String> nameFunctionSerialized;
    private final transient Component nameComponent;
    private final transient SerializableFunction<Player, Component> nameFunction;

    private NpcName(@NotNull Component nameComponent) {
        this.nameComponent = nameComponent;
        this.nameFunction = null;
        this.nameComponentSerialized = (String)JSONComponentSerializer.json().serialize(nameComponent);
        this.nameFunctionSerialized = null;
    }

    private NpcName(@NotNull SerializableFunction<Player, Component> nameFunction, @NotNull Component fallback) {
        this.nameComponent = fallback;
        this.nameFunction = nameFunction;
        this.nameComponentSerialized = (String)JSONComponentSerializer.json().serialize(fallback);
        this.nameFunctionSerialized = player -> (String)JSONComponentSerializer.json().serialize((Component)nameFunction.apply((Player)player));
    }

    @NotNull
    public static NpcName of(@NotNull Component name) {
        return new NpcName(name);
    }

    @NotNull
    public static NpcName of(@NotNull SerializableFunction<Player, Component> nameFunction, @NotNull Component fallback) {
        return new NpcName(nameFunction, fallback);
    }

    @NotNull
    public static NpcName empty() {
        return NpcName.of((Component)Component.empty());
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.nameFunctionSerialized == null) {
            return new NpcName(JSONComponentSerializer.json().deserialize((Object)this.nameComponentSerialized));
        }
        return new NpcName(player -> JSONComponentSerializer.json().deserialize((Object)((String)this.nameFunctionSerialized.apply((Player)player))), JSONComponentSerializer.json().deserialize((Object)this.nameComponentSerialized));
    }

    public boolean isStatic() {
        return this.nameFunction == null;
    }

    @Nullable
    public Component getName() {
        return this.nameComponent;
    }

    @Nullable
    public Component getName(@Nullable Player player) {
        if (this.nameFunction == null || player == null) {
            return this.nameComponent;
        }
        return (Component)this.nameFunction.apply(player);
    }

    @NotNull
    public NpcName copy() {
        return this.isStatic() ? new NpcName(this.nameComponent) : new NpcName(this.nameFunction, this.nameComponent);
    }

    public String toString() {
        return "{" + (this.isStatic() ? "static" : "dynamic") + " -> " + this.getName().toString() + "}";
    }
}

