/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.pathfinding;

import de.eisi05.npc.api.pathfinding.PathingResult;
import de.eisi05.npc.api.pathfinding.Tile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;

public class AStar {
    private final int sx;
    private final int sy;
    private final int sz;
    private final int ex;
    private final int ey;
    private final int ez;
    private final World w;
    private final int maxIterations;
    private final String endUID;
    private final HashMap<String, Tile> open = new HashMap();
    private final HashMap<String, Tile> closed = new HashMap();
    private final Location start;
    private final boolean allowDiagonalMovement;
    private PathingResult result;

    public AStar(Location start, Location end, int maxIterations, boolean allowDiagonalMovement) throws InvalidPathException {
        this.start = start;
        this.allowDiagonalMovement = allowDiagonalMovement;
        boolean e = true;
        boolean s = this.isLocationWalkable(start);
        if (!s || !(e = this.isLocationWalkable(end))) {
            throw new InvalidPathException(s, e);
        }
        this.w = start.getWorld();
        this.sx = start.getBlockX();
        this.sy = start.getBlockY();
        this.sz = start.getBlockZ();
        this.ex = end.getBlockX();
        this.ey = end.getBlockY();
        this.ez = end.getBlockZ();
        this.maxIterations = maxIterations;
        short sh = 0;
        Tile t = new Tile(sh, sh, sh, null);
        t.calculateBoth(this.sx, this.sy, this.sz, this.ex, this.ey, this.ez, true);
        this.open.put(t.getUID(), t);
        this.processAdjacentTiles(t);
        this.endUID = String.valueOf(this.ex - this.sx) + (this.ey - this.sy) + (this.ez - this.sz);
    }

    private void addToOpenList(Tile t) {
        if (!this.open.containsKey(t.getUID())) {
            this.open.put(t.getUID(), t);
        }
    }

    private void addToClosedList(Tile t) {
        if (!this.closed.containsKey(t.getUID())) {
            this.closed.put(t.getUID(), t);
        }
    }

    public Location getStart() {
        return this.start;
    }

    public Location getEndLocation() {
        return new Location(this.w, (double)this.ex, (double)this.ey, (double)this.ez);
    }

    public PathingResult getPathingResult() {
        return this.result;
    }

    public ArrayList<Tile> iterate() {
        Tile parent;
        Tile current = null;
        int iterations = 0;
        while (this.canContinue()) {
            if (++iterations > this.maxIterations) {
                this.result = PathingResult.ITERATIONS_EXCEEDED;
                break;
            }
            current = this.getLowestFTile();
            this.processAdjacentTiles(current);
        }
        if (this.result != PathingResult.SUCCESS) {
            return null;
        }
        LinkedList<Tile> routeTrace = new LinkedList<Tile>();
        routeTrace.add(current);
        while ((parent = current.getParent()) != null) {
            routeTrace.add(parent);
            current = parent;
        }
        Collections.reverse(routeTrace);
        return new ArrayList<Tile>(routeTrace);
    }

    private boolean canContinue() {
        if (this.open.isEmpty()) {
            this.result = PathingResult.NO_PATH;
            return false;
        }
        if (this.closed.containsKey(this.endUID)) {
            this.result = PathingResult.SUCCESS;
            return false;
        }
        return true;
    }

    private Tile getLowestFTile() {
        double f = 0.0;
        Tile drop = null;
        for (Tile t : this.open.values()) {
            if (f == 0.0) {
                t.calculateBoth(this.sx, this.sy, this.sz, this.ex, this.ey, this.ez, true);
                f = t.getF();
                drop = t;
                continue;
            }
            t.calculateBoth(this.sx, this.sy, this.sz, this.ex, this.ey, this.ez, true);
            double posF = t.getF();
            if (!(posF < f)) continue;
            f = posF;
            drop = t;
        }
        this.open.remove(drop.getUID());
        this.addToClosedList(drop);
        return drop;
    }

    private boolean isOnClosedList(Tile t) {
        return this.closed.containsKey(t.getUID());
    }

    private void processAdjacentTiles(Tile current) {
        HashSet<Tile> possible = new HashSet<Tile>(this.allowDiagonalMovement ? 26 : 14);
        if (this.allowDiagonalMovement) {
            for (int x = -1; x <= 1; x = (int)((byte)(x + 1))) {
                for (int y = -1; y <= 1; y = (int)((byte)(y + 1))) {
                    for (int z = -1; z <= 1; z = (int)((byte)(z + 1))) {
                        Tile t;
                        if (x == 0 && y == 0 && z == 0 || this.isOnClosedList(t = new Tile((short)(current.getX() + x), (short)(current.getY() + y), (short)(current.getZ() + z), current)) || !this.isTileWalkable(t)) continue;
                        t.calculateBoth(this.sx, this.sy, this.sz, this.ex, this.ey, this.ez, true);
                        possible.add(t);
                    }
                }
            }
        } else {
            int[][] directions;
            for (int[] d : directions = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}, {0, -1, 1}, {0, -1, -1}, {0, 1, 1}, {0, 1, -1}, {1, -1, 0}, {-1, -1, 0}, {1, 1, 0}, {-1, 1, 0}}) {
                Tile t = new Tile((short)(current.getX() + d[0]), (short)(current.getY() + d[1]), (short)(current.getZ() + d[2]), current);
                if (this.isOnClosedList(t) || !this.isTileWalkable(t)) continue;
                t.calculateBoth(this.sx, this.sy, this.sz, this.ex, this.ey, this.ez, true);
                possible.add(t);
            }
        }
        for (Tile t : possible) {
            Tile openRef = this.isOnOpenList(t);
            if (openRef == null) {
                this.addToOpenList(t);
                continue;
            }
            if (!(t.getG() < openRef.getG())) continue;
            openRef.setParent(current);
            openRef.calculateBoth(this.sx, this.sy, this.sz, this.ex, this.ey, this.ez, true);
        }
    }

    private Tile isOnOpenList(Tile t) {
        return this.open.getOrDefault(t.getUID(), null);
    }

    private boolean isTileWalkable(Tile t) {
        Location l = new Location(this.w, (double)(this.sx + t.getX()), (double)(this.sy + t.getY()), (double)(this.sz + t.getZ()));
        Block b = l.getBlock();
        return !b.isLiquid() && b.getType().isSolid() && b.getRelative(0, 1, 0).isPassable() && b.getRelative(0, 2, 0).isPassable();
    }

    private boolean isLocationWalkable(Location l) {
        Block b = l.getBlock();
        if (!b.isLiquid() && b.getType().isSolid()) {
            return !(!b.getRelative(0, 1, 0).getType().isAir() && !b.getRelative(0, 1, 0).isPassable() || !b.getRelative(0, 2, 0).getType().isAir() && !b.getRelative(0, 2, 0).isPassable());
        }
        return false;
    }

    public static class InvalidPathException
    extends Exception {
        private final boolean s;
        private final boolean e;

        public InvalidPathException(boolean s, boolean e) {
            super(InvalidPathException.getErrorReason(s, e));
            this.s = s;
            this.e = e;
        }

        @NotNull
        private static String getErrorReason(boolean s, boolean e) {
            StringBuilder sb = new StringBuilder();
            if (!s) {
                sb.append("Start Location was air.");
            }
            if (!e) {
                sb.append("End Location was air.");
            }
            return sb.toString();
        }

        public boolean isStartNotSolid() {
            return !this.s;
        }

        public boolean isEndNotSolid() {
            return !this.e;
        }
    }
}

