/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.scheduler;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.manager.NpcManager;
import de.eisi05.npc.api.objects.NpcOption;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Tasks {
    private static BukkitTask task;

    public static void start() {
        Tasks.lookAtTask();
    }

    public static void stop() {
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
    }

    private static void lookAtTask() {
        task = new BukkitRunnable(){

            public void run() {
                NpcManager.getList().forEach(npc -> {
                    double range = npc.getOption(NpcOption.LOOK_AT_PLAYER);
                    if (range <= 0.0) {
                        return;
                    }
                    ((ServerPlayer)npc.getServerPlayer()).getBukkitEntity().getNearbyEntities(range, range, range).stream().filter(entity -> entity instanceof Player).forEach(entity -> npc.lookAtPlayer((Player)entity));
                });
            }
        }.runTaskTimer(NpcApi.plugin, 0L, NpcApi.config.lookAtTimer());
    }
}

