/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class ItemSerializer {
    @NotNull
    public static String[] playerInventoryToBase64(@NotNull PlayerInventory playerInventory) throws IllegalStateException {
        ItemStack[] storage = playerInventory.getStorageContents();
        if (storage == null) {
            throw new IllegalStateException("Storage contents of player inventory is null");
        }
        String content = ItemSerializer.itemStackArrayToBase64(storage);
        ItemStack[] items = new ItemStack[playerInventory.getArmorContents().length + 1];
        for (int i = 0; i < playerInventory.getArmorContents().length; ++i) {
            items[i] = playerInventory.getArmorContents()[i];
        }
        items[items.length - 1] = playerInventory.getItemInOffHand();
        String armor = ItemSerializer.itemStackArrayToBase64(items);
        return new String[]{content, armor};
    }

    @NotNull
    public static String itemStackToBase64(@NotNull ItemStack item) {
        return ItemSerializer.itemStackArrayToBase64(new ItemStack[]{item});
    }

    @Nullable
    public static ItemStack itemStackFromBase64(@NotNull String data) {
        try {
            return ItemSerializer.itemStackArrayFromBase64(data)[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static String itemStackArrayToBase64(@NotNull ItemStack[] items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream dataOutput = new ObjectOutputStream(outputStream);
            dataOutput.writeInt(items.length);
            for (ItemStack item : items) {
                dataOutput.writeObject(item);
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static String toBase64(@NotNull Inventory inventory) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream dataOutput = new ObjectOutputStream(outputStream);
            dataOutput.writeInt(inventory.getSize());
            for (ItemStack item : inventory.getContents()) {
                dataOutput.writeObject(item);
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            return "";
        }
    }

    @NotNull
    public static ItemStack[][] doubleInventoryFromBase64(@NotNull String[] s) {
        return new ItemStack[][]{ItemSerializer.itemStackArrayFromBase64(s[0]), ItemSerializer.itemStackArrayFromBase64(s[1])};
    }

    @Nullable
    public static Inventory fromBase64(@NotNull String data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            ObjectInputStream dataInput = new ObjectInputStream(inputStream);
            Inventory inventory = Bukkit.getServer().createInventory(null, dataInput.readInt());
            for (int i = 0; i < inventory.getSize(); ++i) {
                inventory.setItem(i, (ItemStack)dataInput.readObject());
            }
            dataInput.close();
            return inventory;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static ItemStack[] itemStackArrayFromBase64(@NotNull String data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            ObjectInputStream dataInput = new ObjectInputStream(inputStream);
            ItemStack[] items = new ItemStack[dataInput.readInt()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (ItemStack)dataInput.readObject();
            }
            dataInput.close();
            return items;
        }
        catch (Exception e) {
            return new ItemStack[0];
        }
    }
}

