/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.manager;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class LocalizationManager {
    private static final String defaultLang = "en";
    private static final Map<String, Map<String, YamlConfiguration>> languages = new HashMap<String, Map<String, YamlConfiguration>>();

    public static void loadLanguages(JavaPlugin plugin) {
        File[] files;
        File langFolder;
        block15: {
            languages.clear();
            langFolder = new File(plugin.getDataFolder(), "lang");
            if (!langFolder.exists()) {
                try {
                    String path = "lang/en/";
                    URL dirURL = plugin.getClass().getClassLoader().getResource(path);
                    if (dirURL == null || !dirURL.getProtocol().equals("jar")) break block15;
                    String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                    try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8));){
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String name2 = entry.getName();
                            if (!name2.startsWith(path) || entry.isDirectory()) continue;
                            plugin.saveResource(name2, false);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((files = langFolder.listFiles()) == null) {
            return;
        }
        for (File langDir : files) {
            if (!langDir.isDirectory()) continue;
            String langCode = langDir.getName();
            HashMap<String, YamlConfiguration> typeMap = new HashMap<String, YamlConfiguration>();
            File[] subFiles = langDir.listFiles((d, name) -> name.endsWith(".yml"));
            if (subFiles == null) continue;
            for (File subFile : subFiles) {
                String type = subFile.getName().substring(0, subFile.getName().length() - 4);
                YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)subFile);
                plugin.saveResource("lang/" + langCode + "/" + subFile.getName(), true);
                YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)subFile);
                for (String key : userConfig.getKeys(true)) {
                    newConfig.set(key, userConfig.get(key));
                }
                try {
                    newConfig.save(subFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                typeMap.put(type, newConfig);
            }
            languages.put(langCode, typeMap);
        }
    }

    public static Component get(Player player, String key, Object ... replacements) {
        if (player == null) {
            return LocalizationManager.get(defaultLang, key, replacements);
        }
        return LocalizationManager.get(player.locale().getLanguage(), key, replacements);
    }

    public static Component get(String lang, String key, Object ... replacements) {
        Map<String, YamlConfiguration> map = languages.getOrDefault(lang, languages.get(defaultLang));
        String[] keys = key.split("\\.");
        if (keys.length < 2) {
            return Component.text((String)key);
        }
        String type = keys[0];
        String path = String.join((CharSequence)".", Arrays.copyOfRange(keys, 1, keys.length));
        YamlConfiguration config = map.getOrDefault(type, languages.get(defaultLang).get(type));
        if (config == null) {
            return Component.text((String)key);
        }
        String message = config.getString(path, key);
        if (message == null) {
            return Component.text((String)key);
        }
        TextComponent result = Component.empty();
        int lastIndex = 0;
        Style currentStyle = null;
        for (int i = 0; i < replacements.length; ++i) {
            Object replacement;
            String placeholder = "{" + i + "}";
            int index = message.indexOf(placeholder, lastIndex);
            if (index == -1) continue;
            if (index > lastIndex) {
                String before = message.substring(lastIndex, index);
                TextComponent beforeComp = LegacyComponentSerializer.legacyAmpersand().deserialize(before);
                result = result.append((Component)beforeComp);
                currentStyle = LocalizationManager.getLastStyle((Component)beforeComp);
            }
            if ((replacement = replacements[i]) instanceof Component) {
                Component comp = (Component)replacement;
                result = result.append(comp);
            } else {
                TextComponent replacementComp = Component.text((String)String.valueOf(replacement));
                if (currentStyle != null) {
                    replacementComp = replacementComp.style(currentStyle);
                }
                result = result.append((Component)replacementComp);
            }
            lastIndex = index + placeholder.length();
        }
        if (lastIndex < message.length()) {
            String remaining = message.substring(lastIndex);
            TextComponent remainingComp = LegacyComponentSerializer.legacyAmpersand().deserialize(remaining);
            result = result.append((Component)remainingComp);
        }
        return result;
    }

    private static Style getLastStyle(Component component) {
        List children = component.children();
        if (children.isEmpty()) {
            return component.style();
        }
        return LocalizationManager.getLastStyle((Component)children.getLast());
    }

    public static String getAsString(Player player, String key, Object ... replacements) {
        if (player == null) {
            return LocalizationManager.getAsString(defaultLang, key, replacements);
        }
        return LocalizationManager.getAsString(player.locale().getLanguage(), key, replacements);
    }

    public static String getAsString(String lang, String key, Object ... replacements) {
        Map<String, YamlConfiguration> map = languages.getOrDefault(lang, languages.get(defaultLang));
        String[] keys = key.split("\\.");
        if (keys.length < 2) {
            return key;
        }
        String type = keys[0];
        String path = String.join((CharSequence)".", Arrays.copyOfRange(keys, 1, keys.length));
        YamlConfiguration config = map.getOrDefault(type, languages.get(defaultLang).get(type));
        if (config == null) {
            return key;
        }
        String message = config.getString(path, key);
        for (int i = 0; i < replacements.length; ++i) {
            message = message.replace("{" + i + "}", String.valueOf(replacements[i]));
        }
        return message.replace("/&", "$$").replace("&", "\u00a7").replace("$$", "&");
    }

    public static List<Component> getAsList(Player player, String key, Object ... replacements) {
        if (player == null) {
            return LocalizationManager.getAsList(defaultLang, key, replacements);
        }
        return LocalizationManager.getAsList(player.locale().getLanguage(), key, replacements);
    }

    public static List<Component> getAsList(String lang, String key, Object ... replacements) {
        Map<String, YamlConfiguration> map = languages.getOrDefault(lang, languages.get(defaultLang));
        String[] keys = key.split("\\.");
        if (keys.length < 2) {
            return Collections.singletonList(Component.text((String)key));
        }
        String type = keys[0];
        String path = String.join((CharSequence)".", Arrays.copyOfRange(keys, 1, keys.length));
        YamlConfiguration config = map.getOrDefault(type, languages.get(defaultLang).get(type));
        if (config == null) {
            return Collections.singletonList(Component.text((String)key));
        }
        String message = config.getString(path, key);
        if (message == null) {
            return Collections.singletonList(Component.text((String)key));
        }
        String[] lines = message.split("\n");
        ArrayList<Component> list = new ArrayList<Component>();
        int i = 0;
        for (String line : lines) {
            String placeholder;
            int index;
            TextComponent result = Component.empty();
            int lastIndex = 0;
            Style currentStyle = null;
            while (i < replacements.length && (index = line.indexOf(placeholder = "{" + i + "}", lastIndex)) != -1) {
                Object replacement;
                if (index > lastIndex) {
                    String before = line.substring(lastIndex, index);
                    TextComponent beforeComp = LegacyComponentSerializer.legacyAmpersand().deserialize(before);
                    result = result.append((Component)beforeComp);
                    currentStyle = LocalizationManager.getLastStyle((Component)beforeComp);
                }
                if ((replacement = replacements[i]) instanceof Component) {
                    Component comp = (Component)replacement;
                    result = result.append(comp);
                } else {
                    TextComponent replacementComp = Component.text((String)String.valueOf(replacement));
                    if (currentStyle != null) {
                        replacementComp = replacementComp.style(currentStyle);
                    }
                    result = result.append((Component)replacementComp);
                }
                lastIndex = index + placeholder.length();
                ++i;
            }
            if (lastIndex < line.length()) {
                String remaining = line.substring(lastIndex);
                TextComponent remainingComp = LegacyComponentSerializer.legacyAmpersand().deserialize(remaining);
                result = result.append((Component)remainingComp);
            }
            list.add((Component)result);
        }
        return list;
    }
}

