/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.manager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.time.ZoneId;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeZoneManager {
    private static final String TIMEZONE_API_URL = "http://ip-api.com/line/";
    private static final Map<UUID, ZoneId> timeZones = new ConcurrentHashMap<UUID, ZoneId>();

    @NotNull
    public static Optional<ZoneId> getTimeZone(@NotNull Player player) {
        return Optional.ofNullable(timeZones.computeIfAbsent(player.getUniqueId(), uuid -> TimeZoneManager.fetchTimeZone()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static ZoneId fetchTimeZone() {
        try {
            URL url = URI.create(TIMEZONE_API_URL).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(2500);
            connection.setReadTimeout(2500);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String[] lines = (String[])br.lines().toArray(String[]::new);
                if (lines.length <= 9) return null;
                if (!"success".equalsIgnoreCase(lines[0])) return null;
                ZoneId zoneId = ZoneId.of(lines[9].trim());
                return zoneId;
            }
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
        return null;
    }
}

