/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.objects;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.pathfinding.Path;
import de.eisi05.npc.api.pathfinding.PathfindingUtils;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.gui.NpcGUI;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.manager.PathManager;
import de.eisi05.npc.plugin.objects.AbstractPluginActionOption;
import de.eisi05.npc.plugin.objects.NpcClickActionImpl;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import de.eisi05.npc.plugin.utils.Prefix;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PathActionOption
extends AbstractPluginActionOption<Pair<Path.SerializablePath, Float>> {
    private static final long serialVersionUID = 1L;

    private PathActionOption() {
    }

    @NotNull
    static NpcClickActionImpl.PluginActionOptions<Pair<Path.SerializablePath, Float>> getPathAction() {
        return PathActionOption.getOption(PathActionOption.class, PathActionOption::new);
    }

    @Override
    String getName() {
        return "path";
    }

    @Override
    Pair<Path.SerializablePath, Float> getDefaultValue() {
        return null;
    }

    @Override
    NpcClickAction getAction(Pair<Path.SerializablePath, Float> pair) {
        return e -> {
            if (pair == null || pair.getKey() == null) {
                return;
            }
            e.getNpc().walkTo(((Path.SerializablePath)pair.getKey()).toPath(), e.getPlayer(), pair.getRight() == null ? 0.25 : (double)((Float)pair.getRight()).floatValue(), false, null);
        };
    }

    @Override
    ItemBuilder getIcon(Pair<Path.SerializablePath, Float> pair, Player player) {
        return new ItemBuilder(Material.DIRT_PATH).addLore(pair != null && pair.getKey() != null && ((Path.SerializablePath)pair.getKey()).toPath().getName() != null ? LocalizationManager.get(player, "actions.path.value.name", ((Path.SerializablePath)pair.getKey()).toPath().getName()) : LocalizationManager.get(player, "actions.path.value.name", LocalizationManager.get(player, "misc.not-set", new Object[0]))).addLore(pair != null && pair.getRight() != null ? LocalizationManager.get(player, "actions.path.value.speed", ((Float)pair.getRight()).toString()) : LocalizationManager.get(player, "actions.path.value.speed", LocalizationManager.get(player, "misc.not-set", new Object[0])));
    }

    @Override
    Pair<Path.SerializablePath, Float> getClickAction(final Pair<Path.SerializablePath, Float> currentPair, final NpcClickActionImpl.PluginActionOptions.PluginActionData data) {
        final Path currentPath = currentPair == null ? null : ((Path.SerializablePath)currentPair.getKey()).toPath();
        Player player = (Player)data.event().getWhoClicked();
        player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
        data.event().getWhoClicked().closeInventory();
        ConversationManager conversation = new ConversationManager((Plugin)NpcPlugin.plugin).withEscapeSequence(LocalizationManager.getAsString(player, "actions.path.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(event -> {
            Player p = event.player();
            if (!event.gracefulExit()) {
                p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                if ("timeout".equals(event.reason())) {
                    LocalizedMessage.sendMessage(p, "actions.path.input.timeout", true, NpcApi.config.inputTime());
                } else {
                    LocalizedMessage.sendMessage(p, "actions.path.input.cancelled", true, new Object[0]);
                }
            }
            Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> p.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), p, data.withTeleport())));
        });
        ConversationManager.Prompt firstPrompt = new ConversationManager.Prompt(){

            @Override
            public Component getPromptText(Player p) {
                TextComponent finalComponent = Component.empty();
                if (currentPath != null && currentPath.getName() != null && !currentPath.asLocations().isEmpty()) {
                    finalComponent = LocalizationManager.get(p, "actions.path.input.edit.text.1", new Object[0]).color((TextColor)NamedTextColor.GREEN).decorate(TextDecoration.ITALIC).clickEvent(ClickEvent.suggestCommand((String)currentPath.getName())).hoverEvent((HoverEventSource)HoverEvent.showText((Component)LocalizationManager.get(p, "actions.path.input.edit.hover.1", new Object[0]).color((TextColor)NamedTextColor.GRAY).decorate(TextDecoration.ITALIC)));
                }
                return Prefix.PREFIX.append(LocalizationManager.get(p, "actions.path.input.prompt.1", new Object[0])).appendNewline().append((Component)finalComponent);
            }

            @Override
            public ConversationManager.Prompt onInput(final Player p, final String input) {
                if (input == null || input.trim().isEmpty()) {
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(p, "actions.path.input.empty.1", true, new Object[0]);
                    return this;
                }
                Optional<Path> newPathOpt = PathManager.getInstance(p).getPath(input);
                if (newPathOpt.isEmpty()) {
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(p, "command.path.not-exists", true, input);
                    return this;
                }
                final Path newPath = newPathOpt.get();
                if (!newPath.asLocations().getFirst().getWorld().equals((Object)data.npc().getLocation().getWorld())) {
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(p, "actions.path.other-world", true, new Object[0]);
                    return this;
                }
                return new ConversationManager.Prompt(){

                    @Override
                    public Component getPromptText(Player p2) {
                        TextComponent finalComponent = Component.empty();
                        if (currentPair != null && currentPair.getRight() != null && ((Float)currentPair.getRight()).floatValue() >= 0.1f) {
                            finalComponent = LocalizationManager.get(p2, "actions.path.input.edit.text.2", new Object[0]).color((TextColor)NamedTextColor.GREEN).decorate(TextDecoration.ITALIC).clickEvent(ClickEvent.suggestCommand((String)String.valueOf(currentPair.getRight()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)LocalizationManager.get(p2, "actions.path.input.edit.hover.2", new Object[0]).color((TextColor)NamedTextColor.GRAY).decorate(TextDecoration.ITALIC)));
                        }
                        return Prefix.PREFIX.append(LocalizationManager.get(p, "actions.path.input.prompt.2", new Object[0])).appendNewline().append((Component)finalComponent);
                    }

                    @Override
                    public ConversationManager.Prompt onInput(Player p2, String input2) {
                        float speed;
                        if (input2 == null || input2.trim().isEmpty()) {
                            p2.playSound(p2.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                            LocalizedMessage.sendMessage(p2, "actions.path.input.empty.2", true, new Object[0]);
                            return this;
                        }
                        try {
                            speed = Float.parseFloat(input2);
                            if (speed < 0.1f || speed > 1.0f) {
                                p2.playSound(p2.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                                LocalizedMessage.sendMessage(p2, "actions.path.input.speed.invalid", true, new Object[0]);
                                return this;
                            }
                        }
                        catch (NumberFormatException e) {
                            p2.playSound(p2.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                            LocalizedMessage.sendMessage(p2, "actions.path.input.speed.invalid", true, new Object[0]);
                            return this;
                        }
                        LocalizedMessage.sendMessage(p2, "actions.path.creating", true, input);
                        ((CompletableFuture)PathfindingUtils.findPathAsync(List.of(data.npc().getLocation().clone().subtract(0.0, 1.0, 0.0), newPath.asLocations().getFirst().clone().subtract(0.0, 1.0, 0.0)), 10000, true, null).thenAccept(path -> {
                            Path finalPath = new Path(Stream.concat(path.asLocations().stream(), newPath.asLocations().stream()).toList(), null);
                            finalPath.setName(input);
                            data.actionInstance().param = (Serializable)Var.unsafeCast(new MutablePair((Object)finalPath.toSerializablePath(), (Object)Float.valueOf(speed)));
                            data.npc().markChange();
                            p2.playSound(p2.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                            LocalizedMessage.sendMessage(p2, "actions.path.set", true, input, input2);
                        })).exceptionally(t -> {
                            t.printStackTrace();
                            LocalizedMessage.sendMessage(p2, "actions.path.failed", true, input);
                            return null;
                        });
                        return null;
                    }
                };
            }
        };
        conversation.startConversation(player, firstPrompt);
        return currentPair;
    }
}

