/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils.builder;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import de.eisi05.npc.plugin.utils.builder.SkullBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InventoryBuilder
implements InventoryHolder {
    private final Inventory inventory;

    public InventoryBuilder(int size, Component name) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)name);
    }

    public InventoryBuilder(InventoryHolder holder, int size, Component name) {
        this.inventory = Bukkit.createInventory((InventoryHolder)holder, (int)size, (Component)name);
    }

    public InventoryBuilder(InventoryHolder holder, InventoryType type, Component name) {
        this.inventory = Bukkit.createInventory((InventoryHolder)holder, (InventoryType)type, (Component)name);
    }

    public InventoryBuilder(InventoryType type, Component name) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (InventoryType)type, (Component)name);
    }

    public InventoryBuilder(Inventory inventory) {
        this.inventory = inventory;
    }

    public InventoryBuilder(InventoryView inventory) {
        this.inventory = inventory.getTopInventory();
    }

    public InventoryBuilder fillOut() {
        return this.fillOut(event -> event.setCancelled(true));
    }

    public InventoryBuilder fillOut(Consumer<InventoryClickEvent> event) {
        return this.replace((ItemStack)null, ItemBuilder.PLACEHOLDER.setClickHandler(event).build());
    }

    public InventoryBuilder fill(int first, int last, Material material) {
        return this.fill(first, last, new ItemStack(material));
    }

    public InventoryBuilder fill(int first, int last, ItemStack item) {
        while (first <= last) {
            this.inventory.setItem(first, item);
            ++first;
        }
        return this;
    }

    public InventoryBuilder setItem(int i, ItemStack item) {
        if (i < 0) {
            i = this.inventory.getSize() + i;
        }
        this.inventory.setItem(i, item);
        return this;
    }

    public InventoryBuilder setItem(int i, Material material) {
        return this.setItem(i, new ItemStack(material));
    }

    public InventoryBuilder setItemIfEmpty(int i, Material material) {
        return this.setItemIfEmpty(i, new ItemStack(material));
    }

    public InventoryBuilder setItemIfEmpty(int i, ItemStack item) {
        if (this.inventory.getItem(i) != null) {
            return this;
        }
        if (i < 0) {
            i = this.inventory.getSize() + i;
        }
        this.inventory.setItem(i, item);
        return this;
    }

    public InventoryBuilder splitItem(Material material, int ... ints) {
        return this.splitItem(new ItemStack(material), ints);
    }

    public InventoryBuilder splitItem(ItemStack item, int ... ints) {
        for (int i : ints) {
            this.inventory.setItem(i, item);
        }
        return this;
    }

    public InventoryBuilder splitItem(ItemStack item, List<Integer> list) {
        for (int i : list) {
            this.inventory.setItem(i, item);
        }
        return this;
    }

    public InventoryBuilder replace(Material m1, Material m2) {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i).getType() != m1) continue;
            this.setItem(i, m2);
        }
        return this;
    }

    public InventoryBuilder replace(ItemStack i1, ItemStack i2) {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) == null) {
                if (i1 != null) continue;
                this.setItem(i, i2);
                continue;
            }
            if (!this.inventory.getItem(i).isSimilar(i1)) continue;
            this.setItem(i, i2);
        }
        return this;
    }

    public InventoryBuilder replace(ItemStack i1, Material m2) {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) != i1) continue;
            this.setItem(i, m2);
        }
        return this;
    }

    public InventoryBuilder replace(Material m1, ItemStack i2) {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i).getType() != m1) continue;
            this.setItem(i, i2);
        }
        return this;
    }

    public InventoryBuilder addItem(ItemStack item) {
        this.inventory.addItem(new ItemStack[]{item});
        return this;
    }

    public InventoryBuilder addItem(Material material) {
        return this.addItem(new ItemStack(material));
    }

    public InventoryBuilder addItems(ItemStack ... items) {
        this.inventory.addItem(items);
        return this;
    }

    public InventoryBuilder addItems(Material ... materials) {
        for (Material material : materials) {
            this.addItem(material);
        }
        return this;
    }

    public InventoryBuilder addItems(List<ItemStack> items) {
        for (ItemStack item : items) {
            this.addItem(item);
        }
        return this;
    }

    public InventoryBuilder setArrowRight(Component name, Consumer<InventoryClickEvent> event) {
        this.inventory.setItem(this.inventory.getSize() - 1, PageIcon.right(name).setClickHandler(event).build());
        return this;
    }

    public InventoryBuilder setArrowLeft(Component name, Consumer<InventoryClickEvent> event) {
        this.inventory.setItem(this.inventory.getSize() - 9, PageIcon.left(name).setClickHandler(event).build());
        return this;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public Inventory build() {
        return this.inventory;
    }

    public void open(HumanEntity player) {
        player.openInventory(this.inventory);
    }

    public void open(HumanEntity player, Animation animation) {
        if (this.inventory.getType() != InventoryType.CHEST) {
            this.open(player);
            return;
        }
        if (animation.count == animation.type.getMaxCount(this.inventory)) {
            return;
        }
        if (animation.original == null) {
            animation.original = (ItemStack[])this.inventory.getContents().clone();
            this.fill(0, this.inventory.getSize() - 1, (ItemStack)null);
            player.openInventory(this.inventory);
        }
        for (int i : animation.type.getSlots(animation.count, this.inventory)) {
            this.inventory.setItem(i, animation.original[i]);
        }
        if (animation.sound != null && player instanceof Player) {
            Player player1 = (Player)player;
            if (animation.count != -1) {
                player1.playSound(player1.getLocation(), animation.sound, 100.0f, 1.0f);
            }
        }
        Bukkit.getScheduler().runTaskLater(NpcApi.plugin, () -> {
            ++animation.count;
            this.open(player, animation);
        }, (long)animation.speed);
    }

    public static interface PageIcon {
        public static ItemBuilder left(Component name) {
            return SkullBuilder.skullFromId("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmQ2OWUwNmU1ZGFkZmQ4NGU1ZjNkMWMyMTA2M2YyNTUzYjJmYTk0NWVlMWQ0ZDcxNTJmZGM1NDI1YmMxMmE5In19fQ==").setName(name);
        }

        public static ItemBuilder right(Component name) {
            return SkullBuilder.skullFromId("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTliZjMyOTJlMTI2YTEwNWI1NGViYTcxM2FhMWIxNTJkNTQxYTFkODkzODgyOWM1NjM2NGQxNzhlZDIyYmYifX19").setName(name);
        }

        public static ItemBuilder down(Component name) {
            return SkullBuilder.skullFromId("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzQzNzM0NmQ4YmRhNzhkNTI1ZDE5ZjU0MGE5NWU0ZTc5ZGFlZGE3OTVjYmM1YTEzMjU2MjM2MzEyY2YifX19").setName(name);
        }

        public static ItemBuilder up(Component name) {
            return SkullBuilder.skullFromId("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzA0MGZlODM2YTZjMmZiZDJjN2E5YzhlYzZiZTUxNzRmZGRmMWFjMjBmNTVlMzY2MTU2ZmE1ZjcxMmUxMCJ9fX0=").setName(name);
        }
    }

    public static class Animation {
        private final AnimationType type;
        private final int speed;
        private final Sound sound;
        private int count;
        private ItemStack[] original;

        public Animation(AnimationType type, int speed) {
            this(type, speed, null);
        }

        public Animation(AnimationType type, int speed, int startCount) {
            this(type, speed, startCount, null);
        }

        public Animation(AnimationType type, int speed, Sound sound) {
            this(type, speed, -1, sound);
        }

        public Animation(AnimationType type, int speed, int startCount, Sound sound) {
            this.type = type;
            this.speed = speed;
            this.count = startCount;
            this.sound = sound;
        }
    }

    public static enum AnimationType {
        RIGHT{

            @Override
            List<Integer> getSlots(int count, Inventory inventory) {
                if (count == -1) {
                    return new ArrayList<Integer>();
                }
                List<Integer> slots = this.getSlots(count - 1, inventory);
                for (int i = 0; i < inventory.getSize(); ++i) {
                    if ((i + 10 + count) % 9 != 0) continue;
                    slots.add(i);
                }
                return slots;
            }

            @Override
            int getMaxCount(Inventory inventory) {
                return 9;
            }
        }
        ,
        LEFT{

            @Override
            List<Integer> getSlots(int count, Inventory inventory) {
                if (count == -1) {
                    return new ArrayList<Integer>();
                }
                List<Integer> slots = this.getSlots(count - 1, inventory);
                for (int i = 0; i < inventory.getSize(); ++i) {
                    if ((i + 9 - count) % 9 != 0) continue;
                    slots.add(i);
                }
                return slots;
            }

            @Override
            int getMaxCount(Inventory inventory) {
                return 9;
            }
        }
        ,
        DOWN{

            @Override
            List<Integer> getSlots(int count, Inventory inventory) {
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int i = 0; i < inventory.getSize(); ++i) {
                    if (inventory.getSize() - (count + 1) * 9 > i) continue;
                    slots.add(i);
                }
                return slots;
            }

            @Override
            int getMaxCount(Inventory inventory) {
                return inventory.getSize() / 9;
            }
        }
        ,
        UP{

            @Override
            List<Integer> getSlots(int count, Inventory inventory) {
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int i = 0; i < inventory.getSize(); ++i) {
                    if ((count + 1) * 9 <= i) continue;
                    slots.add(i);
                }
                return slots;
            }

            @Override
            int getMaxCount(Inventory inventory) {
                return inventory.getSize() / 9;
            }
        };


        abstract List<Integer> getSlots(int var1, Inventory var2);

        abstract int getMaxCount(Inventory var1);
    }
}

