/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.manager;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class LocalizationManager {
    private static final String defaultLang = "en";
    private static final Map<String, Map<String, YamlConfiguration>> languages = new HashMap<String, Map<String, YamlConfiguration>>();

    public static void loadLanguages(JavaPlugin plugin) {
        File[] files;
        File langFolder;
        block15: {
            languages.clear();
            langFolder = new File(plugin.getDataFolder(), "lang");
            if (!langFolder.exists()) {
                try {
                    String path = "lang/en/";
                    URL dirURL = plugin.getClass().getClassLoader().getResource(path);
                    if (dirURL == null || !dirURL.getProtocol().equals("jar")) break block15;
                    String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                    try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8));){
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String name2 = entry.getName();
                            if (!name2.startsWith(path) || entry.isDirectory()) continue;
                            plugin.saveResource(name2, false);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((files = langFolder.listFiles()) == null) {
            return;
        }
        for (File langDir : files) {
            if (!langDir.isDirectory()) continue;
            String langCode = langDir.getName();
            HashMap<String, YamlConfiguration> typeMap = new HashMap<String, YamlConfiguration>();
            for (File subFile : Objects.requireNonNull(langDir.listFiles((d, name) -> name.endsWith(".yml")))) {
                String type = subFile.getName().substring(0, subFile.getName().length() - 4);
                YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)subFile);
                plugin.saveResource("lang/" + langCode + "/" + subFile.getName(), true);
                YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)subFile);
                for (String key : userConfig.getKeys(true)) {
                    newConfig.set(key, userConfig.get(key));
                }
                try {
                    newConfig.save(subFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                typeMap.put(type, newConfig);
            }
            languages.put(langCode, typeMap);
        }
    }

    public static String get(Player player, String key, Object ... replacements) {
        if (player == null) {
            return LocalizationManager.get(defaultLang, key, replacements);
        }
        return LocalizationManager.get(player.getLocale().split("_")[0], key, replacements);
    }

    public static String get(String lang, String key, Object ... replacements) {
        Map<String, YamlConfiguration> map = languages.getOrDefault(lang, languages.get(defaultLang));
        String[] keys = key.split("\\.");
        if (keys.length < 2) {
            return key;
        }
        String type = keys[0];
        String path = String.join((CharSequence)".", Arrays.copyOfRange(keys, 1, keys.length));
        YamlConfiguration config = map.getOrDefault(type, languages.get(defaultLang).get(type));
        if (config == null) {
            return key;
        }
        String message = config.getString(path, key);
        for (int i = 0; i < replacements.length; ++i) {
            message = message.replace("{" + i + "}", String.valueOf(replacements[i]));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message).replace("\\$", "&");
    }
}

