/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.utils;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.utils.exceptions.VersionNotFound;
import de.eisi05.npc.api.wrapper.Mapping;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public enum Versions {
    NONE(""),
    V1_17("v1_17_R1"),
    V1_18("v1_18_R1"),
    V1_18_2("v1_18_R2"),
    V1_19("v1_19_R1"),
    V1_19_1("v1_19_R1"),
    V1_19_3("v1_19_R2"),
    V1_19_4("v1_19_R3"),
    V1_20("v1_20_R1"),
    V1_20_2("v1_20_R2"),
    V1_20_4("v1_20_R3"),
    V1_20_6("v1_20_R4"),
    V1_21("v1_21_R1"),
    V1_21_2("v1_21_R2"),
    V1_21_4("v1_21_R3"),
    V1_21_5("v1_21_R4"),
    V1_21_6("v1_21_R5"),
    V1_21_9("v1_21_R6"),
    V1_21_11("v1_21_R7");

    private static Versions VERSION;
    private final String path;

    private Versions(String path) {
        this.path = path;
    }

    @NotNull
    public static Versions getVersion() {
        if (VERSION != null) {
            return VERSION;
        }
        String nmsVersion = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        VERSION = Arrays.stream(Versions.values()).filter(v -> v.path.equalsIgnoreCase(nmsVersion)).reduce((a, b) -> Bukkit.getBukkitVersion().startsWith("1.19.1") ? V1_19_1 : V1_19).orElseThrow(() -> {
            Bukkit.getPluginManager().disablePlugin(NpcApi.plugin);
            return new VersionNotFound(nmsVersion);
        });
        return VERSION;
    }

    @NotNull
    private static Versions[] getVersionBetween(@NotNull Versions versions1, @NotNull Versions versions2) {
        return (Versions[])Arrays.stream(Versions.values()).filter(v -> v != NONE).filter(v -> v.ordinal() >= versions1.ordinal() && v.ordinal() <= versions2.ordinal()).toArray(Versions[]::new);
    }

    public static boolean isCurrentVersionSmallerThan(@NotNull Versions versions) {
        return Versions.getVersion().ordinal() < versions.ordinal();
    }

    public static boolean containsCurrentVersion(@NotNull Mapping mapping) {
        if (mapping.fixed().value() != NONE) {
            return mapping.fixed().value() == Versions.getVersion();
        }
        return Arrays.stream(Versions.getVersionBetween(mapping.range().from(), mapping.range().to())).anyMatch(v -> v == Versions.getVersion());
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public String getName() {
        return this.name().replace("_", ".");
    }
}

