/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.wrapper.objects;

import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.Mapping;
import de.eisi05.npc.api.wrapper.Wrapper;
import de.eisi05.npc.api.wrapper.enums.ChatFormat;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="net.minecraft.network.chat.IChatBaseComponent")
public class WrappedComponent
extends Wrapper {
    private WrappedComponent(Object handle) {
        super(handle);
    }

    public static WrappedComponent fromHandle(@Nullable Object handle) {
        return new WrappedComponent(handle);
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="a")
    @NotNull
    public static @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="a") @NotNull WrappedComponent create(@Nullable String text) {
        return new WrappedComponent(text == null ? CommonComponents.EMPTY : WrappedComponent.invokeStaticWrappedMethod(text));
    }

    @NotNull
    public static WrappedComponent parseFromLegacy(@Nullable String legacy) {
        if (legacy == null || legacy.isEmpty()) {
            return WrappedComponent.create(null);
        }
        return Var.fromString(legacy);
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="a")
    @NotNull
    public @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="a") @NotNull WrappedComponent setFormats(ChatFormat ... format) {
        if (format.length == 0) {
            return this;
        }
        try {
            Method[] methods = this.getHandle().getClass().getMethods();
            String path = this.getPath();
            Method target = Arrays.stream(methods).filter(m -> m.getName().equals(path)).filter(Method::isVarArgs).filter(method -> method.getParameterTypes()[0].isArray()).filter(method -> method.getParameterTypes()[0].componentType().equals(format[0].getHandle().getClass())).findFirst().orElseThrow();
            target.invoke(this.getHandle(), new Object[]{Arrays.stream(format).map(ChatFormat::getHandle).toArray(i -> (Object[])Array.newInstance(format[0].getHandle().getClass(), i))});
        }
        catch (IllegalAccessException | InvocationTargetException | NoSuchElementException exception) {
            // empty catch block
        }
        return this;
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_11), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="format")})
    @NotNull
    public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_11), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="format")}) @NotNull WrappedComponent withClickEvent(@NotNull ClickEvent clickEvent) {
        this.invokeWrappedMethod(o -> new Style(o).withClickEvent(clickEvent).getHandle());
        return this;
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_11), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="format")})
    @NotNull
    public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_11), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="format")}) @NotNull WrappedComponent withHoverEvent(@NotNull HoverEvent hoverEvent) {
        this.invokeWrappedMethod(o -> new Style(o).withHoverEvent(hoverEvent).getHandle());
        return this;
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_19_1, to=Versions.V1_21_11), path="b"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_19), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="addSibling")})
    @NotNull
    public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_19_1, to=Versions.V1_21_11), path="b"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_19), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="addSibling")}) @NotNull WrappedComponent append(WrappedComponent wrappedComponent) {
        this.invokeWrappedMethod(wrappedComponent);
        return this;
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_20_4, to=Versions.V1_21_11), path="f"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_20_2), path="e"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="mutableCopy")})
    @NotNull
    public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_20_4, to=Versions.V1_21_11), path="f"), @Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_20_2), path="e"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="mutableCopy")}) @NotNull WrappedComponent copy() {
        return new WrappedComponent(this.invokeWrappedMethod(new Object[0]));
    }

    @NotNull
    public String toLegacy(boolean withLineBreak) {
        return withLineBreak ? Var.toString(this) : Var.toString(this).replace("\n", "\\n");
    }

    @NotNull
    public String toLegacyNoColor(boolean withLineBreak) {
        return ChatColor.stripColor((String)this.toLegacy(withLineBreak));
    }

    @NotNull
    public SerializedComponent serialize() {
        return new SerializedComponent(this.toLegacy(true));
    }

    @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_19, to=Versions.V1_21_11), path="net.minecraft.network.chat.CommonComponents"), @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_18_2), path="net.minecraft.network.chat.ChatComponentText")})
    private static class CommonComponents
    extends Wrapper {
        @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_19, to=Versions.V1_21_11), path="a"), @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_18_2), path="d")})
        private static final @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_19, to=Versions.V1_21_11), path="a"), @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_18_2), path="d")}) Object EMPTY = CommonComponents.getStaticWrappedFieldValue("EMPTY").orElse(null);

        private CommonComponents() {
            super(null);
        }
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatClickable")
    public static class ClickEvent
    extends Wrapper {
        private ClickEvent(Object handle) {
            super(handle);
        }

        @NotNull
        public static ClickEvent create(@NotNull ClickAction action, @NotNull Object value) {
            if (Versions.isCurrentVersionSmallerThan(Versions.V1_21_5)) {
                return ClickEvent.createWrappedInstance(ClickEvent.class, action, value);
            }
            return action.function.apply(value);
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatClickable$EnumClickAction")
        public static enum ClickAction implements Wrapper.EnumWrapper
        {
            OPEN_URL(o -> new OpenUrl((URI)o)),
            OPEN_FILE(o -> new OpenFile((String)o)),
            RUN_COMMAND(o -> new RunCommand((String)o)),
            SUGGEST_COMMAND(o -> new SuggestCommand((String)o)),
            SHOW_DIALOG(ShowDialog::new),
            CHANGE_PAGE(o -> new ChangePage((Integer)o)),
            COPY_TO_CLIPBOARD(o -> new CopyToClipboard((String)o)),
            CUSTOM(o -> new Custom(((Object[])o)[0], (Optional)((Object[])o)[1]));

            private final Function<Object, ClickEvent> function;

            private ClickAction(Function<Object, ClickEvent> function) {
                this.function = function;
            }

            @Override
            @NotNull
            public Object getHandle() {
                return this.cast(this);
            }
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_21_6, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatClickable$d")
        private static class Custom
        extends ClickEvent {
            private Custom(Object key, Optional<?> optionalNbtBase) {
                super(Custom.createInstance(ShowDialog.class, key, optionalNbtBase));
            }
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_21_6, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatClickable$h")
        private static class ShowDialog
        extends ClickEvent {
            private ShowDialog(Object dialogHolder) {
                super(ShowDialog.createInstance(ShowDialog.class, dialogHolder));
            }
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_21_5, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatClickable$CopyToClipboard")
        private static class CopyToClipboard
        extends ClickEvent {
            private CopyToClipboard(String string) {
                super(CopyToClipboard.createInstance(CopyToClipboard.class, string));
            }
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_21_5, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatClickable$ChangePage")
        private static class ChangePage
        extends ClickEvent {
            private ChangePage(int page) {
                super(ChangePage.createInstance(ChangePage.class, page));
            }
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_21_5, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatClickable$SuggestCommand")
        private static class SuggestCommand
        extends ClickEvent {
            private SuggestCommand(String command) {
                super(SuggestCommand.createInstance(SuggestCommand.class, command));
            }
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_21_5, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatClickable$RunCommand")
        private static class RunCommand
        extends ClickEvent {
            private RunCommand(String command) {
                super(RunCommand.createInstance(RunCommand.class, command));
            }
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_21_5, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatClickable$OpenFile")
        private static class OpenFile
        extends ClickEvent {
            private OpenFile(String file) {
                super(OpenFile.createInstance(OpenFile.class, file));
            }
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_21_5, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatClickable$OpenUrl")
        private static class OpenUrl
        extends ClickEvent {
            private OpenUrl(URI url) {
                super(OpenUrl.createInstance(OpenUrl.class, url));
            }
        }
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatHoverable")
    public static class HoverEvent
    extends Wrapper {
        private HoverEvent(Object handle) {
            super(handle);
        }

        public static HoverEvent create(@NotNull WrappedComponent component) {
            if (Versions.isCurrentVersionSmallerThan(Versions.V1_21_5)) {
                return HoverEvent.createWrappedInstance(HoverEvent.class, HoverAction.SHOW_TEXT, component);
            }
            return new ShowText(component);
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatHoverable$EnumHoverAction")
        private static class HoverAction
        extends Wrapper {
            @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="a")
            private static final @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="a") Object SHOW_TEXT = HoverAction.getStaticWrappedFieldValue("SHOW_TEXT").orElse(null);

            private HoverAction() {
                super(null);
            }
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_21_5, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatHoverable$e")
        private static class ShowText
        extends HoverEvent {
            private ShowText(@NotNull WrappedComponent component) {
                super(ShowText.createInstance(ShowText.class, component));
            }
        }
    }

    public static class SerializedComponent
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String text;

        public SerializedComponent(@Nullable String text) {
            this.text = text;
        }

        @NotNull
        public WrappedComponent deserialize() {
            return WrappedComponent.parseFromLegacy(this.text);
        }
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="net.minecraft.network.chat.ChatModifier")
    public static class Style
    extends Wrapper {
        private Style(Object handle) {
            super(handle);
        }

        @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_11), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="setChatClickable")})
        @NotNull
        public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_11), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="setChatClickable")}) @NotNull Style withClickEvent(@NotNull ClickEvent clickEvent) {
            return new Style(this.invokeWrappedMethod(clickEvent));
        }

        @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_11), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="setChatHoverable")})
        @NotNull
        public @Mapping.WrapList(value={@Mapping(range=@Mapping.Range(from=Versions.V1_18, to=Versions.V1_21_11), path="a"), @Mapping(fixed=@Mapping.Fixed(value=Versions.V1_17), path="setChatHoverable")}) @NotNull Style withHoverEvent(@NotNull HoverEvent hoverEvent) {
            return new Style(this.invokeWrappedMethod(hoverEvent));
        }
    }
}

