/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.wrapper.objects;

import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.Mapping;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import de.eisi05.npc.api.wrapper.objects.WrappedEntity;
import de.eisi05.npc.api.wrapper.objects.WrappedEntityData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.joml.Vector3f;

@Mapping(range=@Mapping.Range(from=Versions.V1_19_4, to=Versions.V1_21_11), path="net.minecraft.world.entity.Display$TextDisplay")
public class WrappedTextDisplay
extends WrappedEntity.WrappedNameTag<Entity> {
    private static final boolean flag = Versions.isCurrentVersionSmallerThan(Versions.V1_20_2);
    private final Map<WrappedEntityData.EntityDataAccessor<?>, Object> dataMap = new LinkedHashMap();

    protected WrappedTextDisplay(Object handle) {
        super(handle);
    }

    public static WrappedTextDisplay create(World world) {
        return new WrappedTextDisplay(WrappedTextDisplay.createInstance(WrappedTextDisplay.class, WrappedEntity.EntityTypes.TEXT_DISPLAY, Reflections.invokeMethod(world, "getHandle", new Object[0]).get()));
    }

    private <T> WrappedTextDisplay set(WrappedEntityData.EntityDataAccessor<T> accessor, T value) {
        this.dataMap.put(accessor, value);
        return this;
    }

    public WrappedTextDisplay translation(float x, float y, float z) {
        return this.set(WrappedEntityData.EntityDataSerializers.VECTOR3.create(flag ? 10 : 11), new Vector3f(x, y, z));
    }

    public WrappedTextDisplay scale(float x, float y, float z) {
        return this.set(WrappedEntityData.EntityDataSerializers.VECTOR3.create(flag ? 11 : 12), new Vector3f(x, y, z));
    }

    public WrappedTextDisplay billboardConstraints(BillboardConstraints constraints) {
        return this.set(WrappedEntityData.EntityDataSerializers.BYTE.create(flag ? 14 : 15), (byte)constraints.ordinal());
    }

    public WrappedTextDisplay brightnessOverride(int brightness) {
        return this.set(WrappedEntityData.EntityDataSerializers.INT.create(flag ? 15 : 16), brightness);
    }

    public WrappedTextDisplay viewRange(float range) {
        return this.set(WrappedEntityData.EntityDataSerializers.FLOAT.create(flag ? 16 : 17), Float.valueOf(range));
    }

    public WrappedTextDisplay shadowRadius(float radius) {
        return this.set(WrappedEntityData.EntityDataSerializers.FLOAT.create(flag ? 17 : 18), Float.valueOf(radius));
    }

    public WrappedTextDisplay shadowStrength(float strength) {
        return this.set(WrappedEntityData.EntityDataSerializers.FLOAT.create(flag ? 18 : 19), Float.valueOf(strength));
    }

    public WrappedTextDisplay width(float width) {
        return this.set(WrappedEntityData.EntityDataSerializers.FLOAT.create(flag ? 19 : 20), Float.valueOf(width));
    }

    public WrappedTextDisplay height(float height) {
        return this.set(WrappedEntityData.EntityDataSerializers.FLOAT.create(flag ? 20 : 21), Float.valueOf(height));
    }

    public WrappedTextDisplay glowColorOverride(int color) {
        return this.set(WrappedEntityData.EntityDataSerializers.INT.create(flag ? 21 : 22), color);
    }

    public WrappedTextDisplay lineWidth(int width) {
        return this.set(WrappedEntityData.EntityDataSerializers.INT.create(flag ? 23 : 24), width);
    }

    public WrappedTextDisplay backgroundColor(int color) {
        return this.set(WrappedEntityData.EntityDataSerializers.INT.create(flag ? 24 : 25), color);
    }

    public WrappedTextDisplay textOpacity(byte opacity) {
        return this.set(WrappedEntityData.EntityDataSerializers.BYTE.create(flag ? 25 : 26), opacity);
    }

    public WrappedTextDisplay flags(TextDisplayFlags ... flags) {
        return this.set(WrappedEntityData.EntityDataSerializers.BYTE.create(flag ? 26 : 27), TextDisplayFlags.combineFlags(flags));
    }

    @Override
    public WrappedEntityData applyData(WrappedComponent component) {
        WrappedEntityData data = this.getEntityData();
        data.set(WrappedEntityData.EntityDataSerializers.OPTIONAL_CHAT_COMPONENT.create(2), Optional.of(component.getHandle()));
        data.set(WrappedEntityData.EntityDataSerializers.BOOLEAN.create(4), true);
        this.translation(0.0f, 0.25f, 0.0f);
        this.billboardConstraints(BillboardConstraints.CENTER);
        data.set(WrappedEntityData.EntityDataSerializers.CHAT_COMPONENT.create(flag ? 22 : 23), Var.unsafeCast(component.getHandle()));
        this.dataMap.forEach((accessor, value) -> data.set(accessor, Var.unsafeCast(value)));
        return data;
    }

    public static enum BillboardConstraints {
        FIXED,
        VERTICAL,
        HORIZONTAL,
        CENTER;

    }

    public static enum TextDisplayFlags {
        NONE(0),
        HAS_SHADOW(1),
        IS_SEE_THROUGH(2),
        USE_DEFAULT_BACKGROUND_COLOR(4),
        CENTER_ALIGNMENT(0),
        LEFT_ALIGNMENT(1),
        RIGHT_ALIGNMENT(2);

        private final byte flag;

        private TextDisplayFlags(byte flag) {
            this.flag = flag;
        }

        public static byte combineFlags(TextDisplayFlags ... flags) {
            byte result = 0;
            for (TextDisplayFlags flag : flags) {
                result = (byte)(result | flag.flag);
            }
            return result;
        }
    }
}

