/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.objects;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.eisi05.dialogMenu.DialogMenu;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.enums.ChatFormat;
import de.eisi05.npc.api.wrapper.objects.WrappedCommandSourceStack;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.gui.NpcGUI;
import de.eisi05.npc.plugin.manager.CommandManager;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.objects.AbstractPluginActionOption;
import de.eisi05.npc.plugin.objects.NpcClickActionImpl;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import de.eisi05.npc.plugin.utils.Prefix;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.io.Serializable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.InactivityConversationCanceller;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandActionOption
extends AbstractPluginActionOption<String> {
    private static final long serialVersionUID = 1L;

    private CommandActionOption() {
    }

    @NotNull
    static NpcClickActionImpl.PluginActionOptions<String> getCommandAction() {
        return CommandActionOption.getOption(CommandActionOption.class, CommandActionOption::new);
    }

    @Override
    String getName() {
        return "command";
    }

    @Override
    String getDefaultValue() {
        return null;
    }

    @Override
    NpcClickAction getAction(String s) {
        return event -> {
            block15: {
                if (s == null || s.isBlank()) {
                    return;
                }
                String commandToExecute = s.startsWith("/") ? s.substring(1) : s;
                try {
                    CommandManager.DISPATCHER.execute(commandToExecute, WrappedServerPlayer.fromPlayer(event.getPlayer()).createCommandStack().withMaximumPermission().withSuppressedOutput().getHandle());
                }
                catch (CommandSyntaxException e) {
                    boolean isOp = event.getPlayer().isOp();
                    PermissionAttachment attachment = null;
                    try {
                        String[] split = commandToExecute.split(" ");
                        PluginCommand command = Bukkit.getPluginCommand((String)split[0]);
                        if (command != null && command.getPermission() != null && !isOp) {
                            boolean hasPermission = event.getPlayer().hasPermission(command.getPermission());
                            if (!hasPermission) {
                                attachment = event.getPlayer().addAttachment((Plugin)NpcPlugin.plugin, command.getPermission(), true);
                                Bukkit.dispatchCommand((CommandSender)event.getPlayer(), (String)commandToExecute);
                                event.getPlayer().removeAttachment(attachment);
                            } else {
                                Bukkit.dispatchCommand((CommandSender)event.getPlayer(), (String)commandToExecute);
                            }
                        } else {
                            event.getPlayer().setOp(true);
                            Bukkit.dispatchCommand((CommandSender)event.getPlayer(), (String)commandToExecute);
                        }
                    }
                    catch (CommandException ex) {
                        if (event.getPlayer().hasPermission("npc.admin")) {
                            LocalizedMessage.sendMessage(event.getPlayer(), "actions.command.error.known", true, e.getMessage());
                        }
                    }
                    finally {
                        event.getPlayer().setOp(isOp);
                        if (attachment != null) {
                            event.getPlayer().removeAttachment(attachment);
                        }
                    }
                }
                catch (Exception e) {
                    NpcPlugin.plugin.getLogger().warning("Error executing NPC command: " + s + " for player " + event.getPlayer().getName() + " - " + e.getMessage());
                    if (!event.getPlayer().hasPermission("npc.admin")) break block15;
                    LocalizedMessage.sendMessage(event.getPlayer(), "actions.command.error.unknown", true, new Object[0]);
                }
            }
        };
    }

    @Override
    ItemBuilder getIcon(String s, Player player) {
        return new ItemBuilder(Material.COMMAND_BLOCK).setLore(s == null || s.isEmpty() ? LocalizationManager.get(player, "actions.command.value.short", LocalizationManager.get(player, "misc.not-set", new Object[0])) : LocalizationManager.get(player, "actions.command.value." + (s.length() > 23 ? "long" : "short"), s.length() > 23 ? s.substring(0, 20) : s));
    }

    @Override
    String getClickAction(final String currentCommand, final NpcClickActionImpl.PluginActionOptions.PluginActionData data) {
        Player p = (Player)data.event().getWhoClicked();
        p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
        data.event().getWhoClicked().closeInventory();
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_6)) {
            DialogMenu.command(p, (Plugin)NpcPlugin.plugin, currentCommand, null, player -> player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport())), (player, s) -> {
                WrappedCommandSourceStack sourceStack;
                if (s == null || s.trim().isEmpty()) {
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(player, "actions.command.input.empty", true, new Object[0]);
                    player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                    return;
                }
                String processedInput = s.startsWith("/") ? s.substring(1) : s;
                ParseResults results = CommandManager.DISPATCHER.parse(processedInput, (sourceStack = WrappedServerPlayer.fromPlayer(player).createCommandStack()).getHandle());
                if (!results.getExceptions().isEmpty()) {
                    for (CommandSyntaxException e : results.getExceptions().values()) {
                        LocalizedMessage.sendMessage(player, "actions.command.error.syntax", true, e.getMessage());
                    }
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                    return;
                }
                if (results.getReader().canRead() && !NpcApi.config.avoidCommandCheck()) {
                    LocalizedMessage.sendMessage(player, "actions.command.error.arguments", true, results.getReader().getRemaining());
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
                    return;
                }
                data.actionInstance().param = (Serializable)Var.unsafeCast("/" + processedInput);
                data.npc().markChange();
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                LocalizedMessage.sendMessage(player, "actions.command.set", true, "/" + processedInput);
                player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport()));
            }, LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.command.input.prompt", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.command.input.edit.text", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "misc.ok", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "misc.back", new Object[0]), LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.command.title", new Object[0]));
            return currentCommand;
        }
        new ConversationManager((Plugin)NpcPlugin.plugin).withModality(false).withLocalEcho(false).withEscapeSequence(LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.command.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(abandonedEvent -> {
            Player player = (Player)abandonedEvent.getContext().getForWhom();
            if (!abandonedEvent.gracefulExit()) {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                ConversationContext context = abandonedEvent.getContext();
                if (!(abandonedEvent.getCanceller() instanceof InactivityConversationCanceller)) {
                    LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.command.input.cancelled", true, new Object[0]);
                } else {
                    LocalizedMessage.sendMessage((Player)context.getForWhom(), "actions.command.input.timeout", true, new Object[0]);
                }
            }
            Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> player.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), player, data.withTeleport())));
        }).withFirstPrompt(new Prompt(){

            public boolean blocksForInput(@NotNull ConversationContext context) {
                if (currentCommand == null || currentCommand.isEmpty()) {
                    return true;
                }
                WrappedServerPlayer.fromPlayer((Player)context.getForWhom()).sendRawMessage(WrappedComponent.parseFromLegacy(LocalizationManager.get((Player)context.getForWhom(), "actions.command.input.edit.text", new Object[0])).setFormats(ChatFormat.ITALIC, ChatFormat.GREEN).withClickEvent(WrappedComponent.ClickEvent.create(WrappedComponent.ClickEvent.ClickAction.SUGGEST_COMMAND, currentCommand.startsWith("/") ? currentCommand.substring(1) : currentCommand)).withHoverEvent(WrappedComponent.HoverEvent.create(WrappedComponent.create(LocalizationManager.get((Player)context.getForWhom(), "actions.command.input.edit.hover", new Object[0])).setFormats(ChatFormat.GRAY, ChatFormat.ITALIC))));
                return true;
            }

            @NotNull
            public String getPromptText(@NotNull ConversationContext context) {
                return Prefix.PREFIX + LocalizationManager.get((Player)context.getForWhom(), "actions.command.input.prompt", new Object[0]);
            }

            public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
                WrappedCommandSourceStack sourceStack;
                Player conversingPlayer = (Player)context.getForWhom();
                if (input == null || input.trim().isEmpty()) {
                    conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(conversingPlayer, "actions.command.input.empty", true, new Object[0]);
                    return this;
                }
                String processedInput = input.startsWith("/") ? input.substring(1) : input;
                ParseResults results = CommandManager.DISPATCHER.parse(processedInput, (sourceStack = WrappedServerPlayer.fromPlayer((Player)context.getForWhom()).createCommandStack()).getHandle());
                if (!results.getExceptions().isEmpty()) {
                    for (CommandSyntaxException e : results.getExceptions().values()) {
                        LocalizedMessage.sendMessage(conversingPlayer, "actions.command.error.syntax", true, e.getMessage());
                    }
                    conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    return this;
                }
                if (results.getReader().canRead() && !NpcApi.config.avoidCommandCheck()) {
                    LocalizedMessage.sendMessage(conversingPlayer, "actions.command.error.arguments", true, results.getReader().getRemaining());
                    conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    return this;
                }
                data.actionInstance().param = (Serializable)Var.unsafeCast("/" + processedInput);
                data.npc().markChange();
                conversingPlayer.playSound(conversingPlayer.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                LocalizedMessage.sendMessage(conversingPlayer, "actions.command.set", true, "/" + processedInput);
                return Prompt.END_OF_CONVERSATION;
            }
        }).buildConversation((Conversable)data.event().getWhoClicked()).begin();
        return currentCommand;
    }
}

