/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.objects;

import de.eisi05.npc.api.enums.ClickActionType;
import de.eisi05.npc.api.events.NpcInteractEvent;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.pathfinding.Path;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.wrapper.packets.AnimatePacket;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.objects.AbstractPluginActionOption;
import de.eisi05.npc.plugin.objects.AnimationActionOption;
import de.eisi05.npc.plugin.objects.CommandActionOption;
import de.eisi05.npc.plugin.objects.PathActionOption;
import de.eisi05.npc.plugin.objects.ServerActionOption;
import de.eisi05.npc.plugin.objects.WaitActionOption;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpcClickActionImpl
implements NpcClickAction {
    private static final long serialVersionUID = 1L;
    private final List<PluginAction<?>> actionListRight = new ArrayList();
    private final List<PluginAction<?>> actionListLeft = new ArrayList();

    public <T extends Serializable> NpcClickActionImpl add(@NotNull ClickActionType clickActionType, @NotNull PluginActionOptions<T> pluginActionOptions, @Nullable T param) {
        PluginAction<T> action = new PluginAction<T>(pluginActionOptions, param);
        if (clickActionType == ClickActionType.BOTH && !this.isBoth()) {
            this.actionListRight.clear();
            this.actionListLeft.clear();
        }
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.add(action);
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.add(action);
        }
        return this;
    }

    @Override
    public NpcClickAction copy() {
        NpcClickActionImpl copy = new NpcClickActionImpl();
        if (this.isBoth()) {
            List<PluginAction> copyList = this.actionListRight.stream().map(pluginAction -> new PluginAction((PluginActionOptions)Var.unsafeCast(pluginAction.option), pluginAction.param)).toList();
            copy.actionListRight.addAll(copyList);
            copy.actionListLeft.addAll(copyList);
            return copy;
        }
        List<PluginAction> copyRight = this.actionListRight.stream().map(pluginAction -> new PluginAction((PluginActionOptions)Var.unsafeCast(pluginAction.option), pluginAction.param)).toList();
        List<PluginAction> copyLeft = this.actionListLeft.stream().map(pluginAction -> new PluginAction((PluginActionOptions)Var.unsafeCast(pluginAction.option), pluginAction.param)).toList();
        copy.actionListRight.addAll(copyRight);
        copy.actionListLeft.addAll(copyLeft);
        return copy;
    }

    public <T extends Serializable> void insert(int index, @NotNull ClickActionType clickActionType, @NotNull PluginActionOptions<T> pluginActionOptions, @Nullable T param) {
        PluginAction<T> action = new PluginAction<T>(pluginActionOptions, param);
        if (clickActionType == ClickActionType.BOTH && !this.isBoth()) {
            this.actionListRight.clear();
            this.actionListLeft.clear();
        }
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.add(index, action);
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.add(index, action);
        }
    }

    public void remove(@NotNull ClickActionType clickActionType, @NotNull PluginAction<? extends Serializable> action) {
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.remove(action);
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.remove(action);
        }
    }

    public void clear(@NotNull ClickActionType clickActionType) {
        if (clickActionType == ClickActionType.RIGHT || clickActionType == ClickActionType.BOTH) {
            this.actionListRight.clear();
        }
        if (clickActionType == ClickActionType.LEFT || clickActionType == ClickActionType.BOTH) {
            this.actionListLeft.clear();
        }
    }

    @Override
    @NotNull
    public NpcClickActionImpl initialize() {
        new ArrayList(this.actionListRight).forEach((Consumer<PluginAction<?>>)((Consumer<PluginAction>)PluginAction::reload));
        new ArrayList(this.actionListLeft).forEach((Consumer<PluginAction<?>>)((Consumer<PluginAction>)PluginAction::reload));
        return this;
    }

    @NotNull
    public List<PluginAction<?>> getRightActions() {
        return Collections.unmodifiableList(this.actionListRight);
    }

    @NotNull
    public List<PluginAction<?>> getLeftActions() {
        return Collections.unmodifiableList(this.actionListLeft);
    }

    @NotNull
    public List<PluginAction<?>> getActions(@NotNull ClickActionType clickActionType) {
        if (!this.isBoth() && clickActionType == ClickActionType.BOTH) {
            return new ArrayList();
        }
        if (clickActionType == ClickActionType.LEFT) {
            return this.getLeftActions();
        }
        return this.getRightActions();
    }

    public boolean isBoth() {
        return this.actionListRight.equals(this.actionListLeft);
    }

    @Override
    public void call(@NotNull NpcInteractEvent event) {
        if (event.getAction() == ClickActionType.LEFT && this.actionListLeft.isEmpty()) {
            return;
        }
        if (event.getAction() == ClickActionType.RIGHT && this.actionListRight.isEmpty()) {
            return;
        }
        this.call(0, event);
    }

    private void call(int index, @NotNull NpcInteractEvent event) {
        List<PluginAction<?>> listToExecute;
        List<PluginAction<?>> list = listToExecute = event.getAction() == ClickActionType.LEFT ? this.actionListLeft : this.actionListRight;
        if (index >= listToExecute.size()) {
            return;
        }
        PluginAction<?> action = listToExecute.get(index);
        if (action.option.equals(PluginActionOptions.WAIT)) {
            if (action.param instanceof Double) {
                double wait = (Double)action.param;
                Bukkit.getScheduler().runTaskLater((Plugin)NpcPlugin.plugin, () -> this.call(index + 1, event), (long)(wait * 20.0));
            } else {
                NpcPlugin.plugin.getLogger().warning("WAIT action parameter is not a Double for NPC interaction. Skipping WAIT!");
                this.call(index + 1, event);
            }
            return;
        }
        NpcClickAction executable = action.option.function.apply((Serializable)Var.unsafeCast(action.param));
        if (executable != null) {
            executable.call(event);
        }
        this.call(index + 1, event);
    }

    public static class PluginAction<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private PluginActionOptions<T> option;
        T param;

        public PluginAction(PluginActionOptions<T> option, T param) {
            this.option = option;
            this.param = param;
        }

        private void reload() {
            if (this.option != null) {
                PluginActionOptions reloadedOption = this.option.getOption();
                if (reloadedOption != null) {
                    this.option = reloadedOption;
                } else {
                    NpcPlugin.plugin.getLogger().warning("Failed to reload PluginActionOption for: " + this.option.name + ". It might be missing or renamed.");
                }
            }
        }

        @NotNull
        public String getTypeName(Player player) {
            return this.option != null ? this.option.getName(player) : LocalizationManager.get(player, "actions.invalid.title", new Object[0]);
        }

        @NotNull
        public Supplier<ItemBuilder> getIcon(Player player) {
            if (this.option == null) {
                return () -> new ItemBuilder(Material.BARRIER).setName(LocalizationManager.get(player, "actions.invalid.title", new Object[0])).setLore(LocalizationManager.get(player, "actions.invalid.description", new Object[0]));
            }
            return () -> this.option.icon.apply(this.param, player).setName(this.getTypeName(player)).hideFlags(true).hideAttributes();
        }

        @NotNull
        public Consumer<InventoryClickEvent> getConsumer(@NotNull NPC npc, @NotNull ClickActionType clickActionType, boolean withTeleport) {
            return inventoryClickEvent -> {
                if (this.option != null) {
                    this.param = (Serializable)this.option.clickAction.apply(this.param, new PluginActionOptions.PluginActionData((InventoryClickEvent)inventoryClickEvent, npc, clickActionType, this, withTeleport));
                }
            };
        }
    }

    public static class PluginActionOptions<T extends Serializable>
    implements Serializable {
        public static final Map<String, PluginActionOptions<?>> OPTIONS_REGISTRY = new HashMap();
        public static final PluginActionOptions<AnimatePacket.Animation> ANIMATION = AnimationActionOption.getAnimationAction();
        public static final PluginActionOptions<Double> WAIT = WaitActionOption.getWaitAction();
        public static final PluginActionOptions<String> COMMAND = CommandActionOption.getCommandAction();
        public static final PluginActionOptions<Pair<Path.SerializablePath, Float>> PATH = PathActionOption.getPathAction();
        public static final PluginActionOptions<String> SERVER = ServerActionOption.getServerAction();
        private static final long serialVersionUID = 1L;
        final String name;
        final T defaultValue;
        final transient Function<T, NpcClickAction> function;
        final transient BiFunction<T, Player, ItemBuilder> icon;
        final transient BiFunction<T, PluginActionData, T> clickAction;

        private PluginActionOptions(@NotNull String name, @Nullable T defaultValue, @NotNull Function<T, NpcClickAction> function, @NotNull BiFunction<T, Player, ItemBuilder> icon, @NotNull BiFunction<T, PluginActionData, T> clickAction) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.function = function;
            this.icon = icon;
            this.clickAction = clickAction;
            OPTIONS_REGISTRY.put(name, this);
        }

        public PluginActionOptions(@NotNull AbstractPluginActionOption<T> pluginActionOption) {
            this.name = pluginActionOption.getName();
            this.defaultValue = pluginActionOption.getDefaultValue();
            this.function = pluginActionOption::getAction;
            this.icon = pluginActionOption::getIcon;
            this.clickAction = pluginActionOption::getClickAction;
            OPTIONS_REGISTRY.put(this.name, this);
        }

        @Nullable
        public static PluginActionOptions<?> getFromMaterial(@NotNull Material material) {
            return OPTIONS_REGISTRY.values().stream().filter(option -> option.icon.apply(null, null).build().getType() == material).findFirst().orElse(null);
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String getName(Player player) {
            return LocalizationManager.get(player, "actions." + this.name + ".title", new Object[0]);
        }

        @NotNull
        public ItemBuilder getDefaultItem(Player player) {
            return this.icon.apply(null, player).setName(this.getName(player)).setClickHandler(null).setLore(new ArrayList<String>());
        }

        <V extends Serializable> PluginActionOptions<V> getOption() {
            PluginActionOptions<?> registeredOption = OPTIONS_REGISTRY.get(this.name.toLowerCase());
            if (registeredOption != null && this.getClass().isAssignableFrom(registeredOption.getClass())) {
                return registeredOption;
            }
            NpcPlugin.plugin.getLogger().severe("Failed to get canonical option for: " + this.name + ". It may have been removed or renamed.");
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PluginActionOptions)) {
                return false;
            }
            PluginActionOptions that = (PluginActionOptions)obj;
            return this.name.equals(that.name);
        }

        public record PluginActionData(@NotNull InventoryClickEvent event, @NotNull NPC npc, @NotNull ClickActionType clickActionType, @NotNull PluginAction<?> actionInstance, boolean withTeleport) {
        }
    }
}

