/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.objects;

import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.objects.AbstractPluginActionOption;
import de.eisi05.npc.plugin.objects.NpcClickActionImpl;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public final class WaitActionOption
extends AbstractPluginActionOption<Double> {
    private static final long serialVersionUID = 1L;

    private WaitActionOption() {
    }

    @NotNull
    static NpcClickActionImpl.PluginActionOptions<Double> getWaitAction() {
        return WaitActionOption.getOption(WaitActionOption.class, WaitActionOption::new);
    }

    @Override
    String getName() {
        return "wait";
    }

    @Override
    Double getDefaultValue() {
        return 1.0;
    }

    @Override
    NpcClickAction getAction(Double option) {
        return null;
    }

    @Override
    ItemBuilder getIcon(Double value, Player player) {
        return new ItemBuilder(Material.CLOCK).setLore(LocalizationManager.get(player, "actions.wait.value", value));
    }

    @Override
    Double getClickAction(Double value, NpcClickActionImpl.PluginActionOptions.PluginActionData data) {
        ItemStack currentItem;
        boolean actuallyChanged;
        double originalValue = value;
        double newValue = value;
        double increment = data.event().isShiftClick() ? 1.0 : 0.1;
        Sound soundToPlay = null;
        float pitch = 1.0f;
        float volume = 1.0f;
        if (data.event().getClick().isLeftClick()) {
            if ((newValue += increment) > 600.0) {
                newValue = 600.0;
            }
        } else if (data.event().getClick().isRightClick()) {
            if ((newValue -= increment) < 0.1) {
                newValue = 0.1;
            }
        } else if (data.event().getClick() == ClickType.MIDDLE) {
            newValue = 1.0;
        }
        boolean bl = actuallyChanged = Math.abs((newValue = (double)Math.round(newValue * 10.0) / 10.0) - originalValue) > 0.001;
        if (actuallyChanged) {
            soundToPlay = Sound.BLOCK_COMPARATOR_CLICK;
            pitch = newValue > originalValue ? 1.2f : (newValue < originalValue ? 0.8f : 1.0f);
            data.npc().markChange();
        } else if (data.event().getClick().isLeftClick() || data.event().getClick().isRightClick()) {
            soundToPlay = Sound.UI_BUTTON_CLICK;
            pitch = 0.7f;
            volume = 0.8f;
        }
        if (soundToPlay != null) {
            Player p = (Player)data.event().getWhoClicked();
            p.playSound(p.getLocation(), soundToPlay, volume, pitch);
        }
        if ((currentItem = data.event().getCurrentItem()) != null && currentItem.hasItemMeta()) {
            ItemMeta meta = currentItem.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>(Arrays.stream(LocalizationManager.get((Player)data.event().getWhoClicked(), "actions.wait.value", newValue).split("\n")).toList());
            meta.setLore(lore);
            currentItem.setItemMeta(meta);
        }
        return newValue;
    }
}

