/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils.builder;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.utils.builder.InventoryBuilder;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class PageInventoryBuilder
implements Listener {
    private static final Set<Integer> BORDER_SLOTS = Set.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44);
    private final String title;
    private final InventoryHolder inventoryHolder;
    private final List<ItemStack> items;
    private final boolean showPage;
    private final Hotbar[] hotbar;
    private int page;
    private Consumer<InventoryClickEvent> arrowBackEvent;
    private boolean border;
    private ItemStack placeHolder;

    public PageInventoryBuilder(String title, InventoryHolder inventoryHolder, List<ItemStack> items, boolean showPage, Hotbar ... hotbar) {
        this.title = title;
        this.inventoryHolder = inventoryHolder;
        this.items = new ArrayList<ItemStack>(items);
        this.showPage = showPage;
        this.hotbar = hotbar;
        Bukkit.getPluginManager().registerEvents((Listener)this, NpcApi.plugin);
    }

    public PageInventoryBuilder(String title, List<ItemStack> items, boolean showPage, Hotbar ... hotbar) {
        this(title, null, items, showPage, hotbar);
    }

    public PageInventoryBuilder(String title, InventoryHolder inventoryHolder, List<ItemStack> items, boolean showPage) {
        this(title, inventoryHolder, items, showPage, new Hotbar[0]);
    }

    public PageInventoryBuilder(String title, List<ItemStack> items, boolean showPage) {
        this(title, items, showPage, new Hotbar[0]);
    }

    public PageInventoryBuilder(String title, InventoryHolder inventoryHolder, List<ItemStack> items) {
        this(title, inventoryHolder, items, false);
    }

    public PageInventoryBuilder(String title, List<ItemStack> items) {
        this(title, items, false);
    }

    public PageInventoryBuilder setClickEvent(Consumer<InventoryClickEvent> event) {
        this.items.replaceAll(item -> new ItemBuilder((ItemStack)item).setClickHandler(event).build());
        return this;
    }

    public PageInventoryBuilder setArrowBackEvent(Consumer<InventoryClickEvent> event) {
        this.arrowBackEvent = event;
        return this;
    }

    public PageInventoryBuilder withBorder() {
        this.border = true;
        return this;
    }

    public PageInventoryBuilder withPlaceHolder(ItemStack item) {
        this.placeHolder = item;
        return this;
    }

    public Inventory getInventory(int page, Player player) {
        this.page = page--;
        if (this.isEmpty()) {
            return this.getInventory(page, player);
        }
        InventoryBuilder builder = this.showPage ? new InventoryBuilder(this.inventoryHolder, 54, this.title + " [" + page + "]") : new InventoryBuilder(this.inventoryHolder, 54, this.title);
        page = (page - 1) * (45 - (this.border ? BORDER_SLOTS.size() : 0));
        for (int a = 0; a < 45; ++a) {
            if (this.border && BORDER_SLOTS.contains(a)) continue;
            if (page < this.items.size() && !this.items.isEmpty()) {
                builder.setItem(a, this.items.get(page++));
                continue;
            }
            if (this.placeHolder == null) continue;
            builder.setItem(a, this.placeHolder);
        }
        int finalPage = this.page;
        if (page != this.items.size()) {
            builder.setArrowRight(LocalizationManager.get(player, "misc.next", new Object[0]), event -> {
                Player player1 = (Player)event.getWhoClicked();
                player1.playSound(player1.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.5f);
                player1.openInventory(this.getInventory(finalPage + 1, player1));
            });
        }
        if (this.arrowBackEvent != null && this.page == 1) {
            builder.setArrowLeft(LocalizationManager.get(player, "misc.previous", new Object[0]), this.arrowBackEvent);
        } else if (this.page != 1) {
            builder.setArrowLeft(LocalizationManager.get(player, "misc.previous", new Object[0]), event -> {
                Player player1 = (Player)event.getWhoClicked();
                player1.playSound(player1.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.5f);
                player1.openInventory(this.getInventory(finalPage - 1, player1));
            });
        }
        for (Hotbar hotbar : this.hotbar) {
            if (hotbar == null) continue;
            builder.setItem(46 + hotbar.slot, hotbar.item);
        }
        return builder.fillOut().build();
    }

    public boolean isEmpty() {
        return this.page != 1 && (this.page - 1) * (45 - (this.border ? BORDER_SLOTS.size() : 0)) >= this.items.size();
    }

    public record Hotbar(int slot, ItemStack item) {
        public static Hotbar of(int slot, ItemStack item) {
            return new Hotbar(slot, item);
        }
    }
}

