/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import com.mojang.datafixers.util.Either;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.enums.WalkingResult;
import de.eisi05.npc.api.events.NpcStartWalkingEvent;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.manager.NpcManager;
import de.eisi05.npc.api.objects.NpcHolder;
import de.eisi05.npc.api.objects.NpcName;
import de.eisi05.npc.api.objects.NpcOption;
import de.eisi05.npc.api.scheduler.PathTask;
import de.eisi05.npc.api.utils.ObjectSaver;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import de.eisi05.npc.api.wrapper.objects.WrappedEntityData;
import de.eisi05.npc.api.wrapper.objects.WrappedPlayerTeam;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import de.eisi05.npc.api.wrapper.packets.AnimatePacket;
import de.eisi05.npc.api.wrapper.packets.MoveEntityPacket;
import de.eisi05.npc.api.wrapper.packets.PacketWrapper;
import de.eisi05.npc.api.wrapper.packets.PlayerInfoRemovePacket;
import de.eisi05.npc.api.wrapper.packets.PlayerInfoUpdatePacket;
import de.eisi05.npc.api.wrapper.packets.RemoveEntityPacket;
import de.eisi05.npc.api.wrapper.packets.RotateHeadPacket;
import de.eisi05.npc.api.wrapper.packets.SetEntityDataPacket;
import de.eisi05.npc.api.wrapper.packets.SetPassengerPacket;
import de.eisi05.npc.api.wrapper.packets.SetPlayerTeamPacket;
import de.eisi05.npc.api.wrapper.packets.TeleportEntityPacket;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NPC
extends NpcHolder {
    private final transient Map<UUID, String> nameCache = new HashMap<UUID, String>();
    final Map<String, Integer> toDeleteEntities = new HashMap<String, Integer>();
    private final List<UUID> viewers = new ArrayList<UUID>();
    private final Map<NpcOption<?, ?>, Object> options;
    WrappedServerPlayer serverPlayer;
    private final Path npcPath;
    NpcName name;
    private Location location;
    private NpcClickAction clickEvent;
    private Instant createdAt = Instant.now();
    private PathTask pathTask;

    public NPC(@NotNull Location location) {
        this(location, UUID.randomUUID());
    }

    public NPC(@NotNull Location location, @NotNull NpcName name) {
        this(location, UUID.randomUUID(), name);
    }

    public NPC(@NotNull Location location, @NotNull UUID uuid) {
        this(location, uuid, NpcName.of(WrappedComponent.create(null)));
    }

    public NPC(@NotNull Location location, @NotNull UUID uuid, @NotNull NpcName name) {
        this.name = name;
        this.location = location;
        this.serverPlayer = WrappedServerPlayer.create(location, uuid, name.isStatic() ? name.getName() : WrappedComponent.create(null), false);
        this.npcPath = NpcApi.plugin.getDataFolder().toPath().resolve("NPC").resolve(uuid + ".npc");
        this.options = new HashMap();
        for (NpcOption<?, ?> value : NpcOption.values()) {
            this.setOption(value, Var.unsafeCast(value.getDefaultValue()));
        }
        NpcManager.addNPC(this);
    }

    private NPC(@NotNull Location location, @NotNull NpcName name, @NotNull Map<NpcOption<?, ?>, Object> options, @Nullable NpcClickAction clickEvent) {
        this(location, UUID.randomUUID(), name);
        this.options.putAll(options);
        this.clickEvent = clickEvent;
    }

    @NotNull
    public NPC copy(@NotNull Location newLocation) {
        return new NPC(newLocation, this.name.copy(), new HashMap(this.options), this.clickEvent == null ? null : this.clickEvent.copy());
    }

    public boolean isSaved() {
        return Files.exists(this.npcPath, new LinkOption[0]);
    }

    @Override
    public void save() throws IOException {
        this.npcPath.toFile().getParentFile().mkdirs();
        new ObjectSaver(this.npcPath.toFile()).write(SerializedNPC.serializedNPC(this), false);
        super.save();
    }

    @NotNull
    public WrappedServerPlayer getServerPlayer() {
        return this.serverPlayer;
    }

    @Nullable
    public NpcClickAction getClickEvent() {
        return this.clickEvent;
    }

    @NotNull
    public NPC setClickEvent(@Nullable NpcClickAction event) {
        this.clickEvent = event;
        return this;
    }

    public boolean isEnabled() {
        return this.getOption(NpcOption.ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.setOption(NpcOption.ENABLED, enabled);
        this.reload();
    }

    public boolean isEditable() {
        return this.getOption(NpcOption.EDITABLE);
    }

    public void setEditable(boolean editable) {
        this.setOption(NpcOption.EDITABLE, editable);
    }

    public <T> void setOption(@NotNull NpcOption<T, ?> option, @Nullable T value) {
        if (value == null) {
            this.options.remove(option);
        } else {
            this.options.put(option, value);
        }
        if (NpcApi.config.autoUpdate()) {
            this.viewers.forEach(uuid -> {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) {
                    return;
                }
                option.getPacket(value, this, player).ifPresent(packetWrapper -> WrappedServerPlayer.fromPlayer(player).sendPacket((PacketWrapper)packetWrapper));
            });
        }
    }

    @Nullable
    public <T> T getOption(@NotNull NpcOption<T, ?> option) {
        return (T)this.options.getOrDefault(option, option.getDefaultValue());
    }

    public void playAnimation(@NotNull Player player, @NotNull AnimatePacket.Animation animation) {
        WrappedServerPlayer.fromPlayer(player).sendPacket(AnimatePacket.create(this.getServerPlayer(), animation));
    }

    public void reload() {
        ArrayList<UUID> viewers = new ArrayList<UUID>(this.viewers);
        this.hideNpcFromAllPlayers();
        WrappedPlayerTeam.clear(this.getServerPlayer().getName());
        viewers.stream().filter(uuid -> Bukkit.getPlayer((UUID)uuid) != null).forEach(uuid -> this.showNPCToPlayer(Bukkit.getPlayer((UUID)uuid)));
    }

    @NotNull
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(@NotNull Location location) {
        this.location = location;
        if (this.serverPlayer != null) {
            this.serverPlayer.moveTo(location);
        }
    }

    @NotNull
    public UUID getUUID() {
        if (this.serverPlayer != null) {
            return this.serverPlayer.getUUID();
        }
        return null;
    }

    @NotNull
    public NpcName getNpcName() {
        return this.name;
    }

    @NotNull
    public WrappedComponent getName(@NotNull Player player) {
        return this.name.getName(player);
    }

    @NotNull
    public WrappedComponent getName() {
        return this.name.getName();
    }

    public void setName(@NotNull NpcName name) {
        this.name = name;
        this.serverPlayer.setListName(name.isStatic() ? WrappedComponent.parseFromLegacy(name.getName().toLegacy(false).replace("\n", "\\n")) : WrappedComponent.create(null));
        this.viewers.stream().filter(uuid -> Bukkit.getPlayer((UUID)uuid) != null).forEach(uuid -> this.updateName(Bukkit.getPlayer((UUID)uuid)));
    }

    public <K extends Serializable, V extends Serializable> void addCustomData(@NotNull K key, @NotNull V value) {
        HashMap<Serializable, Serializable> map = this.getOption(NpcOption.CUSTOM_DATA);
        map.put(key, value);
        this.setOption(NpcOption.CUSTOM_DATA, map);
    }

    @Nullable
    public <K extends Serializable, T extends Serializable> T removeCustomData(@NotNull K key) {
        HashMap<Serializable, Serializable> map = this.getOption(NpcOption.CUSTOM_DATA);
        Serializable value = map.remove(key);
        this.setOption(NpcOption.CUSTOM_DATA, map);
        return (T)value;
    }

    @Nullable
    public <K extends Serializable, T extends Serializable> T getCustomData(@NotNull K key) {
        HashMap<Serializable, Serializable> map = this.getOption(NpcOption.CUSTOM_DATA);
        return (T)map.get(key);
    }

    public void updateName(@NotNull Player player) {
        WrappedServerPlayer.fromPlayer(player).sendPacket(SetEntityDataPacket.create(this.serverPlayer.getNameTag().getId(), this.serverPlayer.getNameTag().applyData(Versions.isCurrentVersionSmallerThan(Versions.V1_19_4) || this.isEnabled() ? this.name.getName(player) : WrappedComponent.parseFromLegacy(NpcApi.DISABLED_MESSAGE_PROVIDER.apply(player)).append(WrappedComponent.create("\n").append(this.name.getName(player))))));
    }

    public void updateNameForAll() {
        for (UUID uuid : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            String name = this.getName(Bukkit.getPlayer((UUID)uuid)).toLegacy(false);
            if (this.nameCache.getOrDefault(uuid, "").equals(name)) continue;
            this.updateName(player);
            this.nameCache.put(uuid, name);
        }
    }

    public void updateSkin(@NotNull Predicate<Player> predicate) {
        for (UUID uuid : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !predicate.test(player)) continue;
            this.hideNpcFromPlayer(player);
            this.showNPCToPlayer(player);
        }
    }

    @NotNull
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void showNpcToAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(this::showNPCToPlayer);
    }

    public void showNPCToPlayer(@NotNull Player player) {
        if (!(this.getOption(NpcOption.ENABLED).booleanValue() || player.isPermissionSet("npc.admin") || player.isOp())) {
            return;
        }
        if (!player.getWorld().getName().equals(this.serverPlayer.getWorld().getName())) {
            this.hideNpcFromPlayer(player);
            return;
        }
        if (!this.serverPlayer.getWorld().isChunkLoaded(this.location.getBlockX() >> 4, this.location.getBlockZ() >> 4)) {
            return;
        }
        if (!this.viewers.contains(player.getUniqueId())) {
            this.viewers.add(player.getUniqueId());
        }
        if (!this.name.isStatic() && this.getOption(NpcOption.SHOW_TAB_LIST).booleanValue()) {
            this.setOption(NpcOption.SHOW_TAB_LIST, false);
        }
        ArrayList<PacketWrapper> packets = new ArrayList<PacketWrapper>();
        Arrays.stream(NpcOption.values()).filter(NpcOption::loadBefore).forEach(npcOption -> npcOption.getPacket(this.getOption((NpcOption)npcOption), this, player).ifPresent(packets::add));
        packets.add(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, this.serverPlayer));
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_19_3)) {
            packets.add(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_LISTED, this.serverPlayer));
        }
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_2)) {
            packets.add(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_LIST_ORDER, this.serverPlayer));
        }
        packets.add(this.serverPlayer.getAddEntityPacket());
        boolean modified = WrappedPlayerTeam.exists(player, this.getServerPlayer().getName());
        WrappedPlayerTeam wrappedPlayerTeam = WrappedPlayerTeam.create(player, this.getServerPlayer().getName());
        wrappedPlayerTeam.setNameTagVisibility(WrappedPlayerTeam.Visibility.NEVER);
        packets.add(SetPlayerTeamPacket.createAddOrModifyPacket(wrappedPlayerTeam, !modified));
        packets.add(SetPlayerTeamPacket.createPlayerPacket(wrappedPlayerTeam, this.getServerPlayer().getName(), SetPlayerTeamPacket.Action.ADD));
        packets.add(new RotateHeadPacket(this.serverPlayer, (byte)(this.location.getYaw() % 360.0f * 256.0f / 360.0f)));
        packets.add(new MoveEntityPacket.Rot(this.serverPlayer.getId(), (byte)this.location.getYaw(), (byte)this.location.getPitch(), this.serverPlayer.isOnGround()));
        WrappedEntityData data = this.serverPlayer.getEntityData();
        data.set(WrappedEntityData.EntityDataSerializers.OPTIONAL_CHAT_COMPONENT.create(2), Optional.of(WrappedComponent.create("NPC").getHandle()));
        data.set(WrappedEntityData.EntityDataSerializers.BOOLEAN.create(3), false);
        packets.add(SetEntityDataPacket.create(this.serverPlayer.getId(), data));
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_19_4) || !this.getOption(NpcOption.HIDE_NAMETAG).booleanValue()) {
            if (Versions.isCurrentVersionSmallerThan(Versions.V1_21)) {
                this.serverPlayer.getNameTag().moveTo(this.getLocation().clone().add(0.0, this.serverPlayer.getBoundingBox().getYSize() * this.getOption(NpcOption.SCALE), 0.0));
            }
            packets.add(this.serverPlayer.getNameTag().getAddEntityPacket());
            packets.add(SetEntityDataPacket.create(this.serverPlayer.getNameTag().getId(), this.serverPlayer.getNameTag().applyData(Versions.isCurrentVersionSmallerThan(Versions.V1_19_4) || this.isEnabled() ? this.name.getName(player) : WrappedComponent.parseFromLegacy(NpcApi.DISABLED_MESSAGE_PROVIDER.apply(player)).append(WrappedComponent.create("\n").append(this.name.getName(player))))));
            if (!Versions.isCurrentVersionSmallerThan(Versions.V1_19_4)) {
                packets.add(new SetPassengerPacket(this.serverPlayer));
            }
        }
        Arrays.stream(NpcOption.values()).filter(npcOption -> !npcOption.equals(NpcOption.ENABLED) && !npcOption.loadBefore()).forEach(npcOption -> npcOption.getPacket(this.getOption((NpcOption)npcOption), this, player).ifPresent(packets::add));
        NpcOption.ENABLED.getPacket(this.isEnabled(), this, player).ifPresent(packets::add);
        WrappedServerPlayer wrappedServerPlayer = WrappedServerPlayer.fromPlayer(player);
        packets.forEach(wrappedServerPlayer::sendPacket);
    }

    public void hideNpcFromAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(this::hideNpcFromPlayer);
    }

    public void hideNpcFromPlayer(@NotNull Player player) {
        WrappedServerPlayer wrappedServerPlayer = WrappedServerPlayer.fromPlayer(player);
        wrappedServerPlayer.sendPacket(new RemoveEntityPacket(this.serverPlayer.getId()));
        wrappedServerPlayer.sendPacket(new RemoveEntityPacket(this.serverPlayer.getNameTag().getId()));
        if (WrappedPlayerTeam.exists(player, this.getServerPlayer().getName())) {
            WrappedPlayerTeam wrappedPlayerTeam = WrappedPlayerTeam.create(player, this.getServerPlayer().getName());
            wrappedServerPlayer.sendPacket(SetPlayerTeamPacket.createPlayerPacket(wrappedPlayerTeam, this.getServerPlayer().getName(), SetPlayerTeamPacket.Action.REMOVE));
            wrappedServerPlayer.sendPacket(SetPlayerTeamPacket.createRemovePacket(wrappedPlayerTeam));
        }
        this.toDeleteEntities.values().forEach(integer -> wrappedServerPlayer.sendPacket(new RemoveEntityPacket((int)integer)));
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_19_3)) {
            wrappedServerPlayer.sendPacket(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.REMOVE_PLAYER, this.serverPlayer));
        } else {
            wrappedServerPlayer.sendPacket(new PlayerInfoRemovePacket(List.of(this.getUUID())));
        }
        this.viewers.remove(player.getUniqueId());
    }

    public void delete() throws IOException {
        if (this.serverPlayer == null) {
            return;
        }
        this.hideNpcFromAllPlayers();
        NpcManager.removeNPC(this);
        this.serverPlayer.remove();
        this.serverPlayer = null;
        this.npcPath.toFile().getParentFile().mkdirs();
        Files.deleteIfExists(this.npcPath);
    }

    public void lookAtPlayer(@NotNull Player viewer) {
        Location npcLoc = ((Player)this.serverPlayer.getBukkitPlayer()).getLocation();
        Location playerLoc = viewer.getLocation();
        if (npcLoc.getWorld() != playerLoc.getWorld()) {
            return;
        }
        double dx = playerLoc.getX() - npcLoc.getX();
        double dy = playerLoc.getY() + viewer.getEyeHeight() - (npcLoc.getY() + ((Player)this.serverPlayer.getBukkitPlayer()).getEyeHeight() * this.getOption(NpcOption.SCALE));
        double dz = playerLoc.getZ() - npcLoc.getZ();
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
        float pitch = (float)Math.toDegrees(-Math.atan2(dy, distanceXZ));
        byte yawByte = (byte)(yaw * 256.0f / 360.0f);
        byte pitchByte = (byte)(pitch * 256.0f / 360.0f);
        WrappedServerPlayer player = WrappedServerPlayer.fromPlayer(viewer);
        player.sendPacket(new RotateHeadPacket(this.serverPlayer, yawByte));
        player.sendPacket(new MoveEntityPacket.Rot(this.serverPlayer.getId(), yawByte, pitchByte, this.serverPlayer.isOnGround()));
    }

    @NotNull
    public BukkitTask walkTo(@NotNull de.eisi05.npc.api.pathfinding.Path path, double walkSpeed, boolean changeRealLocation) {
        return this.walkTo(path, walkSpeed, changeRealLocation, null, null);
    }

    @NotNull
    public BukkitTask walkTo(@NotNull de.eisi05.npc.api.pathfinding.Path path, double walkSpeed, boolean changeRealLocation, @Nullable Consumer<WalkingResult> onEnd, Player ... viewers) {
        if (this.isWalking()) {
            this.cancelWalking();
        }
        double speed = Math.max(Math.min(walkSpeed, 1.0), 0.1);
        NpcStartWalkingEvent event = new NpcStartWalkingEvent(this, path, speed, changeRealLocation);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        this.pathTask = new PathTask.Builder(this, path).speed(event.getWalkSpeed()).viewers(viewers).updateRealLocation(event.isChangeRealLocation()).callback(onEnd).build();
        return this.pathTask.runTaskTimer(NpcApi.plugin, 1L, 1L);
    }

    public boolean isWalking() {
        return this.pathTask != null && !this.pathTask.isFinished();
    }

    public void cancelWalking() {
        if (this.pathTask != null) {
            this.pathTask.cancel();
            this.pathTask = null;
        }
    }

    public void sendNpcBodyPackets(@Nullable MoveEntityPacket.Rot moveEntityPacket, Player ... players) {
        if (players != null) {
            for (Player player : players) {
                WrappedServerPlayer serverPlayer = WrappedServerPlayer.fromPlayer(player);
                if (moveEntityPacket == null) continue;
                serverPlayer.sendPacket(moveEntityPacket);
            }
        } else {
            for (UUID uuid : this.viewers) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (!offlinePlayer.isOnline()) continue;
                WrappedServerPlayer serverPlayer1 = WrappedServerPlayer.fromPlayer(offlinePlayer.getPlayer());
                if (moveEntityPacket == null) continue;
                serverPlayer1.sendPacket(moveEntityPacket);
            }
        }
    }

    public void sendNpcMovePackets(@Nullable TeleportEntityPacket teleportEntityPacket, @Nullable RotateHeadPacket rotateHeadPacket, Player ... players) {
        if (players != null) {
            for (Player player : players) {
                WrappedServerPlayer serverPlayer1 = WrappedServerPlayer.fromPlayer(player);
                if (teleportEntityPacket != null) {
                    serverPlayer1.sendPacket(teleportEntityPacket);
                }
                if (rotateHeadPacket == null) continue;
                serverPlayer1.sendPacket(rotateHeadPacket);
            }
        } else {
            for (UUID uuid : this.viewers) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (!offlinePlayer.isOnline()) continue;
                WrappedServerPlayer serverPlayer1 = WrappedServerPlayer.fromPlayer(offlinePlayer.getPlayer());
                if (teleportEntityPacket != null) {
                    serverPlayer1.sendPacket(teleportEntityPacket);
                }
                if (rotateHeadPacket == null) continue;
                serverPlayer1.sendPacket(rotateHeadPacket);
            }
        }
    }

    public void changeRealLocation(Location location, Player ... excludedPlayers) {
        if (this.serverPlayer == null) {
            return;
        }
        this.setLocation(location);
        Set excluded = excludedPlayers == null ? Collections.emptySet() : Arrays.stream(excludedPlayers).filter(Objects::nonNull).map(OfflinePlayer::getUniqueId).collect(Collectors.toSet());
        TeleportEntityPacket teleport = new TeleportEntityPacket(this.serverPlayer, new TeleportEntityPacket.PositionMoveRotation(location.toVector(), new Vector(0, 0, 0), location.getYaw(), location.getPitch()), Set.of(), true);
        for (UUID uuid : this.viewers) {
            Player viewer = Bukkit.getPlayer((UUID)uuid);
            if (viewer == null || excluded.contains(viewer.getUniqueId())) continue;
            WrappedServerPlayer.fromPlayer(viewer).sendPacket(teleport);
        }
    }

    public record SerializedNPC(@NotNull UUID world, double x, double y, double z, float yaw, float pitch, @NotNull UUID id, @NotNull Serializable name, @NotNull Map<String, ? extends Serializable> options, @Nullable NpcClickAction clickEvent, @NotNull Instant createdAt) implements Serializable
    {
        private static final long serialVersionUID = 1L;

        @NotNull
        public static SerializedNPC serializedNPC(@NotNull NPC npc) {
            return new SerializedNPC(npc.getLocation().getWorld().getUID(), npc.getLocation().getX(), npc.getLocation().getY(), npc.getLocation().getZ(), npc.getLocation().getYaw(), npc.getLocation().getPitch(), npc.getUUID(), npc.getNpcName(), npc.options.keySet().stream().collect(Collectors.toMap(NpcOption::getPath, npcOption -> npcOption.serialize(npc.getOption(npcOption)))), npc.clickEvent, npc.createdAt);
        }

        private Object readResolve() throws ObjectStreamException {
            NpcName fixedName;
            Serializable serializable = this.name;
            if (serializable instanceof NpcName) {
                NpcName sn;
                fixedName = sn = (NpcName)serializable;
            } else {
                serializable = this.name;
                if (serializable instanceof WrappedComponent.SerializedComponent) {
                    WrappedComponent.SerializedComponent oldName = (WrappedComponent.SerializedComponent)serializable;
                    fixedName = NpcName.of(oldName.deserialize());
                } else {
                    throw new IllegalStateException("Unexpected type for name field: " + this.name.getClass());
                }
            }
            return new SerializedNPC(this.world, this.x, this.y, this.z, this.yaw, this.pitch, this.id, fixedName, this.options, this.clickEvent, this.createdAt);
        }

        @NotNull
        public <T, S extends Serializable> Either<NPC, UUID> deserializedNPC() {
            World world1 = Bukkit.getWorld((UUID)this.world);
            if (world1 == null) {
                return Either.right((Object)this.world);
            }
            NPC npc = new NPC(new Location(world1, this.x, this.y, this.z, this.yaw, this.pitch), this.id, (NpcName)this.name).setClickEvent(this.clickEvent == null ? this.clickEvent : this.clickEvent.initialize());
            this.options.forEach((string, serializable) -> NpcOption.getOption(string).ifPresent(npcOption -> npc.setOption(npcOption, npcOption.deserialize((Serializable)Var.unsafeCast(serializable)))));
            npc.createdAt = this.createdAt == null ? Instant.now() : this.createdAt;
            return Either.left((Object)npc);
        }
    }
}

