/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.pathfinding;

import de.eisi05.npc.api.pathfinding.PathfindingUtils;
import de.eisi05.npc.api.utils.Var;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Openable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AStarPathfinder {
    private final int maxIterations;
    private final boolean allowDiagonal;
    private World world;
    private final PriorityQueue<Node> openSet = new PriorityQueue();
    private final Map<Long, Node> allNodes = new HashMap<Long, Node>();

    public AStarPathfinder(int maxIterations, boolean allowDiagonal) {
        this.maxIterations = maxIterations;
        this.allowDiagonal = allowDiagonal;
    }

    @Nullable
    public List<Location> getPath(@NotNull Location start, @NotNull Location end) throws PathfindingUtils.PathfindingException {
        if (!start.getWorld().equals(end.getWorld())) {
            return null;
        }
        this.openSet.clear();
        this.allNodes.clear();
        this.world = start.getWorld();
        Block startFloor = this.world.getBlockAt(start.getBlockX(), start.getBlockY() - 1, start.getBlockZ());
        if (!this.isSafeFloor(startFloor)) {
            throw new PathfindingUtils.PathfindingException("Start not on a valid floor: " + start);
        }
        Block endFloor = this.world.getBlockAt(end.getBlockX(), end.getBlockY() - 1, end.getBlockZ());
        if (!this.isSafeFloor(endFloor)) {
            throw new PathfindingUtils.PathfindingException("End not on a valid floor: " + end);
        }
        Node startNode = new Node(start.getBlockX(), start.getBlockY(), start.getBlockZ(), null);
        startNode.gCost = 0.0;
        startNode.calculateH(end);
        this.openSet.add(startNode);
        this.allNodes.put(startNode.id, startNode);
        int iterations = 0;
        while (!this.openSet.isEmpty()) {
            if (iterations > this.maxIterations) {
                return null;
            }
            ++iterations;
            Node current = this.openSet.poll();
            if (this.distance(current, end) < 2.0) {
                return this.retracePath(current);
            }
            current.closed = true;
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        double moveCost;
                        double newGCost;
                        int targetZ;
                        int targetY;
                        int targetX;
                        if (x == 0 && y == 0 && z == 0 || !this.allowDiagonal && (double)(Math.abs(x) + Math.abs(z)) > 1.5 || !this.canWalk(current.x, current.y, current.z, targetX = current.x + x, targetY = current.y + y, targetZ = current.z + z)) continue;
                        long id = Node.hash(targetX, targetY, targetZ);
                        Node neighbor = this.allNodes.getOrDefault(id, new Node(targetX, targetY, targetZ, id));
                        if (neighbor.closed || !((newGCost = current.gCost + (moveCost = Math.abs(x) + Math.abs(y) + Math.abs(z) > 1 ? 1.414 : 1.0)) < neighbor.gCost) && this.openSet.contains(neighbor)) continue;
                        neighbor.gCost = newGCost;
                        neighbor.calculateH(end);
                        neighbor.parent = current;
                        if (this.openSet.contains(neighbor)) continue;
                        this.openSet.add(neighbor);
                        this.allNodes.put(id, neighbor);
                    }
                }
            }
        }
        return null;
    }

    private boolean canWalk(int fx, int fy, int fz, int tx, int ty, int tz) {
        Block floor = this.world.getBlockAt(tx, ty, tz);
        Block spaceFeet = this.world.getBlockAt(tx, ty + 1, tz);
        Block spaceHead = this.world.getBlockAt(tx, ty + 2, tz);
        if (!this.isSafeFloor(floor)) {
            return false;
        }
        if (this.isSolid(spaceFeet) || this.isSolid(spaceHead)) {
            return false;
        }
        if (fx != tx && fz != tz) {
            Block checkA = this.world.getBlockAt(fx, ty + 1, tz);
            Block checkB = this.world.getBlockAt(tx, ty + 1, fz);
            if (this.isSolid(checkA) || this.isSolid(checkB)) {
                return false;
            }
        }
        return true;
    }

    private boolean isSafeFloor(Block block) {
        if (block == null) {
            return false;
        }
        Material type = block.getType();
        if (type.isAir() || block.isLiquid()) {
            return false;
        }
        return !block.isPassable();
    }

    private boolean isSolid(Block block) {
        if (block == null) {
            return false;
        }
        Material type = block.getType();
        if (type.isAir()) {
            return false;
        }
        if (Var.isCarpet(type) && Var.isCarpet(block.getRelative(BlockFace.UP).getType())) {
            return true;
        }
        if (Var.isCarpet(type)) {
            return false;
        }
        if (block.isPassable()) {
            return false;
        }
        return !(block.getBlockData() instanceof Openable);
    }

    @NotNull
    private List<Location> retracePath(@NotNull Node current) {
        ArrayList<Location> path = new ArrayList<Location>();
        while (current != null) {
            path.add(new Location(this.world, (double)current.x + 0.5, (double)current.y, (double)current.z + 0.5));
            current = current.parent;
        }
        Collections.reverse(path);
        return path;
    }

    private double distance(@NotNull Node n, @NotNull Location l) {
        double dx = (double)n.x + 0.5 - (double)l.getBlockX();
        double dy = n.y - l.getBlockY();
        double dz = (double)n.z + 0.5 - (double)l.getBlockZ();
        return dx * dx + dy * dy + dz * dz;
    }

    private static class Node
    implements Comparable<Node> {
        final int x;
        final int y;
        final int z;
        final long id;
        double gCost = Double.MAX_VALUE;
        double hCost = 0.0;
        Node parent = null;
        boolean closed = false;

        public Node(int x, int y, int z, Long id) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.id = id != null ? id : Node.hash(x, y, z);
        }

        public static long hash(int x, int y, int z) {
            return (long)x & 0x3FFFFFFL | ((long)z & 0x3FFFFFFL) << 26 | ((long)y & 0xFFFL) << 52;
        }

        public void calculateH(@NotNull Location end) {
            this.hCost = Math.hypot(Math.hypot(this.x - end.getBlockX(), this.y - end.getBlockY()), this.z - end.getBlockZ());
        }

        public double getFCost() {
            return this.gCost + this.hCost;
        }

        @Override
        public int compareTo(@NotNull Node other) {
            return Double.compare(this.getFCost(), other.getFCost());
        }
    }
}

