/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class ItemSerializer {
    @NotNull
    public static String[] playerInventoryToBase64(@NotNull PlayerInventory playerInventory) throws IllegalStateException {
        String content = ItemSerializer.itemStackArrayToBase64(playerInventory.getStorageContents());
        ItemStack[] items = new ItemStack[playerInventory.getArmorContents().length + 1];
        for (int i = 0; i < playerInventory.getArmorContents().length; ++i) {
            items[i] = playerInventory.getArmorContents()[i];
        }
        items[items.length - 1] = playerInventory.getItemInOffHand();
        String armor = ItemSerializer.itemStackArrayToBase64(items);
        return new String[]{content, armor};
    }

    @NotNull
    public static String itemStackToBase64(@NotNull ItemStack item) {
        return ItemSerializer.itemStackArrayToBase64(new ItemStack[]{item});
    }

    @Nullable
    public static ItemStack itemStackFromBase64(@NotNull String data) {
        try {
            return ItemSerializer.itemStackArrayFromBase64(data)[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static String itemStackArrayToBase64(@NotNull ItemStack[] items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(items.length);
            for (ItemStack item : items) {
                dataOutput.writeObject((Object)item);
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static String toBase64(@NotNull Inventory inventory) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(inventory.getSize());
            for (ItemStack item : inventory.getContents()) {
                dataOutput.writeObject((Object)item);
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            return "";
        }
    }

    @NotNull
    public static ItemStack[][] doubleInventoryFromBase64(@NotNull String[] s) {
        return new ItemStack[][]{ItemSerializer.itemStackArrayFromBase64(s[0]), ItemSerializer.itemStackArrayFromBase64(s[1])};
    }

    @Nullable
    public static Inventory fromBase64(@NotNull String data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            Inventory inventory = Bukkit.getServer().createInventory(null, dataInput.readInt());
            for (int i = 0; i < inventory.getSize(); ++i) {
                inventory.setItem(i, (ItemStack)dataInput.readObject());
            }
            dataInput.close();
            return inventory;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static ItemStack[] itemStackArrayFromBase64(@NotNull String data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack[] items = new ItemStack[dataInput.readInt()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (ItemStack)dataInput.readObject();
            }
            dataInput.close();
            return items;
        }
        catch (Exception e) {
            return new ItemStack[0];
        }
    }
}

