/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.utils;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.enums.ClickActionType;
import de.eisi05.npc.api.events.NpcInteractEvent;
import de.eisi05.npc.api.manager.NpcManager;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.wrapper.enums.InteractionHand;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import de.eisi05.npc.api.wrapper.packets.PacketWrapper;
import de.eisi05.npc.api.wrapper.packets.UseEntityPacketWrapper;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class PacketReader {
    private static final Map<UUID, Channel> channels = new HashMap<UUID, Channel>();
    private static final List<BiConsumer<Player, Object>> readers = new ArrayList<BiConsumer<Player, Object>>();

    public static void addReader(@NotNull BiConsumer<Player, Object> reader) {
        readers.add(reader);
    }

    public static void inject(final @NotNull Player player) {
        WrappedServerPlayer serverPlayer = WrappedServerPlayer.fromPlayer(player);
        Channel channel = serverPlayer.playerConnection().networkManager().channel();
        channels.put(player.getUniqueId(), channel);
        if (channel.pipeline().get(NpcApi.plugin.getName()) != null) {
            return;
        }
        ChannelDuplexHandler duplexHandler = new ChannelDuplexHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                PacketReader.checkForPacket(msg, player);
                readers.forEach(consumer -> consumer.accept(player, msg));
                super.channelRead(ctx, msg);
            }
        };
        if (channel.pipeline().get("packet_handler") == null) {
            channel.pipeline().addLast(NpcApi.plugin.getName(), (ChannelHandler)duplexHandler);
        } else {
            channel.pipeline().addBefore("packet_handler", NpcApi.plugin.getName(), (ChannelHandler)duplexHandler);
        }
    }

    private static void checkForPacket(@NotNull Object packet, @NotNull Player player) {
        if (!PacketWrapper.PacketHolder.is(packet, PacketWrapper.PacketHolder.class)) {
            return;
        }
        if (!PacketWrapper.PacketHolder.is(packet, UseEntityPacketWrapper.class)) {
            return;
        }
        UseEntityPacketWrapper useEntityPacketWrapper = PacketWrapper.PacketHolder.wrap(packet, UseEntityPacketWrapper.class);
        int id = useEntityPacketWrapper.getId();
        NPC npc = NpcManager.getList().stream().filter(npc1 -> npc1.getServerPlayer().getId() == id).findFirst().orElse(null);
        if (npc == null) {
            return;
        }
        UseEntityPacketWrapper.Action action = useEntityPacketWrapper.getAction();
        if (action.getActionType() == UseEntityPacketWrapper.ActionType.ATTACK) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(NpcApi.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new NpcInteractEvent(player, npc, ClickActionType.LEFT)), 0L);
        } else if (action.getActionType() == UseEntityPacketWrapper.ActionType.INTERACT && action.getHand() == InteractionHand.MAIN_HAND) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(NpcApi.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new NpcInteractEvent(player, npc, ClickActionType.RIGHT)), 0L);
        }
    }

    public static void uninject(@NotNull Player player) {
        Channel channel = channels.get(player.getUniqueId());
        if (channel == null) {
            return;
        }
        if (channel.pipeline().get(NpcApi.plugin.getName()) != null) {
            channel.pipeline().remove(NpcApi.plugin.getName());
        }
    }

    public static void uninjectAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            PacketReader.uninject(player);
        }
    }

    public static void injectAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            PacketReader.inject(player);
        }
    }
}

