/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.utils;

import com.google.common.primitives.Primitives;
import de.eisi05.npc.api.wrapper.Wrapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Reflections {
    @NotNull
    public static <T> Optional<Class<T>> getClass(@NotNull String path) {
        try {
            return Optional.of(Class.forName(path));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    @NotNull
    public static <T> Optional<T> getInstance(@NotNull String path, Object ... args) {
        return Reflections.getClass(path).flatMap(objectClass -> Reflections.getInstance(objectClass, args));
    }

    @NotNull
    public static <T> Optional<T> getInstance(@NotNull Class<T> clazz, Object ... args) {
        Object[] newArgs = Wrapper.checkArgs(args);
        try {
            Class[] argTypes = (Class[])Arrays.stream(newArgs).map(Object::getClass).toArray(Class[]::new);
            for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
                Class<?>[] paramTypes = ctor.getParameterTypes();
                if (paramTypes.length != argTypes.length) continue;
                boolean match = true;
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (paramTypes[i].isAssignableFrom(argTypes[i])) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                ctor.setAccessible(true);
                return Optional.of(ctor.newInstance(newArgs));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @NotNull
    private static Method findMethod(@NotNull Class<?> clazz, @NotNull String name, @Nullable Object[] args) throws NoSuchMethodException {
        Class[] argTypes = (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new);
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                boolean isVarArgs;
                Class<?>[] paramTypes;
                if (!method.getName().equals(name) || !Reflections.isCompatible(argTypes, paramTypes = method.getParameterTypes(), isVarArgs = method.isVarArgs())) continue;
                method.setAccessible(true);
                return method;
            }
        }
        throw new NoSuchMethodException("No compatible method " + name + " found in class " + clazz.getName() + "(" + Arrays.toString(args) + ")");
    }

    private static boolean isCompatible(@NotNull Class<?>[] args, @NotNull Class<?>[] params, boolean isVarArgs) {
        if (!isVarArgs) {
            if (args.length != params.length) {
                return false;
            }
            for (int i = 0; i < args.length; ++i) {
                if (Primitives.wrap(params[i]).isAssignableFrom(Primitives.wrap(args[i]))) continue;
                return false;
            }
            return true;
        }
        if (args.length < params.length - 1) {
            return false;
        }
        for (int i = 0; i < params.length - 1; ++i) {
            if (Primitives.wrap(params[i]).isAssignableFrom(Primitives.wrap(args[i]))) continue;
            return false;
        }
        Class varArgType = Primitives.wrap(params[params.length - 1].getComponentType());
        for (int i = params.length - 1; i < args.length; ++i) {
            if (varArgType.isAssignableFrom(Primitives.wrap(args[i]))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static <V> ReflectionChain<V> invokeMethod(@NotNull Object object, @NotNull String methodName, Object ... args) {
        args = Wrapper.checkArgs(args);
        try {
            Method method = Reflections.findMethod(object.getClass(), methodName, args);
            method.setAccessible(true);
            return new ReflectionChain<Object>(method.invoke(object, args));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <V> ReflectionChain<V> invokeStaticMethod(@NotNull String classPath, @NotNull String methodName, Object ... args) {
        args = Wrapper.checkArgs(args);
        try {
            Class<?> clazz = Class.forName(classPath);
            Method method = Reflections.findMethod(clazz, methodName, args);
            method.setAccessible(true);
            return new ReflectionChain<Object>(method.invoke(null, args));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static Field findField(@NotNull Class<?> clazz, @NotNull String fieldName) throws NoSuchFieldException {
        while (clazz != null) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException ignored) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchFieldException();
    }

    @NotNull
    public static <T> ReflectionChain<T> getField(@NotNull Object object, @NotNull String fieldName) {
        try {
            Field field = Reflections.findField(object.getClass(), fieldName);
            return new ReflectionChain<Object>(field.get(object));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static <T, V> V getStaticField(@NotNull Class<T> clazz, @Nullable String fieldName) {
        try {
            Field field = Reflections.findField(clazz, fieldName);
            return (V)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static <T> T getStaticField(@NotNull String classPath, @NotNull String fieldName) {
        try {
            Class<?> clazz = Class.forName(classPath);
            Field field = Reflections.findField(clazz, fieldName);
            return (T)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(@NotNull Object object, @NotNull String fieldName, @Nullable Object value) {
        try {
            Field field = Reflections.findField(object.getClass(), fieldName);
            field.set(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticField(@NotNull String classPath, @NotNull String fieldName, @Nullable Object value) {
        try {
            Class<?> clazz = Class.forName(classPath);
            Field field = Reflections.findField(clazz, fieldName);
            field.set(null, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ReflectionChain<V> {
        @Nullable
        private final V value;

        public ReflectionChain(@Nullable V value) {
            this.value = value;
        }

        @NotNull
        public ReflectionChain<V> thanInvoke(@NotNull String methodName, Object ... args) {
            if (this.value == null) {
                return new ReflectionChain<Object>(null);
            }
            args = Wrapper.checkArgs(args);
            try {
                Method method = Reflections.findMethod(this.value.getClass(), methodName, args);
                method.setAccessible(true);
                return new ReflectionChain<Object>(method.invoke(this.value, args));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        public ReflectionChain<V> thanGetField(@NotNull String fieldName) {
            if (this.value == null) {
                return new ReflectionChain<Object>(null);
            }
            try {
                Field field = Reflections.findField(this.value.getClass(), fieldName);
                return new ReflectionChain<Object>(field.get(this.value));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Nullable
        public V get() {
            return this.value;
        }
    }
}

