/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.wrapper.enums;

import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.Mapping;
import de.eisi05.npc.api.wrapper.Wrapper;
import java.util.Arrays;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mapping(range=@Mapping.Range(from=Versions.V1_17, to=Versions.V1_21_11), path="net.minecraft.world.entity.EntityPose")
public enum Pose implements Wrapper.EnumWrapper
{
    STANDING(Pose.getBukkit("STANDING"), Material.ARMOR_STAND),
    FALL_FLYING(Pose.getBukkit("FALL_FLYING"), Material.FEATHER),
    SLEEPING(Pose.getBukkit("SLEEPING"), Material.RED_BED),
    SWIMMING(Pose.getBukkit("SWIMMING"), Material.WATER_BUCKET),
    SPIN_ATTACK(Pose.getBukkit("SPIN_ATTACK"), Material.TRIDENT),
    CROUCHING(Pose.getBukkit("SNEAKING"), Material.LEATHER_BOOTS),
    LONG_JUMPING(Pose.getBukkit("LONG_JUMPING"), null),
    DYING(Pose.getBukkit("DYING"), (Material)(Versions.isCurrentVersionSmallerThan(Versions.V1_19_4) ? Material.ROTTEN_FLESH : null)),
    CROAKING(Pose.getBukkit("CROAKING"), null),
    USING_TONGUE(Pose.getBukkit("USING_TONGUE"), null),
    SITTING(Pose.getBukkit("SITTING"), Versions.isCurrentVersionSmallerThan(Versions.V1_19_4) ? null : Material.OAK_STAIRS),
    ROARING(Pose.getBukkit("ROARING"), null),
    SNIFFING(Pose.getBukkit("SNIFFING"), null),
    EMERGING(Pose.getBukkit("EMERGING"), null),
    DIGGING(Pose.getBukkit("DIGGING"), null),
    SLIDING(Pose.getBukkit("SLIDING"), null),
    SHOOTING(Pose.getBukkit("SHOOTING"), null),
    INHALING(Pose.getBukkit("INHALING"), null);

    private final org.bukkit.entity.Pose bukkitPose;
    private final Material icon;

    private Pose(org.bukkit.entity.Pose bukkitPose, Material icon) {
        this.bukkitPose = bukkitPose;
        this.icon = icon;
    }

    @Nullable
    public static Pose fromBukkit(@NotNull org.bukkit.entity.Pose bukkitPose) {
        for (Pose pose : Pose.values()) {
            if (pose.bukkitPose == null || pose.bukkitPose != bukkitPose) continue;
            return pose;
        }
        return null;
    }

    @Nullable
    private static org.bukkit.entity.Pose getBukkit(@NotNull String pose) {
        try {
            return org.bukkit.entity.Pose.valueOf((String)pose);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @NotNull
    public static Pose[] getValues() {
        return (Pose[])Arrays.stream(Pose.values()).filter(pose -> pose.bukkitPose != null).toArray(Pose[]::new);
    }

    public org.bukkit.entity.Pose toBukkit() {
        return this.bukkitPose;
    }

    public boolean isForPlayer() {
        return this.icon != null;
    }

    public Material getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public Object getHandle() {
        return this.cast(this);
    }
}

