/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.listeners;

import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.NpcHolder;
import de.eisi05.npc.plugin.utils.Prefix;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

public class InventoryListener
implements Listener {
    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getView().getTopInventory().getHolder();
        if (!(inventoryHolder instanceof NpcHolder)) {
            return;
        }
        NpcHolder npcHolder = (NpcHolder)inventoryHolder;
        if (event.getPlayer().getItemOnCursor() != null) {
            event.getPlayer().setItemOnCursor(null);
        }
        if (!npcHolder.hasUnsavedChanges()) {
            return;
        }
        try {
            npcHolder.save();
        }
        catch (IOException e) {
            event.getPlayer().sendMessage(Prefix.PREFIX + ChatColor.RED + "Error while trying to save NPC!");
            throw new RuntimeException(e);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getView().getTopInventory().getHolder();
        if (!(inventoryHolder instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)inventoryHolder;
        if (event.getSlotType() == InventoryType.SlotType.OUTSIDE) {
            event.setCancelled(true);
            event.getWhoClicked().setItemOnCursor(null);
            return;
        }
        if (event.getCursor() == null) {
            return;
        }
        if (!event.getClickedInventory().equals(event.getView().getBottomInventory())) {
            return;
        }
        if (ChatColor.stripColor((String)event.getView().getTitle()).equals(npc.getName().toLegacyNoColor(false))) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        if (!(event.getView().getTopInventory().getHolder() instanceof NpcHolder)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent event) {
        if (((Player)event.getPlayer()).isConversing()) {
            event.setCancelled(true);
        }
    }
}

