/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.utils.Prefix;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker {
    private static final String VERSION = Bukkit.getBukkitVersion().split("-")[0];
    private static final String PROJECT_ID = "lMVQTkWl";
    private static final String LOADER = "spigot";
    private static final String API_URL = "https://api.modrinth.com/v2/project/lMVQTkWl/version";
    private static final String PROJECT_LINK = "https://modrinth.com/plugin/npc-plugin?version=" + VERSION + "&loader=spigot#download";
    private static String LATEST = null;
    private static long lastCheck = 0L;

    public static void checkForUpdates(@Nullable Player player, boolean withFeedback) {
        if (player != null && LATEST != null && lastCheck >= System.currentTimeMillis() - 86400000L) {
            if (lastCheck >= player.getLastPlayed()) {
                UpdateChecker.sendMessage(player, LATEST);
            }
            return;
        }
        lastCheck = System.currentTimeMillis();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)NpcPlugin.plugin, () -> {
            block6: {
                try {
                    URL url = new URL(API_URL);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestProperty("User-Agent", NpcPlugin.plugin.getName());
                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    String json = reader.lines().collect(Collectors.joining());
                    reader.close();
                    JsonArray versions = new JsonParser().parse(json).getAsJsonArray();
                    for (JsonElement element : versions) {
                        String current;
                        JsonObject version = element.getAsJsonObject();
                        JsonArray loaders = version.getAsJsonArray("loaders");
                        if (!loaders.toString().contains(LOADER)) continue;
                        String latest = version.get("version_number").getAsString();
                        if (!latest.equalsIgnoreCase(current = NpcPlugin.plugin.getDescription().getVersion())) {
                            Bukkit.getConsoleSender().sendMessage(Prefix.PREFIX + ChatColor.GRAY + "New version available: " + ChatColor.GREEN + latest + ChatColor.GRAY + " \u2192 " + ChatColor.BLUE + PROJECT_LINK);
                            Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> {
                                LATEST = latest;
                                UpdateChecker.sendMessage(player, LATEST);
                            });
                        } else if (player != null && withFeedback) {
                            Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> player.sendMessage(Prefix.PREFIX + ChatColor.GRAY + "You are on the latest version!"));
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    NpcPlugin.plugin.getLogger().warning("Failed to check for updates");
                    if (player == null || !withFeedback) break block6;
                    Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> player.sendMessage(Prefix.PREFIX + ChatColor.RED + "Failed to check for updates!"));
                }
            }
        });
    }

    public static void sendMessage(@Nullable Player player, @NotNull String latest) {
        if (player != null) {
            BaseComponent[] prefix = TextComponent.fromLegacyText((String)Prefix.PREFIX);
            TextComponent textComponent = new TextComponent(ChatColor.GRAY + "New version available: " + ChatColor.GREEN + latest + ChatColor.GRAY + " \u2192 ");
            TextComponent linkComponent = new TextComponent("[Update]");
            linkComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, PROJECT_LINK));
            linkComponent.setColor(net.md_5.bungee.api.ChatColor.AQUA);
            textComponent.addExtra((BaseComponent)linkComponent);
            player.spigot().sendMessage((BaseComponent[])Stream.concat(Arrays.stream(prefix), Stream.of(textComponent)).toArray(BaseComponent[]::new));
        }
    }
}

