/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils.builder;

import de.eisi05.npc.api.utils.PacketReader;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.objects.WrappedComponent;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import de.eisi05.npc.api.wrapper.packets.PacketWrapper;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.events.SignInputEvent;
import de.eisi05.npc.plugin.utils.wrapper.OpenSignEditorPacket;
import de.eisi05.npc.plugin.utils.wrapper.SignBlockEntity;
import de.eisi05.npc.plugin.utils.wrapper.SignUpdatePacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class SignBuilder
implements Listener {
    private static final Map<UUID, Consumer<SignInputEvent>> events = new HashMap<UUID, Consumer<SignInputEvent>>();

    public SignBuilder() {
        PacketReader.addReader((player, o) -> {
            if (!PacketWrapper.PacketHolder.is(o, SignUpdatePacket.class)) {
                return;
            }
            SignUpdatePacket packet = PacketWrapper.PacketHolder.wrap(o, SignUpdatePacket.class);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NpcPlugin.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new SignInputEvent((Player)player, packet.getLocation(), packet.getLines())), 0L);
        });
    }

    public static void open(@NotNull Player player, @NotNull Consumer<SignInputEvent> event, String ... text) {
        Location location = new Location(player.getWorld(), (double)player.getLocation().getBlockX(), (double)player.getLocation().getBlockY(), (double)player.getLocation().getBlockZ());
        while (!location.getBlock().getType().isAir()) {
            location.setY(location.getY() + 1.0);
        }
        SignBlockEntity sign = new SignBlockEntity(location);
        sign.setAllowedPlayerEditor(player.getUniqueId());
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_20)) {
            for (int i = 0; i < text.length; ++i) {
                sign.setText(i, WrappedComponent.parseFromLegacy(text[i]));
            }
        } else {
            SignBlockEntity.SignText signText = sign.getText();
            for (int i = 0; i < text.length; ++i) {
                signText = signText.setMessage(i, WrappedComponent.parseFromLegacy(text[i]));
            }
            sign.setSignText(signText);
        }
        sign.setLevel(player.getWorld());
        player.sendBlockChange(location, Material.OAK_SIGN.createBlockData());
        WrappedServerPlayer serverPlayer = WrappedServerPlayer.fromPlayer(player);
        serverPlayer.sendPacket(sign.getUpdatePacket());
        serverPlayer.sendPacket(new OpenSignEditorPacket(location));
        events.put(player.getUniqueId(), event);
    }

    @EventHandler
    public void onSign(SignInputEvent event) {
        events.getOrDefault(event.getPlayer().getUniqueId(), (Consumer<SignInputEvent>)((Consumer)event1 -> {})).accept((Object)event);
        Location location = event.getLocation();
        location.setWorld(event.getPlayer().getWorld());
        event.getPlayer().sendBlockChange(location, location.getBlock().getBlockData());
        events.remove(event.getPlayer().getUniqueId());
    }
}

