/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.gui;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.enums.ClickActionType;
import de.eisi05.npc.api.enums.SkinParts;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.manager.NpcManager;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.NpcName;
import de.eisi05.npc.api.objects.NpcOption;
import de.eisi05.npc.api.objects.NpcSkin;
import de.eisi05.npc.api.objects.Skin;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.wrapper.enums.ChatFormat;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.manager.TimeZoneManager;
import de.eisi05.npc.plugin.objects.NpcClickActionImpl;
import de.eisi05.npc.plugin.utils.ColorConverter;
import de.eisi05.npc.plugin.utils.EquipmentModifier;
import de.eisi05.npc.plugin.utils.ItemList;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import de.eisi05.npc.plugin.utils.Prefix;
import de.eisi05.npc.plugin.utils.StringHelper;
import de.eisi05.npc.plugin.utils.builder.InventoryBuilder;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import de.eisi05.npc.plugin.utils.builder.PageInventoryBuilder;
import de.eisi05.npc.plugin.utils.builder.SignBuilder;
import de.eisi05.npc.plugin.utils.builder.SkullBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpcGUI {
    private static final Map<UUID, ListSettings> listSettingsMap = new HashMap<UUID, ListSettings>();

    private static void playSoundForPlayer(@NotNull InventoryClickEvent event, @Nullable Sound sound, float volume, float pitch) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (sound != null) {
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
    }

    private static void updateBooleanOptionItem(@NotNull InventoryClickEvent event, @NotNull NPC npc, @NotNull NpcOption<Boolean, ?> option, boolean newValue) {
        npc.setOption(option, newValue);
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        ArrayList<Component> lore = meta.lore();
        if (lore == null) {
            lore = new ArrayList<Component>();
        }
        lore.set(lore.size() - 1, LocalizationManager.get((Player)event.getWhoClicked(), "menu.option.value", Component.text((boolean)newValue).color((TextColor)(newValue ? NamedTextColor.GREEN : NamedTextColor.RED))).decoration(TextDecoration.ITALIC, false));
        meta.lore(lore);
        item.setItemMeta(meta);
    }

    private static void updateValueLore(@NotNull InventoryClickEvent event, @NotNull Component valueDisplay) {
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.lore();
        if (lore == null || lore.isEmpty()) {
            return;
        }
        lore.set(lore.size() - 1, LocalizationManager.get((Player)event.getWhoClicked(), "menu.option.value", valueDisplay).decoration(TextDecoration.ITALIC, false));
        meta.lore(lore);
        item.setItemMeta(meta);
    }

    @NotNull
    public static InventoryBuilder getInventory(final @NotNull NPC npc, final @NotNull Player player, final boolean isList) {
        InventoryBuilder builder = new InventoryBuilder((InventoryHolder)npc, 54, npc.getName());
        Map<EquipmentSlot, ItemStack> equipment = npc.getOption(NpcOption.EQUIPMENT);
        builder.setItem(4, NpcGUI.getEquipment(npc, equipment, EquipmentSlot.HEAD, isList, player));
        builder.setItem(13, NpcGUI.getEquipment(npc, equipment, EquipmentSlot.CHEST, isList, player));
        builder.setItem(22, NpcGUI.getEquipment(npc, equipment, EquipmentSlot.LEGS, isList, player));
        builder.setItem(31, NpcGUI.getEquipment(npc, equipment, EquipmentSlot.FEET, isList, player));
        builder.setItem(12, NpcGUI.getEquipment(npc, equipment, EquipmentSlot.HAND, isList, player));
        builder.setItem(14, NpcGUI.getEquipment(npc, equipment, EquipmentSlot.OFF_HAND, isList, player));
        Skin skinOption = npc.getOption(NpcOption.SKIN) == null ? null : npc.getOption(NpcOption.SKIN).getSkin(player, npc);
        builder.setItem(0, NpcGUI.createIcon(skinOption == null ? SkullBuilder.skullFromGameProfile(((ServerPlayer)npc.getServerPlayer()).getGameProfile()) : SkullBuilder.skullFromId(skinOption.value()), (Object)(skinOption == null ? "?" : skinOption.name()), "skin", (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            Player whoClicked = (Player)inventoryClickEvent.getWhoClicked();
            whoClicked.closeInventory();
            ConversationManager conversation = new ConversationManager((Plugin)NpcPlugin.plugin).withEscapeSequence(LocalizationManager.getAsString(whoClicked, "menu.option.skin.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(event -> {
                Player p = event.player();
                if (event.gracefulExit()) {
                    p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 0.8f);
                    return;
                }
                p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                if ("timeout".equals(event.reason())) {
                    LocalizedMessage.sendMessage(p, "menu.option.skin.input.timeout", true, new Object[0]);
                } else {
                    LocalizedMessage.sendMessage(p, "menu.option.skin.input.cancelled", true, new Object[0]);
                }
                Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> p.openInventory(NpcGUI.getInventory(npc, p, isList).getInventory()));
            });
            ConversationManager.Prompt skinPrompt = new ConversationManager.Prompt(){

                @Override
                public Component getPromptText(Player p) {
                    return Prefix.PREFIX.append(LocalizationManager.get(p, "menu.option.skin.prompt", new Object[0]));
                }

                @Override
                public ConversationManager.Prompt onInput(Player p, String input) {
                    CompletableFuture<Optional<Skin>> skinFuture;
                    String failedKey;
                    if (input == null || input.trim().isEmpty()) {
                        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(p, "menu.option.skin.input.empty", true, new Object[0]);
                        return this;
                    }
                    String finalInput = input.trim();
                    if (finalInput.endsWith(".png")) {
                        File file = new File(finalInput);
                        if (!file.exists()) {
                            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                            LocalizedMessage.sendMessage(player, "menu.option.skin.file.not-found", true, new Object[0]);
                            return this;
                        }
                        failedKey = "menu.option.skin.fetching.failed.file";
                        skinFuture = Skin.fetchSkinAsync(file);
                        LocalizedMessage.sendMessage(player, "menu.option.skin.fetching.file", true, finalInput);
                    } else {
                        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") && PlaceholderAPI.containsPlaceholders((String)finalInput)) {
                            npc.setOption(NpcOption.SKIN, NpcSkin.of((player2, npc1) -> {
                                CompletableFuture<Optional<Skin>> skinFuture1;
                                String placeholder = PlaceholderAPI.setPlaceholders((Player)player2, (String)finalInput);
                                if (PlaceholderAPI.containsPlaceholders((String)placeholder)) {
                                    return null;
                                }
                                try {
                                    UUID uuid = UUID.fromString(placeholder);
                                    if (Skin.isPreLoaded(uuid)) {
                                        return Skin.fetchSkin(uuid).orElse(null);
                                    }
                                    skinFuture1 = Skin.fetchSkinAsync(uuid);
                                }
                                catch (IllegalArgumentException e) {
                                    if (Skin.isPreLoaded(placeholder)) {
                                        return Skin.fetchSkin(placeholder).orElse(null);
                                    }
                                    skinFuture1 = Skin.fetchSkinAsync(placeholder);
                                }
                                skinFuture1.thenAcceptAsync(skin -> Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> {
                                    npc1.hideNpcFromPlayer((Player)player2);
                                    npc1.showNPCToPlayer((Player)player2);
                                }));
                                return null;
                            }, new Skin(finalInput, null, null)));
                            npc.markChange();
                            p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
                            LocalizedMessage.sendMessage(p, "menu.option.skin.success", true, new Object[0]);
                            return null;
                        }
                        try {
                            UUID uuid = UUID.fromString(finalInput);
                            failedKey = "menu.option.skin.fetching.failed.uuid";
                            skinFuture = Skin.fetchSkinAsync(uuid);
                            LocalizedMessage.sendMessage(p, "menu.option.skin.fetching.uuid", true, finalInput);
                        }
                        catch (IllegalArgumentException e) {
                            failedKey = "menu.option.skin.fetching.failed.name";
                            skinFuture = Skin.fetchSkinAsync(finalInput);
                            LocalizedMessage.sendMessage(p, "menu.option.skin.fetching.name", true, finalInput);
                        }
                    }
                    String finalFailedKey = failedKey;
                    ((CompletableFuture)skinFuture.orTimeout(10L, TimeUnit.SECONDS).thenAcceptAsync(skin -> {
                        if (skin.isEmpty()) {
                            Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> {
                                p.playSound(p.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                                LocalizedMessage.sendMessage(p, finalFailedKey, true, finalInput);
                                p.openInventory(NpcGUI.getInventory(npc, p, isList).getInventory());
                            });
                            return;
                        }
                        npc.setOption(NpcOption.SKIN, NpcSkin.of((Skin)skin.get()));
                        Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> {
                            npc.markChange();
                            p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
                            LocalizedMessage.sendMessage(p, "menu.option.skin.success", true, new Object[0]);
                            p.openInventory(NpcGUI.getInventory(npc, p, isList).getInventory());
                        });
                    }, runnable -> Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, runnable))).exceptionally(throwable -> {
                        Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> {
                            p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                            LocalizedMessage.sendMessage(p, finalFailedKey, true, finalInput);
                            p.openInventory(NpcGUI.getInventory(npc, p, isList).getInventory());
                        });
                        return null;
                    });
                    return null;
                }
            };
            conversation.startConversation(whoClicked, skinPrompt);
        }, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f, player));
        builder.setItem(10, NpcGUI.createIcon(SkullBuilder.fromPlayer(player), (Object)npc.getOption(NpcOption.USE_PLAYER_SKIN), "use-player-skin", (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            boolean currentValue = npc.getOption(NpcOption.USE_PLAYER_SKIN);
            boolean newValue = inventoryClickEvent.getClick() == ClickType.MIDDLE ? NpcOption.USE_PLAYER_SKIN.getDefaultValue() : !currentValue;
            HumanEntity patt0$temp = inventoryClickEvent.getWhoClicked();
            if (patt0$temp instanceof Player) {
                Player p = (Player)patt0$temp;
                p.playSound(p.getLocation(), newValue ? Sound.BLOCK_NOTE_BLOCK_PLING : Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, newValue ? 1.5f : 1.0f);
            }
            npc.markChange();
            NpcGUI.updateBooleanOptionItem(inventoryClickEvent, npc, NpcOption.USE_PLAYER_SKIN, newValue);
        }, null, 0.0f, 0.0f, player));
        builder.setItem(18, NpcGUI.createIcon(Material.REPEATER, (Object)NpcGUI.getBars(npc.getOption(NpcOption.LATENCY)), "latency", (InventoryClickEvent inventoryClickEvent) -> {
            int currentLatency;
            inventoryClickEvent.setCancelled(true);
            int newLatency = currentLatency = npc.getOption(NpcOption.LATENCY).intValue();
            float pitch = 1.0f;
            if (inventoryClickEvent.getClick().isLeftClick()) {
                if (currentLatency < 1600) {
                    newLatency = Math.min(1600, NpcGUI.roundToNextLatencyStep(currentLatency, true));
                    pitch = 1.2f;
                } else {
                    pitch = 0.8f;
                }
            } else if (inventoryClickEvent.getClick().isRightClick()) {
                if (currentLatency > 100) {
                    newLatency = Math.max(100, NpcGUI.roundToNextLatencyStep(currentLatency, false));
                    pitch = 0.8f;
                } else {
                    pitch = 1.2f;
                }
            } else if (inventoryClickEvent.getClick() == ClickType.MIDDLE) {
                newLatency = NpcOption.LATENCY.getDefaultValue();
                pitch = 1.0f;
            }
            if (newLatency != currentLatency) {
                NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.BLOCK_COMPARATOR_CLICK, 1.0f, pitch);
                npc.markChange();
                npc.setOption(NpcOption.LATENCY, newLatency);
                NpcGUI.updateValueLore(inventoryClickEvent, NpcGUI.getBars(newLatency));
            } else {
                NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.UI_BUTTON_CLICK, 1.0f, 0.7f);
            }
        }, null, 0.0f, 0.0f, player));
        builder.setItem(20, NpcGUI.createIcon(Material.MAP, (Object)npc.getOption(NpcOption.SHOW_TAB_LIST), "show-tab-list", (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            boolean currentValue = npc.getOption(NpcOption.SHOW_TAB_LIST);
            boolean newValue = inventoryClickEvent.getClick() == ClickType.MIDDLE ? NpcOption.SHOW_TAB_LIST.getDefaultValue() : !currentValue;
            HumanEntity patt0$temp = inventoryClickEvent.getWhoClicked();
            if (patt0$temp instanceof Player) {
                Player p = (Player)patt0$temp;
                p.playSound(p.getLocation(), newValue ? Sound.BLOCK_NOTE_BLOCK_PLING : Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, newValue ? 1.5f : 1.0f);
            }
            npc.markChange();
            NpcGUI.updateBooleanOptionItem(inventoryClickEvent, npc, NpcOption.SHOW_TAB_LIST, newValue);
        }, null, 0.0f, 0.0f, player));
        builder.setItem(28, NpcGUI.createIcon(Material.OAK_SIGN, (Object)npc.getOption(NpcOption.HIDE_NAMETAG), "hide-nametag", (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            boolean currentValue = npc.getOption(NpcOption.HIDE_NAMETAG);
            boolean newValue = inventoryClickEvent.getClick() == ClickType.MIDDLE ? NpcOption.HIDE_NAMETAG.getDefaultValue() : !currentValue;
            HumanEntity patt0$temp = inventoryClickEvent.getWhoClicked();
            if (patt0$temp instanceof Player) {
                Player p = (Player)patt0$temp;
                p.playSound(p.getLocation(), newValue ? Sound.BLOCK_NOTE_BLOCK_PLING : Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, newValue ? 1.5f : 1.0f);
            }
            npc.markChange();
            NpcGUI.updateBooleanOptionItem(inventoryClickEvent, npc, NpcOption.HIDE_NAMETAG, newValue);
        }, null, 0.0f, 0.0f, player));
        builder.setItem(36, NpcGUI.createIcon(Material.LADDER, (Object)(NpcOption.LIST_ORDER.isCompatible() ? npc.getOption(NpcOption.LIST_ORDER) : LocalizationManager.get(player, "menu.option.incompatible.title", new Object[0])), LocalizationManager.get(player, "menu.option.list-order.title", new Object[0]).decoration(TextDecoration.STRIKETHROUGH, !NpcOption.LIST_ORDER.isCompatible()), NpcOption.LIST_ORDER.isCompatible() ? LocalizationManager.getAsList(player, "menu.option.list-order.description", new Object[0]) : LocalizationManager.getAsList(player, "menu.option.incompatible.description", NpcOption.SCALE.since().getName()), (InventoryClickEvent inventoryClickEvent) -> {
            int currentListOrder;
            inventoryClickEvent.setCancelled(true);
            int newListOrder = currentListOrder = npc.getOption(NpcOption.LIST_ORDER).intValue();
            ClickType click = inventoryClickEvent.getClick();
            if (click.isLeftClick()) {
                newListOrder = click.isShiftClick() ? Math.min(currentListOrder * 2, Integer.MAX_VALUE) : Math.min(currentListOrder + 1, Integer.MAX_VALUE);
            } else if (click.isRightClick()) {
                newListOrder = click.isShiftClick() ? Math.floorDiv(currentListOrder, 2) : currentListOrder - 1;
            } else if (click == ClickType.MIDDLE) {
                newListOrder = NpcOption.LIST_ORDER.getDefaultValue();
            }
            newListOrder = Math.max(0, newListOrder);
            if (newListOrder != currentListOrder) {
                NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.BLOCK_COMPARATOR_CLICK, 1.0f, 1.0f);
                npc.setOption(NpcOption.LIST_ORDER, newListOrder);
                npc.markChange();
                NpcGUI.updateValueLore(inventoryClickEvent, ((TextComponent)Component.text((int)newListOrder).color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
            } else {
                NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.UI_BUTTON_CLICK, 1.0f, 0.7f);
            }
        }, null, 0.0f, 0.0f, player));
        Pose currentPose = npc.getOption(NpcOption.POSE);
        builder.setItem(38, NpcGUI.createIcon(NpcGUI.getPoseIcon(currentPose) == null ? Material.ARMOR_STAND : NpcGUI.getPoseIcon(currentPose), (Object)StringHelper.toTitleCase(npc.getOption(NpcOption.POSE).name()), "pose", (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.ITEM_ARMOR_EQUIP_CHAIN, 1.0f, 1.2f);
            Player whoClicked = (Player)inventoryClickEvent.getWhoClicked();
            InventoryBuilder poseBuilder = new InventoryBuilder((InventoryHolder)npc, 27, npc.getName().append(((TextComponent)Component.text((String)" >> ").color((TextColor)NamedTextColor.DARK_GRAY)).append(StringHelper.stripColors(LocalizationManager.get((Player)inventoryClickEvent.getWhoClicked(), "menu.option.pose.title", new Object[0])))).color((TextColor)NamedTextColor.DARK_GRAY));
            Pose[] availablePoses = (Pose[])Arrays.stream(Pose.values()).filter(pose1 -> NpcGUI.getPoseIcon(pose1) != null).toArray(Pose[]::new);
            poseBuilder.setArrowLeft(LocalizationManager.get(player, "misc.back", new Object[0]).decoration(TextDecoration.ITALIC, false), e -> {
                NpcGUI.playSoundForPlayer(e, Sound.UI_BUTTON_CLICK, 1.0f, 0.8f);
                e.getWhoClicked().openInventory(NpcGUI.getInventory(npc, (Player)e.getWhoClicked(), isList).getInventory());
            });
            for (int i = 0; i < availablePoses.length; ++i) {
                Pose poseOption = availablePoses[i];
                ItemBuilder poseItem = new ItemBuilder(NpcGUI.getPoseIcon(poseOption) == null ? Material.ARMOR_STAND : NpcGUI.getPoseIcon(poseOption)).setName(((TextComponent)Component.text((String)StringHelper.toTitleCase(poseOption.name())).color((TextColor)NamedTextColor.BLUE)).decoration(TextDecoration.ITALIC, false)).setClickHandler(e -> {
                    e.setCancelled(true);
                    NpcGUI.playSoundForPlayer(e, Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f);
                    npc.markChange();
                    npc.setOption(NpcOption.POSE, poseOption);
                    Objects.requireNonNull(e.getClickedInventory()).forEach(itemStack -> {
                        if (itemStack != null) {
                            itemStack.removeEnchantment(Enchantment.LUCK_OF_THE_SEA);
                        }
                    });
                    Objects.requireNonNull(e.getCurrentItem()).addUnsafeEnchantment(Enchantment.LUCK_OF_THE_SEA, 1);
                });
                if (poseOption == npc.getOption(NpcOption.POSE)) {
                    poseItem.addEnchantment(Enchantment.LUCK_OF_THE_SEA, 1);
                }
                poseBuilder.setItem(i + 10, poseItem.hideFlags(true).build());
            }
            whoClicked.openInventory(poseBuilder.fillOut().getInventory());
        }, Sound.ITEM_ARMOR_EQUIP_CHAIN, 1.0f, 1.0f, player));
        builder.setItem(8, NpcGUI.createIcon(Material.LEATHER_HELMET, npc.getOption(NpcOption.SKIN_PARTS).length == 0 ? LocalizationManager.get(player, "menu.option.skin-parts.none", new Object[0]) : Stream.concat(Stream.of(Component.empty()), Arrays.stream(npc.getOption(NpcOption.SKIN_PARTS)).map(s -> (TextComponent)((TextComponent)Component.text((String)" \u2022 ").color((TextColor)NamedTextColor.GRAY)).append(LocalizationManager.get(player, "menu.option.skin-parts." + s.name().replace("_", "-").toLowerCase(), new Object[0]).color((TextColor)NamedTextColor.GREEN)))).toList(), "skin-parts", (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.2f);
            Player whoClicked = (Player)inventoryClickEvent.getWhoClicked();
            InventoryBuilder skinPartsBuilder = new InventoryBuilder((InventoryHolder)npc, 27, npc.getName().append(((TextComponent)((TextComponent)Component.text((String)" >> ").color((TextColor)NamedTextColor.DARK_GRAY)).append(StringHelper.stripColors(LocalizationManager.get((Player)inventoryClickEvent.getWhoClicked(), "menu.option.skin-parts.title", new Object[0])))).color((TextColor)NamedTextColor.DARK_GRAY)));
            skinPartsBuilder.setArrowLeft(LocalizationManager.get(player, "misc.back", new Object[0]).decoration(TextDecoration.ITALIC, false), e -> {
                NpcGUI.playSoundForPlayer(e, Sound.UI_BUTTON_CLICK, 1.0f, 0.8f);
                e.getWhoClicked().openInventory(NpcGUI.getInventory(npc, (Player)e.getWhoClicked(), isList).getInventory());
            });
            SkinParts[] allSkinParts = SkinParts.values();
            ArrayList<SkinParts> currentVisibleParts = new ArrayList<SkinParts>(Arrays.asList(npc.getOption(NpcOption.SKIN_PARTS)));
            for (int i = 0; i < allSkinParts.length; ++i) {
                SkinParts skinPart = allSkinParts[i];
                ItemBuilder skinPartItem = new ItemBuilder(skinPart.getIcon()).setName(LocalizationManager.get((Player)inventoryClickEvent.getWhoClicked(), "menu.option.skin-parts." + skinPart.name().replace("_", "-").toLowerCase(), new Object[0]).color((TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false)).setClickHandler(e -> {
                    e.setCancelled(true);
                    ItemStack clickedItem = e.getCurrentItem();
                    if (clickedItem == null) {
                        return;
                    }
                    boolean wasVisible = currentVisibleParts.contains(skinPart);
                    if (wasVisible) {
                        currentVisibleParts.remove(skinPart);
                        clickedItem.removeEnchantment(Enchantment.LUCK_OF_THE_SEA);
                        NpcGUI.playSoundForPlayer(e, Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, 1.0f);
                    } else {
                        currentVisibleParts.add(skinPart);
                        clickedItem.addUnsafeEnchantment(Enchantment.LUCK_OF_THE_SEA, 1);
                        NpcGUI.playSoundForPlayer(e, Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.2f);
                    }
                    npc.markChange();
                    npc.setOption(NpcOption.SKIN_PARTS, currentVisibleParts.toArray(new SkinParts[0]));
                });
                if (currentVisibleParts.contains(skinPart)) {
                    skinPartItem.addEnchantment(Enchantment.LUCK_OF_THE_SEA, 1);
                }
                skinPartsBuilder.setItem(i + 10, skinPartItem.hideFlags(true).build());
            }
            whoClicked.openInventory(skinPartsBuilder.fillOut().getInventory());
        }, Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 1.0f, player));
        double lookAtPlayerRadius = npc.getOption(NpcOption.LOOK_AT_PLAYER);
        builder.setItem(16, NpcGUI.createIcon(Material.OBSERVER, (Object)(lookAtPlayerRadius == 0.0 ? LocalizationManager.get(player, "misc.disabled", new Object[0]) : Component.text((double)lookAtPlayerRadius).color((TextColor)NamedTextColor.GREEN)), "look-at-player", (InventoryClickEvent inventoryClickEvent) -> {
            double currentRadius;
            inventoryClickEvent.setCancelled(true);
            double newRadius = currentRadius = npc.getOption(NpcOption.LOOK_AT_PLAYER).doubleValue();
            float pitch = 1.0f;
            if (inventoryClickEvent.getClick().isLeftClick()) {
                newRadius = Math.min(64.0, currentRadius + 1.0);
                pitch = newRadius == currentRadius ? 0.8f : 1.2f;
            } else if (inventoryClickEvent.getClick().isRightClick()) {
                newRadius = Math.max(0.0, currentRadius - 1.0);
                pitch = newRadius == currentRadius ? 1.2f : 0.8f;
            } else if (inventoryClickEvent.getClick() == ClickType.MIDDLE) {
                newRadius = NpcOption.LOOK_AT_PLAYER.getDefaultValue();
                pitch = 1.0f;
            }
            if (newRadius != currentRadius) {
                NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.BLOCK_COMPARATOR_CLICK, 1.0f, pitch);
                npc.markChange();
                npc.setOption(NpcOption.LOOK_AT_PLAYER, newRadius);
                NpcGUI.updateValueLore(inventoryClickEvent, newRadius == 0.0 ? LocalizationManager.get((Player)inventoryClickEvent.getWhoClicked(), "misc.disabled", new Object[0]).decoration(TextDecoration.ITALIC, false) : ((TextComponent)Component.text((double)newRadius).color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
            } else {
                NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.UI_BUTTON_CLICK, 1.0f, 0.7f);
            }
        }, null, 0.0f, 0.0f, player));
        ChatFormat glowingColor = npc.getOption(NpcOption.GLOWING);
        builder.setItem(24, NpcGUI.createIcon(glowingColor == null ? Material.REDSTONE : Material.GLOWSTONE_DUST, (Object)(glowingColor == null ? LocalizationManager.get(player, "misc.disabled", new Object[0]) : LocalizationManager.get(player, "menu.option.glowing.color." + glowingColor.name().replace("_", "-").toLowerCase(), new Object[0]).style(builder1 -> {
            TextFormat patt0$temp = glowingColor.getTextFormat();
            if (patt0$temp instanceof TextColor) {
                TextColor color = (TextColor)patt0$temp;
                builder1.color(color);
            }
        })), "glowing", (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.5f);
            Player whoClicked = (Player)inventoryClickEvent.getWhoClicked();
            InventoryBuilder glowBuilder = new InventoryBuilder((InventoryHolder)npc, 45, npc.getName().append(((TextComponent)((TextComponent)Component.text((String)" >> ").color((TextColor)NamedTextColor.DARK_GRAY)).append(StringHelper.stripColors(LocalizationManager.get((Player)inventoryClickEvent.getWhoClicked(), "menu.option.glowing.title", new Object[0])))).color((TextColor)NamedTextColor.DARK_GRAY)));
            glowBuilder.setArrowLeft(LocalizationManager.get(player, "misc.back", new Object[0]).decoration(TextDecoration.ITALIC, false), e -> {
                NpcGUI.playSoundForPlayer(e, Sound.UI_BUTTON_CLICK, 1.0f, 0.8f);
                e.getWhoClicked().openInventory(NpcGUI.getInventory(npc, (Player)e.getWhoClicked(), isList).getInventory());
            });
            List<ChatFormat> colors = Arrays.stream(ChatFormat.values()).filter(ChatFormat::isColor).toList();
            for (int i = 0; i < colors.size(); ++i) {
                NamedTextColor namedTextColor;
                ChatFormat color = colors.get(i);
                TextFormat format = color.getTextFormat();
                ItemBuilder itemBuilder = new ItemBuilder(ColorConverter.getMaterial(color));
                Component component = LocalizationManager.get((Player)inventoryClickEvent.getWhoClicked(), "menu.option.glowing.color." + color.name().replace("_", "-").toLowerCase(), new Object[0]);
                if (format instanceof TextColor) {
                    TextColor color1 = (TextColor)format;
                    namedTextColor = color1;
                } else {
                    namedTextColor = NamedTextColor.GRAY;
                }
                ItemBuilder dyeBuilder = itemBuilder.setName(component.color((TextColor)namedTextColor).decoration(TextDecoration.ITALIC, false)).setClickHandler(e -> {
                    e.setCancelled(true);
                    NpcGUI.playSoundForPlayer(e, Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.2f);
                    npc.markChange();
                    npc.setOption(NpcOption.GLOWING, color);
                    e.getWhoClicked().openInventory(NpcGUI.getInventory(npc, (Player)e.getWhoClicked(), isList).getInventory());
                });
                if (npc.getOption(NpcOption.GLOWING) == color) {
                    dyeBuilder.addEnchantment(Enchantment.LUCK_OF_THE_SEA, 1);
                }
                int row = i / 7;
                int col = i % 7;
                glowBuilder.setItem(10 + row * 9 + col, dyeBuilder.hideFlags(true).build());
            }
            ItemBuilder disabledItem = new ItemBuilder(Material.BARRIER).setName(LocalizationManager.get((Player)inventoryClickEvent.getWhoClicked(), "menu.option.glowing.disable", new Object[0]).decoration(TextDecoration.ITALIC, false)).setClickHandler(e -> {
                e.setCancelled(true);
                NpcGUI.playSoundForPlayer(e, Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 1.0f);
                npc.markChange();
                npc.setOption(NpcOption.GLOWING, null);
                e.getWhoClicked().openInventory(NpcGUI.getInventory(npc, (Player)e.getWhoClicked(), isList).getInventory());
            });
            if (npc.getOption(NpcOption.GLOWING) == null) {
                disabledItem.addEnchantment(Enchantment.LUCK_OF_THE_SEA, 1);
            }
            glowBuilder.setItem(40, disabledItem.hideFlags(true).build());
            whoClicked.openInventory(glowBuilder.fillOut().getInventory());
        }, Sound.BLOCK_BEACON_AMBIENT, 1.0f, 1.2f, player));
        builder.setItem(26, NpcGUI.createIcon(Material.SLIME_BALL, (Object)(NpcOption.SCALE.isCompatible() ? npc.getOption(NpcOption.SCALE) : LocalizationManager.get(player, "menu.option.incompatible.title", new Object[0])), LocalizationManager.get(player, "menu.option.scale.title", new Object[0]).decoration(TextDecoration.STRIKETHROUGH, !NpcOption.SCALE.isCompatible()), NpcOption.SCALE.isCompatible() ? LocalizationManager.getAsList(player, "menu.option.scale.description", new Object[0]) : LocalizationManager.getAsList(player, "menu.option.incompatible.description", NpcOption.SCALE.since().getName()), (InventoryClickEvent inventoryClickEvent) -> {
            double currentScale;
            inventoryClickEvent.setCancelled(true);
            double newScale = currentScale = npc.getOption(NpcOption.SCALE).doubleValue();
            float pitch = 1.0f;
            if (inventoryClickEvent.getClick().isLeftClick()) {
                newScale = Math.min(16.0, (double)Math.round((currentScale + 0.1) * 10.0) / 10.0);
                pitch = Math.abs(newScale - currentScale) < 0.001 ? 0.8f : 1.2f;
            } else if (inventoryClickEvent.getClick().isRightClick()) {
                newScale = Math.max(0.1, (double)Math.round((currentScale - 0.1) * 10.0) / 10.0);
                pitch = Math.abs(newScale - currentScale) < 0.001 ? 1.2f : 0.8f;
            } else if (inventoryClickEvent.getClick() == ClickType.MIDDLE) {
                newScale = NpcOption.SCALE.getDefaultValue();
                pitch = 1.0f;
            }
            if (Math.abs(newScale - currentScale) > 0.001) {
                NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.ENTITY_SLIME_SQUISH_SMALL, 1.0f, pitch);
                npc.markChange();
                npc.setOption(NpcOption.SCALE, newScale);
                NpcGUI.updateValueLore(inventoryClickEvent, ((TextComponent)Component.text((double)newScale).color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
            } else {
                NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.UI_BUTTON_CLICK, 1.0f, 0.7f);
            }
        }, null, 0.0f, 0.0f, player));
        builder.setItem(34, NpcGUI.createIcon(Material.NAME_TAG, (Object)(npc.getName().equals((Object)Component.empty()) ? "?" : npc.getName()), "name", (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            Player whoClicked = (Player)inventoryClickEvent.getWhoClicked();
            whoClicked.closeInventory();
            ConversationManager conversation = new ConversationManager((Plugin)NpcPlugin.plugin).withEscapeSequence(LocalizationManager.getAsString(player, "menu.option.name.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(event -> {
                Player p = event.player();
                if (event.gracefulExit()) {
                    return;
                }
                p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                if ("timeout".equals(event.reason())) {
                    LocalizedMessage.sendMessage(p, "menu.option.name.input.timeout", true, NpcApi.config.inputTime());
                } else {
                    LocalizedMessage.sendMessage(p, "menu.option.name.input.cancelled", true, NpcApi.config.inputTime());
                }
                Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> p.openInventory(NpcGUI.getInventory(npc, p, isList).getInventory()));
            });
            ConversationManager.Prompt namePrompt = new ConversationManager.Prompt(){

                @Override
                public Component getPromptText(Player p) {
                    Component name = npc.getName();
                    TextComponent finalCompontent = Component.empty();
                    if (name != null && !name.equals((Object)Component.empty())) {
                        boolean hasNonWhite = name.children().stream().map(Component::color).filter(Objects::nonNull).anyMatch(color -> !NamedTextColor.WHITE.equals(color));
                        Component result = name;
                        if (!hasNonWhite) {
                            result = name.replaceText(builder -> builder.match("").replacement((ComponentLike)Component.text((String)"", (TextColor)NamedTextColor.WHITE)));
                        }
                        String withColorCodes = LegacyComponentSerializer.legacyAmpersand().serialize(result);
                        finalCompontent = LocalizationManager.get(p, "menu.option.name.edit.text", new Object[0]).color((TextColor)NamedTextColor.GREEN).decorate(TextDecoration.ITALIC).clickEvent(ClickEvent.suggestCommand((String)withColorCodes)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)LocalizationManager.get(p, "menu.option.name.edit.hover", new Object[0]).color((TextColor)NamedTextColor.GRAY).decorate(TextDecoration.ITALIC)));
                    }
                    return Prefix.PREFIX.append((Component)LegacyComponentSerializer.legacySection().deserialize(LocalizationManager.getAsString(p, "menu.option.name.prompt", new Object[0]))).appendNewline().append((Component)finalCompontent);
                }

                @Override
                public ConversationManager.Prompt onInput(Player p, String input) {
                    if (input == null || input.trim().isEmpty()) {
                        p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        LocalizedMessage.sendMessage(p, "menu.option.name.input.empty", true, new Object[0]);
                        return this;
                    }
                    if (input.equalsIgnoreCase(LocalizationManager.getAsString(p, "menu.option.name.abort-sequence", new Object[0]))) {
                        p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 0.8f);
                        LocalizedMessage.sendMessage(p, "menu.option.name.abort-sequence", true, new Object[0]);
                        Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> p.openInventory(NpcGUI.getInventory(npc, p, isList).getInventory()));
                        return null;
                    }
                    Component oldName = npc.getName();
                    String name = input.replace("&", "\u00a7");
                    boolean hasColor = Arrays.stream(ChatColor.values()).anyMatch(chatColor -> name.contains(chatColor.toString()) && chatColor.isColor());
                    net.minecraft.network.chat.Component nmsComp = hasColor ? CraftChatMessage.fromStringOrNull((String)name, (boolean)false) : CraftChatMessage.fromStringOrNull((String)("\u00a7f" + name), (boolean)true);
                    Component finalComponent = JSONComponentSerializer.json().deserialize((Object)CraftChatMessage.toJSON((net.minecraft.network.chat.Component)nmsComp));
                    if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") && PlaceholderAPI.containsPlaceholders((String)name)) {
                        npc.setName(NpcName.of(player2 -> {
                            String placeHolder = PlaceholderAPI.setPlaceholders((Player)player2, (String)name).replace("&", "\u00a7");
                            net.minecraft.network.chat.Component nmsComp1 = hasColor ? CraftChatMessage.fromStringOrNull((String)placeHolder, (boolean)false) : CraftChatMessage.fromStringOrNull((String)("\u00a7f" + placeHolder), (boolean)true);
                            return JSONComponentSerializer.json().deserialize((Object)CraftChatMessage.toJSON((net.minecraft.network.chat.Component)nmsComp1));
                        }, finalComponent));
                    } else {
                        npc.setName(NpcName.of(finalComponent));
                    }
                    npc.markChange();
                    p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
                    LocalizedMessage.sendMessage(p, "menu.option.name.change", true, oldName, finalComponent);
                    Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> p.openInventory(NpcGUI.getInventory(npc, p, isList).getInventory()));
                    return null;
                }
            };
            conversation.startConversation(player, namePrompt);
        }, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f, player));
        List<Component> clickActionLore = npc.getClickEvent() == null || npc.getClickEvent() instanceof NpcClickActionImpl ? LocalizationManager.getAsList(player, "menu.option.click-action.description", new Object[0]) : LocalizationManager.getAsList(player, "menu.option.click-action.external.description", new Object[0]);
        builder.setItem(42, NpcGUI.createIcon(Material.COMMAND_BLOCK_MINECART, (Object)(npc.getClickEvent() == null || npc.getClickEvent() instanceof NpcClickActionImpl ? null : LocalizationManager.get(player, "menu.option.click-action.external.title", new Object[0])), LocalizationManager.get(player, "menu.option.click-action.title", new Object[0]), clickActionLore, (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            if (!(npc.getClickEvent() instanceof NpcClickActionImpl) && npc.getClickEvent() != null) {
                NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                LocalizedMessage.sendMessage((Player)inventoryClickEvent.getWhoClicked(), "menu.option.click-action.external.description", true, new Object[0]);
                return;
            }
            NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
            inventoryClickEvent.getWhoClicked().openInventory(NpcGUI.getActionTypeInventory(npc, (Player)inventoryClickEvent.getWhoClicked(), isList));
        }, Sound.UI_BUTTON_CLICK, 1.0f, 1.1f, player));
        builder.setItem(46, NpcGUI.createIcon(Material.PAPER, null, "copy", (InventoryClickEvent event) -> {
            event.setCancelled(true);
            NpcGUI.playSoundForPlayer(event, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.5f);
            event.getWhoClicked().closeInventory();
            Component component = LocalizationManager.get((Player)event.getWhoClicked(), "menu.option.copy.click", new Object[0]).clickEvent(ClickEvent.copyToClipboard((String)npc.getUUID().toString())).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)npc.getUUID().toString(), (TextColor)NamedTextColor.GRAY)));
            event.getWhoClicked().sendMessage(Prefix.PREFIX.append(component));
        }, Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.2f, player));
        builder.setItem(48, NpcGUI.createIcon(Material.ENDER_EYE, null, "reload", (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            npc.reload();
            inventoryClickEvent.getWhoClicked().closeInventory();
            LocalizedMessage.sendMessage((Player)inventoryClickEvent.getWhoClicked(), "menu.option.reload.success", true, npc.getName());
        }, Sound.ITEM_ARMOR_EQUIP_IRON, 1.0f, 1.0f, player));
        builder.setItem(50, NpcGUI.createIcon(npc.isEnabled() ? Material.LIME_DYE : Material.RED_DYE, null, LocalizationManager.get(player, "menu.option." + (npc.isEnabled() ? "enabled" : "disabled") + ".title", new Object[0]).decoration(TextDecoration.ITALIC, false), LocalizationManager.getAsList(player, "menu.option." + (npc.isEnabled() ? "enabled" : "disabled") + ".description", new Object[0]), (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            boolean currentEnabled = npc.isEnabled();
            npc.setEnabled(!currentEnabled);
            npc.markChange();
            HumanEntity patt0$temp = inventoryClickEvent.getWhoClicked();
            if (patt0$temp instanceof Player) {
                Player p = (Player)patt0$temp;
                p.playSound(p.getLocation(), npc.isEnabled() ? Sound.ENTITY_EXPERIENCE_ORB_PICKUP : Sound.ENTITY_ITEM_BREAK, 1.0f, npc.isEnabled() ? 1.5f : 1.0f);
            }
            LocalizedMessage.sendMessage((Player)inventoryClickEvent.getWhoClicked(), "menu.option." + (npc.isEnabled() ? "enabled" : "disabled") + ".change", true, npc.getName());
            ItemStack currentItem = inventoryClickEvent.getCurrentItem();
            if (currentItem != null) {
                ItemMeta meta = (currentItem = currentItem.withType(npc.isEnabled() ? Material.LIME_DYE : Material.RED_DYE)).getItemMeta();
                if (meta != null) {
                    meta.displayName(LocalizationManager.get((Player)inventoryClickEvent.getWhoClicked(), "menu.option." + (npc.isEnabled() ? "enabled" : "disabled") + ".title", new Object[0]).decoration(TextDecoration.ITALIC, false));
                    meta.lore(Collections.singletonList(LocalizationManager.get((Player)inventoryClickEvent.getWhoClicked(), "menu.option." + (npc.isEnabled() ? "enabled" : "disabled") + ".description", new Object[0])));
                    currentItem.setItemMeta(meta);
                }
                inventoryClickEvent.getClickedInventory().setItem(inventoryClickEvent.getSlot(), currentItem);
            }
        }, null, 0.0f, 0.0f, player));
        builder.setItem(52, NpcGUI.createIcon(Material.BARRIER, null, "delete", (InventoryClickEvent inventoryClickEvent) -> {
            inventoryClickEvent.setCancelled(true);
            NpcGUI.playSoundForPlayer(inventoryClickEvent, Sound.BLOCK_LAVA_POP, 1.0f, 0.8f);
            Player whoClicked = (Player)inventoryClickEvent.getWhoClicked();
            InventoryBuilder confirmBuilder = new InventoryBuilder((InventoryHolder)npc, 27, npc.getName().append(((TextComponent)Component.text((String)" >> ").color((TextColor)NamedTextColor.DARK_GRAY)).append(StringHelper.stripColors(LocalizationManager.get(whoClicked, "menu.option.delete.title", new Object[0])).color((TextColor)NamedTextColor.DARK_GRAY))));
            confirmBuilder.setItem(12, SkullBuilder.CHECKMARK.clone().setName(LocalizationManager.get(whoClicked, "menu.option.delete.confirm.title", new Object[0]).decoration(TextDecoration.ITALIC, false)).setLore(LocalizationManager.getAsList(whoClicked, "menu.option.delete.confirm.description", new Object[0]).stream().map(component -> component.decorate(TextDecoration.BOLD).decoration(TextDecoration.ITALIC, false)).toList()).setClickHandler(e -> {
                e.setCancelled(true);
                NpcGUI.playSoundForPlayer(e, Sound.BLOCK_ANVIL_DESTROY, 1.0f, 1.0f);
                try {
                    npc.delete();
                }
                catch (IOException ex) {
                    LocalizedMessage.sendMessage((Player)e.getWhoClicked(), "menu.option.delete.confirm.fail", true, npc.getUUID());
                    e.getWhoClicked().closeInventory();
                    return;
                }
                LocalizedMessage.sendMessage((Player)e.getWhoClicked(), "menu.option.delete.success", true, npc.getName());
                if (isList) {
                    e.getWhoClicked().openInventory(NpcGUI.getListInventory((Player)e.getWhoClicked()));
                } else {
                    e.getWhoClicked().closeInventory();
                }
            }).build());
            confirmBuilder.setItem(14, SkullBuilder.RED_X.clone().setName(LocalizationManager.get((Player)inventoryClickEvent.getWhoClicked(), "misc.cancel", new Object[0]).decoration(TextDecoration.ITALIC, false)).setClickHandler(e -> {
                e.setCancelled(true);
                NpcGUI.playSoundForPlayer(e, Sound.BLOCK_CHEST_CLOSE, 1.0f, 1.0f);
                e.getWhoClicked().openInventory(NpcGUI.getInventory(npc, (Player)e.getWhoClicked(), isList).getInventory());
            }).build());
            whoClicked.openInventory(confirmBuilder.fillOut().getInventory());
        }, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f, player));
        if (isList) {
            builder.setItem(40, new ItemBuilder(Material.ENDER_PEARL).setName(LocalizationManager.get(player, "menu.option.teleport.title", new Object[0]).decoration(TextDecoration.ITALIC, false)).setLore(LocalizationManager.getAsList(player, "menu.option.teleport.description", new Object[0])).setClickHandler(event -> {
                event.setCancelled(true);
                NpcGUI.playSoundForPlayer(event, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.2f);
                if (event.getClick().isLeftClick()) {
                    event.getWhoClicked().teleport(npc.getLocation());
                    event.getWhoClicked().closeInventory();
                    LocalizedMessage.sendMessage((Player)event.getWhoClicked(), "command.tp.success", true, npc.getName());
                } else if (event.getClick().isRightClick()) {
                    NPC copy = npc.copy(event.getWhoClicked().getLocation());
                    copy.showNpcToAllPlayers();
                    try {
                        copy.save();
                        npc.delete();
                    }
                    catch (IOException e) {
                        LocalizedMessage.sendMessage((Player)event.getWhoClicked(), "command.tphere.fail", true, npc.getName());
                        throw new RuntimeException(e);
                    }
                    LocalizedMessage.sendMessage((Player)event.getWhoClicked(), "command.tphere.success", true, npc.getName());
                }
            }).build());
            builder.setArrowLeft(LocalizationManager.get(player, "misc.back", new Object[0]), event -> {
                event.setCancelled(true);
                NpcGUI.playSoundForPlayer(event, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.1f);
                event.getWhoClicked().openInventory(NpcGUI.getListInventory((Player)event.getWhoClicked()));
            });
        }
        return builder.fillOut();
    }

    @NotNull
    private static ItemStack createIcon(@NotNull Material iconMaterial, @Nullable Object value, @NotNull String key, @NotNull Consumer<InventoryClickEvent> eventConsumer, @Nullable Sound clickSound, float soundPitch, float soundVolume, Player player) {
        return NpcGUI.createIcon(new ItemBuilder(iconMaterial), value, key, eventConsumer, clickSound, soundPitch, soundVolume, player);
    }

    @NotNull
    private static ItemStack createIcon(@NotNull ItemBuilder builder, @Nullable Object value, @NotNull String key, @NotNull Consumer<InventoryClickEvent> eventConsumer, @Nullable Sound clickSound, float soundPitch, float soundVolume, Player player) {
        Component name = LocalizationManager.get(player, "menu.option." + key + ".title", new Object[0]);
        List<Component> description = LocalizationManager.getAsList(player, "menu.option." + key + ".description", new Object[0]);
        return NpcGUI.createIcon(builder, value, name, description, eventConsumer, clickSound, soundPitch, soundVolume, player);
    }

    @NotNull
    private static ItemStack createIcon(@NotNull Material iconMaterial, @Nullable Object value, @NotNull Component name, @NotNull List<Component> description, @NotNull Consumer<InventoryClickEvent> eventConsumer, @Nullable Sound clickSound, float soundPitch, float soundVolume, Player player) {
        return NpcGUI.createIcon(new ItemBuilder(iconMaterial), value, name, description, eventConsumer, clickSound, soundPitch, soundVolume, player);
    }

    @NotNull
    private static ItemStack createIcon(@NotNull ItemBuilder builder, @Nullable Object value, @NotNull Component name, @Nullable List<Component> description, @NotNull Consumer<InventoryClickEvent> originalEventConsumer, @Nullable Sound clickSound, float soundPitch, float soundVolume, Player player) {
        builder.setName(name.decoration(TextDecoration.ITALIC, false));
        ArrayList<Component> loreLines = new ArrayList<Component>();
        if (description != null) {
            for (Object line : description) {
                loreLines.add(line.color((TextColor)NamedTextColor.GRAY));
            }
        }
        if (value != null) {
            Object line;
            ArrayList<Component> valueComponents = new ArrayList<Component>();
            Object object = value;
            Objects.requireNonNull(object);
            line = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Component.class, List.class}, (Object)line, n)) {
                case 0: {
                    Boolean bool = (Boolean)line;
                    valueComponents.add(((TextComponent)Component.text((String)value.toString()).color((TextColor)(bool != false ? NamedTextColor.GREEN : NamedTextColor.RED))).decoration(TextDecoration.ITALIC, false));
                    break;
                }
                case 1: {
                    Object c = line;
                    valueComponents.add(c.decoration(TextDecoration.ITALIC, false));
                    break;
                }
                case 2: {
                    List l = (List)line;
                    valueComponents.addAll(l);
                    break;
                }
                default: {
                    String[] valueLines;
                    for (String s : valueLines = value.toString().split("\n")) {
                        valueComponents.add(((TextComponent)Component.text((String)s).color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
                    }
                }
            }
            loreLines.add(LocalizationManager.get(player, "menu.option.value", valueComponents.getFirst()).decoration(TextDecoration.ITALIC, false));
            for (int i = 1; i < valueComponents.size(); ++i) {
                loreLines.add((Component)valueComponents.get(i));
            }
        }
        builder.setLore(loreLines);
        Consumer<InventoryClickEvent> soundPlayingConsumer = event -> {
            HumanEntity patt0$temp;
            if (clickSound != null && (patt0$temp = event.getWhoClicked()) instanceof Player) {
                Player player1 = (Player)patt0$temp;
                player1.playSound(player1.getLocation(), clickSound, soundVolume, soundPitch);
            }
            originalEventConsumer.accept((InventoryClickEvent)event);
        };
        return builder.hideFlags(true).hideAttributes().setClickHandler(soundPlayingConsumer).build();
    }

    @NotNull
    private static ItemStack getEquipment(@NotNull NPC npc, @Nullable Map<EquipmentSlot, ItemStack> currentEquipmentMap, @NotNull EquipmentSlot equipmentSlot, boolean isList, Player player) {
        ItemBuilder itemBuilder;
        ItemStack currentItem = Optional.ofNullable(currentEquipmentMap).map(m -> (ItemStack)m.get(equipmentSlot)).orElse(null);
        String key = "menu.option.equipment.slot." + equipmentSlot.name().replace("_", "-").toLowerCase();
        if (currentItem == null || currentItem.getType().isAir()) {
            itemBuilder = new ItemBuilder(Material.LIGHT_GRAY_STAINED_GLASS_PANE).setName(LocalizationManager.get(player, "menu.option.equipment.slot.title", LocalizationManager.get(player, key, new Object[0])).color((TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, true));
        } else {
            itemBuilder = new ItemBuilder(currentItem.clone());
            itemBuilder.setName(LocalizationManager.get(player, "menu.option.equipment.equipped", LocalizationManager.get(player, "menu.option." + currentItem.getType().name().replace("_", " ").toLowerCase(), new Object[0]).decoration(TextDecoration.ITALIC, false)));
        }
        itemBuilder.setLore(LocalizationManager.getAsList(player, "menu.option.equipment.lore", new Object[0]));
        itemBuilder.setClickHandler(event -> {
            event.setCancelled(true);
            Player whoClicked = (Player)event.getWhoClicked();
            ItemStack cursorItem = whoClicked.getItemOnCursor();
            if (cursorItem != null && !cursorItem.getType().isAir()) {
                NpcGUI.playSoundForPlayer(event, Sound.ITEM_ARMOR_EQUIP_GENERIC, 1.0f, 1.0f);
                ItemStack newItemToEquip = cursorItem.clone();
                npc.setOption(NpcOption.EQUIPMENT, new EquipmentModifier(npc.getOption(NpcOption.EQUIPMENT)).put(equipmentSlot, newItemToEquip).toMap());
                npc.markChange();
                whoClicked.setItemOnCursor(null);
                whoClicked.openInventory(NpcGUI.getInventory(npc, whoClicked, isList).getInventory());
            } else if (event.getClick() == ClickType.MIDDLE) {
                NpcGUI.playSoundForPlayer(event, Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                npc.setOption(NpcOption.EQUIPMENT, new EquipmentModifier(npc.getOption(NpcOption.EQUIPMENT)).remove(equipmentSlot).toMap());
                npc.markChange();
                whoClicked.openInventory(NpcGUI.getInventory(npc, whoClicked, isList).getInventory());
            } else {
                NpcGUI.playSoundForPlayer(event, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
                PageInventoryBuilder pageBuilder = new PageInventoryBuilder(npc.getName().append(((TextComponent)((TextComponent)Component.text((String)" >> ").color((TextColor)NamedTextColor.DARK_GRAY)).append(StringHelper.stripColors(LocalizationManager.get(whoClicked, "menu.option.equipment.title", LocalizationManager.get(player, key, new Object[0]))))).decoration(TextDecoration.ITALIC, false)), npc, ItemList.getList(), true, new PageInventoryBuilder.Hotbar(3, new ItemBuilder(Material.BARRIER).setName(LocalizationManager.get(player, "menu.option.equipment.clear.title", LocalizationManager.get(player, key, new Object[0])).decoration(TextDecoration.ITALIC, false)).setClickHandler(clearEvent -> {
                    clearEvent.setCancelled(true);
                    NpcGUI.playSoundForPlayer(clearEvent, Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                    npc.setOption(NpcOption.EQUIPMENT, new EquipmentModifier(npc.getOption(NpcOption.EQUIPMENT)).remove(equipmentSlot).toMap());
                    npc.markChange();
                    whoClicked.openInventory(NpcGUI.getInventory(npc, whoClicked, isList).getInventory());
                }).build()));
                pageBuilder.setClickEvent(itemSelectedEvent -> {
                    itemSelectedEvent.setCancelled(true);
                    NpcGUI.playSoundForPlayer(itemSelectedEvent, Sound.ITEM_ARMOR_EQUIP_GENERIC, 1.0f, 1.2f);
                    ItemStack selectedItem = itemSelectedEvent.getCurrentItem();
                    if (selectedItem != null && !selectedItem.getType().isAir()) {
                        npc.setOption(NpcOption.EQUIPMENT, new EquipmentModifier(npc.getOption(NpcOption.EQUIPMENT)).put(equipmentSlot, selectedItem.clone()).toMap());
                        npc.markChange();
                    }
                    whoClicked.openInventory(NpcGUI.getInventory(npc, whoClicked, isList).getInventory());
                });
                pageBuilder.setArrowBackEvent(backEvent -> {
                    NpcGUI.playSoundForPlayer(backEvent, Sound.UI_BUTTON_CLICK, 1.0f, 0.8f);
                    whoClicked.openInventory(NpcGUI.getInventory(npc, whoClicked, isList).getInventory());
                });
                whoClicked.openInventory(pageBuilder.getInventory(1, (Player)event.getWhoClicked()));
            }
        });
        return itemBuilder.build();
    }

    @NotNull
    private static Component getBars(int latency) {
        int filledBars = latency <= 150 ? 5 : (latency <= 300 ? 4 : (latency <= 600 ? 3 : (latency <= 1000 ? 2 : 1)));
        return ((TextComponent)((TextComponent)Component.text((String)String.join((CharSequence)"", Collections.nCopies(filledBars, "|"))).color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false)).append(((TextComponent)Component.text((String)String.join((CharSequence)"", Collections.nCopies(5 - filledBars, "|"))).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
    }

    private static int roundToNextLatencyStep(int currentLatency, boolean increase) {
        int[] targets = new int[]{100, 200, 400, 800, 1600};
        if (increase) {
            for (int target : targets) {
                if (target <= currentLatency) continue;
                return target;
            }
            return targets[targets.length - 1];
        }
        for (int i = targets.length - 1; i >= 0; --i) {
            if (targets[i] >= currentLatency) continue;
            return targets[i];
        }
        return targets[0];
    }

    @NotNull
    private static Inventory getActionTypeInventory(@NotNull NPC npc, @NotNull Player player, boolean isList) {
        Optional<NpcClickActionImpl> optional;
        InventoryBuilder actionTypeBuilder = new InventoryBuilder((InventoryHolder)npc, 27, npc.getName().append(((TextComponent)Component.text((String)" >> ").color((TextColor)NamedTextColor.DARK_GRAY)).append(StringHelper.stripColors(LocalizationManager.get(player, "menu.option.click-action.type.title", new Object[0])).color((TextColor)NamedTextColor.DARK_GRAY))));
        NpcClickAction npcClickAction = npc.getClickEvent();
        if (npcClickAction instanceof NpcClickActionImpl) {
            NpcClickActionImpl implCasted = (NpcClickActionImpl)npcClickAction;
            optional = Optional.of(implCasted);
        } else {
            optional = Optional.empty();
        }
        Optional<NpcClickActionImpl> implOpt = optional;
        actionTypeBuilder.setItem(11, new ItemBuilder(Material.DIAMOND_SWORD).setName(LocalizationManager.get(player, "menu.option.click-action.type.left.title", new Object[0]).decoration(TextDecoration.ITALIC, false)).setLore(LocalizationManager.getAsList(player, "menu.option.click-action.type.left.description", implOpt.map(impl -> impl.getActions(ClickActionType.LEFT).size()).orElse(0))).setClickHandler(e -> {
            e.setCancelled(true);
            NpcGUI.playSoundForPlayer(e, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
            player.openInventory(NpcGUI.getActionInventory(ClickActionType.LEFT, npc, player, isList));
        }).hideAttributes().build());
        actionTypeBuilder.setItem(13, SkullBuilder.PLUS.clone().setName(LocalizationManager.get(player, "menu.option.click-action.type.both.title", new Object[0]).decoration(TextDecoration.ITALIC, false)).setLore(LocalizationManager.getAsList(player, "menu.option.click-action.type.both.description", implOpt.map(impl -> impl.isBoth() ? impl.getActions(ClickActionType.BOTH).size() : 0).orElse(0))).setClickHandler(e -> {
            e.setCancelled(true);
            NpcGUI.playSoundForPlayer(e, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
            player.openInventory(NpcGUI.getActionInventory(ClickActionType.BOTH, npc, player, isList));
        }).build());
        actionTypeBuilder.setItem(15, new ItemBuilder(Material.SHIELD).setName(LocalizationManager.get(player, "menu.option.click-action.type.right.title", new Object[0]).decoration(TextDecoration.ITALIC, false)).setLore(LocalizationManager.getAsList(player, "menu.option.click-action.type.right.description", implOpt.map(impl -> impl.getActions(ClickActionType.RIGHT).size()).orElse(0))).setClickHandler(e -> {
            e.setCancelled(true);
            NpcGUI.playSoundForPlayer(e, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
            player.openInventory(NpcGUI.getActionInventory(ClickActionType.RIGHT, npc, player, isList));
        }).hideAttributes().build());
        actionTypeBuilder.setItem(22, new ItemBuilder(Material.BARRIER).setName(LocalizationManager.get(player, "misc.clear-all", new Object[0]).decoration(TextDecoration.ITALIC, false)).setClickHandler(event -> {
            event.setCancelled(true);
            NpcGUI.playSoundForPlayer(event, Sound.BLOCK_LAVA_EXTINGUISH, 1.0f, 1.0f);
            npc.setClickEvent(new NpcClickActionImpl());
            npc.markChange();
            event.getWhoClicked().openInventory(NpcGUI.getActionTypeInventory(npc, (Player)event.getWhoClicked(), isList));
        }).hideFlags(true).build());
        actionTypeBuilder.setArrowLeft(LocalizationManager.get(player, "misc.back", new Object[0]).decoration(TextDecoration.ITALIC, false), e -> {
            NpcGUI.playSoundForPlayer(e, Sound.UI_BUTTON_CLICK, 1.0f, 0.8f);
            e.getWhoClicked().openInventory(NpcGUI.getInventory(npc, player, isList).getInventory());
        });
        return actionTypeBuilder.fillOut().getInventory();
    }

    @NotNull
    public static Inventory getActionInventory(@NotNull ClickActionType actionType, @NotNull NPC npc, @NotNull Player player, boolean isList) {
        NpcClickActionImpl implCasted;
        NpcClickAction npcClickAction = npc.getClickEvent();
        NpcClickActionImpl impl = npcClickAction instanceof NpcClickActionImpl ? (implCasted = (NpcClickActionImpl)npcClickAction) : new NpcClickActionImpl();
        InventoryBuilder actionBuilder = new InventoryBuilder((InventoryHolder)npc, 54, npc.getName().append(((TextComponent)Component.text((String)" >> ").color((TextColor)NamedTextColor.DARK_GRAY)).append(StringHelper.stripColors(LocalizationManager.get(player, "menu.option.click-action.type." + actionType.name().toLowerCase() + ".title", new Object[0])).color((TextColor)NamedTextColor.DARK_GRAY))));
        List<NpcClickActionImpl.PluginAction<?>> actions = impl.getActions(actionType);
        int[] actionSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        int MAX_ACTIONS = actionSlots.length;
        BiConsumer<NpcClickActionImpl.PluginActionOptions, InventoryClickEvent> addingActionHandler = (action, event) -> {
            event.setCancelled(true);
            ItemStack cursorStack = player.getItemOnCursor();
            if (cursorStack == null || cursorStack.getType().isAir()) {
                NpcGUI.playSoundForPlayer(event, Sound.UI_BUTTON_CLICK, 1.0f, 0.7f);
                return;
            }
            ItemMeta cursorMeta = cursorStack.getItemMeta();
            if (cursorMeta == null || !cursorMeta.hasDisplayName()) {
                NpcGUI.playSoundForPlayer(event, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            if (action == null) {
                NpcGUI.playSoundForPlayer(event, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            int clickedInventorySlot = event.getSlot();
            int actionIndex = -1;
            for (int i = 0; i < actionSlots.length; ++i) {
                if (actionSlots[i] != clickedInventorySlot) continue;
                actionIndex = i;
                break;
            }
            if (actionIndex != -1 && actions.size() < MAX_ACTIONS) {
                NpcGUI.playSoundForPlayer(event, Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.2f);
                if (actionIndex >= actions.size()) {
                    impl.add(actionType, (NpcClickActionImpl.PluginActionOptions)Var.unsafeCast(action), action.getDefaultValue());
                } else {
                    impl.insert(actionIndex, actionType, (NpcClickActionImpl.PluginActionOptions)Var.unsafeCast(action), action.getDefaultValue());
                }
                npc.markChange();
                npc.setClickEvent(impl);
                player.setItemOnCursor(null);
                player.openInventory(NpcGUI.getActionInventory(actionType, npc, player, isList));
            } else if (actions.size() >= MAX_ACTIONS) {
                NpcGUI.playSoundForPlayer(event, Sound.BLOCK_ANVIL_LAND, 1.0f, 1.0f);
                LocalizedMessage.sendMessage(player, "menu.option.click-action.max-actions", true, new Object[0]);
            }
        };
        for (int i = 0; i < MAX_ACTIONS; ++i) {
            int slot = actionSlots[i];
            if (i < actions.size()) {
                NpcClickActionImpl.PluginAction<?> action2 = actions.get(i);
                ItemBuilder actionItem = action2.getIcon(player).get();
                actionItem.setClickHandler(clickEvent -> {
                    clickEvent.setCancelled(true);
                    if (clickEvent.getClick() == ClickType.MIDDLE) {
                        NpcGUI.playSoundForPlayer(clickEvent, Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                        impl.remove(actionType, action2);
                        npc.markChange();
                        npc.setClickEvent(impl);
                        player.openInventory(NpcGUI.getActionInventory(actionType, npc, player, isList));
                    } else if (player.getItemOnCursor() != null && !player.getItemOnCursor().getType().isAir()) {
                        addingActionHandler.accept(clickEvent.getCursor() == null ? null : NpcClickActionImpl.PluginActionOptions.getFromMaterial(clickEvent.getCursor().getType()), (InventoryClickEvent)clickEvent);
                    } else {
                        action2.getConsumer(npc, actionType, isList).accept((InventoryClickEvent)clickEvent);
                    }
                });
                actionBuilder.setItem(slot, actionItem.build());
                continue;
            }
            actionBuilder.setItem(slot, new ItemBuilder(Material.LIGHT_GRAY_STAINED_GLASS_PANE).setName(LocalizationManager.get(player, "menu.option.click-action.empty", new Object[0])).setClickHandler(inventoryClickEvent -> addingActionHandler.accept(inventoryClickEvent.getCursor() == null ? null : NpcClickActionImpl.PluginActionOptions.getFromMaterial(inventoryClickEvent.getCursor().getType()), (InventoryClickEvent)inventoryClickEvent)).build());
        }
        actionBuilder.setItem(47, NpcClickActionImpl.PluginActionOptions.SERVER.getDefaultItem(player).setClickHandler(NpcGUI.getClickActionEvent(actionType, NpcClickActionImpl.PluginActionOptions.SERVER, impl, npc, isList)).setLore(LocalizationManager.getAsList(player, "actions.server.description", new Object[0])).build());
        actionBuilder.setItem(48, NpcClickActionImpl.PluginActionOptions.COMMAND.getDefaultItem(player).setClickHandler(NpcGUI.getClickActionEvent(actionType, NpcClickActionImpl.PluginActionOptions.COMMAND, impl, npc, isList)).setLore(LocalizationManager.getAsList(player, "actions.command.description", new Object[0])).build());
        actionBuilder.setItem(49, NpcClickActionImpl.PluginActionOptions.ANIMATION.getDefaultItem(player).setClickHandler(NpcGUI.getClickActionEvent(actionType, NpcClickActionImpl.PluginActionOptions.ANIMATION, impl, npc, isList)).setLore(LocalizationManager.getAsList(player, "actions.animation.description", new Object[0])).build());
        actionBuilder.setItem(50, NpcClickActionImpl.PluginActionOptions.WAIT.getDefaultItem(player).setClickHandler(NpcGUI.getClickActionEvent(actionType, NpcClickActionImpl.PluginActionOptions.WAIT, impl, npc, isList)).setLore(LocalizationManager.getAsList(player, "actions.wait.description", new Object[0])).build());
        actionBuilder.setItem(51, NpcClickActionImpl.PluginActionOptions.PATH.getDefaultItem(player).setClickHandler(NpcGUI.getClickActionEvent(actionType, NpcClickActionImpl.PluginActionOptions.PATH, impl, npc, isList)).setLore(LocalizationManager.getAsList(player, "actions.path.description", new Object[0])).build());
        actionBuilder.setItem(53, new ItemBuilder(Material.BARRIER).setName(LocalizationManager.get(player, "menu.option.click-action.clear", LocalizationManager.get(player, "menu.option.click-action.type." + actionType.name().toLowerCase() + ".title", new Object[0])).decoration(TextDecoration.ITALIC, false)).setClickHandler(event -> {
            event.setCancelled(true);
            NpcGUI.playSoundForPlayer(event, Sound.BLOCK_LAVA_EXTINGUISH, 1.0f, 0.8f);
            impl.clear(actionType);
            npc.markChange();
            npc.setClickEvent(impl);
            player.openInventory(NpcGUI.getActionInventory(actionType, npc, player, isList));
        }).build());
        actionBuilder.setArrowLeft(LocalizationManager.get(player, "misc.back", new Object[0]), e -> {
            NpcGUI.playSoundForPlayer(e, Sound.UI_BUTTON_CLICK, 1.0f, 0.8f);
            player.openInventory(NpcGUI.getActionTypeInventory(npc, player, isList));
        });
        return actionBuilder.fillOut().getInventory();
    }

    @NotNull
    private static Consumer<InventoryClickEvent> getClickActionEvent(@NotNull ClickActionType clickActionType, @NotNull NpcClickActionImpl.PluginActionOptions<?> optionType, @NotNull NpcClickActionImpl currentActionImpl, @NotNull NPC npc, boolean isList) {
        return event -> {
            event.setCancelled(true);
            if (event.getCursor() != null && event.getCursor().isSimilar(event.getCurrentItem())) {
                NpcGUI.playSoundForPlayer(event, Sound.ENTITY_ITEM_PICKUP, 0.7f, 0.8f);
                event.getWhoClicked().setItemOnCursor(null);
                return;
            }
            int MAX_ACTIONS = 21;
            if (event.isShiftClick()) {
                if (currentActionImpl.getActions(clickActionType).size() >= 21) {
                    NpcGUI.playSoundForPlayer(event, Sound.BLOCK_ANVIL_LAND, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage((Player)event.getWhoClicked(), "menu.option.click-action.max-actions", true, new Object[0]);
                    return;
                }
                NpcGUI.playSoundForPlayer(event, Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.2f);
                currentActionImpl.add(clickActionType, (NpcClickActionImpl.PluginActionOptions)Var.unsafeCast(optionType), optionType.getDefaultValue());
                npc.markChange();
                npc.setClickEvent(currentActionImpl);
                event.getWhoClicked().openInventory(NpcGUI.getActionInventory(clickActionType, npc, (Player)event.getWhoClicked(), isList));
            } else {
                ItemStack currentPaletteItem = event.getCurrentItem();
                if (currentPaletteItem != null) {
                    NpcGUI.playSoundForPlayer(event, Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
                    event.getWhoClicked().setItemOnCursor(currentPaletteItem.clone());
                }
            }
        };
    }

    @NotNull
    public static Inventory getListInventory(@NotNull Player player) {
        ListSettings settings = listSettingsMap.computeIfAbsent(player.getUniqueId(), uuid -> new ListSettings(SortBy.NONE, SortOrder.ASCENDING, EnabledFilter.ALL, null));
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        NpcManager.getList().stream().filter(npc -> {
            int n = Integer.MIN_VALUE;
            block5: do {
                switch (n == Integer.MIN_VALUE ? settings.enabledFilter.ordinal() : n) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        if (!npc.isEnabled()) return false;
                        n = 0;
                        continue block5;
                    }
                    case 2: {
                        if (npc.isEnabled()) return false;
                    }
                    case 0: {
                        if (settings.nameFilter == null) return true;
                        if (!PlainTextComponentSerializer.plainText().serialize(npc.getName()).toLowerCase().contains(settings.nameFilter.toLowerCase())) return false;
                        return true;
                    }
                }
            } while (true);
            return false;
        }).sorted((o1, o2) -> {
            Comparator<NPC> comparator;
            switch (settings.sortBy.ordinal()) {
                case 1: {
                    comparator = Comparator.comparing(npc -> PlainTextComponentSerializer.plainText().serialize(npc.getName()), String.CASE_INSENSITIVE_ORDER);
                    break;
                }
                case 2: {
                    comparator = Comparator.comparing(NPC::getCreatedAt);
                    break;
                }
                case 0: {
                    return 0;
                }
                case 3: {
                    comparator = Comparator.comparingDouble(npc -> npc.getLocation().distanceSquared(player.getLocation()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected sort type: " + String.valueOf((Object)settings.sortBy));
                }
            }
            if (settings.sortOrder == SortOrder.DESCENDING) {
                comparator = comparator.reversed();
            }
            return comparator.compare((NPC)o1, (NPC)o2);
        }).forEach(npc -> {
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add(LocalizationManager.get(player, "menu.list.uuid", npc.getUUID().toString().substring(0, Math.min(npc.getUUID().toString().length(), 14))).decoration(TextDecoration.ITALIC, false));
            lore.add(LocalizationManager.get(player, "menu.list.saved", LocalizationManager.get(player, "menu.list.value." + npc.isSaved(), new Object[0])).decoration(TextDecoration.ITALIC, false));
            lore.add(LocalizationManager.get(player, "menu.list.enabled", LocalizationManager.get(player, "menu.list.value." + npc.isEnabled(), new Object[0])).decoration(TextDecoration.ITALIC, false));
            if (npc.getClickEvent() == null) {
                lore.add(LocalizationManager.get(player, "menu.list.click-events", 0).decoration(TextDecoration.ITALIC, false));
            } else {
                NpcClickAction patt0$temp = npc.getClickEvent();
                if (patt0$temp instanceof NpcClickActionImpl) {
                    NpcClickActionImpl impl = (NpcClickActionImpl)patt0$temp;
                    lore.add(LocalizationManager.get(player, "menu.list.click-events", impl.getRightActions().size() + impl.getLeftActions().size()).decoration(TextDecoration.ITALIC, false));
                } else {
                    lore.add(LocalizationManager.get(player, "menu.list.click-events", LocalizationManager.get(player, "menu.option.click-action.external.title", new Object[0])).decoration(TextDecoration.ITALIC, false));
                }
            }
            Instant createdAt = npc.getCreatedAt();
            ZoneId zone = TimeZoneManager.getTimeZone(player).orElse(ZoneId.systemDefault());
            Locale locale = player.locale() != null ? player.locale() : Locale.getDefault();
            ZonedDateTime createdDateTime = createdAt.atZone(zone);
            ZonedDateTime now = ZonedDateTime.now(zone);
            DateTimeFormatter timeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(locale);
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(locale);
            Component createdAtComponent = createdDateTime.toLocalDate().equals(now.toLocalDate()) ? LocalizationManager.get(player, "menu.list.created.today", createdDateTime.format(timeFormatter)) : (createdDateTime.toLocalDate().equals(now.minusDays(1L).toLocalDate()) ? LocalizationManager.get(player, "menu.list.created.yesterday", createdDateTime.format(timeFormatter)) : LocalizationManager.get(player, "menu.list.created.any", createdDateTime.format(dateFormatter)));
            lore.add(createdAtComponent.decoration(TextDecoration.ITALIC, false));
            if (settings.sortBy == SortBy.NEAREST) {
                lore.add(LocalizationManager.get(player, "menu.list.distance", String.format("%.2f", npc.getLocation().distance(player.getLocation()))).decoration(TextDecoration.ITALIC, false));
            }
            lore.add((Component)Component.text((String)" "));
            lore.add(LocalizationManager.get(player, "menu.list.click-for-actions", new Object[0]));
            items.add(SkullBuilder.skullFromGameProfile(((ServerPlayer)npc.getServerPlayer()).getGameProfile()).setName(npc.getName().equals((Object)Component.empty()) ? ((TextComponent)Component.text((String)"?").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false) : npc.getName().decoration(TextDecoration.ITALIC, false)).setLore(lore).setClickHandler(event -> {
                event.setCancelled(true);
                if (npc.isEditable()) {
                    NpcGUI.getInventory(npc, (Player)event.getWhoClicked(), true).open(event.getWhoClicked(), new InventoryBuilder.Animation(InventoryBuilder.AnimationType.UP, 1, Sound.BLOCK_NOTE_BLOCK_HAT));
                } else {
                    LocalizedMessage.sendMessage((Player)event.getWhoClicked(), "misc.interact.not-editable", true, new Object[0]);
                    ((Player)event.getWhoClicked()).playSound(event.getWhoClicked().getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                }
            }).build());
        });
        Component component = LocalizationManager.get(player, "menu.list.title", items.size());
        PageInventoryBuilder.Hotbar[] hotbarArray = new PageInventoryBuilder.Hotbar[4];
        hotbarArray[0] = new PageInventoryBuilder.Hotbar(0, new ItemBuilder(switch (settings.sortBy.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Material.BARRIER;
            case 1 -> Material.NAME_TAG;
            case 2 -> Material.CLOCK;
            case 3 -> Material.ENDER_PEARL;
        }).setName(LocalizationManager.get(player, "menu.list.sort-by.title", new Object[0]).decoration(TextDecoration.ITALIC, false)).setLore(Arrays.stream(SortBy.values()).map(sortBy -> ((TextComponent)((TextComponent)Component.text((String)"> ").append(LocalizationManager.get(player, "menu.list.sort-by." + sortBy.name().toLowerCase(), new Object[0]))).color((TextColor)(sortBy == settings.sortBy ? NamedTextColor.GOLD : NamedTextColor.GRAY))).decoration(TextDecoration.ITALIC, sortBy != settings.sortBy)).toList()).setClickHandler(event -> {
            event.setCancelled(true);
            settings.sortBy = switch (settings.sortBy.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (event.isLeftClick()) {
                        yield SortBy.NAME;
                    }
                    yield SortBy.NEAREST;
                }
                case 1 -> {
                    if (event.isLeftClick()) {
                        yield SortBy.CREATED;
                    }
                    yield SortBy.NONE;
                }
                case 2 -> {
                    if (event.isLeftClick()) {
                        yield SortBy.NEAREST;
                    }
                    yield SortBy.NAME;
                }
                case 3 -> event.isLeftClick() ? SortBy.NONE : SortBy.CREATED;
            };
            NpcGUI.playSoundForPlayer(event, Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, 1.2f);
            event.getWhoClicked().openInventory(NpcGUI.getListInventory((Player)event.getWhoClicked()));
        }).build());
        hotbarArray[1] = new PageInventoryBuilder.Hotbar(2, (settings.sortOrder == SortOrder.ASCENDING ? InventoryBuilder.PageIcon.up(LocalizationManager.get(player, "menu.list.order.title", new Object[0]).decoration(TextDecoration.ITALIC, false)) : InventoryBuilder.PageIcon.down(LocalizationManager.get(player, "menu.list.order.title", new Object[0]).decoration(TextDecoration.ITALIC, false))).setLore(Arrays.stream(SortOrder.values()).map(sortOrder -> ((TextComponent)((TextComponent)Component.text((String)"> ").append(LocalizationManager.get(player, "menu.list.order." + sortOrder.name().toLowerCase(), new Object[0]))).color((TextColor)(sortOrder == settings.sortOrder ? NamedTextColor.GOLD : NamedTextColor.GRAY))).decoration(TextDecoration.ITALIC, sortOrder != settings.sortOrder)).toList()).setClickHandler(event -> {
            event.setCancelled(true);
            settings.sortOrder = switch (settings.sortOrder.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SortOrder.DESCENDING;
                case 1 -> SortOrder.ASCENDING;
            };
            NpcGUI.playSoundForPlayer(event, Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, 1.2f);
            event.getWhoClicked().openInventory(NpcGUI.getListInventory((Player)event.getWhoClicked()));
        }).build());
        hotbarArray[2] = new PageInventoryBuilder.Hotbar(4, new ItemBuilder(switch (settings.enabledFilter.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> Material.LIME_DYE;
            case 2 -> Material.RED_DYE;
            case 0 -> Material.ORANGE_DYE;
        }).setName(LocalizationManager.get(player, "menu.list.enabled-filter.title", new Object[0]).decoration(TextDecoration.ITALIC, false)).setLore(Arrays.stream(EnabledFilter.values()).map(status -> ((TextComponent)((TextComponent)Component.text((String)"> ").append(LocalizationManager.get(player, "menu.list.enabled-filter." + status.name().toLowerCase(), new Object[0]))).color((TextColor)(status == settings.enabledFilter ? status.color : NamedTextColor.GRAY))).decoration(TextDecoration.ITALIC, status != settings.enabledFilter)).toList()).addLore(LocalizationManager.getAsList(player, "menu.list.enabled-filter.description", new Object[0])).setClickHandler(event -> {
            event.setCancelled(true);
            settings.enabledFilter = switch (settings.enabledFilter.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (event.isLeftClick()) {
                        yield EnabledFilter.ENABLED;
                    }
                    yield EnabledFilter.DISABLED;
                }
                case 1 -> {
                    if (event.isLeftClick()) {
                        yield EnabledFilter.DISABLED;
                    }
                    yield EnabledFilter.ALL;
                }
                case 2 -> event.isLeftClick() ? EnabledFilter.ALL : EnabledFilter.ENABLED;
            };
            NpcGUI.playSoundForPlayer(event, Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, 1.2f);
            event.getWhoClicked().openInventory(NpcGUI.getListInventory((Player)event.getWhoClicked()));
        }).build());
        hotbarArray[3] = new PageInventoryBuilder.Hotbar(6, new ItemBuilder(settings.nameFilter == null ? Material.CRIMSON_SIGN : Material.WARPED_SIGN).setName(LocalizationManager.get(player, "menu.list.name-filter.title", new Object[0]).decoration(TextDecoration.ITALIC, false)).setLore(settings.nameFilter == null ? Component.text((String)"?").color((TextColor)NamedTextColor.GRAY) : Component.text((String)settings.nameFilter).color((TextColor)NamedTextColor.GOLD)).setClickHandler(event -> {
            event.setCancelled(true);
            NpcGUI.playSoundForPlayer(event, Sound.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, 1.0f, 0.9f);
            SignBuilder.open((Player)event.getWhoClicked(), event1 -> {
                String input = PlainTextComponentSerializer.plainText().serialize((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(event1.getLines()[0])).trim();
                String string = settings.nameFilter = input.isEmpty() ? null : input;
                if (input.isEmpty()) {
                    event1.getPlayer().playSound(event1.getPlayer().getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.2f);
                } else {
                    event1.getPlayer().playSound(event1.getPlayer().getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.5f);
                }
                event1.getPlayer().openInventory(NpcGUI.getListInventory(event1.getPlayer()));
            }, "", "^^^^^^^^^^^^^^", LocalizationManager.getAsString(player, "menu.list.name.input.prompt", new Object[0]));
        }).build());
        PageInventoryBuilder inventoryBuilder = new PageInventoryBuilder(component, items, true, hotbarArray);
        return inventoryBuilder.withBorder().withPlaceHolder(new ItemBuilder(Material.LIGHT_GRAY_STAINED_GLASS_PANE).setName((Component)Component.empty()).hideFlags(true).hideAttributes().setClickHandler(event -> {
            event.setCancelled(true);
            NpcGUI.playSoundForPlayer(event, Sound.UI_BUTTON_CLICK, 0.5f, 1.5f);
        }).build()).getInventory(1, player);
    }

    private static Material getPoseIcon(Pose pose) {
        return switch (pose) {
            case Pose.STANDING -> Material.ARMOR_STAND;
            case Pose.FALL_FLYING -> Material.FEATHER;
            case Pose.SLEEPING -> Material.RED_BED;
            case Pose.SWIMMING -> Material.WATER_BUCKET;
            case Pose.SPIN_ATTACK -> Material.TRIDENT;
            case Pose.SNEAKING -> Material.LEATHER_BOOTS;
            case Pose.SITTING -> Material.OAK_STAIRS;
            default -> null;
        };
    }

    private static class ListSettings {
        @NotNull
        private SortBy sortBy;
        @NotNull
        private SortOrder sortOrder;
        @NotNull
        private EnabledFilter enabledFilter;
        @Nullable
        private String nameFilter;

        public ListSettings(@NotNull SortBy sortBy, @NotNull SortOrder sortOrder, @NotNull EnabledFilter enabledFilter, @Nullable String nameFilter) {
            this.sortBy = sortBy;
            this.sortOrder = sortOrder;
            this.enabledFilter = enabledFilter;
            this.nameFilter = nameFilter;
        }
    }

    private static enum SortBy {
        NONE,
        NAME,
        CREATED,
        NEAREST;

    }

    private static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }

    private static enum EnabledFilter {
        ALL(NamedTextColor.GOLD),
        ENABLED(NamedTextColor.GREEN),
        DISABLED(NamedTextColor.RED);

        @NotNull
        private final NamedTextColor color;

        private EnabledFilter(NamedTextColor color) {
            this.color = color;
        }
    }
}

